/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LengthTextField
extends JTextField
implements GlobalConstants {
    private int maxLen;
    private boolean debug = false;

    public LengthTextField(String text) {
        super(text);
    }

    public LengthTextField(int maxLen) {
        this.maxLen = maxLen;
    }

    public LengthTextField(int columns, int maxLen) {
        super(columns);
        this.maxLen = maxLen;
    }

    public LengthTextField(String text, int maxLen) {
        super(text);
        this.maxLen = maxLen;
    }

    public LengthTextField(String text, int columns, int maxLen) {
        super(text, columns);
        this.maxLen = maxLen;
    }

    public int maxLen() {
        return this.maxLen;
    }

    protected Document createDefaultModel() {
        return new LengthTextFieldDocument();
    }

    class LengthTextFieldDocument
    extends PlainDocument {
        LengthTextFieldDocument() {
        }

        public void insertString(int offset, String text, AttributeSet attrib) throws BadLocationException {
            if (text == null) {
                return;
            }
            if (this.getLength() + text.length() > LengthTextField.this.maxLen) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offset, text, attrib);
            LengthTextField.this.postActionEvent();
        }

        public void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
            super.removeUpdate(chng);
            LengthTextField.this.postActionEvent();
        }
    }
}

