#!/bin/sh
#set -x

createLilo () {
  local kern
  local lilo
  local style
  kern="$1"
  lilo="$2"

  >$lilo
  echo "prompt" >>$lilo
  echo "timeout=80" >>$lilo
  echo "default=linuxsmp" >>$lilo
  echo "boot=/dev/sda" >>$lilo
  echo "map=/boot/map" >>$lilo
  echo "install=/boot/boot.b" >>$lilo
  echo "message=/boot/message" >>$lilo
  echo "lba32" >>$lilo
  echo "" >>$lilo
  echo "image=/boot/vmlinuz-$kern" >>$lilo
  echo "	label  = linux" >>$lilo
  echo "	initrd = /boot/initrd-$kern.img" >>$lilo
  echo "	read-only" >>$lilo
  echo "	append = \"root=LABEL=/\"" >>$lilo
  for style in smp bigmem ;do
    if [ -f $DISK/boot/vmlinuz-${kern}$style ] ;then
      echo "image=/boot/vmlinuz-${kern}$style" >>$lilo
      echo "	label  = linux$style" >>$lilo
      echo "	initrd = /boot/initrd-${kern}$style.img" >>$lilo
      echo "	read-only" >>$lilo
      echo "	append = \"root=LABEL=/\"" >>$lilo
    fi
  done
}

KERN=`uname -r | sed 's/BOOT//'`
KERN=`echo $KERN | sed 's/smp//'`
KERN=`echo $KERN | sed 's/bigmem//'`
#KERN_VER=$1
#KERN_DIR=$1$3
#DRIVER=sii6514
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"

$SETCOLOR_NORMAL
echo "########################################################"
echo "#         Silicon Image SATARaid controller            #"
echo "#               RedHatLinux  Driver                    #"
echo "########################################################"
echo ""
echo "you are running $KERN version of kernel."
$SETCOLOR_WARNING
echo "#####################################################"
echo "# grub may not be able to boot from a RAID disk set #"
echo "# this script will use use LILO as the boot loader  #"
echo "# if the boot device is a RAID                      #"
echo "#####################################################"
echo -n "MUST BE ROOT TO RUN THIS PROGRAM ... ready ? "
$SETCOLOR_NORMAL
read nothing

while true ;do
  echo -n "Will this system boot from a RAID? " >/dev/tty
  read lilo </dev/tty
  if [ "$lilo" == 'y' -o "$lilo" == 'Y' ] ;then
    break
  elif [ "$lilo" == 'n' -o "$lilo" == 'N' ] ;then
    lilo=""
    break
  fi
done

if [ -d /mnt/sysimage/etc ] ;then
  DISK="/mnt/sysimage/etc"
  FLOPPY=""
elif [ -d /etc -a -f /mnt/floppy/lilo.conf ] ;then
  DISK=""
  FLOPPY="/mnt/floppy"
else
  echo "Bad install disk"
  exit 9
fi

if [ "$lilo" != "" ];then
  mkdir -p /tmp
  if [ -f $DISK/etc/lilo.conf ];then
    if [ ! -f $DISK/etc/lilo.bak ] ;then
      mv $DISK/etc/lilo.conf $DISK/etc/lilo.bak
    fi
  fi

  echo "LILO boot loader ($DISK/etc/lilo.conf) detected ..."
  #sed -f $FLOPPY/lilosii.sed $DISK/etc/lilo.conf > /tmp/lilo.tmp
  createLilo $KERN /tmp/lilo.tmp	#,,,
  echo "-----------ORIGINAL FILE --------------"
  cat $DISK/etc/lilo.conf
  echo "-----------NEW LILO FILE --------------"
  cat /tmp/lilo.tmp
  echo "---------------------------------------"
  echo ""
  echo -n "Type carriage return to continue or control-c to exit - "
  read nothing
  mv -f /tmp/lilo.tmp $DISK/etc/lilo.conf
  echo "Running Lilo"
  $DISK/sbin/lilo
  cd $FLOPPY
  $FLOPPY/cleanup_9.0
else
  if [ -f /mnt/sysimage/boot/grub/grub.conf ];then
    echo "GRUB boot loader ($DISK/boot/grub/grub.conf) detected..."

    sed -f $FLOPPY/grubsii.sed $DISK/boot/grub/grub.conf > /tmp/grub.tmp
    echo "-----------ORIGINAL FILE --------------"
    cat $DISK/boot/grub/grub.conf
    echo "-----------NEW KERNEL FILE ------------"
    cat /tmp/grub.tmp
    echo "---------------------------------------"
    echo ""
    echo -n "Type carriage return to continue or control-c to exit - "
    read nothing
    cp -rf $DISK/boot/grub/grub.conf $DISK/boot/grub/grub.bak
    cp -rf /tmp/grub.tmp $DISK/boot/grub/grub.conf

    echo "Installing GRUB `$FLOPPY/grub/grub --version`"
    mkdir -p $DISK/usr/share/grub/i386-pc
    cp -rf  $DISK/usr/share/grub/i386-redhat/* $DISK/usr/share/grub/i386-pc
    cp -rf  $FLOPPY/grub/i386-pc/* $DISK/usr/share/grub/i386-pc
    cp -rf  $FLOPPY/grub/* $DISK/sbin/
    $DISK/sbin/grub-install /dev/sda
    #$DISK/sbin/grub-install -v
  fi
fi

echo "Cleaning up unused modules"
#cd $FLOPPY
#$FLOPPY/cleanup_9.0
rm -f $DISK/lib/modules/${KERN}*/kernel/drivers/scsi/sii6514.o

$SETCOLOR_WARNING
echo "################################################################"
echo "#  IF you have UNUSUAL CONFIGURATIONS..                         "
echo "#  Make sure Lilo and/or GRUB config file are correct           "
echo "#  Run Lilo again if necessary. Please inspect files visually   "
echo "#  BACKEP UP files are /etc/lilo.bak or /boot/grub/grub.bak     "
echo "################################################################"
$SETCOLOR_SUCCESS
echo "########################################################"
echo "#  Silicon Image, Inc (C) 2003                         #"
echo "########################################################"
$SETCOLOR_NORMAL
