/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DatabaseManager
implements GlobalConstants {
    public boolean snapshot;
    public int state;
    public int selectedController;
    public StorageManagementUtility storageManagementUtility;
    public HostConnectionManager hostConnectionManager;
    public CommManager commManager;
    public ControllerDatabase controllerDatabase;
    public RaidGroupDatabase raidGroupDatabase;
    public DeviceDatabase deviceDatabase;
    public TaskDatabase taskDatabase;
    public EventDatabase eventDatabase;
    public int maximumRaidGroups;
    public int maximumSpares;
    private ControllerUpdateListener controllerUpdateListener;
    private AbstractDatabase[] databaseComponents;
    private boolean outstandingUpdateCountRequest;
    private Timer updateCountPollTimer;
    static CommLinkChangeEvent localEvent;
    public static boolean RemoteAccessAllowed;
    public static boolean RemoteAccessWanted;
    static final String masterUpdateRequest = "<si:Request><si:Type>MasterUpdateCounts</si:Type></si:Request>";
    protected ArrayList notifyList;
    protected ArrayList notifyNukeList;

    public DatabaseManager(StorageManagementUtility storageManagementUtility, HostConnectionManager hostConnectionManager) {
        this.storageManagementUtility = storageManagementUtility;
        this.hostConnectionManager = hostConnectionManager;
        this.commManager = hostConnectionManager.commManager;
        this.maximumRaidGroups = 0;
        this.maximumSpares = 0;
        this.controllerDatabase = new ControllerDatabase(this);
        this.deviceDatabase = new DeviceDatabase(this);
        this.raidGroupDatabase = new RaidGroupDatabase(this);
        this.taskDatabase = new TaskDatabase(this);
        this.eventDatabase = new EventDatabase(this);
        this.databaseComponents = new AbstractDatabase[5];
        this.databaseComponents[0] = this.controllerDatabase;
        this.databaseComponents[1] = this.deviceDatabase;
        this.databaseComponents[2] = this.raidGroupDatabase;
        this.databaseComponents[3] = this.taskDatabase;
        this.databaseComponents[4] = this.eventDatabase;
        localEvent = new CommLinkChangeEvent();
        LinkChangeListener changeListener = new LinkChangeListener();
        this.commManager.addChangeListener(changeListener);
        this.controllerUpdateListener = new ControllerUpdateListener();
        this.notifyList = new ArrayList();
        this.notifyNukeList = new ArrayList();
        this.updateCountPollTimer = new Timer(5000, new TimerActionListener());
    }

    public void startUpInitialization() {
        if (this.getControllerCount() == 0) {
            RemoteAccessAllowed = false;
            RemoteAccessWanted = true;
        }
        this.state = 1;
        this.updateCountPollTimer.start();
        this.getUpdateCounts(true);
    }

    public synchronized void initializationComplete(String completionSource) {
        if (completionSource.equals("UpdateCounts")) {
            this.controllerDatabase.initialize();
        } else if (completionSource.equals("ControllerDatabase")) {
            this.deviceDatabase.initialize();
        } else if (completionSource.equals("DeviceDatabase")) {
            this.raidGroupDatabase.initialize();
        } else if (completionSource.equals("RaidGroupDatabase")) {
            this.taskDatabase.initialize();
        } else if (completionSource.equals("TaskDatabase")) {
            this.eventDatabase.initialize();
        } else if (completionSource.equals("EventDatabase")) {
            this.state = 3;
            this.controllerDatabase.addUpdateListener(this.controllerUpdateListener);
            this.storageManagementUtility.databaseInitialized();
            this.eventDatabase.UpdateApplicationEvents("Informational", "Database initialized..");
            this.controllerDatabase.notifyListeners();
            this.deviceDatabase.notifyListeners();
            this.raidGroupDatabase.notifyListeners();
            this.taskDatabase.notifyListeners();
            this.eventDatabase.notifyListeners();
            this.notifyListeners();
        }
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            if ((Runnable)this.notifyList.get(index) != updateListener) continue;
            this.notifyList.remove(index);
            break;
        }
    }

    public void notifyListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
        }
    }

    public synchronized void addNukeListener(Runnable nukeListener) {
        this.notifyNukeList.add(nukeListener);
    }

    public synchronized void removeNukeListener(Runnable nukeListener) {
        for (int index = 0; index < this.notifyNukeList.size(); ++index) {
            if ((Runnable)this.notifyNukeList.get(index) != nukeListener) continue;
            this.notifyNukeList.remove(index);
            break;
        }
    }

    public synchronized void notifyNukeListeners() {
        this.controllerDatabase.removeUpdateListener(this.controllerUpdateListener);
        for (int index = 0; index < this.notifyNukeList.size(); ++index) {
            SwingUtilities.invokeLater((Runnable)this.notifyNukeList.get(index));
        }
    }

    private void suspendDatabase() {
        Utility.println("suspendDatabase() entered");
        this.state = 2;
        this.updateCountPollTimer.stop();
        for (int index = 0; index < this.databaseComponents.length; ++index) {
            this.databaseComponents[index].suspend();
        }
    }

    private void resumeDatabase() {
        Utility.println("resumeDatabase() entered");
        this.getUpdateCounts(false);
        for (int index = 0; index < this.databaseComponents.length; ++index) {
            this.databaseComponents[index].resume();
        }
        this.updateCountPollTimer.start();
        this.state = 3;
    }

    public synchronized void nukeDatabase() {
        Utility.println("nukeDatabase() entered");
        this.state = 0;
        this.updateCountPollTimer.stop();
        this.notifyNukeListeners();
        for (int index = 0; index < this.databaseComponents.length; ++index) {
            this.databaseComponents[index].nuke();
        }
        this.maximumRaidGroups = 0;
        this.maximumSpares = 0;
    }

    private void getUpdateCounts(boolean first) {
        if (!this.outstandingUpdateCountRequest) {
            this.outstandingUpdateCountRequest = true;
            this.commManager.sendMessage("Get", masterUpdateRequest, new UpdateCountMessageHandler(first));
        }
    }

    public ControllerDescriptor getSelectedController() {
        return this.controllerDatabase.getConnectedController();
    }

    public int getControllerCount() {
        return this.commManager.getControllerCount();
    }

    public void refresh() {
        this.getUpdateCounts(false);
    }

    public Nexus getNexus() {
        return this.hostConnectionManager.getNexus();
    }

    public int getNexusController() {
        return this.hostConnectionManager.getNexusController();
    }

    public String getNexusIpAddress() {
        return this.hostConnectionManager.getNexusIpAddress();
    }

    public boolean isNexusLocal() {
        return this.hostConnectionManager.getNexusLocal();
    }

    static {
        RemoteAccessAllowed = false;
        RemoteAccessWanted = false;
    }

    private class LinkChangeListener
    extends CommLinkChangeListener {
        private LinkChangeListener() {
        }

        public void linkUp(CommLinkChangeEvent event) {
            Utility.println("LinkChangeListener(): linkUp() entered");
            if (!localEvent.same(event)) {
                event.copyTo(localEvent);
                DatabaseManager.this.nukeDatabase();
                DatabaseManager.this.hostConnectionManager.setNexusToConnection(event.local, event.ipAddress, event.controller);
                DatabaseManager.this.startUpInitialization();
            } else if (DatabaseManager.this.state == 2) {
                DatabaseManager.this.resumeDatabase();
            }
        }

        public void linkDown(CommLinkChangeEvent event) {
            Utility.println("LinkChangeListener(): linkDown() entered");
            if (DatabaseManager.this.state == 3) {
                DatabaseManager.this.suspendDatabase();
            } else if (DatabaseManager.this.state == 1) {
                DatabaseManager.this.nukeDatabase();
            }
            event.copyTo(localEvent);
        }
    }

    private class ControllerUpdateListener
    extends AbstractListener {
        private ControllerUpdateListener() {
        }

        public void processChange() {
            Utility.println("ControllerUpdateListener(): processChange() entered");
            ControllerDescriptor controllerDescriptor = DatabaseManager.this.controllerDatabase.getConnectedController();
            DatabaseManager.this.maximumRaidGroups = controllerDescriptor.maxRaidGroups;
            DatabaseManager.this.maximumSpares = controllerDescriptor.maxSpares;
            DatabaseManager.this.storageManagementUtility.menubar.update();
        }
    }

    private class UpdateCountMessageHandler
    extends AbstractMessageHandler {
        final String[] updateCountNames = new String[]{"Controller", "Device", "RaidGroup", "Task", "Event"};
        long[] updateCounts;
        boolean firstTime;

        public UpdateCountMessageHandler(boolean firstTime) {
            this.firstTime = firstTime;
            this.updateCounts = new long[this.updateCountNames.length];
        }

        public void handleError(Message message) {
            DatabaseManager.this.outstandingUpdateCountRequest = false;
        }

        public void handleMessage(Message message) {
            DatabaseManager.this.outstandingUpdateCountRequest = false;
            try {
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement()) {
                    if (xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                        if (faultDescriptor.code.equals("System") && faultDescriptor.subcode.equals("Database Error") && faultDescriptor.reason.equals("GUI Database Out Of Sync")) {
                            DatabaseManager.this.nukeDatabase();
                            DatabaseManager.this.startUpInitialization();
                        }
                    } else if (xmlData.element.equals("MasterUpdateCounts")) {
                        int index;
                        xmlData = new XmlData(xmlData.elementValue);
                        block2: while (xmlData.getNextElement()) {
                            for (index = 0; index < this.updateCountNames.length; ++index) {
                                if (!xmlData.element.equalsIgnoreCase(this.updateCountNames[index])) continue;
                                this.updateCounts[index] = Long.parseLong(xmlData.elementValue);
                                continue block2;
                            }
                        }
                        if (this.firstTime) {
                            DatabaseManager.this.initializationComplete("UpdateCounts");
                            for (index = 0; index < DatabaseManager.this.databaseComponents.length; ++index) {
                                DatabaseManager.this.databaseComponents[index].setInitialUpdateCount(this.updateCounts[index]);
                            }
                        } else {
                            for (index = 0; index < DatabaseManager.this.databaseComponents.length; ++index) {
                                DatabaseManager.this.databaseComponents[index].processUpdateCount(this.updateCounts[index]);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "DatabaseManager Exception\nMessage " + message.response);
            }
        }
    }

    private class TimerActionListener
    implements ActionListener {
        private TimerActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (DatabaseManager.this.state == 3) {
                DatabaseManager.this.getUpdateCounts(false);
            }
        }
    }
}

