/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

class SoftRAID5DaemonConnection {
    private Socket so = null;
    private OutputStream os = null;
    private InputStream is = null;
    private boolean connected = false;
    private int bufferSize;
    private int maxOutgoingSize = 0;
    private int maxIncomingSize = 0;
    private boolean debugMode = false;
    static final int maxMessageSize = 32768;
    static final int ctrlZ = 26;
    static final int wellKnownPort = 4242;

    private void sendNetString(String s) throws IOException {
        this.os.write(s.getBytes());
        this.os.write(26);
        this.os.flush();
        if (this.debugMode) {
            System.out.println("\ntx: '" + s + "'^Z");
        }
    }

    private String getNetString() throws Exception, IOException {
        int b;
        StringBuffer readBuffer = new StringBuffer(32768);
        if (this.debugMode) {
            System.out.println("Waiting for network data...");
        }
        while ((b = this.is.read()) != 26) {
            if (b == -1) {
                return null;
            }
            readBuffer.append((char)b);
        }
        String response = readBuffer.toString();
        response = response.trim();
        readBuffer = null;
        if (!response.startsWith("<ioctl-server")) {
            throw new Exception("Bad IOCTL Server response: no <ioctl-server> tag at start of response\n" + response);
        }
        if (!response.endsWith("</ioctl-server>")) {
            throw new Exception("Bad IOCTL Server response: no </ioctl-server> tag at end of response");
        }
        if (response.startsWith("<ioctl-server error>")) {
            response = response.replaceFirst("<ioctl-server error>", "");
            response = response.replaceFirst("</ioctl-server>", "");
            response = response.trim();
            throw new Exception("IOCTL-DAEMON Error: " + response);
        }
        if (this.debugMode) {
            System.out.println("rx: '" + response + "^Z'");
        }
        return response;
    }

    private String netExchange(String args, String payload) throws Exception, IOException {
        if (!this.connected) {
            throw new Exception("Not connected to IOCTL Server");
        }
        this.sendNetString("<ioctl-client " + args + ">" + payload + "</ioctl-client>");
        return this.getNetString();
    }

    private String netExchange(String args) throws Exception, IOException {
        return this.netExchange(args, "");
    }

    private String[] getServerHeaderTag(String s, int min_tokens) throws Exception {
        int right;
        int left = s.indexOf("<");
        if (left > (right = s.indexOf(">"))) {
            throw new Exception("Bad IOCTL Server response: can't find header tag");
        }
        String headerTag = s.substring(left, right);
        String[] tokens = headerTag.split("[\\s<=>]");
        if (tokens.length < min_tokens) {
            throw new Exception("IOCTL(5) Server response message has too few args");
        }
        if (!tokens[1].equals("ioctl-server")) {
            throw new Exception("Bad IOCTL Server response message: unexpected header tag");
        }
        return tokens;
    }

    public synchronized int getHandleCount() throws Exception, IOException {
        int handleCount = 0;
        String response = this.netExchange("get-ifc-count");
        String[] tokens = this.getServerHeaderTag(response, 2);
        if (!tokens[2].equals("ifc-count")) {
            throw new Exception("IOCTL Server response message has bad header tag format. ifc-count variable missing");
        }
        try {
            handleCount = Integer.parseInt(tokens[3]);
        }
        catch (NumberFormatException e) {
            throw new Exception("IOCTL Server response message has bad header tag format");
        }
        return handleCount;
    }

    public synchronized void setBufferSize(int size) throws Exception, IOException {
        String request = "set-buffer-size=" + Integer.toString(size, 10);
        String response = this.netExchange(request);
        String[] tokens = this.getServerHeaderTag(response, 3);
        if (!tokens[2].equals("buffer-size")) {
            throw new Exception("IOCTL Server response message has bad header tag format");
        }
        try {
            this.bufferSize = Integer.parseInt(tokens[3]);
        }
        catch (NumberFormatException e) {
            throw new Exception("IOCTL Server response message has bad header tag format");
        }
        if (size > this.bufferSize) {
            throw new Exception("IOCTL Server returned smaller buffer size");
        }
    }

    public synchronized String exchange(int ifc_num, String inStr) throws Exception, IOException {
        if (this.maxOutgoingSize < inStr.length()) {
            this.maxOutgoingSize = inStr.length();
        }
        String request = "exch ifc-num=" + Integer.toString(ifc_num, 10);
        String response = this.netExchange(request, inStr);
        response = response.replaceAll("<ioctl-server>", "");
        if (this.maxIncomingSize < (response = response.replaceAll("</ioctl-server>", "")).length()) {
            this.maxIncomingSize = response.length();
        }
        return response;
    }

    private void internal_goodbye() throws IOException, Exception {
        if (this.connected) {
            this.netExchange("goodbye");
            this.so.close();
            this.so = null;
            this.os = null;
            this.is = null;
            this.connected = false;
        }
    }

    public synchronized void goodbye() throws IOException, Exception {
        ApplicationLog.put(this.getClass().getName() + ": goodbye");
        this.internal_goodbye();
    }

    public synchronized void netConnect(String host, int port) throws UnknownHostException, IOException, Exception {
        this.internal_goodbye();
        ApplicationLog.put(this.getClass().getName() + " netConnect(): remoteHost ='" + InetAddress.getByName(host) + "'");
        this.so = new Socket(InetAddress.getByName(host), port);
        this.os = this.so.getOutputStream();
        this.is = this.so.getInputStream();
        this.connected = true;
    }

    public synchronized void directConnect() throws UnknownHostException, IOException, Exception {
        this.directConnect(4242);
    }

    public synchronized void directConnect(int port) throws UnknownHostException, IOException, Exception {
        this.internal_goodbye();
        ApplicationLog.put(this.getClass().getName() + " directConnect(): localHost ='" + InetAddress.getLocalHost() + "'");
        this.so = new Socket(InetAddress.getLocalHost(), port);
        this.os = this.so.getOutputStream();
        this.is = this.so.getInputStream();
        this.connected = true;
    }

    public synchronized boolean scanDrive() throws Exception, IOException {
        boolean handleCount = false;
        String response = this.netExchange("scan-drive");
        String[] tokens = this.getServerHeaderTag(response, 5);
        if (!tokens[2].equals("scan-drive")) {
            throw new Exception("IOCTL Server response message has bad header tag format");
        }
        if (!tokens[3].equals("return-status")) {
            throw new Exception("IOCTL Server response message has bad header tag format");
        }
        if (!tokens[4].equals("true")) {
            return true;
        }
        if (!tokens[4].equals("false")) {
            return false;
        }
        throw new Exception("IOCTL Server response message has bad header tag format");
    }

    public synchronized void removeDrive(int ctrlIdx, int pathId, int targetId) throws Exception, IOException {
        String request = "remove-drive controller-index=" + Integer.toString(ctrlIdx, 10) + " path-id=" + Integer.toString(pathId, 10) + " target-id=" + Integer.toString(targetId, 10);
        this.netExchange(request);
    }

    public synchronized int largestOutgoingMessage() {
        return this.maxOutgoingSize;
    }

    public synchronized int largestIncomingMessage() {
        return this.maxIncomingSize;
    }

    public synchronized void turnDebugOn() {
        this.debugMode = true;
    }

    public synchronized void turnDebugOff() {
        this.debugMode = false;
    }

    public synchronized void turnRemoteDebugOn() throws Exception, IOException {
        this.netExchange("debug");
    }

    public synchronized void turnRemoteDebugOff() throws Exception, IOException {
        this.netExchange("nodebug");
    }

    public static void main(String[] args) {
        SoftRAID5DaemonConnection sr5dc = null;
        sr5dc = new SoftRAID5DaemonConnection();
        try {
            System.out.println("Connecting to remote system...");
            sr5dc.netConnect("172.16.3.9", 4242);
            System.out.println("getHandleCount()");
            int handleCount = sr5dc.getHandleCount();
            System.out.println("setBufferSize()");
            sr5dc.setBufferSize(16384);
            System.out.println("\nsending exchange() all adapters....");
            for (int i = 0; i < handleCount; ++i) {
                sr5dc.exchange(i, "<ping></ping>");
            }
            System.out.println("scanDrive()");
            sr5dc.scanDrive();
            System.out.println("removeDrive(0,0,0)");
            sr5dc.removeDrive(0, 0, 0);
        }
        catch (UnknownHostException e1) {
            System.out.println(e1.toString());
        }
        catch (IOException e2) {
            System.out.println(e2.toString());
        }
        catch (Exception e3) {
            System.out.println(e3.toString());
        }
        catch (NoClassDefFoundError e4) {
            System.out.println(e4.toString());
        }
    }
}

