/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class RaidGroupSummaryPage
extends KFrame
implements SortInterface {
    KTable raidGroupTable;
    RaidGroupManagerTableModel raidGroupTableModel;
    RaidGroupDatabaseUpdateListener raidGroupDatabaseUpdateListener;
    RaidGroupDatabase raidGroupDatabase;
    ArrayList raidGroupList;
    AbstractMessageHandler messageHandler;
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;
    JLabel raidGroupCountLabel;

    public RaidGroupSummaryPage(DatabaseManager databaseManager, String title) {
        this.beginFrameInit(databaseManager, title);
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.loadPreferences();
        this.buildMenus();
        this.getContentPane().add((Component)this.buildTable(), "Center");
        this.buildStatusBar();
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        this.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
        this.completeFrameInit();
    }

    protected void closeFrame() {
        this.raidGroupDatabase.removeUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.completeFrameClosure();
    }

    private void buildMenus() {
        JMenuItem openItem = new JMenuItem("Open...", 79);
        JMenuItem saveItem = new JMenuItem("Save...", 83);
        JMenuItem printItem = new JMenuItem("Print...", 80);
        JMenuItem exitItem = new JMenuItem("Exit", 88);
        openItem.setEnabled(false);
        saveItem.setEnabled(false);
        printItem.setEnabled(false);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RaidGroupSummaryPage.this.closeFrame();
            }
        });
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(exitItem);
        JMenuItem sortingItem = new JMenuItem("Sorting...", 83);
        JMenuItem fieldsItem = new JMenuItem("Fields...", 70);
        fieldsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new FieldsBox(RaidGroupSummaryPage.this, RaidGroupSummaryPage.this.raidGroupTable, RaidGroupSummaryPage.this.raidGroupTableModel);
            }
        });
        sortingItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SortBox(RaidGroupSummaryPage.this, RaidGroupDescriptor.fieldNames, RaidGroupSummaryPage.this.sortDescriptors);
                RaidGroupSummaryPage.this.raidGroupDatabaseUpdateListener.run();
            }
        });
        JMenu optionsMenu = new JMenu("Options");
        optionsMenu.setMnemonic(79);
        optionsMenu.add(sortingItem);
        optionsMenu.add(fieldsItem);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(optionsMenu);
        this.setJMenuBar(menubar);
    }

    private void buildStatusBar() {
        this.raidGroupCountLabel = new JLabel(" RAID Group Count: 0");
        this.raidGroupCountLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.raidGroupCountLabel, "South");
    }

    private void savePreferences() {
        int index;
        String columns = "";
        TableColumnModel tableColumnModel = this.raidGroupTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        for (index = 0; index < 1; ++index) {
            this.preferences.put("Table Sort Field" + index, RaidGroupDescriptor.fieldNames[this.sortDescriptors[index].field]);
            this.preferences.put("Table Sort Direction" + index, this.sortDescriptors[index].direction == 1 ? "Ascending" : "Descending");
        }
    }

    private void loadPreferences() {
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = this.preferences.get("Table Columns", "RAID Group,Label,Configuration,Status,Capacity");
            int startIndex = 0;
            do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (int index = 0; index < RaidGroupDescriptor.fieldNames.length; ++index) {
                    if (!RaidGroupDescriptor.fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            this.preferences.put("Table Columns", "RAID Group,Label,Configuration,Status,Capacity");
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index = 0; index < fieldList.size(); ++index) {
            this.defaultColumns[index] = fieldList.get(index);
        }
        this.sortedList = new ArrayList();
        this.sortDescriptors = new SortDescriptor[1];
        String[] defaultFields = new String[]{"RAID Group"};
        String[] defaultDirection = new String[]{"Ascending"};
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            String fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
            String direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            for (int index = 0; index < RaidGroupDescriptor.fieldNames.length; ++index) {
                if (!RaidGroupDescriptor.fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    private JScrollPane buildTable() {
        this.raidGroupList = this.getRaidGroupList();
        this.raidGroupTableModel = new RaidGroupManagerTableModel();
        this.raidGroupTable = new KTable(this.raidGroupTableModel, 24);
        this.raidGroupTable.setSelectionMode(0);
        this.raidGroupTable.getColumnModel().addColumnModelListener(new RaidGroupTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = RaidGroupSummaryPage.this.raidGroupTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = RaidGroupSummaryPage.this.raidGroupTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = RaidGroupSummaryPage.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = RaidGroupSummaryPage.this.raidGroupTableModel.getColumnName(column);
                    for (count = 0; count < RaidGroupDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(RaidGroupDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < RaidGroupDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        RaidGroupSummaryPage.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.raidGroupTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.raidGroupTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        JScrollPane scrollPane = new JScrollPane(this.raidGroupTable);
        scrollPane.getViewport().setBackground(this.raidGroupTable.getBackground());
        return scrollPane;
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
    }

    public synchronized ArrayList getRaidGroupList() {
        ArrayList newRaidGroupList = this.raidGroupDatabase.getRaidGroupList(false);
        ArrayList<RaidGroupDescriptor> sortedList = new ArrayList<RaidGroupDescriptor>();
        for (int sourceIndex = 0; sourceIndex < newRaidGroupList.size(); ++sourceIndex) {
            RaidGroupDescriptor destRaidGroup;
            int result;
            int destIndex;
            RaidGroupDescriptor sourceRaidGroup = (RaidGroupDescriptor)newRaidGroupList.get(sourceIndex);
            for (destIndex = 0; destIndex < sortedList.size() && (result = sourceRaidGroup.compare(destRaidGroup = (RaidGroupDescriptor)sortedList.get(destIndex), this.sortDescriptors[0])) < 1; ++destIndex) {
            }
            sortedList.add(destIndex, sourceRaidGroup);
        }
        return sortedList;
    }

    class RaidGroupManagerTableModel
    extends KTableModel {
        public RaidGroupManagerTableModel() {
            this.setColumns(RaidGroupDescriptor.reducedFieldNames, RaidGroupDescriptor.reducedMaxFieldText);
        }

        public Object[] getDefaultColumns() {
            return RaidGroupSummaryPage.this.defaultColumns;
        }

        public void updateDisplay() {
            if (RaidGroupSummaryPage.this.raidGroupList.size() > 0) {
                this.fireTableRowsInserted(0, RaidGroupSummaryPage.this.raidGroupList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return RaidGroupSummaryPage.this.raidGroupList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= RaidGroupSummaryPage.this.raidGroupList.size()) {
                value = "";
            } else {
                RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)RaidGroupSummaryPage.this.raidGroupList.get(row);
                value = raidGroup.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }
    }

    class RaidGroupTableColumnModelListener
    implements TableColumnModelListener {
        RaidGroupTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            RaidGroupSummaryPage.this.savePreferences();
        }

        public void columnMoved(TableColumnModelEvent e) {
            RaidGroupSummaryPage.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = RaidGroupSummaryPage.this.raidGroupTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < RaidGroupSummaryPage.this.raidGroupTable.getRowCount()) {
                RaidGroupSummaryPage.this.raidGroupTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)RaidGroupSummaryPage.this.raidGroupList.get(mouseSelectedRow);
            }
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    protected class RaidGroupDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void terminate() {
            this.active = false;
        }

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newRaidGroupList = RaidGroupSummaryPage.this.getRaidGroupList();
            if (RaidGroupSummaryPage.this.raidGroupTable.getSelectedRow() == -1) {
                RaidGroupSummaryPage.this.raidGroupList = newRaidGroupList;
                RaidGroupSummaryPage.this.raidGroupTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = RaidGroupSummaryPage.this.raidGroupList.size();
                int oldTableSize = RaidGroupSummaryPage.this.raidGroupTableModel.getRowCount();
                int[] selectedRows = RaidGroupSummaryPage.this.raidGroupTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)RaidGroupSummaryPage.this.raidGroupList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newRaidGroupList.size(); ++newRow) {
                        RaidGroupDescriptor newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newRow);
                        if (newRaidGroupDescriptor.raidGroup == raidGroupDescriptor.raidGroup) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                RaidGroupSummaryPage.this.raidGroupList = newRaidGroupList;
                RaidGroupSummaryPage.this.raidGroupTable.clearSelection();
                RaidGroupSummaryPage.this.raidGroupTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    RaidGroupSummaryPage.this.raidGroupTable.addRowSelectionInterval(newRow, newRow);
                }
            }
            RaidGroupSummaryPage.this.raidGroupCountLabel.setText(" RAID Group Count: " + RaidGroupSummaryPage.this.raidGroupList.size());
        }
    }
}

