/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class StorageManagementUtility
extends KFrame
implements GlobalConstants {
    static BuildCheck buildCheck = new BuildCheck();
    DatabaseManager databaseManager;
    ArrayList openWindows = new ArrayList();
    MenuBar menubar;
    DeviceChannelPanel deviceChannelPanel;
    HostConnectionTreePane hostConnectionTreePane;
    int waitCount;
    UpdateListener updateListener;
    HostConnectionManager hostConnectionManager;
    CommManager commManager;
    CommLinkUpdateListener commLinkUpdateListener;
    DatabaseNukeListener databaseNukeListener;
    JLabel subsystemStatusLabel;
    JLabel link0Label;
    ArrayList modalWindows = new ArrayList();
    public int createdRaidGroupCount;
    public boolean legacySupportOption;
    public boolean deleteMemberOption;
    public boolean resourceInfoOption;
    public boolean advancedRaidOption;
    public boolean logFileGen;
    public String logFilePath;
    public String purgeFilePath;
    public String popUpLevel;
    public String applicationName;
    public String companyName;
    public String noControllerMessage;
    public String legacySupportMessage;
    static StorageManagementUtility storageManagementUtility;
    static boolean firstTime;
    private static Preferences configPreferences;
    static boolean minimized;
    static SplashScreen mSplash;
    static FileLock oneIstanceSemaphore;

    public static void main(String[] arguments) {
        String errorString;
        try {
            for (int index = 0; index < arguments.length; ++index) {
                String argument = arguments[index].toLowerCase();
                if (!argument.equals("-min")) continue;
                minimized = true;
            }
        }
        catch (Exception e) {
            errorString = "StorageManagementUtility: main(): unable to extract call arguments";
            ErrorLog.put(e, errorString);
            Utility.println(errorString);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                UIManager.put("ScrollBar.track", new Color(230, 230, 230));
                UIDefaults defaults = UIManager.getDefaults();
                Font newFont = new Font("Dialog", 0, 12);
                Enumeration enumeration = defaults.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    Object value = defaults.get(key);
                    String name = key.toString();
                    if (!name.endsWith("font") || !value.toString().endsWith("[family=sansserif,name=MS Sans Serif,style=plain,size=11]")) continue;
                    UIManager.put(name, new FontUIResource(newFont));
                }
            }
        }
        catch (Exception e) {
            errorString = "StorageManagementUtility: main(): unable to load application look and feel";
            ErrorLog.put(e, errorString + "\nDetails: ");
            Utility.println(errorString);
        }
        if (!minimized) {
            try {
                mSplash = new SplashScreen("SplashScreen.jpg");
            }
            catch (Exception e) {
                errorString = "StorageManagementUtility: main(): unable to launch splash screen";
                ErrorLog.put(e, errorString);
                Utility.println(errorString);
            }
        }
        ApplicationLog.put("Application version: Version 1.5.1.1");
        try {
            oneIstanceSemaphore = new FileOutputStream(GlobalConstants.userDirectory + GlobalConstants.separatorChar + "AppLock").getChannel().tryLock();
            if (oneIstanceSemaphore == null) {
                JOptionPane.showMessageDialog(null, "Another instance of the application is already running.\nPlease press the button to exit", "Warning", 2);
                ApplicationLog.put("StorageManagementUtility: main(): Another instance of the application detected");
                System.exit(0);
            }
            ApplicationLog.put("StorageManagementUtility: main(): Application lock acquired");
        }
        catch (Exception e) {
            errorString = "StorageManagementUtility: main(): " + e.getMessage();
            ErrorLog.put(e, errorString);
            Utility.println(errorString);
            JOptionPane.showMessageDialog(null, "Could not acquire application lock!\nPlease press the button to exit", "Error", 0);
            System.exit(0);
        }
        try {
            storageManagementUtility = new StorageManagementUtility(arguments);
        }
        catch (Exception e) {
            errorString = "StorageManagementUtility: main(): unable to instantiate StorageManagementUtility class";
            ErrorLog.put(e, errorString);
            Utility.println(errorString);
        }
    }

    public synchronized void systemExitApplication() {
        System.exit(0);
    }

    private StorageManagementUtility(String[] arguments) {
        this.ReadOEMData();
        this.beginFrameInit(this.databaseManager, this, this.applicationName + " (Array Manager)");
        this.hostConnectionManager = new HostConnectionManager(this);
        this.commManager = this.hostConnectionManager.getCommManager();
        this.databaseManager = new DatabaseManager(this, this.hostConnectionManager);
        this.commManager.addDatabaseManager(this.databaseManager);
        this.loadConfigurationPreferences();
        this.waitCount = 0;
        this.enableEvents(64L);
        this.commManager.remoteDebug(false);
        this.databaseManager.startUpInitialization();
    }

    private void ReadOEMData() {
        try {
            OEMData oemData = new OEMData("OEM.dat");
            this.applicationName = oemData.getApplicationName();
            if (this.applicationName == null) {
                this.applicationName = "SATARAID5";
            }
            this.companyName = oemData.getCompanyName();
            if (this.companyName == null) {
                this.companyName = "Silicon Image";
            }
            this.noControllerMessage = oemData.getNoControllerMessage();
            this.legacySupportMessage = oemData.getLegacySupportMessage();
        }
        catch (Exception e) {
            this.applicationName = "SATARAID5";
            this.companyName = "Silicon Image";
            this.noControllerMessage = "This utility is used to configure RAID capable chips and host bus adapters.\nIf there are chips or host bus adapters installed in this system which are not being\ndetected, please perform the following steps.\n\n1.  If the RAID controller is a PCI Host Bus Adapter card, turn power off and make sure\n    the card is fully inserted into its PCI slot.\n2.  Verify that all motherboard BIOS settings are set according to the manufacturers   \n    recommendations.\n3.  Check that all disks and cables are connected and powered on.\n  ";
            this.legacySupportMessage = "Yes";
        }
    }

    public void databaseInitialized() {
        if (!firstTime) {
            this.deviceChannelPanel.addListeners();
            this.hostConnectionTreePane.addListeners();
            this.addListeners();
            this.updateStatusBar();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (mSplash != null) {
                    mSplash.dismiss();
                    mSplash = null;
                }
                StorageManagementUtility.this.menubar = new MenuBar();
                StorageManagementUtility.this.setJMenuBar(StorageManagementUtility.this.menubar);
                StorageManagementUtility.this.buildStatusBar();
                StorageManagementUtility.this.deviceChannelPanel = new DeviceChannelPanel(StorageManagementUtility.this, StorageManagementUtility.this.databaseManager);
                JScrollPane deviceChannelPane = new JScrollPane(StorageManagementUtility.this.deviceChannelPanel);
                deviceChannelPane.getHorizontalScrollBar().setUnitIncrement(StorageManagementUtility.this.deviceChannelPanel.getHorizontalScrollUnitIncrement());
                deviceChannelPane.getVerticalScrollBar().setUnitIncrement(StorageManagementUtility.this.deviceChannelPanel.getVerticalScrollUnitIncrement());
                Dimension dim = deviceChannelPane.getPreferredSize();
                dim.width = StorageManagementUtility.this.deviceChannelPanel.getPreferredWidth();
                deviceChannelPane.setPreferredSize(dim);
                StorageManagementUtility.this.hostConnectionTreePane = new HostConnectionTreePane(StorageManagementUtility.this, StorageManagementUtility.this.databaseManager);
                JScrollPane raidTreePane = new JScrollPane(StorageManagementUtility.this.hostConnectionTreePane);
                raidTreePane.setHorizontalScrollBarPolicy(31);
                dim = StorageManagementUtility.this.hostConnectionTreePane.getPreferredSize();
                dim.width = 200;
                StorageManagementUtility.this.hostConnectionTreePane.setPreferredSize(dim);
                JSplitPane mainPane = new JSplitPane(1, raidTreePane, deviceChannelPane);
                mainPane.setResizeWeight(0.0);
                dim = mainPane.getPreferredSize();
                dim.height = 360;
                dim.width = 640;
                mainPane.setPreferredSize(dim);
                StorageManagementUtility.this.getContentPane().add((Component)mainPane, "Center");
                StorageManagementUtility.this.pack();
                mainPane.setDividerLocation(220);
                StorageManagementUtility.this.completeFrameInit();
                StorageManagementUtility.this.updateListener = new UpdateListener();
                StorageManagementUtility.this.commLinkUpdateListener = new CommLinkUpdateListener();
                StorageManagementUtility.this.databaseNukeListener = new DatabaseNukeListener();
                StorageManagementUtility.this.addListeners();
                StorageManagementUtility.this.updateListener.run();
                StorageManagementUtility.this.commLinkUpdateListener.run();
                firstTime = false;
                if (StorageManagementUtility.this.databaseManager.eventDatabase.initializationEvents()) {
                    StorageManagementUtility.this.databaseManager.eventDatabase.newEventNotification();
                }
            }
        });
    }

    protected void completeFrameInit() {
        this.pack();
        this.preferences.putBoolean("Frame Open", true);
        Rectangle rectangle = Utility.getCenteredBounds(this);
        this.systemPreferences.putBoolean("RememberLocations", true);
        if (this.systemPreferences.getBoolean("RememberLocations", true)) {
            rectangle.width = this.preferences.getInt("Frame Width", rectangle.width);
            rectangle.height = this.preferences.getInt("Frame Height", rectangle.height);
            rectangle.x = this.preferences.getInt("Frame X", rectangle.x);
            rectangle.y = this.preferences.getInt("Frame Y", rectangle.y);
        }
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
                StorageManagementUtility.this.saveFrameBounds();
            }

            public void componentResized(ComponentEvent e) {
                StorageManagementUtility.this.saveFrameBounds();
            }

            public void componentShown(ComponentEvent e) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                StorageManagementUtility.this.commManager.goodbyeConnection();
                StorageManagementUtility.this.closeFrame();
            }
        });
        ((Component)this).setBounds(rectangle);
        this.setResizable(true);
        if (minimized) {
            storageManagementUtility.setExtendedState(1);
        }
        ((Component)this).setVisible(true);
    }

    public synchronized void closeNotification(Object closingObject) {
        for (int index = 0; index < this.openWindows.size(); ++index) {
            if (closingObject != this.openWindows.get(index)) continue;
            this.openWindows.remove(index);
            break;
        }
    }

    private void buildStatusBar() {
        JPanel statusBar = new JPanel();
        GridBagLayout statusBarLayout = new GridBagLayout();
        statusBar.setLayout(statusBarLayout);
        this.getContentPane().add((Component)statusBar, "South");
        ControllerDescriptor connectedController = this.databaseManager.controllerDatabase.getConnectedController();
        this.subsystemStatusLabel = new JLabel(" Controller: " + connectedController.chipType);
        Utility.setLabelAtrributes(this.subsystemStatusLabel, 10, 0, 1, 2, statusBarLayout);
        statusBar.add(this.subsystemStatusLabel);
        this.link0Label = new JLabel(" Link Status: Connected");
        Utility.setLabelAtrributes(this.link0Label, 4, 1, 0, 0, statusBarLayout);
        statusBar.add(this.link0Label);
    }

    private void updateStatusBar() {
        ControllerDescriptor connectedController = this.databaseManager.controllerDatabase.getConnectedController();
        this.subsystemStatusLabel.setText(connectedController.chipType);
    }

    public synchronized void addListeners() {
        this.databaseManager.raidGroupDatabase.addUpdateListener(this.updateListener);
        this.databaseManager.deviceDatabase.addUpdateListener(this.updateListener);
        this.databaseManager.eventDatabase.addUpdateListener(this.updateListener);
        this.databaseManager.controllerDatabase.addUpdateListener(this.updateListener);
        this.commManager.addUpdateListener(this.commLinkUpdateListener);
        this.databaseManager.addNukeListener(this.databaseNukeListener);
        this.updateListener.run();
        this.commLinkUpdateListener.run();
    }

    private synchronized void removeListeners() {
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.updateListener);
        this.databaseManager.deviceDatabase.removeUpdateListener(this.updateListener);
        this.databaseManager.eventDatabase.removeUpdateListener(this.updateListener);
        this.databaseManager.controllerDatabase.removeUpdateListener(this.updateListener);
        this.commManager.removeUpdateListener(this.commLinkUpdateListener);
        this.databaseManager.removeNukeListener(this.databaseNukeListener);
    }

    private boolean alreadyOpen(String title) {
        for (int index = 0; index < this.openWindows.size(); ++index) {
            JFrame frame = (JFrame)this.openWindows.get(index);
            if (!frame.getTitle().equals(title)) continue;
            frame.toFront();
            return true;
        }
        return false;
    }

    private boolean previouslyOpen(String title) {
        Preferences preferences = Preferences.userRoot().node("/Sam/" + title);
        return preferences.getBoolean("Frame Open", false);
    }

    public void loadConfigurationPreferences() {
        this.logFileGen = configPreferences.getBoolean("logfilegen", false);
        this.logFilePath = configPreferences.get("logfilepath", "");
        if (this.logFilePath.equals("")) {
            this.logFilePath = GlobalConstants.userDirectory + GlobalConstants.separatorChar + "eventlog.evl";
        }
        this.purgeFilePath = configPreferences.get("purgefilepath", "");
        if (this.purgeFilePath.equals("")) {
            this.purgeFilePath = GlobalConstants.userDirectory + GlobalConstants.separatorChar + "eventlog.bak";
        }
        this.popUpLevel = configPreferences.get("popUpLevel", "");
        if (this.popUpLevel.equals("")) {
            this.popUpLevel = "Error";
        }
        this.legacySupportOption = configPreferences.getBoolean("legacySupportOption", false);
        this.deleteMemberOption = configPreferences.getBoolean("deleteMemberOption", false);
        this.resourceInfoOption = configPreferences.getBoolean("resourceInfoOption", false);
        this.advancedRaidOption = configPreferences.getBoolean("advancedRaidOption", false);
        if (this.legacySupportMessage == null) {
            this.legacySupportOption = false;
        }
    }

    public void saveConfigurationPreferences() {
        configPreferences.putBoolean("logfilegen", this.logFileGen);
        configPreferences.put("logfilepath", this.logFilePath);
        configPreferences.put("purgefilepath", this.purgeFilePath);
        configPreferences.put("popUpLevel", this.popUpLevel);
        if (this.legacySupportMessage != null) {
            configPreferences.putBoolean("legacySupportOption", this.legacySupportOption);
        }
        configPreferences.putBoolean("deleteMemberOption", this.deleteMemberOption);
        configPreferences.putBoolean("resourceInfoOption", this.resourceInfoOption);
        configPreferences.putBoolean("advancedRaidOption", this.advancedRaidOption);
    }

    public void saveLogFilePathConfiguration(String newLogFilePath) {
        this.logFilePath = newLogFilePath;
        configPreferences.put("logfilepath", this.logFilePath);
    }

    public void savePurgeFilePathConfiguration(String newPurgeFilePath) {
        this.purgeFilePath = newPurgeFilePath;
        configPreferences.put("logfilepath", this.purgeFilePath);
    }

    public synchronized void setWait() {
        if (this.waitCount++ == 0) {
            this.setCursor(new Cursor(3));
        }
    }

    public synchronized void clearWait() {
        if (--this.waitCount == 0) {
            this.setCursor(new Cursor(0));
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.fileExit_actionPerformed(null);
        }
    }

    public void fileExit_actionPerformed(ActionEvent e) {
        this.systemExitApplication();
    }

    public void addModalWindow(Object thing) {
        Node node = this.getNewNode();
        node.thing = thing;
        this.modalWindows.add(node);
    }

    public Object getTopModalWindow() {
        return this.getModalWindow(this.modalWindows.size() - 1);
    }

    public Object getModalWindow(int index) {
        return ((Node)this.modalWindows.get((int)index)).thing;
    }

    public void removeTopModalWindow() {
        this.removeModalWindow(this.modalWindows.size() - 1);
    }

    public void removeModalWindow(int index) {
        this.modalWindows.remove(index);
    }

    public void removeModalWindow(Object thing) {
        for (int index = 0; index < this.getNumberOfModalWindows(); ++index) {
            if (this.getModalWindow(index) != thing) continue;
            this.removeModalWindow(index);
        }
    }

    public Node getNewNode() {
        return new Node();
    }

    public boolean anyModalWindows() {
        return this.getNumberOfModalWindows() > 0;
    }

    public boolean isManagedModalWindow(Object thing) {
        for (int index = 0; index < this.getNumberOfModalWindows(); ++index) {
            if (this.getModalWindow(index) != thing) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfModalWindows() {
        return this.modalWindows.size();
    }

    public void setWindowsModality(boolean modality) {
        for (int index = 0; index < this.getNumberOfModalWindows(); ++index) {
            ((JDialog)this.getModalWindow(index)).setModal(modality);
        }
    }

    static {
        firstTime = true;
        configPreferences = Preferences.userRoot().node("/Sam/System/Configuration");
        minimized = false;
        mSplash = null;
    }

    private class Node {
        Object thing;

        private Node() {
        }
    }

    private class CommLinkUpdateListener
    implements Runnable {
        private CommLinkUpdateListener() {
        }

        public void run() {
            StorageManagementUtility.this.link0Label.setText(" Link Status: " + StorageManagementUtility.this.commManager.commLink.upDownStatus);
        }
    }

    private class DatabaseNukeListener
    implements Runnable {
        private DatabaseNukeListener() {
        }

        public void run() {
            StorageManagementUtility.this.removeListeners();
        }
    }

    protected class UpdateListener
    implements Runnable {
        protected UpdateListener() {
        }

        public void run() {
            StorageManagementUtility.this.menubar.update();
        }
    }

    class MenuBar
    extends JMenuBar {
        JMenu fileMenu = this.buildFileMenu();
        JMenu systemMenu;
        JMenu deviceMenu = this.buildDeviceMenu();
        JMenu raidGroupMenu = this.buildRaidGroupMenu();
        JMenu windowMenu = this.buildWindowMenu();
        JMenu legacyMenu = this.buildLegacySupportMenu();
        JMenu debugMenu = this.buildDebugMenu();
        JMenu helpMenu = this.buildHelpMenu();
        JMenuItem createSpareMenuItem;
        JMenuItem deleteSpareMenuItem;
        JMenuItem deleteMemberMenuItem;
        JMenuItem deleteOrphanMenuItem;
        JMenuItem makePassThruMenuItem;
        JMenuItem deviceSummaryMenuItem;
        JMenuItem raidGroupParametersMenuItem;
        JMenuItem createRaidGroupMenuItem;
        JMenuItem reconfigureRaidSetMenuItem;
        JMenuItem rebuildRaidGroupMenuItem;
        JMenuItem checkRaidSetMenuItem;
        JMenuItem deleteRaidGroupMenuItem;
        JMenuItem raidGroupSummaryMenuItem;
        JMenuItem bringRaidGroupOnlineMenuItem;
        JMenuItem firmwareMenuItem;
        JMenuItem shutdownMenuItem;
        JMenuItem breakpointMenuItem;
        JMenuItem taskManagerMenuItem;
        JMenuItem eventLogMenuItem;
        JMenuItem performanceMenuItem;
        JMenuItem resourceInfoMenuItem;
        JMenuItem processInfoMenuItem;
        JMenuItem createLegacyRaidGroupMenuItem;
        JMenuItem convertLegacyRaidGroupMenuItem;
        JMenuItem convertLegacySpareMenuItem;
        JMenuItem createLegacySpareMenuItem;
        JMenuItem deleteLegacySpareMenuItem;
        JMenuItem rebuildLegacyRaidGroupMenuItem;
        JMenuItem deleteLegacyRaidGroupMenuItem;
        JMenuItem bringLegacyRaidGroupOnlineMenuItem;
        JMenuItem nukeMetadataMenuItem;

        public MenuBar() {
            this.createMenuBar();
            this.update();
        }

        private void createMenuBar() {
            this.add(this.fileMenu);
            this.add(this.deviceMenu);
            this.add(this.raidGroupMenu);
            this.add(this.windowMenu);
            if (StorageManagementUtility.this.legacySupportOption) {
                this.add(this.legacyMenu);
            }
            this.add(this.helpMenu);
        }

        private void updateMenuBar() {
            this.removeAll();
            this.rebuildDeviceMenu();
            this.rebuildWindowMenu();
            this.createMenuBar();
        }

        public void update() {
            if (!StorageManagementUtility.this.commManager.commLink.enabled) {
                return;
            }
            this.reconfigureRaidSetMenuItem.setEnabled(false);
            this.checkRaidSetMenuItem.setEnabled(false);
            this.deleteRaidGroupMenuItem.setEnabled(false);
            this.deleteMemberMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.newRaidGroupExists()) {
                this.rebuildRaidGroupMenuItem.setEnabled(true);
                this.deleteRaidGroupMenuItem.setEnabled(true);
                String[] raidGroupStatuses = new String[]{"Online"};
                if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.getRaidGroupList(raidGroupStatuses, true, "New").size() > 0) {
                    this.deleteMemberMenuItem.setEnabled(true);
                }
            }
            this.deleteSpareMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.newSpareExists()) {
                this.deleteSpareMenuItem.setEnabled(true);
            }
            this.deleteOrphanMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.orphanedSegmentExists()) {
                this.deleteOrphanMenuItem.setEnabled(true);
            }
            this.makePassThruMenuItem.setEnabled(false);
            this.deviceSummaryMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.availableSegmentExists() && StorageManagementUtility.this.databaseManager.deviceDatabase.getDeviceList().size() > 0) {
                this.makePassThruMenuItem.setEnabled(true);
                this.deviceSummaryMenuItem.setEnabled(true);
            }
            this.rebuildRaidGroupMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.newReducedRaidGroupExists() && StorageManagementUtility.this.databaseManager.deviceDatabase.availableSegmentExists()) {
                this.rebuildRaidGroupMenuItem.setEnabled(true);
            }
            this.createRaidGroupMenuItem.setEnabled(false);
            this.createSpareMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.availableSegmentExists()) {
                if (StorageManagementUtility.this.databaseManager.deviceDatabase.getNumberOfAllSpares() < StorageManagementUtility.this.databaseManager.maximumSpares) {
                    this.createSpareMenuItem.setEnabled(true);
                }
                if (StorageManagementUtility.this.databaseManager.deviceDatabase.qualifiedSegmentExists() && StorageManagementUtility.this.databaseManager.raidGroupDatabase.getNextAvailableRaidGroup() != -1) {
                    this.createRaidGroupMenuItem.setEnabled(true);
                }
            }
            this.bringRaidGroupOnlineMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.minimumRaidGroupExists("New")) {
                this.bringRaidGroupOnlineMenuItem.setEnabled(true);
            }
            this.raidGroupSummaryMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.getRaidGroupList(false, "New").size() > 0) {
                this.raidGroupSummaryMenuItem.setEnabled(true);
            }
            this.createLegacyRaidGroupMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.legacyBootSupportable() && StorageManagementUtility.this.databaseManager.deviceDatabase.qualifiedSegmentExists() && !StorageManagementUtility.this.databaseManager.raidGroupDatabase.legacyRaidGroupMaxReached()) {
                this.createLegacyRaidGroupMenuItem.setEnabled(true);
            }
            this.createLegacySpareMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.legacyRaidGroupExists() && StorageManagementUtility.this.databaseManager.raidGroupDatabase.getRaidGroupList(true, "Old").size() > 0 && StorageManagementUtility.this.databaseManager.deviceDatabase.getBootableSegmentCount() > 0 && StorageManagementUtility.this.databaseManager.deviceDatabase.qualifiedLegacySpareSegmentExists()) {
                this.createLegacySpareMenuItem.setEnabled(true);
            }
            this.convertLegacyRaidGroupMenuItem.setEnabled(false);
            this.deleteLegacyRaidGroupMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.legacyRaidGroupExists()) {
                this.convertLegacyRaidGroupMenuItem.setEnabled(true);
                this.deleteLegacyRaidGroupMenuItem.setEnabled(true);
            }
            this.rebuildLegacyRaidGroupMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.legacyReducedRaidGroupExists() && StorageManagementUtility.this.databaseManager.deviceDatabase.availableLbn0SegmentExists()) {
                this.rebuildLegacyRaidGroupMenuItem.setEnabled(true);
            }
            this.convertLegacySpareMenuItem.setEnabled(false);
            this.deleteLegacySpareMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.legacySpareExists()) {
                this.convertLegacySpareMenuItem.setEnabled(true);
                this.deleteLegacySpareMenuItem.setEnabled(true);
            }
            this.bringLegacyRaidGroupOnlineMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.minimumRaidGroupExists("Old")) {
                this.bringLegacyRaidGroupOnlineMenuItem.setEnabled(true);
            }
        }

        public JMenu buildFileMenu() {
            this.fileMenu = new JMenu("File");
            this.fileMenu.setMnemonic(70);
            JMenuItem connectionMenuItem = new JMenuItem("Connections...", 67);
            JMenuItem configurationMenuItem = new JMenuItem("Configuration...", 75);
            JMenuItem exitMenuItem = new JMenuItem("Exit", 88);
            this.fileMenu.add(configurationMenuItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(exitMenuItem);
            connectionMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new PostponedConnectionTableBox(StorageManagementUtility.this, ((MenuBar)MenuBar.this).StorageManagementUtility.this.hostConnectionManager);
                }
            });
            configurationMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConfigurationBox configurationBox = new ConfigurationBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Configuration Screen");
                    configurationBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.updateMenuBar();
                    StorageManagementUtility.this.setJMenuBar(((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar);
                }
            });
            exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.commManager.goodbyeConnection();
                    StorageManagementUtility.this.systemExitApplication();
                }
            });
            return this.fileMenu;
        }

        public JMenu buildDeviceMenu() {
            this.deviceMenu = new JMenu("Device");
            this.deviceMenu.setMnemonic(68);
            this.createSpareMenuItem = new JMenuItem("Create Spare", 67);
            this.deleteSpareMenuItem = new JMenuItem("Delete Spare", 68);
            this.deleteMemberMenuItem = new JMenuItem("Delete Member", 77);
            this.deleteOrphanMenuItem = new JMenuItem("Delete Orphan", 79);
            this.makePassThruMenuItem = new JMenuItem("Make Pass-Thru", 80);
            this.deviceSummaryMenuItem = new JMenuItem("Device Summary", 86);
            this.createSpareMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CreateSpareBox createSpareBox = new CreateSpareBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Create Spare");
                    createSpareBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.deleteSpareMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DeleteSpareBox deleteSpareBox = new DeleteSpareBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Delete Spare", "New");
                    deleteSpareBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.deleteMemberMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DeleteRaidGroupMemberBox deleteRaidGroupMemberBox = new DeleteRaidGroupMemberBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Delete RAID Group Member");
                    deleteRaidGroupMemberBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.deleteOrphanMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DeleteOrphanBox deleteOrphanBox = new DeleteOrphanBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Delete Orphan Segment", "New");
                    deleteOrphanBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.makePassThruMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakePassThruBox makePassThruBox = new MakePassThruBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Make Pass-Thru");
                    makePassThruBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.deviceSummaryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = "Device Summary";
                    if (!StorageManagementUtility.this.alreadyOpen(title)) {
                        ((MenuBar)MenuBar.this).StorageManagementUtility.this.openWindows.add(new DeviceSummaryPage(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, title));
                    }
                }
            });
            this.deviceMenu.add(this.createSpareMenuItem);
            this.deviceMenu.add(this.deleteSpareMenuItem);
            if (StorageManagementUtility.this.deleteMemberOption) {
                this.deviceMenu.add(this.deleteMemberMenuItem);
            }
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.deleteOrphanMenuItem);
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.makePassThruMenuItem);
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.deviceSummaryMenuItem);
            return this.deviceMenu;
        }

        private void rebuildDeviceMenu() {
            this.deviceMenu.removeAll();
            this.deviceMenu.add(this.createSpareMenuItem);
            this.deviceMenu.add(this.deleteSpareMenuItem);
            if (StorageManagementUtility.this.deleteMemberOption) {
                this.deviceMenu.add(this.deleteMemberMenuItem);
            }
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.deleteOrphanMenuItem);
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.makePassThruMenuItem);
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.deviceSummaryMenuItem);
        }

        public JMenu buildRaidGroupMenu() {
            this.raidGroupMenu = new JMenu("RAID Group");
            this.raidGroupMenu.setMnemonic(82);
            this.raidGroupParametersMenuItem = new JMenuItem("RAID Group Parameters", 80);
            this.createRaidGroupMenuItem = new JMenuItem("Create RAID Group", 67);
            this.reconfigureRaidSetMenuItem = new JMenuItem("Reconfigure RAID Group", 71);
            this.rebuildRaidGroupMenuItem = new JMenuItem("Rebuild RAID Group", 82);
            this.checkRaidSetMenuItem = new JMenuItem("Check RAID Group", 72);
            this.deleteRaidGroupMenuItem = new JMenuItem("Delete RAID Group", 68);
            this.bringRaidGroupOnlineMenuItem = new JMenuItem("Bring RAID Group Online", 66);
            this.raidGroupSummaryMenuItem = new JMenuItem("RAID Group Summary", 83);
            this.createRaidGroupMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int answer = 0;
                    if (((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager.deviceDatabase.legacyBootSupportable() && ((MenuBar)MenuBar.this).StorageManagementUtility.this.legacySupportOption) {
                        answer = JOptionPane.showConfirmDialog(StorageManagementUtility.this, "Creation of RAID Group(s) now may prevent you from creating Bootable RAID Group(s) at a later time.\nOperating System can only be stored on and started from a Bootable RAID Group.\nTo create Bootable RAID Group(s), use the Create Legacy RAID Group option under the Legacy Support.\nAre you sure you want to continue?", "RAID Group Creation Verification", 0);
                    }
                    if (answer == 0) {
                        CreateRaidGroupBox createRaidGroupBox = new CreateRaidGroupBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Create RAID Group");
                        createRaidGroupBox = null;
                        ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                    }
                }
            });
            this.rebuildRaidGroupMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = "Rebuild RAID Group";
                    RebuildRaidGroupBox rebuildRaidGroupBox = new RebuildRaidGroupBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, title, "New");
                    rebuildRaidGroupBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.deleteRaidGroupMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = "Delete RAID Group";
                    DeleteRaidGroupBox deleteRaidGroupBox = new DeleteRaidGroupBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, title, "New");
                    deleteRaidGroupBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.bringRaidGroupOnlineMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = "Bring RAID Group Online";
                    BringRaidGroupOnlineBox bringRaidGroupOnlineBox = new BringRaidGroupOnlineBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, title, "New");
                    bringRaidGroupOnlineBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.raidGroupSummaryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = "RAID Group Summary";
                    if (!StorageManagementUtility.this.alreadyOpen(title)) {
                        ((MenuBar)MenuBar.this).StorageManagementUtility.this.openWindows.add(new RaidGroupSummaryPage(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, title));
                    }
                }
            });
            this.raidGroupMenu.add(this.createRaidGroupMenuItem);
            this.raidGroupMenu.add(this.rebuildRaidGroupMenuItem);
            this.raidGroupMenu.add(this.deleteRaidGroupMenuItem);
            this.raidGroupMenu.addSeparator();
            this.raidGroupMenu.add(this.bringRaidGroupOnlineMenuItem);
            this.raidGroupMenu.addSeparator();
            this.raidGroupMenu.add(this.raidGroupSummaryMenuItem);
            return this.raidGroupMenu;
        }

        public JMenu buildSystemMenu() {
            this.systemMenu = new JMenu("System");
            this.systemMenu.setMnemonic(83);
            JMenuItem parametersMenuItem = new JMenuItem("System Parameters", 80);
            JMenuItem deviceParametersMenuItem = new JMenuItem("Device Parameters", 68);
            JMenuItem flashMenuItem = new JMenuItem("Flash Images", 70);
            this.firmwareMenuItem = new JMenuItem("Update Firmware", 85);
            this.shutdownMenuItem = new JMenuItem("Shutdown System", 83);
            this.systemMenu.add(parametersMenuItem);
            this.systemMenu.add(deviceParametersMenuItem);
            this.systemMenu.add(flashMenuItem);
            this.systemMenu.add(this.firmwareMenuItem);
            this.systemMenu.add(this.shutdownMenuItem);
            return this.systemMenu;
        }

        public JMenu buildWindowMenu() {
            this.windowMenu = new JMenu("Window");
            this.windowMenu.setMnemonic(87);
            this.taskManagerMenuItem = new JMenuItem("Task Manager", 84);
            this.eventLogMenuItem = new JMenuItem("Event Log", 69);
            this.performanceMenuItem = new JMenuItem("I/O Statistics", 73);
            this.resourceInfoMenuItem = new JMenuItem("Resources", 82);
            this.processInfoMenuItem = new JMenuItem("Processes", 80);
            this.windowMenu.add(this.taskManagerMenuItem);
            this.windowMenu.add(this.eventLogMenuItem);
            if (StorageManagementUtility.this.resourceInfoOption) {
                this.windowMenu.add(this.resourceInfoMenuItem);
            }
            this.taskManagerMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = "Task Summary";
                    if (!StorageManagementUtility.this.alreadyOpen(title)) {
                        ((MenuBar)MenuBar.this).StorageManagementUtility.this.openWindows.add(new TaskManagerPage(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, title));
                    }
                }
            });
            this.eventLogMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new EventSummaryPage(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Event Log");
                }
            });
            this.resourceInfoMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = "Resource Information";
                    if (!StorageManagementUtility.this.alreadyOpen(title)) {
                        ((MenuBar)MenuBar.this).StorageManagementUtility.this.openWindows.add(new ResourcePage(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, title));
                    }
                }
            });
            return this.windowMenu;
        }

        private void rebuildWindowMenu() {
            this.windowMenu.removeAll();
            this.windowMenu.add(this.taskManagerMenuItem);
            this.windowMenu.add(this.eventLogMenuItem);
            if (StorageManagementUtility.this.resourceInfoOption) {
                this.windowMenu.add(this.resourceInfoMenuItem);
            }
        }

        public JMenu buildLegacySupportMenu() {
            String rebuildOldRaidGroupMetaDataStr = "Rebuild Legacy RAID Group";
            String deleteOldRaidGroupMetaDataStr = "Delete Legacy RAID Group";
            this.legacyMenu = new JMenu("Legacy Support");
            this.legacyMenu.setMnemonic(87);
            this.createLegacyRaidGroupMenuItem = new JMenuItem("Create Legacy RAID Group", 82);
            this.rebuildLegacyRaidGroupMenuItem = new JMenuItem("Rebuild Legacy RAID Group", 71);
            this.deleteLegacyRaidGroupMenuItem = new JMenuItem("Delete Legacy RAID Group", 69);
            this.convertLegacyRaidGroupMenuItem = new JMenuItem("Convert Legacy RAID Group", 67);
            this.bringLegacyRaidGroupOnlineMenuItem = new JMenuItem("Bring Legacy RAID Group Online", 66);
            this.createLegacySpareMenuItem = new JMenuItem("Create Legacy Spare", 65);
            this.deleteLegacySpareMenuItem = new JMenuItem("Delete Legacy Spare", 68);
            this.convertLegacySpareMenuItem = new JMenuItem("Convert Legacy Spare", 79);
            this.legacyMenu.add(this.createLegacyRaidGroupMenuItem);
            this.legacyMenu.add(this.rebuildLegacyRaidGroupMenuItem);
            this.legacyMenu.add(this.deleteLegacyRaidGroupMenuItem);
            this.legacyMenu.add(this.convertLegacyRaidGroupMenuItem);
            this.legacyMenu.addSeparator();
            this.legacyMenu.add(this.bringLegacyRaidGroupOnlineMenuItem);
            this.legacyMenu.addSeparator();
            this.legacyMenu.add(this.createLegacySpareMenuItem);
            this.legacyMenu.add(this.deleteLegacySpareMenuItem);
            this.legacyMenu.add(this.convertLegacySpareMenuItem);
            this.createLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CreateLegacyRaidGroupBox createLegacyRaidGroupBox = new CreateLegacyRaidGroupBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Create Legacy RAID Group");
                    createLegacyRaidGroupBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.rebuildLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RebuildRaidGroupBox rebuildRaidGroupBox = new RebuildRaidGroupBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Rebuild Legacy RAID Group", "Old");
                    rebuildRaidGroupBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.deleteLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DeleteRaidGroupBox deleteRaidGroupBox = new DeleteRaidGroupBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Delete Legacy RAID Group", "Old");
                    deleteRaidGroupBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.convertLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConvertLegacyRaidGroupBox convertLegacyRaidGroupBox = new ConvertLegacyRaidGroupBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Convert Legacy RAID Group");
                    convertLegacyRaidGroupBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.bringLegacyRaidGroupOnlineMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = "Bring Legacy RAID Group Online";
                    BringRaidGroupOnlineBox bringRaidGroupOnlineBox = new BringRaidGroupOnlineBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, title, "Old");
                    bringRaidGroupOnlineBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.createLegacySpareMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CreateLegacySpareBox createLegacySpareBox = new CreateLegacySpareBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Create Legacy Spare");
                    createLegacySpareBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.deleteLegacySpareMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DeleteSpareBox deleteSpareBox = new DeleteSpareBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Delete Legacy Spare", "Old");
                    deleteSpareBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            this.convertLegacySpareMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConvertLegacySpareBox convertLegacySpareBox = new ConvertLegacySpareBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager, "Convert Legacy Spare");
                    convertLegacySpareBox = null;
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            return this.legacyMenu;
        }

        public JMenu buildDebugMenu() {
            this.debugMenu = new JMenu("Debug");
            this.debugMenu.setMnemonic(71);
            this.nukeMetadataMenuItem = new JMenuItem("Nuke Metadata", 78);
            this.debugMenu.add(this.nukeMetadataMenuItem);
            this.nukeMetadataMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int answer = JOptionPane.showConfirmDialog(StorageManagementUtility.this, "Are you sure you want to Clear All Metadata?", "Clear All Metadata", 0);
                    if (answer == 0 && (answer = JOptionPane.showConfirmDialog(StorageManagementUtility.this, "Last chance!!! Are you REALLY sure you want to Clear All Metadata? All data will be irretrievably lost!!!", "Clear All Metadata", 0)) == 0) {
                        String request = "<si:Request><si:Type>NukeAllMetadata</si:Type></si:Request>";
                        ((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager.commManager.sendMessage("Execute", request, null);
                    }
                    ((MenuBar)MenuBar.this).StorageManagementUtility.this.menubar.update();
                }
            });
            return this.debugMenu;
        }

        public JMenu buildHelpMenu() {
            JMenu helpMenu = new JMenu("Help");
            helpMenu.setMnemonic(72);
            JMenuItem helpTopicsMenuItem = new JMenuItem("Help Topics", 84);
            this.breakpointMenuItem = new JMenuItem("Breakpoint", 66);
            JMenuItem AboutMenuItem = new JMenuItem("About", 65);
            helpTopicsMenuItem.setEnabled(false);
            helpMenu.add(helpTopicsMenuItem);
            helpMenu.addSeparator();
            helpMenu.add(AboutMenuItem);
            AboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new AboutBox(((MenuBar)MenuBar.this).StorageManagementUtility.this.databaseManager);
                }
            });
            return helpMenu;
        }
    }
}

