/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class HostConnectionTreePane
extends JScrollPane
implements GlobalConstants,
TreeSelectionListener {
    private StorageManagementUtility storageManagementUtility;
    private DatabaseManager databaseManager;
    private HostConnectionManager hostConnectionManager;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private ImageIcon controllerGreenIcon;
    private ImageIcon controllerYellowIcon;
    private ImageIcon raidGroupGreenIcon;
    private ImageIcon raidGroupYellowIcon;
    private ImageIcon raidGroupOrangeIcon;
    private ImageIcon raidGroupPinkIcon;
    private ImageIcon raidGroupRedIcon;
    private ImageIcon guiIcon;
    private ImageIcon localConnectionGreenIcon;
    private ImageIcon remoteConnectionGreenIcon;
    private ImageIcon localConnectionYellowIcon;
    private ImageIcon remoteConnectionYellowIcon;
    private JPopupMenu hostConnectionPopupMenu;
    private JMenuItem openConnectionMenuItem;
    private JMenuItem closeConnectionMenuItem;
    private ArrayList hostConnectionList;
    private HostConnectionDescriptor selectedHostConnectionDescriptor;
    private NodeInfo selectedHostNode;
    private NodeInfo selectedControllerNode;
    private JPopupMenu controllerPopupMenu;
    private JMenuItem createRaidGroupMenuItem;
    private JMenuItem createLegacyRaidGroupMenuItem;
    private JPopupMenu raidGroupPopupMenu;
    private JMenuItem rebuildRaidGroupMenuItem;
    private JMenuItem deleteRaidGroupMenuItem;
    private JMenuItem bringRaidGroupOnlineMenuItem;
    private JPopupMenu legacyRaidGroupPopupMenu;
    private JMenuItem rebuildLegacyRaidGroupMenuItem;
    private JMenuItem deleteLegacyRaidGroupMenuItem;
    private JMenuItem convertLegacyRaidGroupMenuItem;
    private JMenuItem bringLegacyRaidGroupOnlineMenuItem;
    private ArrayList raidGroupList;
    private RaidGroupDescriptor[] raidGroupTable;
    private RaidGroupDescriptor selectedRaidGroupDescriptor;
    private DatabaseChangeListener databaseChangeListener;
    private DatabaseNukeListener databaseNukeListener;
    private int popUpAnswer;

    public HostConnectionTreePane(StorageManagementUtility storageManagementUtility, DatabaseManager databaseManager) {
        this.storageManagementUtility = storageManagementUtility;
        this.databaseManager = databaseManager;
        this.hostConnectionManager = databaseManager.hostConnectionManager;
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        this.guiIcon = imageIconLoader.loadImageIcon("samIcon.gif");
        this.localConnectionGreenIcon = imageIconLoader.loadImageIcon("localSystem.gif");
        this.localConnectionYellowIcon = imageIconLoader.loadImageIcon("deviceYellow.gif");
        this.remoteConnectionGreenIcon = imageIconLoader.loadImageIcon("fibreGreen.gif");
        this.remoteConnectionYellowIcon = imageIconLoader.loadImageIcon("fibreYellow.gif");
        this.controllerGreenIcon = imageIconLoader.loadImageIcon("controllerGreen.gif");
        this.controllerYellowIcon = imageIconLoader.loadImageIcon("controllerYellow.gif");
        this.raidGroupGreenIcon = imageIconLoader.loadImageIcon("raidGroupGreen.gif");
        this.raidGroupYellowIcon = imageIconLoader.loadImageIcon("raidGroupYellow.gif");
        this.raidGroupOrangeIcon = imageIconLoader.loadImageIcon("raidGroupOrange.gif");
        this.raidGroupRedIcon = imageIconLoader.loadImageIcon("raidGroupRed.gif");
        this.raidGroupPinkIcon = imageIconLoader.loadImageIcon("raidGroupPink.gif");
        this.selectedHostNode = new NodeInfo();
        this.selectedControllerNode = new NodeInfo();
        this.buildHostConnectionTree();
        this.buildPopupMenus();
        AbstractListener connectionChangeHandler = new AbstractListener(){

            public void processChange() {
                HostConnectionTreePane.this.updateTreeHostNodes();
            }
        };
        this.hostConnectionManager.addUpdateListener(connectionChangeHandler);
        connectionChangeHandler.processChange();
        AbstractListener databaseInitializationHandler = new AbstractListener(){

            public void processChange() {
                HostConnectionTreePane.this.initializeTreeRaidDatabase();
                HostConnectionTreePane.this.updateTreeRaidNodes();
            }
        };
        databaseManager.addUpdateListener(databaseInitializationHandler);
        this.databaseChangeListener = new DatabaseChangeListener();
        this.databaseNukeListener = new DatabaseNukeListener();
        this.addListeners();
    }

    public synchronized void addListeners() {
        this.databaseManager.deviceDatabase.addUpdateListener(this.databaseChangeListener);
        this.databaseManager.raidGroupDatabase.addUpdateListener(this.databaseChangeListener);
        this.databaseManager.controllerDatabase.addUpdateListener(this.databaseChangeListener);
        this.databaseManager.addNukeListener(this.databaseNukeListener);
        this.databaseChangeListener.run();
    }

    private synchronized void removeListeners() {
        this.databaseManager.deviceDatabase.removeUpdateListener(this.databaseChangeListener);
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.databaseChangeListener);
        this.databaseManager.controllerDatabase.removeUpdateListener(this.databaseChangeListener);
        this.databaseManager.removeNukeListener(this.databaseNukeListener);
    }

    private void buildHostConnectionTree() {
        this.raidGroupList = new ArrayList();
        Nexus nexus = this.hostConnectionManager.getNexus();
        HostConnectionDescriptor hostConnectionDescriptor = this.hostConnectionManager.getHostConnection(this.hostConnectionManager.getCurrentConnectionIndex());
        NodeInfo hostInfo = new NodeInfo();
        this.rootNode = new DefaultMutableTreeNode(hostInfo);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        hostInfo.treeNode = this.rootNode;
        hostInfo.nodeType = 2;
        hostInfo.controllers = hostConnectionDescriptor.controllers;
        hostInfo.controller = hostConnectionDescriptor.controller;
        hostInfo.type = hostConnectionDescriptor.type;
        hostInfo.ipAddress = hostConnectionDescriptor.ipAddress;
        hostInfo.hostConnectionDescriptor = hostConnectionDescriptor;
        if (hostConnectionDescriptor.type.equals("Local")) {
            hostInfo.title = "Local Host";
            hostInfo.icon = this.localConnectionGreenIcon;
            if (nexus.local) {
                hostInfo.cloneTo(this.selectedHostNode);
            }
        } else if (hostConnectionDescriptor.type.equals("Remote")) {
            hostInfo.title = hostInfo.ipAddress;
            if (!hostConnectionDescriptor.alias.equals("")) {
                hostInfo.title = hostConnectionDescriptor.alias;
            }
            hostInfo.icon = this.remoteConnectionGreenIcon;
            if (hostConnectionDescriptor.ipAddress.equals(nexus.ipAddress) && !nexus.local) {
                hostInfo.icon = this.remoteConnectionGreenIcon;
                hostInfo.cloneTo(this.selectedHostNode);
            }
        }
        if (hostConnectionDescriptor.controllers != -1) {
            for (int controller = 0; controller < hostConnectionDescriptor.controllers; ++controller) {
                DefaultMutableTreeNode controllerNode;
                ControllerDescriptor controllerDescriptor = this.databaseManager.controllerDatabase.getController(controller);
                NodeInfo controllerInfo = new NodeInfo();
                controllerInfo.treeNode = controllerNode = new DefaultMutableTreeNode(controllerInfo);
                controllerInfo.title = "Controller " + Integer.toString(controller) + " - " + controllerDescriptor.chipType;
                controllerInfo.nodeType = 1;
                controllerInfo.controllers = hostInfo.controllers;
                controllerInfo.controller = controller;
                controllerInfo.type = hostInfo.type;
                controllerInfo.ipAddress = hostInfo.ipAddress;
                controllerInfo.hostConnectionDescriptor = hostConnectionDescriptor;
                controllerInfo.icon = this.controllerGreenIcon;
                if (hostConnectionDescriptor.ipAddress.equals(nexus.ipAddress) && controller == nexus.controller) {
                    controllerInfo.cloneTo(this.selectedControllerNode);
                }
                this.rootNode.add(controllerNode);
            }
        }
        TreePath treePath = new TreePath(this.rootNode.getPath());
        this.tree.scrollPathToVisible(treePath);
        if (hostConnectionDescriptor.type.equals(nexus.local ? "Local" : "Remote") && hostConnectionDescriptor.ipAddress.equals(nexus.ipAddress)) {
            if (hostConnectionDescriptor.controllers != -1) {
                DefaultMutableTreeNode firstControllerNode = this.rootNode.getFirstLeaf();
                DefaultMutableTreeNode lastRaidGroupNode = firstControllerNode.getLastLeaf();
                treePath = new TreePath(lastRaidGroupNode.getPath());
                this.tree.scrollPathToVisible(treePath);
            }
            this.tree.expandPath(treePath);
        }
        this.hostConnectionList = this.hostConnectionManager.getHostConnectionList();
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(new MouseTreeListener());
        this.tree.setCellRenderer(new TreeCellRenderer());
        this.tree.setRowHeight(18);
        Dimension d = this.tree.getPreferredSize();
        d.width = (int)((double)d.width * 1.25);
        this.tree.setPreferredSize(d);
        this.setViewportView(this.tree);
    }

    public void buildPopupMenus() {
        this.controllerPopupMenu = new JPopupMenu();
        this.createRaidGroupMenuItem = new JMenuItem("Create RAID Group", 67);
        this.createLegacyRaidGroupMenuItem = new JMenuItem("Create Legacy RAID Group", 76);
        this.createRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConnectionTreePane.this.popUpAnswer = 0;
                if (((HostConnectionTreePane)HostConnectionTreePane.this).storageManagementUtility.legacySupportOption && ((HostConnectionTreePane)HostConnectionTreePane.this).databaseManager.deviceDatabase.legacyBootSupportable()) {
                    String header = "RAID Group Creation Verification";
                    new MessagePopUpBox(header, "Creation of RAID Group(s) now may prevent you from creating Bootable RAID Group(s) at a later time.\nOperating System can only be stored on and started from a Bootable RAID Group.\nTo create Bootable RAID Group(s), use the Create Legacy RAID Group option under the Legacy Support.\nAre you sure you want to continue?");
                }
                if (HostConnectionTreePane.this.popUpAnswer == 0) {
                    new CreateRaidGroupBox(HostConnectionTreePane.this.databaseManager, "Create RAID Group");
                }
            }
        });
        this.createLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new CreateLegacyRaidGroupBox(HostConnectionTreePane.this.databaseManager, "Create Legacy RAID Group");
            }
        });
        this.controllerPopupMenu.add(this.createRaidGroupMenuItem);
        if (this.storageManagementUtility.legacySupportOption) {
            this.controllerPopupMenu.add(this.createLegacyRaidGroupMenuItem);
        }
        this.raidGroupPopupMenu = new JPopupMenu();
        this.rebuildRaidGroupMenuItem = new JMenuItem("Rebuild RAID Group", 82);
        this.deleteRaidGroupMenuItem = new JMenuItem("Delete RAID Group", 68);
        this.bringRaidGroupOnlineMenuItem = new JMenuItem("Bring RAID Group Online", 66);
        this.rebuildRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String failedMember = "";
                String title = "Rebuild RAID Group";
                ArrayList selectedList = new ArrayList();
                RaidGroupDescriptor rebuildRaidGroupDescriptor = (RaidGroupDescriptor)HostConnectionTreePane.this.selectedRaidGroupDescriptor.clone();
                rebuildRaidGroupDescriptor.memberArray.clear();
                String reducedRaidGroup = Integer.toString(rebuildRaidGroupDescriptor.raidGroup);
                int failedMemberCount = 0;
                for (int member = 0; member < ((HostConnectionTreePane)HostConnectionTreePane.this).selectedRaidGroupDescriptor.memberArray.size(); ++member) {
                    MemberDescriptor memberDescriptor = (MemberDescriptor)((HostConnectionTreePane)HostConnectionTreePane.this).selectedRaidGroupDescriptor.memberArray.get(member);
                    if (!memberDescriptor.status.equals("Failed")) continue;
                    ++failedMemberCount;
                    failedMember = Integer.toString(member);
                }
                new RebuildRaidGroupBox(HostConnectionTreePane.this.databaseManager, title, reducedRaidGroup, failedMember, "New");
            }
        });
        this.deleteRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String header = "Delete RAID Group Verification";
                String message = "Are you sure you want to delete specified RAID Group?";
                new MessagePopUpBox(header, message);
                if (HostConnectionTreePane.this.popUpAnswer == 0) {
                    new DeleteRaidGroupBox(HostConnectionTreePane.this.databaseManager, ((HostConnectionTreePane)HostConnectionTreePane.this).selectedRaidGroupDescriptor.raidGroup, "New");
                }
            }
        });
        this.bringRaidGroupOnlineMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String title = "Bring RAID Group Online";
                BringRaidGroupOnlineBox bringRaidGroupOnlineBox = new BringRaidGroupOnlineBox(HostConnectionTreePane.this.databaseManager, ((HostConnectionTreePane)HostConnectionTreePane.this).selectedRaidGroupDescriptor.raidGroup, "New");
                bringRaidGroupOnlineBox = null;
            }
        });
        this.raidGroupPopupMenu.add(this.rebuildRaidGroupMenuItem);
        this.raidGroupPopupMenu.add(this.deleteRaidGroupMenuItem);
        this.raidGroupPopupMenu.addSeparator();
        this.raidGroupPopupMenu.add(this.bringRaidGroupOnlineMenuItem);
        this.legacyRaidGroupPopupMenu = new JPopupMenu();
        this.rebuildLegacyRaidGroupMenuItem = new JMenuItem("Rebuild Legacy RAID Group", 82);
        this.deleteLegacyRaidGroupMenuItem = new JMenuItem("Delete Legacy RAID Group", 68);
        this.convertLegacyRaidGroupMenuItem = new JMenuItem("Convert Legacy RAID Group", 67);
        this.bringLegacyRaidGroupOnlineMenuItem = new JMenuItem("Bring Legacy RAID Group Online", 66);
        this.rebuildLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String failedMember = "";
                String title = "Rebuild Legacy RAID Group";
                ArrayList selectedList = new ArrayList();
                RaidGroupDescriptor rebuildRaidGroupDescriptor = (RaidGroupDescriptor)HostConnectionTreePane.this.selectedRaidGroupDescriptor.clone();
                rebuildRaidGroupDescriptor.memberArray.clear();
                String reducedRaidGroup = Integer.toString(rebuildRaidGroupDescriptor.raidGroup);
                int failedMemberCount = 0;
                for (int member = 0; member < ((HostConnectionTreePane)HostConnectionTreePane.this).selectedRaidGroupDescriptor.memberArray.size(); ++member) {
                    MemberDescriptor memberDescriptor = (MemberDescriptor)((HostConnectionTreePane)HostConnectionTreePane.this).selectedRaidGroupDescriptor.memberArray.get(member);
                    if (!memberDescriptor.status.equals("Failed")) continue;
                    ++failedMemberCount;
                    failedMember = Integer.toString(member);
                }
                new RebuildRaidGroupBox(HostConnectionTreePane.this.databaseManager, title, reducedRaidGroup, failedMember, "Old");
            }
        });
        this.deleteLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String header = "Delete Legacy RAID Group Verification";
                String message = "Are you sure you want to delete specified Legacy RAID Group?";
                new MessagePopUpBox(header, message);
                if (HostConnectionTreePane.this.popUpAnswer == 0) {
                    new DeleteRaidGroupBox(HostConnectionTreePane.this.databaseManager, ((HostConnectionTreePane)HostConnectionTreePane.this).selectedRaidGroupDescriptor.raidGroup, "Old");
                }
            }
        });
        this.convertLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ConvertLegacyRaidGroupBox(HostConnectionTreePane.this.databaseManager, ((HostConnectionTreePane)HostConnectionTreePane.this).selectedRaidGroupDescriptor.raidGroup);
            }
        });
        this.bringLegacyRaidGroupOnlineMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String title = "Bring Legacy RAID Group Online";
                BringRaidGroupOnlineBox bringRaidGroupOnlineBox = new BringRaidGroupOnlineBox(HostConnectionTreePane.this.databaseManager, ((HostConnectionTreePane)HostConnectionTreePane.this).selectedRaidGroupDescriptor.raidGroup, "Old");
                bringRaidGroupOnlineBox = null;
            }
        });
        this.legacyRaidGroupPopupMenu.add(this.rebuildLegacyRaidGroupMenuItem);
        this.legacyRaidGroupPopupMenu.add(this.deleteLegacyRaidGroupMenuItem);
        this.legacyRaidGroupPopupMenu.add(this.convertLegacyRaidGroupMenuItem);
        this.legacyRaidGroupPopupMenu.addSeparator();
        this.legacyRaidGroupPopupMenu.add(this.bringLegacyRaidGroupOnlineMenuItem);
    }

    public void updateCreatePopupMenu() {
        this.controllerPopupMenu.removeAll();
        this.controllerPopupMenu.add(this.createRaidGroupMenuItem);
        if (this.storageManagementUtility.legacySupportOption) {
            this.controllerPopupMenu.add(this.createLegacyRaidGroupMenuItem);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object treeInfo = node.getUserObject();
        NodeInfo nodeInfo = (NodeInfo)treeInfo;
        if (nodeInfo.nodeType == 2) {
            if (!nodeInfo.same(this.selectedHostNode)) {
                int status = this.hostConnectionManager.openNewHostConnection(nodeInfo.hostConnectionDescriptor, nodeInfo.controller);
                if (status == 0) {
                    this.initializeTreeHostDatabase();
                    if (nodeInfo.controllers == -1) {
                        int controllers = nodeInfo.hostConnectionDescriptor.controllers;
                        int controller = 0;
                        while (controller < controllers) {
                            DefaultMutableTreeNode newNode;
                            ControllerDescriptor controllerDescriptor = this.databaseManager.controllerDatabase.getController(controller);
                            NodeInfo newNodeInfo = new NodeInfo();
                            newNodeInfo.treeNode = newNode = new DefaultMutableTreeNode(newNodeInfo);
                            newNodeInfo.title = "Controller " + Integer.toString(controller) + " - " + controllerDescriptor.chipType;
                            newNodeInfo.nodeType = 1;
                            newNodeInfo.controllers = nodeInfo.controllers;
                            newNodeInfo.controller = controller++;
                            newNodeInfo.type = nodeInfo.type;
                            newNodeInfo.ipAddress = nodeInfo.ipAddress;
                            newNodeInfo.hostConnectionDescriptor = nodeInfo.hostConnectionDescriptor;
                            newNodeInfo.icon = this.controllerGreenIcon;
                            node.add(newNode);
                            nodeInfo.controllers = controllers;
                        }
                    }
                    nodeInfo.icon = nodeInfo.type.equals("Local") ? this.localConnectionGreenIcon : this.remoteConnectionGreenIcon;
                    nodeInfo.cloneTo(this.selectedHostNode);
                    if (node.getChildCount() > 0) {
                        DefaultMutableTreeNode firstChild = node.getFirstLeaf();
                        Object childInfo = firstChild.getUserObject();
                        nodeInfo = (NodeInfo)childInfo;
                        nodeInfo.icon = this.controllerGreenIcon;
                        nodeInfo.cloneTo(this.selectedControllerNode);
                    }
                    TreePath treePath = new TreePath(node.getPath());
                    this.tree.scrollPathToVisible(treePath);
                    this.tree.expandPath(treePath);
                    this.updateTreeHostNodes();
                } else {
                    this.hostConnectionManager.reconnectPreviousConnection();
                }
            }
            this.storageManagementUtility.deviceChannelPanel.highlightRaidGroupHandler(-1);
        } else if (nodeInfo.nodeType == 1) {
            if (!nodeInfo.same(this.selectedControllerNode)) {
                int status = this.hostConnectionManager.openNewHostConnection(nodeInfo.hostConnectionDescriptor, nodeInfo.controller);
                if (status == 0) {
                    this.initializeTreeRaidDatabase();
                    nodeInfo.cloneTo(this.selectedControllerNode);
                    TreePath treePath = new TreePath(node.getPath());
                    this.tree.scrollPathToVisible(treePath);
                    this.tree.expandPath(treePath);
                    this.updateTreeHostNodes();
                } else {
                    this.hostConnectionManager.reconnectPreviousConnection();
                }
            }
            this.storageManagementUtility.deviceChannelPanel.highlightRaidGroupHandler(-1);
        } else if (nodeInfo.nodeType == 0) {
            this.storageManagementUtility.deviceChannelPanel.highlightRaidGroupHandler(nodeInfo.raidGroup);
        }
    }

    private void initializeTreeHostDatabase() {
        DefaultMutableTreeNode parent = this.selectedHostNode.treeNode;
        int children = parent.getChildCount();
        while (children-- > 0) {
            DefaultMutableTreeNode leaf = parent.getFirstLeaf();
            this.treeModel.removeNodeFromParent(leaf);
        }
    }

    private synchronized void updateTreeHostNodes() {
        int count;
        HostConnectionDescriptor newHostConnectionDescriptor;
        int newIndex;
        HostConnectionDescriptor hostConnectionDescriptor;
        int index;
        ArrayList newConnectionList = this.hostConnectionManager.getHostConnectionList();
        ArrayList<HostConnectionDescriptor> removeList = new ArrayList<HostConnectionDescriptor>();
        for (index = 0; index < this.hostConnectionList.size(); ++index) {
            hostConnectionDescriptor = (HostConnectionDescriptor)this.hostConnectionList.get(index);
            boolean found = false;
            for (newIndex = 0; newIndex < newConnectionList.size(); ++newIndex) {
                newHostConnectionDescriptor = (HostConnectionDescriptor)newConnectionList.get(newIndex);
                if (!hostConnectionDescriptor.alias.equals(newHostConnectionDescriptor.alias) || !hostConnectionDescriptor.type.equals(newHostConnectionDescriptor.type) || !hostConnectionDescriptor.ipAddress.equals(newHostConnectionDescriptor.ipAddress)) continue;
                found = true;
                break;
            }
            if (found) continue;
            removeList.add(hostConnectionDescriptor);
        }
        ArrayList<HostConnectionDescriptor> addList = new ArrayList<HostConnectionDescriptor>();
        for (newIndex = 0; newIndex < newConnectionList.size(); ++newIndex) {
            newHostConnectionDescriptor = (HostConnectionDescriptor)newConnectionList.get(newIndex);
            boolean found = false;
            for (index = 0; index < this.hostConnectionList.size(); ++index) {
                hostConnectionDescriptor = (HostConnectionDescriptor)this.hostConnectionList.get(index);
                if (!hostConnectionDescriptor.alias.equals(newHostConnectionDescriptor.alias) || !hostConnectionDescriptor.type.equals(newHostConnectionDescriptor.type) || !hostConnectionDescriptor.ipAddress.equals(newHostConnectionDescriptor.ipAddress)) continue;
                found = true;
                break;
            }
            if (found) continue;
            addList.add(newHostConnectionDescriptor);
        }
        block4: for (count = 0; count < removeList.size(); ++count) {
            NodeInfo nodeInfo;
            DefaultMutableTreeNode leaf;
            hostConnectionDescriptor = (HostConnectionDescriptor)removeList.get(count);
            int childCount = hostConnectionDescriptor.controllers;
            for (leaf = this.rootNode.getFirstLeaf(); leaf != null && leaf != this.rootNode && childCount > 0; leaf = leaf.getNextLeaf()) {
                nodeInfo = (NodeInfo)leaf.getUserObject();
                if (!nodeInfo.type.equals(hostConnectionDescriptor.type) || !nodeInfo.ipAddress.equals(hostConnectionDescriptor.ipAddress)) continue;
                DefaultMutableTreeNode treeNode = leaf.getPreviousNode();
                Object parentInfo = treeNode.getUserObject();
                NodeInfo parentNodeInfo = (NodeInfo)parentInfo;
                while (true) {
                    if (parentNodeInfo.nodeType == 2) break;
                    treeNode = treeNode.getPreviousNode();
                    parentInfo = treeNode.getUserObject();
                    parentNodeInfo = (NodeInfo)parentInfo;
                }
                treeNode.removeAllChildren();
                break;
            }
            for (leaf = this.rootNode.getFirstLeaf(); leaf != null && leaf != this.rootNode; leaf = leaf.getNextLeaf()) {
                nodeInfo = (NodeInfo)leaf.getUserObject();
                if (!nodeInfo.type.equals(hostConnectionDescriptor.type) || !nodeInfo.ipAddress.equals(hostConnectionDescriptor.ipAddress)) continue;
                this.treeModel.removeNodeFromParent(leaf);
                continue block4;
            }
        }
        for (count = 0; count < addList.size(); ++count) {
            DefaultMutableTreeNode leaf;
            NodeInfo nodeInfo = new NodeInfo();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(nodeInfo);
            hostConnectionDescriptor = (HostConnectionDescriptor)addList.get(count);
            nodeInfo.treeNode = newNode;
            nodeInfo.nodeType = 2;
            nodeInfo.controllers = hostConnectionDescriptor.controllers;
            nodeInfo.controller = hostConnectionDescriptor.controller;
            nodeInfo.type = hostConnectionDescriptor.type;
            nodeInfo.ipAddress = hostConnectionDescriptor.ipAddress;
            nodeInfo.hostConnectionDescriptor = hostConnectionDescriptor;
            if (hostConnectionDescriptor.type.equals("Local")) {
                nodeInfo.title = "Local Host";
                nodeInfo.icon = this.localConnectionGreenIcon;
            } else if (hostConnectionDescriptor.type.equals("Remote")) {
                nodeInfo.title = nodeInfo.ipAddress;
                if (!hostConnectionDescriptor.alias.equals("")) {
                    nodeInfo.title = hostConnectionDescriptor.alias;
                }
                nodeInfo.icon = this.remoteConnectionGreenIcon;
            }
            if (leaf == this.rootNode) {
                this.treeModel.insertNodeInto(newNode, this.rootNode, 0);
                this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                continue;
            }
            NodeInfo newNodeInfo = null;
            index = 0;
            for (leaf = this.rootNode.getFirstLeaf(); leaf != null; leaf = leaf.getNextLeaf()) {
                newNodeInfo = (NodeInfo)leaf.getUserObject();
                if (newNodeInfo.type.equals("Local")) {
                    this.treeModel.insertNodeInto(newNode, this.rootNode, index);
                    this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                    newNode = null;
                    break;
                }
                if (newNodeInfo.ipAddress.compareToIgnoreCase(hostConnectionDescriptor.ipAddress) >= 1) {
                    this.treeModel.insertNodeInto(newNode, this.rootNode, index);
                    this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                    newNode = null;
                    break;
                }
                if (++index >= this.rootNode.getChildCount()) break;
            }
            if (newNode == null) continue;
            this.treeModel.insertNodeInto(newNode, this.rootNode, this.rootNode.getChildCount());
            this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
        }
        this.hostConnectionList = newConnectionList;
        this.tree.repaint();
    }

    private void initializeTreeRaidDatabase() {
        DefaultMutableTreeNode parent = this.selectedControllerNode.treeNode;
        int children = parent.getChildCount();
        while (children-- > 0) {
            DefaultMutableTreeNode leaf = parent.getFirstLeaf();
            this.treeModel.removeNodeFromParent(leaf);
        }
        NodeInfo nodeInfo = (NodeInfo)parent.getUserObject();
        this.raidGroupList.clear();
    }

    private synchronized void updateTreeRaidNodes() {
        NodeInfo nodeInfo;
        int count;
        RaidGroupDescriptor newRaidGroupDescriptor;
        int newIndex;
        int index;
        RaidGroupDescriptor raidGroupDescriptor;
        if (this.databaseManager.state != 3) {
            return;
        }
        ArrayList newRaidGroupList = this.databaseManager.raidGroupDatabase.getRaidGroupList(false);
        ControllerDescriptor controllerDescriptor = this.databaseManager.getSelectedController();
        this.raidGroupTable = new RaidGroupDescriptor[controllerDescriptor.maxRaidGroups];
        for (int newIndex2 = 0; newIndex2 < newRaidGroupList.size(); ++newIndex2) {
            this.raidGroupTable[raidGroupDescriptor.raidGroup] = raidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newIndex2);
        }
        ArrayList<RaidGroupDescriptor> removeList = new ArrayList<RaidGroupDescriptor>();
        for (index = 0; index < this.raidGroupList.size(); ++index) {
            raidGroupDescriptor = (RaidGroupDescriptor)this.raidGroupList.get(index);
            boolean found = false;
            for (newIndex = 0; newIndex < newRaidGroupList.size(); ++newIndex) {
                newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newIndex);
                if (raidGroupDescriptor.raidGroup != newRaidGroupDescriptor.raidGroup || !raidGroupDescriptor.label.equals(newRaidGroupDescriptor.label)) continue;
                found = true;
                break;
            }
            if (found) continue;
            removeList.add(raidGroupDescriptor);
        }
        ArrayList<RaidGroupDescriptor> addList = new ArrayList<RaidGroupDescriptor>();
        for (newIndex = 0; newIndex < newRaidGroupList.size(); ++newIndex) {
            newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newIndex);
            boolean found = false;
            for (index = 0; index < this.raidGroupList.size(); ++index) {
                raidGroupDescriptor = (RaidGroupDescriptor)this.raidGroupList.get(index);
                if (raidGroupDescriptor.raidGroup != newRaidGroupDescriptor.raidGroup || !raidGroupDescriptor.label.equals(newRaidGroupDescriptor.label)) continue;
                found = true;
                break;
            }
            if (found) continue;
            addList.add(newRaidGroupDescriptor);
        }
        block5: for (count = 0; count < removeList.size(); ++count) {
            raidGroupDescriptor = (RaidGroupDescriptor)removeList.get(count);
            DefaultMutableTreeNode parent = this.selectedControllerNode.treeNode;
            DefaultMutableTreeNode leaf = parent.getFirstLeaf();
            for (int children = parent.getChildCount(); leaf != null && leaf != parent && children > 0; leaf = leaf.getNextLeaf(), --children) {
                nodeInfo = (NodeInfo)leaf.getUserObject();
                if (nodeInfo.raidGroup != raidGroupDescriptor.raidGroup) continue;
                this.treeModel.removeNodeFromParent(leaf);
                continue block5;
            }
        }
        for (count = 0; count < addList.size(); ++count) {
            NodeInfo nodeInfo2 = new NodeInfo();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(nodeInfo2);
            raidGroupDescriptor = (RaidGroupDescriptor)addList.get(count);
            nodeInfo2.treeNode = newNode;
            nodeInfo2.title = raidGroupDescriptor.label + " (RG" + raidGroupDescriptor.raidGroup + ")";
            if (raidGroupDescriptor.label.equals("") && raidGroupDescriptor.metadataFormat.equals("Old")) {
                nodeInfo2.title = "Legacy RG " + raidGroupDescriptor.raidGroup;
            }
            nodeInfo2.nodeType = 0;
            nodeInfo2.raidGroup = raidGroupDescriptor.raidGroup;
            if (raidGroupDescriptor.status.equals("Online")) {
                nodeInfo2.icon = this.raidGroupGreenIcon;
            } else if (raidGroupDescriptor.status.equals("Reduced")) {
                nodeInfo2.icon = this.raidGroupYellowIcon;
            } else if (raidGroupDescriptor.status.equals("Offline")) {
                nodeInfo2.icon = raidGroupDescriptor.validateState.equals("Minimum") ? this.raidGroupOrangeIcon : this.raidGroupPinkIcon;
            }
            DefaultMutableTreeNode parent = this.selectedControllerNode.treeNode;
            DefaultMutableTreeNode leaf = parent.getFirstLeaf();
            if (leaf == parent) {
                this.treeModel.insertNodeInto(newNode, parent, 0);
                this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                continue;
            }
            NodeInfo newNodeInfo = null;
            index = 0;
            for (int children = parent.getChildCount(); leaf != null && children > 0; leaf = leaf.getNextLeaf(), --children) {
                newNodeInfo = (NodeInfo)leaf.getUserObject();
                if (newNodeInfo.raidGroup >= raidGroupDescriptor.raidGroup) {
                    this.treeModel.insertNodeInto(newNode, parent, index);
                    this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                    newNode = null;
                    break;
                }
                if (++index >= parent.getChildCount()) break;
            }
            if (newNode == null) continue;
            this.treeModel.insertNodeInto(newNode, parent, parent.getChildCount());
            this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
        }
        DefaultMutableTreeNode parent = this.selectedControllerNode.treeNode;
        DefaultMutableTreeNode leaf = parent.getFirstLeaf();
        boolean controllerStatusGood = true;
        for (int children = parent.getChildCount(); leaf != null && leaf != parent && children > 0; leaf = leaf.getNextLeaf(), --children) {
            nodeInfo = (NodeInfo)leaf.getUserObject();
            raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(nodeInfo.raidGroup);
            if (raidGroupDescriptor.status.equals("Online")) {
                if (nodeInfo.icon.equals(this.raidGroupGreenIcon)) continue;
                nodeInfo.icon = this.raidGroupGreenIcon;
                continue;
            }
            if (raidGroupDescriptor.status.equals("Reduced")) {
                if (!nodeInfo.icon.equals(this.raidGroupYellowIcon)) {
                    nodeInfo.icon = this.raidGroupYellowIcon;
                }
                controllerStatusGood = false;
                continue;
            }
            if (!raidGroupDescriptor.status.equals("Offline")) continue;
            if (raidGroupDescriptor.validateState.equals("Minimum")) {
                if (nodeInfo.icon.equals(this.raidGroupOrangeIcon)) continue;
                nodeInfo.icon = this.raidGroupOrangeIcon;
                continue;
            }
            if (nodeInfo.icon.equals(this.raidGroupPinkIcon)) continue;
            nodeInfo.icon = this.raidGroupPinkIcon;
        }
        nodeInfo = (NodeInfo)parent.getUserObject();
        if (controllerStatusGood) {
            if (!nodeInfo.icon.equals(this.controllerGreenIcon)) {
                nodeInfo.icon = this.controllerGreenIcon;
            }
        } else if (!nodeInfo.icon.equals(this.controllerYellowIcon)) {
            nodeInfo.icon = this.controllerYellowIcon;
        }
        this.raidGroupList = newRaidGroupList;
        this.tree.repaint();
    }

    private void updatePopupMenu(RaidGroupDescriptor raidGroupDescriptor) {
        if (raidGroupDescriptor.status.equals("Reduced") && this.databaseManager.deviceDatabase.rebuildSegmentExists(raidGroupDescriptor.raidGroup)) {
            this.rebuildRaidGroupMenuItem.setEnabled(true);
        } else {
            this.rebuildRaidGroupMenuItem.setEnabled(false);
        }
        this.deleteRaidGroupMenuItem.setEnabled(true);
        this.bringRaidGroupOnlineMenuItem.setEnabled(false);
        if (raidGroupDescriptor.status.equals("Offline") && raidGroupDescriptor.validateState.equals("Minimum")) {
            this.bringRaidGroupOnlineMenuItem.setEnabled(true);
        }
    }

    private void updateLegacyPopupMenu(RaidGroupDescriptor raidGroupDescriptor) {
        this.rebuildLegacyRaidGroupMenuItem.setEnabled(false);
        if (raidGroupDescriptor.status.equals("Reduced") && this.databaseManager.deviceDatabase.availableLbn0SegmentExists()) {
            this.rebuildLegacyRaidGroupMenuItem.setEnabled(true);
        }
        this.deleteLegacyRaidGroupMenuItem.setEnabled(true);
        this.convertLegacyRaidGroupMenuItem.setEnabled(true);
        this.bringLegacyRaidGroupOnlineMenuItem.setEnabled(false);
        if (raidGroupDescriptor.status.equals("Offline") && raidGroupDescriptor.validateState.equals("Minimum")) {
            this.bringLegacyRaidGroupOnlineMenuItem.setEnabled(true);
        }
    }

    private void updateControllerPopupMenu() {
        this.createRaidGroupMenuItem.setEnabled(false);
        if (this.databaseManager.deviceDatabase.availableSegmentExists() && this.databaseManager.deviceDatabase.qualifiedSegmentExists() && this.databaseManager.raidGroupDatabase.getNextAvailableRaidGroup() != -1) {
            this.createRaidGroupMenuItem.setEnabled(true);
        }
        this.createLegacyRaidGroupMenuItem.setEnabled(false);
        if (this.databaseManager.deviceDatabase.qualifiedSegmentExists() && this.databaseManager.deviceDatabase.legacyBootSupportable() && !this.databaseManager.raidGroupDatabase.legacyRaidGroupMaxReached()) {
            this.createLegacyRaidGroupMenuItem.setEnabled(true);
        }
    }

    private HostConnectionDescriptor findHostConnectionFromNodeInfo(NodeInfo nodeInfo) {
        ArrayList hostConnections = this.hostConnectionManager.getHostConnectionList();
        for (int index = 0; index < hostConnections.size(); ++index) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)hostConnections.get(index);
            if (!hostConnection.type.equals(nodeInfo.type) || !hostConnection.ipAddress.equals(nodeInfo.ipAddress)) continue;
            return hostConnection;
        }
        return null;
    }

    private class NodeInfo {
        int nodeType = -1;
        int controllers = -1;
        int controller = -1;
        int raidGroup = -1;
        String type = "?";
        String ipAddress = "0.0.0.0";
        String title = "?";
        ImageIcon icon;
        HostConnectionDescriptor hostConnectionDescriptor;
        DefaultMutableTreeNode treeNode;
        static final int RAID_TYPE = 0;
        static final int CNTR_TYPE = 1;
        static final int HOST_TYPE = 2;
        static final int ROOT_TYPE = 3;

        public String toString() {
            return this.title;
        }

        public synchronized boolean same(NodeInfo node) {
            if (node.nodeType != this.nodeType) {
                return false;
            }
            if (node.controllers != this.controllers) {
                return false;
            }
            if (node.controller != this.controller) {
                return false;
            }
            if (node.raidGroup != this.raidGroup) {
                return false;
            }
            if (!node.type.equals(this.type)) {
                return false;
            }
            if (!node.ipAddress.equals(this.ipAddress)) {
                return false;
            }
            if (!node.title.equals(this.title)) {
                return false;
            }
            return node.hostConnectionDescriptor == this.hostConnectionDescriptor;
        }

        public synchronized Object clone() {
            NodeInfo newNode = new NodeInfo();
            newNode.nodeType = this.nodeType;
            newNode.controllers = this.controllers;
            newNode.controller = this.controller;
            newNode.raidGroup = this.raidGroup;
            newNode.type = this.type;
            newNode.ipAddress = this.ipAddress;
            newNode.title = this.title;
            newNode.hostConnectionDescriptor = this.hostConnectionDescriptor;
            newNode.icon = this.icon;
            newNode.treeNode = this.treeNode;
            return newNode;
        }

        public synchronized void cloneTo(NodeInfo node) {
            node.nodeType = this.nodeType;
            node.controllers = this.controllers;
            node.controller = this.controller;
            node.raidGroup = this.raidGroup;
            node.type = this.type;
            node.ipAddress = this.ipAddress;
            node.title = this.title;
            node.hostConnectionDescriptor = this.hostConnectionDescriptor;
            node.icon = this.icon;
            node.treeNode = this.treeNode;
        }
    }

    private class MessagePopUpBox
    extends JDialog {
        public MessagePopUpBox(String header, String message) {
            HostConnectionTreePane.this.popUpAnswer = 1;
            HostConnectionTreePane.this.popUpAnswer = JOptionPane.showConfirmDialog(this, message, header, 0);
        }
    }

    private class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)value;
            Object userObject = newNode.getUserObject();
            NodeInfo nodeInfo = (NodeInfo)userObject;
            if (nodeInfo.icon != null) {
                this.setIcon(nodeInfo.icon);
            }
            return this;
        }
    }

    private class MouseTreeListener
    extends MouseAdapter {
        private MouseTreeListener() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = HostConnectionTreePane.this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1 || (e.getModifiers() & 4) == 0) {
                return;
            }
            HostConnectionTreePane.this.tree.setSelectionRow(selRow);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)HostConnectionTreePane.this.tree.getLastSelectedPathComponent();
            NodeInfo nodeInfo = (NodeInfo)node.getUserObject();
            if (nodeInfo.nodeType == 1) {
                HostConnectionTreePane.this.updateControllerPopupMenu();
                Utility.displayPopupMenu(HostConnectionTreePane.this, HostConnectionTreePane.this.controllerPopupMenu, e);
            } else if (nodeInfo.nodeType == 0) {
                HostConnectionTreePane.this.selectedRaidGroupDescriptor = HostConnectionTreePane.this.raidGroupTable[nodeInfo.raidGroup];
                if (HostConnectionTreePane.this.selectedRaidGroupDescriptor.isLegacy()) {
                    HostConnectionTreePane.this.updateLegacyPopupMenu(HostConnectionTreePane.this.raidGroupTable[nodeInfo.raidGroup]);
                    Utility.displayPopupMenu(HostConnectionTreePane.this, HostConnectionTreePane.this.legacyRaidGroupPopupMenu, e);
                } else {
                    HostConnectionTreePane.this.updatePopupMenu(HostConnectionTreePane.this.raidGroupTable[nodeInfo.raidGroup]);
                    Utility.displayPopupMenu(HostConnectionTreePane.this, HostConnectionTreePane.this.raidGroupPopupMenu, e);
                }
            }
        }
    }

    private class DatabaseNukeListener
    implements Runnable {
        private DatabaseNukeListener() {
        }

        public void run() {
            HostConnectionTreePane.this.removeListeners();
        }
    }

    private class DatabaseChangeListener
    implements Runnable {
        private DatabaseChangeListener() {
        }

        public void run() {
            HostConnectionTreePane.this.updateTreeRaidNodes();
        }
    }
}

