/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CreateLegacySpareBox
extends KDialog
implements GlobalConstants {
    private SegmentTable segmentTable;
    private JComboBox legacyRaidGroupComboBox;
    private JButton createButton;
    private JPanel borderPanel;
    private String segmentFields = "Path ID,Target ID,Capacity,Starting LBN";
    private String[] segmentStatuses = new String[]{"Available"};
    private String[] metadataFormats = new String[]{"Old"};
    private String[] usedRaidGroupNumbers = new String[128];
    private LegacyRaidGroupComboBoxListener legacyRaidGroupComboBoxListener;
    private LegacySpareUpdateListener legacySpareUpdateListener;
    private SegmentTableSelectionListener segmentTableSelectionListener;

    public CreateLegacySpareBox(DatabaseManager databaseManager, String title) {
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildParametersPanel(), "North");
        this.getContentPane().add((Component)this.buildSpareTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.legacySpareUpdateListener = new LegacySpareUpdateListener();
        this.legacyRaidGroupComboBoxListener = new LegacyRaidGroupComboBoxListener();
        this.legacyRaidGroupComboBox.addActionListener(this.legacyRaidGroupComboBoxListener);
        databaseManager.raidGroupDatabase.addUpdateListener(this.legacySpareUpdateListener);
        databaseManager.deviceDatabase.addUpdateListener(this.legacySpareUpdateListener);
        this.usedRaidGroupNumbers = databaseManager.raidGroupDatabase.getUsedRaidGroupNumbers(this.metadataFormats, true);
        this.initializeParameterPanel(Integer.toString(2));
        this.legacySpareUpdateListener.run();
        this.completeDialogInit(true);
    }

    protected void closeDialog() {
        Utility.println("closeDialog");
        this.legacyRaidGroupComboBox.removeActionListener(this.legacyRaidGroupComboBoxListener);
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.legacySpareUpdateListener);
        this.databaseManager.deviceDatabase.removeUpdateListener(this.legacySpareUpdateListener);
        this.segmentTable.removeUpdateListener(this.segmentTableSelectionListener);
        this.segmentTable.dispose();
        this.dispose();
    }

    protected JPanel buildSpareTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.segmentTable = new SegmentTable(this.databaseManager, null, this.segmentFields, this.segmentStatuses, 6, "Old");
        this.segmentTable.setSelectionMode(0);
        tablePanel.add(this.segmentTable.getScrollPane());
        this.segmentTableSelectionListener = new SegmentTableSelectionListener();
        this.segmentTable.addUpdateListener(this.segmentTableSelectionListener);
        tablePanel.setBorder(BorderFactory.createEmptyBorder(8, 14, 4, 14));
        return tablePanel;
    }

    protected JPanel buildParametersPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.legacyRaidGroupComboBox = new JComboBox<String>(this.usedRaidGroupNumbers);
        Utility.addComponent(new JLabel("Legacy RAID Group:"), panel, layout, constraints, 0, 0, 0, 9, 8, 10, 0.0);
        Utility.addComponent(this.legacyRaidGroupComboBox, panel, layout, constraints, 1, 0, 0, 9, 8, 10, 1.0);
        this.legacyRaidGroupComboBox.setEnabled(false);
        Dimension dimension = this.legacyRaidGroupComboBox.getPreferredSize();
        dimension.width = (int)((double)dimension.width * 2.0);
        this.legacyRaidGroupComboBox.setPreferredSize(dimension);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
        this.borderPanel = new JPanel();
        this.borderPanel.setLayout(new BoxLayout(this.borderPanel, 1));
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 13, 0, 13));
        this.borderPanel.add(panel);
        return this.borderPanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.createButton = new JButton("Create");
        JButton closeButton = new JButton("Close");
        this.createButton.setMnemonic(69);
        closeButton.setMnemonic(88);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLegacySpareBox.this.sendRequest();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLegacySpareBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.createButton);
        buttonPanel.add(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    private void initializeParameterPanel(String raidToSkip) {
        int dimension = this.usedRaidGroupNumbers.length - 1;
        if (raidToSkip.equals(Integer.toString(2))) {
            ++dimension;
        }
        String[] newUsedRaidGroupNumbers = new String[dimension];
        this.legacyRaidGroupComboBox.removeActionListener(this.legacyRaidGroupComboBoxListener);
        this.legacyRaidGroupComboBox.removeAllItems();
        int index = 0;
        for (int i = 0; i < this.usedRaidGroupNumbers.length; ++i) {
            if (raidToSkip.equals(this.usedRaidGroupNumbers[i])) continue;
            this.legacyRaidGroupComboBox.addItem(this.usedRaidGroupNumbers[i]);
            newUsedRaidGroupNumbers[index++] = this.usedRaidGroupNumbers[i];
        }
        this.usedRaidGroupNumbers = newUsedRaidGroupNumbers;
        this.legacyRaidGroupComboBox.addActionListener(this.legacyRaidGroupComboBoxListener);
        if (this.usedRaidGroupNumbers.length == 0) {
            this.borderPanel.setEnabled(false);
            this.createButton.setEnabled(false);
        }
    }

    private void sendRequest() {
        int answer;
        ArrayList segmentList = this.segmentTable.getSelectedSegments();
        boolean passThruFound = false;
        for (int segment = 0; segment < segmentList.size(); ++segment) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(segment);
            DeviceDescriptor deviceDescriptor = this.databaseManager.deviceDatabase.getDevice(Integer.parseInt(segmentDescriptor.device));
            if (!deviceDescriptor.passThru) continue;
            passThruFound = true;
            break;
        }
        if (passThruFound && (answer = JOptionPane.showConfirmDialog(this, "WARNING: You have selected one or more PASS-THRU disks to be used for the Spare(s).\nUsing these disks will result in any existing data on the disks being overwritten.\nWould you like to continue?", "Pass-Thru Disks Warning", 0)) == 1) {
            return;
        }
        int legacyRaidGroup = Integer.parseInt((String)this.legacyRaidGroupComboBox.getSelectedItem());
        long capacityBlocks = this.databaseManager.raidGroupDatabase.getRaidGroupMemberCapacity(legacyRaidGroup);
        SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(0);
        String request = "<si:Request><si:Type>CreateSpare</si:Type><si:SpareParams><si:Type>Legacy</si:Type><si:Device>" + segmentDescriptor.device + "</si:Device>" + "<si:StartingPlbn>" + segmentDescriptor.startingPlbn + "</si:StartingPlbn>" + "<si:Capacity>" + capacityBlocks + "</si:Capacity>" + "</si:SpareParams>" + "</si:Request>";
        Utility.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                CreateLegacySpareBox.this.databaseManager.refresh();
                CreateLegacySpareBox.this.setCursor(new Cursor(0));
                CreateLegacySpareBox.this.borderPanel.setEnabled(true);
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement()) {
                    if (xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                        new ErrorMessageBox(CreateLegacySpareBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Create Legacy Spare Error");
                    } else {
                        CreateLegacySpareBox.this.initializeParameterPanel((String)CreateLegacySpareBox.this.legacyRaidGroupComboBox.getSelectedItem());
                    }
                }
            }
        };
        this.borderPanel.setEnabled(false);
        this.setCursor(new Cursor(3));
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    static /* synthetic */ String[] access$802(CreateLegacySpareBox x0, String[] x1) {
        x0.usedRaidGroupNumbers = x1;
        return x1;
    }

    private class SegmentTableSelectionListener
    implements Runnable {
        private SegmentTableSelectionListener() {
        }

        public void run() {
            Utility.println("SegmentTableSelectionListener() entered");
            ArrayList segmentList = CreateLegacySpareBox.this.segmentTable.getSelectedSegments();
            if (segmentList.size() > 0 && !CreateLegacySpareBox.this.createButton.isEnabled()) {
                CreateLegacySpareBox.this.createButton.setEnabled(true);
            }
        }
    }

    private class LegacySpareUpdateListener
    implements Runnable {
        private LegacySpareUpdateListener() {
        }

        public void run() {
            String[] segmentStatuses = new String[]{"Legacy Spare"};
            ArrayList segmentList = CreateLegacySpareBox.this.databaseManager.deviceDatabase.getSegmentList(segmentStatuses);
            if (segmentList.size() >= 2) {
                CreateLegacySpareBox.this.borderPanel.setEnabled(false);
                CreateLegacySpareBox.this.createButton.setEnabled(false);
            }
            CreateLegacySpareBox.access$802(CreateLegacySpareBox.this, CreateLegacySpareBox.this.databaseManager.raidGroupDatabase.getUsedRaidGroupNumbers(CreateLegacySpareBox.this.metadataFormats, true));
        }
    }

    private class LegacyRaidGroupComboBoxListener
    implements ActionListener {
        private LegacyRaidGroupComboBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int legacyRaidGroup = Integer.parseInt((String)CreateLegacySpareBox.this.legacyRaidGroupComboBox.getSelectedItem());
            CreateLegacySpareBox.this.segmentTable.segmentTableSpareUpdate("Old", legacyRaidGroup);
        }
    }
}

