/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DeleteRaidGroupBox
extends KDialog {
    String metadataFormat;
    private JButton deleteButton;
    private RaidGroupTable raidGroupTable;
    private RemovePopUpBox removePopUpBox;
    private int selectedRaidGroup;
    private RemoveSingleThread removeSingleThread;
    private RemoveMultipleThread removeMultipleThread;
    private RaidGroupTableSelectionListener raidGroupTableSelectionListener;

    public DeleteRaidGroupBox(DatabaseManager databaseManager, String title, String metadataFormat) {
        this.metadataFormat = metadataFormat;
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildRaidGroupTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.completeDialogInit(true);
    }

    public DeleteRaidGroupBox(DatabaseManager databaseManager, int selectedRaidGroup, String metadataFormat) {
        this.databaseManager = databaseManager;
        this.metadataFormat = metadataFormat;
        this.selectedRaidGroup = selectedRaidGroup;
        this.storageManagementUtility = databaseManager.storageManagementUtility;
        this.commManager = databaseManager.commManager;
        this.removeSingleThread = new RemoveSingleThread();
        this.removeSingleThread.start();
    }

    protected JPanel buildRaidGroupTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.raidGroupTable = new RaidGroupTable(this.databaseManager, this.preferences, 12, this.metadataFormat);
        tablePanel.add(new JLabel("Select RAID Group(s):"));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.add(this.raidGroupTable.getScrollPane());
        this.raidGroupTableSelectionListener = new RaidGroupTableSelectionListener();
        this.raidGroupTable.addUpdateListener(this.raidGroupTableSelectionListener);
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        return tablePanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.deleteButton = new JButton("Delete");
        JButton cancelButton = new JButton("Cancel");
        this.deleteButton.setMnemonic(68);
        cancelButton.setMnemonic(67);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(DeleteRaidGroupBox.this, "Are you sure you want to delete specified RAID Group(s)?", "Delete RAID Group Verification", 0);
                if (answer == 0) {
                    DeleteRaidGroupBox.this.sendRequest();
                }
                DeleteRaidGroupBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteRaidGroupBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected void closeDialog() {
        Utility.println("DeleteRaidGroup: closeDialog() entered");
        this.raidGroupTable.removeUpdateListener(this.raidGroupTableSelectionListener);
        this.raidGroupTable.dispose();
        this.dispose();
    }

    private void sendRequest() {
        this.removeMultipleThread = new RemoveMultipleThread();
        this.removeMultipleThread.start();
    }

    public void sendRequest(int raidGroup) {
        String request = "<si:Request><si:Type>DeleteRaidGroup</si:Type><si:RaidGroupParams><si:RaidGroup>" + raidGroup + "</si:RaidGroup>" + "</si:RaidGroupParams>" + "</si:Request>";
        Utility.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(DeleteRaidGroupBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Delete RAID Group Error");
                }
                DeleteRaidGroupBox.this.databaseManager.refresh();
            }
        };
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    private class RaidGroupTableSelectionListener
    implements Runnable {
        private RaidGroupTableSelectionListener() {
        }

        public void run() {
            Utility.println("RaidGroupTableSelectionListener() entered");
            ArrayList raidGroupList = DeleteRaidGroupBox.this.raidGroupTable.getSelectedRaidGroups();
            if (raidGroupList.size() > 0 && !DeleteRaidGroupBox.this.deleteButton.isEnabled()) {
                DeleteRaidGroupBox.this.deleteButton.setEnabled(true);
            }
        }
    }

    private class RemoveMultipleThread
    extends Thread {
        private RemoveMultipleThread() {
        }

        public void run() {
            DeleteRaidGroupBox.this.setCursor(new Cursor(3));
            ArrayList raidGroupList = DeleteRaidGroupBox.this.raidGroupTable.getSelectedRaidGroups();
            for (int count = 0; count < raidGroupList.size(); ++count) {
                RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(count);
                DeleteRaidGroupBox.this.sendRequest(raidGroupDescriptor.raidGroup);
            }
            DeleteRaidGroupBox.this.setCursor(new Cursor(0));
        }
    }

    private class RemoveSingleThread
    extends Thread {
        private RemoveSingleThread() {
        }

        public void run() {
            DeleteRaidGroupBox.this.setCursor(new Cursor(3));
            DeleteRaidGroupBox.this.sendRequest(DeleteRaidGroupBox.this.selectedRaidGroup);
            DeleteRaidGroupBox.this.setCursor(new Cursor(0));
        }
    }
}

