/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Utility
implements GlobalConstants {
    public static void addComponent(Component component, JPanel panel, GridBagLayout layout, GridBagConstraints constraints, int x, int y, int top, int bottom, int left, int right, double weightx) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.insets.top = top;
        constraints.insets.bottom = bottom;
        constraints.insets.left = left;
        constraints.insets.right = right;
        constraints.weightx = weightx;
        layout.setConstraints(component, constraints);
        panel.add(component);
    }

    public static JPanel buildRadioButtonPanel(String borderText, JRadioButton[] buttonArray, String[] buttonTextArray, ActionListener actionListener, int selectedIndex) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), borderText));
        panel.add(Box.createRigidArea(new Dimension(14, 0)));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int count = 0; count < buttonArray.length; ++count) {
            buttonArray[count] = new JRadioButton(buttonTextArray[count]);
            buttonGroup.add(buttonArray[count]);
            panel.add(buttonArray[count]);
            if (actionListener == null) continue;
            buttonArray[count].addActionListener(actionListener);
        }
        if (selectedIndex != -1) {
            buttonArray[selectedIndex].setSelected(true);
        }
        return panel;
    }

    public static void displayPopupMenu(Component parent, JPopupMenu popupMenu, MouseEvent mouseEvent) {
        Dimension menu = popupMenu.getPreferredSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Point parentLocation = parent.getLocationOnScreen();
        int x = mouseEvent.getX() + parentLocation.x;
        int y = mouseEvent.getY() + parentLocation.y;
        if (menu.width + x > screen.width) {
            x = screen.width - menu.width - 8;
        }
        if (menu.height + y > screen.height) {
            y -= menu.height;
        }
        popupMenu.show(mouseEvent.getComponent(), x - parentLocation.x, y - parentLocation.y);
    }

    public static void centerFrame(JFrame frame, int height, int width) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (width > (int)((double)dimension.width * 0.7)) {
            width = (int)((double)dimension.width * 0.7);
        }
        if (height > (int)((double)dimension.height * 0.7)) {
            height = (int)((double)dimension.height * 0.7);
        }
        frame.setBounds((dimension.width - width) / 2, (dimension.height - height) / 2, width, height);
    }

    public static Rectangle getCenteredBounds(Component component) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = new Rectangle();
        rectangle.width = component.getWidth();
        rectangle.height = component.getHeight();
        rectangle.x = (screen.width - rectangle.width) / 2;
        rectangle.y = (screen.height - rectangle.height) / 2;
        return rectangle;
    }

    public static void setLabelAtrributes(JLabel label, int additionalWidth, int gridx, int weightx, int fill, GridBagLayout layout) {
        Dimension dimension = new Dimension();
        dimension = label.getPreferredSize();
        dimension.height += 4;
        dimension.width += additionalWidth;
        label.setPreferredSize(dimension);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = gridx;
        constraints.gridy = 0;
        constraints.weightx = weightx;
        constraints.ipadx = 10;
        constraints.fill = fill;
        layout.setConstraints(label, constraints);
        label.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public static void setLabelAtrributes(JLabel label, int additionalWidth, int gridx, int weightx, int anchor, int fill, GridBagLayout statusBarLayout) {
        Dimension dimension = new Dimension();
        dimension = label.getPreferredSize();
        dimension.height += 4;
        dimension.width += additionalWidth;
        label.setPreferredSize(dimension);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = 0;
        constraints.weightx = weightx;
        constraints.ipadx = 10;
        constraints.anchor = anchor;
        constraints.fill = fill;
        statusBarLayout.setConstraints(label, constraints);
        label.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public static JPanel buildIpAddressPanel(String boxName, JTextField[] addressTextField) {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        for (int index = 0; index < addressTextField.length; ++index) {
            Utility.addComponent(addressTextField[index], panel, layout, constraints, index, 0, 1, 9, 10, 10, 0.0);
        }
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), boxName));
        return panel;
    }

    public static void enableContainer(Container container, boolean enabled) {
        Component[] components = container.getComponents();
        for (int index = 0; index < components.length; ++index) {
            components[index].setEnabled(enabled);
            if (!(components[index] instanceof Container)) continue;
            Utility.enableContainer((Container)components[index], enabled);
        }
    }

    public static String byteCountLongToString(long longByteCount) {
        String stringByteCount = longByteCount >= 0x10000000000L ? (float)((long)(10.0f * ((float)longByteCount / 1.0995116E12f))) / 10.0f + " TB" : (longByteCount >= 0x40000000L ? (float)((long)(10.0f * ((float)longByteCount / 1.0737418E9f))) / 10.0f + " GB" : (longByteCount >= 0x100000L ? (float)((long)(10.0f * ((float)longByteCount / 1048576.0f))) / 10.0f + " MB" : (longByteCount >= 1024L ? (float)((long)(10.0f * ((float)longByteCount / 1024.0f))) / 10.0f + " KB" : longByteCount + " B")));
        return stringByteCount;
    }

    public static String blocksToBytes(long blocks) {
        String bytes = blocks >= 0x80000000L ? (float)((long)(100.0f * ((float)blocks / 2.1474836E9f))) / 100.0f + " TB" : (blocks >= 0x200000L ? (float)((long)(100.0f * ((float)blocks / 2097152.0f))) / 100.0f + " GB" : (blocks >= 2048L ? (float)((long)(100.0f * ((float)blocks / 2048.0f))) / 100.0f + " MB" : (blocks >= 2L ? (float)((long)(100.0f * ((float)blocks / 2.0f))) / 100.0f + " KB" : blocks * 512L + " B")));
        return bytes;
    }

    public static String covertSecondsToHourMinuteSecond(int allSeconds) {
        int seconds = allSeconds % 60;
        int minutes = allSeconds % 3600 / 60;
        int hours = allSeconds % 86400 / 3600;
        int days = allSeconds / 86400;
        DecimalFormat df = new DecimalFormat("00");
        if (days == 0) {
            return df.format(hours) + ":" + df.format(minutes) + ":" + df.format(seconds);
        }
        return df.format(days) + ":" + df.format(hours) + ":" + df.format(minutes) + ":" + df.format(seconds);
    }

    public static int minInt(int a, int b) {
        return a <= b ? a : b;
    }

    public static int maxInt(int a, int b) {
        return a >= b ? a : b;
    }

    public static long minLong(long a, long b) {
        return a <= b ? a : b;
    }

    public static long maxLong(long a, long b) {
        return a >= b ? a : b;
    }

    public static void println(String text) {
    }

    public static void println(String text, boolean condition) {
    }
}

