/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class NoControllerBox
extends JDialog
implements GlobalConstants {
    StorageManagementUtility storageManagementUtility;

    public NoControllerBox(StorageManagementUtility storageManagementUtility) {
        super(storageManagementUtility, storageManagementUtility.companyName + " Controllers NOT Present", true);
        this.storageManagementUtility = storageManagementUtility;
        this.getContentPane().add((Component)this.buildMessagePanel(), "North");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screen.width - this.getBounds().width) / 2, (screen.height - this.getBounds().height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                NoControllerBox.this.dispose();
            }
        });
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private JPanel buildMessagePanel() {
        String msgLine1 = this.storageManagementUtility.companyName + " RAID controllers are NOT detected in the system.  Please make";
        String msgLine2 = "sure that all controllers are installed and configured correctly.  Press \"OK\" to exit";
        String msgLine3 = "this application.";
        String padding = "";
        int delta = "Silicon Image".length() - this.storageManagementUtility.companyName.length();
        while (delta-- > 0) {
            padding = padding + " ";
        }
        msgLine1 = padding + msgLine1;
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        Utility.addComponent(new JLabel(""), panel, layout, constraints, 0, 0, 0, 2, 12, 12, 0.0);
        Utility.addComponent(new JLabel(msgLine1), panel, layout, constraints, 0, 1, 0, 0, 12, 12, 0.0);
        Utility.addComponent(new JLabel(msgLine2), panel, layout, constraints, 0, 2, 0, 0, 12, 12, 0.0);
        Utility.addComponent(new JLabel(msgLine3), panel, layout, constraints, 0, 3, 0, 2, 12, 12, 0.0);
        constraints.weighty = 1.0;
        Utility.addComponent(new JLabel(""), panel, layout, constraints, 0, 4, 0, 2, 0, 0, 1.0);
        panel.setBorder(BorderFactory.createEtchedBorder());
        JPanel returnPanel = new JPanel();
        returnPanel.add(panel);
        returnPanel.setBorder(BorderFactory.createEmptyBorder(8, 4, 0, 4));
        return returnPanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton okButton = new JButton("OK");
        okButton.setMnemonic(79);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NoControllerBox.this.dispose();
            }
        });
        buttonPanel.add(okButton);
        if (this.storageManagementUtility.noControllerMessage != null) {
            JButton helpButton = new JButton("Help");
            helpButton.setMnemonic(72);
            helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(null, NoControllerBox.this.storageManagementUtility.noControllerMessage, "Additional Information", -1);
                }
            });
            buttonPanel.add(helpButton);
        }
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }
}

