/*
 * Decompiled with CFR 0.152.
 */
public class HostConnectionDescriptor
extends AbstractDescriptor {
    public String alias;
    public String type;
    public String status;
    public String ipAddress;
    public String serverPort;
    public boolean preferred;
    public int ipAddress0;
    public int ipAddress1;
    public int ipAddress2;
    public int ipAddress3;
    public int controllers;
    public int controller;
    private String[] fieldNameLookUp = new String[]{"Alias", "alias", "Type", "type", "Status", "status", "IPAddress", "ipAddress", "ServerPort", "serverPort", "Controllers", "controllers", "Preferred", "preferred"};
    public static final String[] fieldNames = new String[]{"Alias", "Type", "Status", "IP Address", "Server Port", "Controllers", "Preferred"};
    public static final String[] maxFieldText = new String[]{"XAliasX", "XTypeX", "XStatusX", "XXXIP AddressXX", "XServer PortX", "XControllersX", "XPreferredX"};

    HostConnectionDescriptor() {
        this.nuke();
    }

    HostConnectionDescriptor(String alias, int controllers) {
        this.nuke();
        this.alias = alias;
        this.controllers = controllers;
    }

    HostConnectionDescriptor(String alias, String ipAddress, int controllers, boolean preferred) {
        this.nuke();
        this.alias = alias;
        this.type = "Remote";
        this.ipAddress = ipAddress;
        this.controllers = controllers;
        this.preferred = preferred;
    }

    HostConnectionDescriptor(String alias, String ipAddress, String serverPort, int controllers, boolean preferred) {
        this.nuke();
        this.alias = alias;
        this.type = "Remote";
        this.ipAddress = ipAddress;
        this.serverPort = serverPort;
        this.controllers = controllers;
        this.preferred = preferred;
    }

    public void nuke() {
        this.ipAddress0 = -1;
        this.ipAddress1 = -1;
        this.ipAddress2 = -1;
        this.ipAddress3 = -1;
        this.controllers = -1;
        this.controller = -1;
        this.serverPort = "";
        this.alias = "";
        this.ipAddress = "0.0.0.0";
        this.type = "Local";
        this.status = "Closed";
        this.preferred = false;
    }

    public synchronized Object clone() {
        HostConnectionDescriptor newDescriptor = new HostConnectionDescriptor();
        newDescriptor.ipAddress0 = this.ipAddress0;
        newDescriptor.ipAddress1 = this.ipAddress1;
        newDescriptor.ipAddress2 = this.ipAddress2;
        newDescriptor.ipAddress3 = this.ipAddress3;
        newDescriptor.controllers = this.controllers;
        newDescriptor.controller = this.controller;
        newDescriptor.serverPort = this.serverPort;
        newDescriptor.alias = this.alias;
        newDescriptor.type = this.type;
        newDescriptor.ipAddress = this.ipAddress;
        newDescriptor.status = this.status;
        newDescriptor.preferred = this.preferred;
        return newDescriptor;
    }

    public synchronized void copyTo(HostConnectionDescriptor destDescriptor) {
        destDescriptor.ipAddress0 = this.ipAddress0;
        destDescriptor.ipAddress1 = this.ipAddress1;
        destDescriptor.ipAddress2 = this.ipAddress2;
        destDescriptor.ipAddress3 = this.ipAddress3;
        destDescriptor.controllers = this.controllers;
        destDescriptor.controller = this.controller;
        destDescriptor.serverPort = this.serverPort;
        destDescriptor.alias = this.alias;
        destDescriptor.type = this.type;
        destDescriptor.ipAddress = this.ipAddress;
        destDescriptor.status = this.status;
        destDescriptor.preferred = this.preferred;
    }

    public synchronized boolean same(HostConnectionDescriptor connection) {
        if (!connection.type.equals(this.type)) {
            return false;
        }
        if (!connection.status.equals(this.status)) {
            return false;
        }
        if (!connection.ipAddress.equals(this.ipAddress)) {
            return false;
        }
        if (!connection.serverPort.equals(this.serverPort)) {
            return false;
        }
        if (connection.controllers != this.controllers) {
            return false;
        }
        if (connection.controller != this.controller) {
            return false;
        }
        return connection.preferred == this.preferred;
    }

    public synchronized void dump() {
        System.out.println("ipAddress0  = " + this.ipAddress0);
        System.out.println("ipAddress1  = " + this.ipAddress1);
        System.out.println("ipAddress2  = " + this.ipAddress2);
        System.out.println("ipAddress3  = " + this.ipAddress3);
        System.out.println("controllers = " + this.controllers);
        System.out.println("controller  = " + this.controller);
        System.out.println("serverPort  = " + this.serverPort);
        System.out.println("alias       = " + this.alias);
        System.out.println("type        = " + this.type);
        System.out.println("ipAddress   = " + this.ipAddress);
        System.out.println("status      = " + this.status);
        System.out.println("preferred   = " + (this.preferred ? "true" : "false"));
    }

    public synchronized void parseXml(String data) {
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setNumberOfControllers(int controllers) {
        this.controllers = controllers;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String assembleEthernetPortAddress(int ipAddress0, int ipAddress1, int ipAddress2, int ipAddress3) {
        String ipAddress;
        try {
            ipAddress = Integer.toString(ipAddress0);
            ipAddress = ipAddress + "." + Integer.toString(ipAddress1);
            ipAddress = ipAddress + "." + Integer.toString(ipAddress2);
            ipAddress = ipAddress + "." + Integer.toString(ipAddress3);
        }
        catch (Exception e) {
            Utility.println("assembleEthernetPortAddress: Bad int-2-string conversion");
            ipAddress = "";
        }
        return ipAddress;
    }

    public boolean assembleAndSetEthernetPortAddress(int ipAddress0, int ipAddress1, int ipAddress2, int ipAddress3) {
        String ipAddress;
        try {
            ipAddress = Integer.toString(ipAddress0);
            ipAddress = ipAddress + "." + Integer.toString(ipAddress1);
            ipAddress = ipAddress + "." + Integer.toString(ipAddress2);
            ipAddress = ipAddress + "." + Integer.toString(ipAddress3);
        }
        catch (Exception e) {
            Utility.println("assembleAndSetEthernetPortAddress: Bad int-2-string conversion");
            return false;
        }
        this.ipAddress0 = ipAddress0;
        this.ipAddress1 = ipAddress1;
        this.ipAddress2 = ipAddress2;
        this.ipAddress3 = ipAddress3;
        this.ipAddress = ipAddress;
        return true;
    }

    public int[] disassembleEtherPortAddress(String ipAddress) {
        int[] ipAddressElements = new int[]{0, 0, 0, 0};
        int startIndex = 0;
        String addressElement = this.getEtherPortAddressElement(startIndex, ipAddress);
        if (addressElement.equals("")) {
            return ipAddressElements;
        }
        try {
            ipAddressElements[0] = Integer.parseInt(addressElement);
        }
        catch (Exception e) {
            Utility.println("disassembleEtherPortAddress: Bad string-2-int conversion");
            return ipAddressElements;
        }
        try {
            startIndex += addressElement.length();
            if (ipAddress.charAt(startIndex++) == '.' && !(addressElement = this.getEtherPortAddressElement(startIndex, ipAddress)).equals("")) {
                ipAddressElements[1] = Integer.parseInt(addressElement);
                startIndex += addressElement.length();
                if (ipAddress.charAt(startIndex++) == '.' && !(addressElement = this.getEtherPortAddressElement(startIndex, ipAddress)).equals("")) {
                    ipAddressElements[2] = Integer.parseInt(addressElement);
                    startIndex += addressElement.length();
                    if (ipAddress.charAt(startIndex++) == '.' && !(addressElement = this.getEtherPortAddressElement(startIndex, ipAddress)).equals("")) {
                        ipAddressElements[3] = Integer.parseInt(addressElement);
                        return ipAddressElements;
                    }
                }
            }
            ipAddressElements[0] = 0;
            ipAddressElements[1] = 0;
            ipAddressElements[2] = 0;
            ipAddressElements[3] = 0;
        }
        catch (Exception e) {
            Utility.println("disassembleEtherPortAddress: Bad string-2-int conversion");
            ipAddressElements[0] = 0;
            ipAddressElements[1] = 0;
            ipAddressElements[2] = 0;
            ipAddressElements[3] = 0;
        }
        return ipAddressElements;
    }

    public boolean disassembleAndSetEtherPortAddress(String ipAddress) {
        int startIndex = 0;
        String addressElement = this.getEtherPortAddressElement(startIndex, ipAddress);
        if (addressElement.equals("")) {
            return false;
        }
        try {
            this.ipAddress0 = Integer.parseInt(addressElement);
        }
        catch (Exception e) {
            Utility.println("disassembleAndSetEtherPortAddress: Bad string-2-int conversion");
            return false;
        }
        try {
            startIndex += addressElement.length();
            if (ipAddress.charAt(startIndex++) == '.' && !(addressElement = this.getEtherPortAddressElement(startIndex, ipAddress)).equals("")) {
                this.ipAddress1 = Integer.parseInt(addressElement);
                startIndex += addressElement.length();
                if (ipAddress.charAt(startIndex++) == '.' && !(addressElement = this.getEtherPortAddressElement(startIndex, ipAddress)).equals("")) {
                    this.ipAddress2 = Integer.parseInt(addressElement);
                    startIndex += addressElement.length();
                    if (ipAddress.charAt(startIndex++) == '.' && !(addressElement = this.getEtherPortAddressElement(startIndex, ipAddress)).equals("")) {
                        this.ipAddress3 = Integer.parseInt(addressElement);
                        return true;
                    }
                }
            }
            this.ipAddress0 = -1;
            this.ipAddress1 = -1;
            this.ipAddress2 = -1;
            this.ipAddress3 = -1;
        }
        catch (Exception e) {
            Utility.println("disassembleAndSetEtherPortAddress: Bad string-2-int conversion");
            this.ipAddress0 = -1;
            this.ipAddress1 = -1;
            this.ipAddress2 = -1;
            this.ipAddress3 = -1;
        }
        return false;
    }

    private String getEtherPortAddressElement(int startOfElementIndex, String ipAddress) {
        int endOfElementIndex = ipAddress.indexOf(".", startOfElementIndex);
        if (endOfElementIndex == -1) {
            if (ipAddress.length() - (startOfElementIndex + 1) > 3) {
                return "";
            }
            endOfElementIndex = ipAddress.length();
        }
        return ipAddress.substring(startOfElementIndex, endOfElementIndex);
    }

    public String getFieldValue(int fieldIndicator) {
        String value = "";
        if (fieldIndicator < this.fieldNameLookUp.length / 2) {
            value = value + this.getValue(this.fieldNameLookUp[fieldIndicator * 2 + 1]);
        }
        return value;
    }

    public int compare(HostConnectionDescriptor compareConnection, SortDescriptor sortDescriptor) {
        long result = this.compareFields(this.fieldNameLookUp[sortDescriptor.field * 2 + 1], compareConnection);
        if (sortDescriptor.direction == 1) {
            if (result >= 1L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
        if (result >= 1L) {
            return 1;
        }
        if (result == 0L) {
            return 0;
        }
        return -1;
    }

    public String getFieldName(int fieldIndicator) {
        return fieldNames[fieldIndicator];
    }
}

