/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ConcatCapacityBox
extends KDialog
implements GlobalConstants {
    private final int BORDER_WIDTH = 10;
    private final String moduleName = "ConcatCapacityBox";
    private KDialog parent;
    private boolean DebugParam = true;
    private boolean selectionValidity = false;
    private DeviceDatabaseChangeHandler deviceDatabaseChangeHandler;
    private JLabel[] pathIdLabels;
    private JLabel[] targetIdLabels;
    private JComboBox[] comboBoxes;
    private JTextField totalCapacity;
    private JButton createButton;
    private JButton cancelButton;
    private ArrayList segmentList;
    private int selectionCount;
    private boolean disableDocumentListener;
    private ComboBoxesPollingThread comboBoxesPollingThread;

    public ConcatCapacityBox(KDialog parent, DatabaseManager databaseManager, String title, ArrayList segmentList) {
        this.beginDialogInit(databaseManager, title, true);
        this.parent = parent;
        this.segmentList = segmentList;
        try {
            this.initializeBoxComponents();
        }
        catch (Exception e) {
            String errorMsg = "ConcatCapacityBox constructor: Failed initialize box components";
            ErrorLog.put(e, errorMsg);
            Utility.println(errorMsg);
        }
        this.getContentPane().add((Component)this.buildSegmentPanel(), "North");
        this.getContentPane().add((Component)this.buildCapacityPanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.comboBoxesPollingThread = new ComboBoxesPollingThread();
        this.comboBoxesPollingThread.start();
        this.completeDialogInit(true);
    }

    private void initializeBoxComponents() {
        this.selectionCount = this.segmentList.size();
        this.disableDocumentListener = true;
        this.pathIdLabels = new JLabel[this.selectionCount];
        this.targetIdLabels = new JLabel[this.selectionCount];
        this.comboBoxes = new JComboBox[this.selectionCount];
        this.totalCapacity = new JTextField();
        this.totalCapacity.setEditable(false);
        ComboBoxActionListener comboBoxActionListener = new ComboBoxActionListener();
        ComboBoxKeyListener comboBoxKeyListener = new ComboBoxKeyListener();
        for (int index = 0; index < this.selectionCount; ++index) {
            boolean sameFound = false;
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)this.segmentList.get(index);
            this.pathIdLabels[index] = new JLabel("  " + segmentDescriptor.pathId);
            this.targetIdLabels[index] = new JLabel("  " + segmentDescriptor.targetId);
            this.comboBoxes[index] = new JComboBox();
            for (int count = 0; count < GlobalConstants.capacityStrings.length; ++count) {
                long segmentCapacityInBlocks = 0L;
                try {
                    segmentCapacityInBlocks = Long.parseLong(segmentDescriptor.capacityInBlocks);
                }
                catch (Exception e) {
                    String errorMsg = "ConcatCapacityBox initializeBoxComponents(): Failed string>>int conversion";
                    ErrorLog.put(e, errorMsg);
                    Utility.println(errorMsg);
                }
                if (GlobalConstants.capacities[count] > 0L && GlobalConstants.capacities[count] < segmentCapacityInBlocks) {
                    this.comboBoxes[index].addItem(GlobalConstants.capacityStrings[count]);
                    continue;
                }
                if (GlobalConstants.capacities[count] != segmentCapacityInBlocks) continue;
                this.comboBoxes[index].addItem(GlobalConstants.capacityStrings[this.selectionCount]);
                this.comboBoxes[index].setSelectedIndex(this.comboBoxes[index].getItemCount() - 1);
                sameFound = true;
            }
            if (!sameFound) {
                this.comboBoxes[index].addItem(segmentDescriptor.capacity);
                this.comboBoxes[index].setSelectedIndex(this.comboBoxes[index].getItemCount() - 1);
            }
            this.comboBoxes[index].addItem("HALF");
            this.comboBoxes[index].addItem("MAX");
            this.comboBoxes[index].addActionListener(comboBoxActionListener);
            this.comboBoxes[index].getEditor().getEditorComponent().addKeyListener(comboBoxKeyListener);
            this.comboBoxes[index].setEditable(true);
        }
        if (this.checkTotalCapacity()) {
            this.totalCapacity.setText(Utility.byteCountLongToString(this.getTotalCapacityInBytes()));
        } else {
            this.totalCapacity.setText("        ");
        }
        this.deviceDatabaseChangeHandler = new DeviceDatabaseChangeHandler();
        this.databaseManager.deviceDatabase.addUpdateListener(this.deviceDatabaseChangeHandler);
        this.disableDocumentListener = false;
    }

    private JPanel buildSegmentPanel() {
        JPanel headerPanel = this.buildHeaderPanel();
        JPanel scrollPanel = this.buildScrollPanel();
        JScrollPane scrollingPane = new JScrollPane(scrollPanel);
        scrollingPane.setVerticalScrollBarPolicy(21);
        scrollingPane.setHorizontalScrollBarPolicy(31);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.anchor = 17;
        constraints.fill = 2;
        Utility.addComponent(headerPanel, panel, layout, constraints, 0, 0, 0, 0, 0, 0, 0.0);
        Utility.addComponent(scrollingPane, panel, layout, constraints, 0, 1, 0, 0, 0, 0, 0.0);
        constraints.weighty = 1.0;
        Utility.addComponent(new JLabel(""), panel, layout, constraints, 0, 2, 0, 0, 0, 0, 0.0);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Segment"));
        JPanel borderPanel = new JPanel();
        borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        borderPanel.add(panel);
        return borderPanel;
    }

    private JPanel buildHeaderPanel() {
        JPanel headerPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        headerPanel.setLayout(layout);
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets.top = 0;
        constraints.insets.bottom = 4;
        constraints.gridx = 0;
        constraints.insets.left = 10;
        constraints.ipadx = 0;
        constraints.ipadx = 8;
        JLabel template = new JLabel("Path ID ");
        Dimension dim = template.getPreferredSize();
        JLabel headerLabel = new JLabel("Path ID");
        headerLabel.setPreferredSize(dim);
        layout.setConstraints(headerLabel, constraints);
        headerPanel.add(headerLabel);
        constraints.insets.bottom = 0;
        constraints.gridx = 1;
        constraints.insets.left = 4;
        headerLabel = new JLabel("Target ID");
        layout.setConstraints(headerLabel, constraints);
        headerPanel.add(headerLabel);
        constraints.insets.bottom = 0;
        constraints.gridx = 2;
        constraints.insets.left = 10;
        headerLabel = new JLabel("Capacity");
        layout.setConstraints(headerLabel, constraints);
        headerPanel.add(headerLabel);
        constraints.insets.bottom = 0;
        constraints.gridx = 3;
        constraints.weightx = 1.0;
        headerLabel = new JLabel("");
        layout.setConstraints(headerLabel, constraints);
        headerPanel.add(headerLabel);
        return headerPanel;
    }

    private JPanel buildScrollPanel() {
        int count;
        JPanel scrollPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        scrollPanel.setLayout(layout);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.insets.left = 10;
        JLabel template = new JLabel("Target ID ");
        Dimension dim = template.getPreferredSize();
        for (count = 0; count < this.selectionCount; ++count) {
            if (count == this.selectionCount - 1) {
                constraints.insets.bottom = 8;
            }
            constraints.gridy = count;
            constraints.insets.top = count == 0 ? 8 : 2;
            layout.setConstraints(this.pathIdLabels[count], constraints);
            this.pathIdLabels[count].setPreferredSize(dim);
            scrollPanel.add(this.pathIdLabels[count]);
        }
        constraints.insets.left = 6;
        constraints.insets.bottom = 0;
        constraints.gridx = 1;
        for (count = 0; count < this.selectionCount; ++count) {
            if (count == this.selectionCount - 1) {
                constraints.insets.bottom = 8;
            }
            constraints.gridy = count;
            constraints.insets.top = count == 0 ? 8 : 2;
            layout.setConstraints(this.targetIdLabels[count], constraints);
            this.targetIdLabels[count].setPreferredSize(dim);
            scrollPanel.add(this.targetIdLabels[count]);
        }
        constraints.insets.bottom = 0;
        constraints.gridx = 2;
        for (count = 0; count < this.selectionCount; ++count) {
            if (count == this.selectionCount - 1) {
                constraints.insets.bottom = 5;
            }
            constraints.gridy = count;
            if (count == 0) {
                constraints.insets.top = 4;
            }
            layout.setConstraints(this.comboBoxes[count], constraints);
            scrollPanel.add(this.comboBoxes[count]);
        }
        constraints.insets.bottom = 0;
        constraints.gridx = 4;
        constraints.weightx = 1.0;
        count = 0;
        while (count < this.selectionCount) {
            if (count == this.selectionCount - 1) {
                constraints.insets.bottom = 8;
            }
            constraints.gridy = count++;
            JLabel jlabel = new JLabel("");
            layout.setConstraints(jlabel, constraints);
            scrollPanel.add(jlabel);
        }
        return scrollPanel;
    }

    private JPanel buildCapacityPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets.top = 0;
        constraints.insets.bottom = 4;
        JPanel namePanel = new JPanel(new FlowLayout(1));
        namePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        namePanel.add(new JLabel("Total Capacity: "));
        namePanel.add(this.totalCapacity);
        Utility.addComponent(namePanel, panel, layout, constraints, 0, 5, 0, 4, 8, 8, 0.0);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "RAID Group"));
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BoxLayout(borderPanel, 1));
        borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 13, 0, 13));
        borderPanel.add(panel);
        return borderPanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.createButton = new JButton("Create");
        JButton cancelButton = new JButton("Cancel");
        this.createButton.setMnemonic(67);
        cancelButton.setMnemonic(88);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConcatCapacityBox.this.parent.setReturnValue(ConcatCapacityBox.this.getTotalCapacityInBlocks());
                ConcatCapacityBox.this.parent.setReturnList(ConcatCapacityBox.this.fetchUpdatedCapacities());
                ConcatCapacityBox.this.parent.setReturnStatus(true);
                ConcatCapacityBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConcatCapacityBox.this.parent.setReturnStatus(false);
                ConcatCapacityBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.createButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    private void updateButtonState() {
        if (!this.checkCapacityValidity() || !this.checkTotalCapacity()) {
            this.totalCapacity.setText("        ");
            this.updateDoneButtonState(false);
        } else {
            this.totalCapacity.setText(Utility.byteCountLongToString(this.getTotalCapacityInBytes()));
            this.updateDoneButtonState(true);
        }
    }

    private synchronized boolean checkCapacityValidity() {
        for (int count = 0; count < this.segmentList.size(); ++count) {
            String capacityString = this.comboBoxes[count].getEditor().getItem().toString().toUpperCase().trim();
            if (capacityString.equals("MAX") || capacityString.equals("HALF")) {
                return true;
            }
            int endIndex = capacityString.indexOf(" MB");
            if (endIndex == -1 && (endIndex = capacityString.indexOf(" GB")) == -1 && (endIndex = capacityString.indexOf(" TB")) == -1) {
                return false;
            }
            String suffix = capacityString.substring(endIndex, capacityString.length());
            if (suffix.length() > 3) {
                return false;
            }
            String digits = capacityString.substring(0, endIndex).trim();
            int digitsLen = digits.length();
            int decpointIndex = capacityString.indexOf(".");
            if (decpointIndex != -1 ? capacityString.substring(++decpointIndex, endIndex).trim().length() > 2 : (digitsLen = (digits = capacityString.substring(0, endIndex).trim()).length()) == 0 || digitsLen > 3) {
                return false;
            }
            for (int index = 0; index < digits.length(); ++index) {
                char digit = digits.charAt(index);
                if (digit >= '0' && digit <= '9' || digit == '.') continue;
                return false;
            }
        }
        return true;
    }

    private synchronized boolean checkTotalCapacity() {
        return this.getTotalCapacityInBlocks() <= Long.MAX_VALUE;
    }

    private synchronized long getTotalCapacityInBlocks() {
        long accumCapacity = 0L;
        for (int index = 0; index < this.selectionCount; ++index) {
            accumCapacity += this.getComboCapacityInBlocks(index);
        }
        return accumCapacity;
    }

    private synchronized long getComboCapacityInBlocks(int index) {
        long capacityBlocks;
        SegmentDescriptor segment = (SegmentDescriptor)this.segmentList.get(index);
        String capacityString = this.comboBoxes[index].getEditor().getItem().toString().toUpperCase().trim();
        if (capacityString.equals("MAX")) {
            capacityBlocks = Long.parseLong(segment.capacityInBlocks);
        } else if (capacityString.equals("HALF")) {
            capacityBlocks = Long.parseLong(segment.capacityInBlocks) / 2L;
        } else if (capacityString.indexOf(".") != -1) {
            capacityBlocks = Long.parseLong(segment.capacityInBlocks);
        } else {
            int endIndex = capacityString.indexOf(" MB");
            if (endIndex == -1) {
                endIndex = capacityString.indexOf(" GB");
                if (endIndex == -1) {
                    endIndex = capacityString.indexOf(" TB");
                    if (endIndex == -1) {
                        endIndex = capacityString.length();
                        capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 2048L;
                    } else {
                        capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 0x80000000L;
                    }
                } else {
                    capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 0x200000L;
                }
            } else {
                capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 2048L;
            }
        }
        return capacityBlocks;
    }

    private synchronized long getTotalCapacityInBytes() {
        long capacityInBlocksLong = this.getTotalCapacityInBlocks();
        long capacityInBytes = capacityInBlocksLong * 512L;
        return capacityInBytes;
    }

    private void updateDoneButtonState(boolean newState) {
        if (this.createButton.isEnabled() != newState) {
            this.createButton.setEnabled(newState);
        }
    }

    private synchronized ArrayList fetchUpdatedCapacities() {
        ArrayList<String> capacitiesList = new ArrayList<String>();
        for (int index = 0; index < this.selectionCount; ++index) {
            long capacityBlocks = this.getComboCapacityInBlocks(index);
            capacitiesList.add(Long.toString(capacityBlocks));
        }
        return capacitiesList;
    }

    protected void closeDialog() {
        this.comboBoxesPollingThread = null;
        this.databaseManager.deviceDatabase.removeUpdateListener(this.deviceDatabaseChangeHandler);
        this.dispose();
    }

    static /* synthetic */ JComboBox[] access$800(ConcatCapacityBox x0) {
        return x0.comboBoxes;
    }

    private class ComboBoxesPollingThread
    extends Thread {
        private ComboBoxesPollingThread() {
        }

        public void run() {
            while (ConcatCapacityBox.this.comboBoxesPollingThread != null) {
                try {
                    Thread.sleep(500L);
                    ConcatCapacityBox.this.updateButtonState();
                }
                catch (Exception exception) {}
            }
        }
    }

    private class ComboBoxKeyListener
    implements KeyListener {
        private ComboBoxKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        /*
         * Unable to fully structure code
         */
        public void keyTyped(KeyEvent e) {
            eSource = e.getSource();
            for (count = 0; count < ConcatCapacityBox.access$500(ConcatCapacityBox.this).size(); ++count) {
                if (!eSource.equals(ConcatCapacityBox.access$800(ConcatCapacityBox.this)[count].getEditor().getEditorComponent())) continue;
                digit = e.getKeyChar();
                if (digit >= 'a' && digit <= 'z') {
                    digit = (char)(digit - 32);
                    e.setKeyChar(digit);
                }
                capacityString = ConcatCapacityBox.access$800(ConcatCapacityBox.this)[count].getEditor().getItem().toString().trim();
                if (digit == '\b') ** GOTO lbl-1000
                if (digit == '\t') ** GOTO lbl-1000
                if (digit == ' ') ** GOTO lbl-1000
                if (digit == '%') ** GOTO lbl-1000
                if (digit == '\'') ** GOTO lbl-1000
                if (digit == '\u00e2') ** GOTO lbl-1000
                if (digit != '\u00e2' && digit != 'G' && digit != 'T' && digit != 'B') {
                    if (digit < '0' || digit > '9') {
                        e.consume();
                        return;
                    }
                } else lbl-1000:
                // 7 sources

                {
                    if (digit == 'G' && capacityString.indexOf("G") != -1) {
                        e.consume();
                        return;
                    }
                    if (digit == 'T' && capacityString.indexOf("T") != -1) {
                        e.consume();
                        return;
                    }
                    if (digit == 'B' && capacityString.indexOf("B") != -1) {
                        e.consume();
                        return;
                    }
                }
                if (digit == '\b' || capacityString.length() <= 5) continue;
                e.consume();
                return;
            }
        }
    }

    class ComboBoxActionListener
    implements ActionListener {
        ComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Utility.println("comboBox action listener");
            if (!ConcatCapacityBox.this.disableDocumentListener) {
                ConcatCapacityBox.this.updateButtonState();
            }
        }
    }

    private class DeviceDatabaseChangeHandler
    implements Runnable {
        public void run() {
            Utility.println("DeviceDatabaseChangeHandler() entered");
            ArrayList deviceList = ConcatCapacityBox.this.databaseManager.deviceDatabase.getDeviceList();
            boolean same = false;
            for (int count = 0; count < ConcatCapacityBox.this.segmentList.size(); ++count) {
                SegmentDescriptor segment = (SegmentDescriptor)ConcatCapacityBox.this.segmentList.get(count);
                same = false;
                for (int index = 0; index < deviceList.size(); ++index) {
                    DeviceDescriptor device = (DeviceDescriptor)deviceList.get(index);
                    if (Integer.parseInt(segment.pathId) != device.pathId || Integer.parseInt(segment.targetId) != device.targetId || !device.status.equals("Healthy")) continue;
                    same = true;
                    break;
                }
                if (!same) break;
            }
            if (!same) {
                JOptionPane.showMessageDialog(ConcatCapacityBox.this, "One or more segments previously selected no longer exist.\nPlease, make a new selection.", "Warning", 2);
            }
            ConcatCapacityBox.this.parent.setReturnStatus(false);
            ConcatCapacityBox.this.closeDialog();
        }
    }
}

