/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public abstract class AbstractDatabase
implements GlobalConstants {
    protected AbstractMessageHandler infoMessageHandler;
    protected AbstractMessageHandler countsMessageHandler;
    protected DatabaseManager databaseManager;
    protected ArrayList notifyList;
    protected CommManager commManager;
    protected long updateCount;
    protected String updateCountType;
    protected boolean slowInitMode;
    protected boolean valid;
    protected boolean initializing;
    protected int previousState;
    protected int state;

    public AbstractDatabase(DatabaseManager databaseManager, String updateCountType) {
        this.databaseManager = databaseManager;
        this.commManager = databaseManager.commManager;
        this.updateCountType = updateCountType;
        this.notifyList = new ArrayList();
        this.infoMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                AbstractDatabase.this.processNewData(message);
            }
        };
        this.countsMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                AbstractDatabase.this.processUpdateCountsMessage(message);
            }
        };
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            if ((Runnable)this.notifyList.get(index) != updateListener) continue;
            this.notifyList.remove(index);
            break;
        }
    }

    protected abstract void processNewData(Message var1);

    protected void processUpdateCountsMessage(Message message) {
    }

    public void processUpdateCount(long latestUpdateCount) {
        if (latestUpdateCount != this.updateCount) {
            String request = "<si:Request><si:Type>" + this.updateCountType + "UpdateCounts</si:Type>" + "</si:Request>";
            this.databaseManager.commManager.sendMessage("Get", request, this.countsMessageHandler);
            this.updateCount = latestUpdateCount;
        }
    }

    protected void getNew() {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>New</si:Qualifier>" + "</si:Request>";
        this.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getFirst() {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>First</si:Qualifier>" + "</si:Request>";
        this.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getNext(int count) {
        this.getNext((long)count);
    }

    protected void getThis(int count) {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>This</si:Qualifier>" + "<si:" + this.updateCountType + ">" + count + "</si:" + this.updateCountType + ">" + "</si:Request>";
        this.databaseManager.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getThis(long count) {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>This</si:Qualifier>" + "<si:" + this.updateCountType + ">" + count + "</si:" + this.updateCountType + ">" + "</si:Request>";
        this.databaseManager.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getThis(String count) {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>This</si:Qualifier>" + "<si:" + this.updateCountType + ">" + count + "</si:" + this.updateCountType + ">" + "</si:Request>";
        this.databaseManager.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getNext(long count) {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>Next</si:Qualifier>" + "<si:" + this.updateCountType + ">" + count + "</si:" + this.updateCountType + ">" + "</si:Request>";
        this.databaseManager.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    public void setInitialUpdateCount(long initialUpdateCount) {
        this.updateCount = initialUpdateCount;
    }

    public synchronized void initialize() {
        this.initializing = true;
        ApplicationLog.put(this.getClass().getName() + " initialization started");
        Utility.println(this.getClass().getName() + " initialization started");
    }

    public void initializationComplete() {
        this.valid = true;
        this.initializing = false;
        ApplicationLog.put(this.getClass().getName() + " initialization completed");
        Utility.println(this.getClass().getName() + " initialization completed\n");
        this.databaseManager.initializationComplete(this.getClass().getName());
        this.notifyListeners();
    }

    public void suspend() {
        if (this.state != 2) {
            this.previousState = this.state;
            this.state = 2;
            ApplicationLog.put(this.getClass().getName() + " suspended");
            Utility.println(this.getClass().getName() + " suspended\n");
            this.notifyListeners();
        }
    }

    public void resume() {
        if (this.state == 2) {
            this.state = this.previousState;
            ApplicationLog.put(this.getClass().getName() + " resumed");
            Utility.println(this.getClass().getName() + " resumed\n");
            this.notifyListeners();
        }
    }

    public synchronized void nuke() {
        this.valid = false;
        this.initializing = false;
        this.updateCount = 0L;
        ApplicationLog.put(this.getClass().getName() + " nuked");
        Utility.println(this.getClass().getName() + " nuked\n");
    }

    public boolean valid() {
        return this.valid;
    }

    public synchronized void saveSnapshot(FileOutputStream outputStream) {
    }

    public synchronized void loadSnapshot(XmlData xmlData) {
    }

    public void notifyListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
        }
    }
}

