/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DeviceChannelPanel
extends JPanel
implements MouseListener,
GlobalConstants {
    StorageManagementUtility storageManagementUtility;
    DatabaseManager databaseManager;
    Runnable deviceDatabaseChangeHandler;
    boolean popupEnabled;
    DatabaseChangeListener databaseChangeListener;
    DatabaseNukeListener databaseNukeListener;
    int raidGroupInFocus = -1;
    int ROW_OFFSET = 30;
    int FIRST_COLUMN_OFFSET = 30;
    final String emptyString = "Empty";
    int SLOT_WIDTH = 170;
    int SLOT_HEIGHT = 96;
    final int SLOT_BORDER_WIDTH = 4;
    final int VERTICAL_OFFSET = 25;
    final int HORIZONTAL_OFFSET = 20;
    final Color textColor = Color.black;

    public DeviceChannelPanel(StorageManagementUtility storageManagementUtility, DatabaseManager databaseManager) {
        this.storageManagementUtility = storageManagementUtility;
        this.databaseManager = databaseManager;
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        this.popupEnabled = true;
        Dimension d = new Dimension(this.getPreferredWidth(), this.getPreferredHeight());
        this.setPreferredSize(d);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addMouseListener(this);
        this.databaseChangeListener = new DatabaseChangeListener();
        this.databaseNukeListener = new DatabaseNukeListener();
        this.addListeners();
    }

    public synchronized void addListeners() {
        this.databaseManager.deviceDatabase.addUpdateListener(this.databaseChangeListener);
        this.databaseManager.raidGroupDatabase.addUpdateListener(this.databaseChangeListener);
        this.databaseManager.controllerDatabase.addUpdateListener(this.databaseChangeListener);
        this.databaseManager.addNukeListener(this.databaseNukeListener);
        SwingUtilities.invokeLater(this.databaseChangeListener);
    }

    private synchronized void removeListeners() {
        this.databaseManager.deviceDatabase.removeUpdateListener(this.databaseChangeListener);
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.databaseChangeListener);
        this.databaseManager.controllerDatabase.removeUpdateListener(this.databaseChangeListener);
        this.databaseManager.removeNukeListener(this.databaseNukeListener);
    }

    public int getHorizontalScrollUnitIncrement() {
        return this.SLOT_WIDTH;
    }

    public int getVerticalScrollUnitIncrement() {
        return this.SLOT_HEIGHT;
    }

    public int getPreferredHeight() {
        ControllerDescriptor controllerDescriptor = this.databaseManager.getSelectedController();
        int maxDevices = controllerDescriptor.targetIdCount;
        int width = 25 + (this.SLOT_HEIGHT + this.ROW_OFFSET) * maxDevices;
        return width;
    }

    public int getPreferredWidth() {
        ControllerDescriptor controllerDescriptor = this.databaseManager.getSelectedController();
        int maxChannels = controllerDescriptor.pathIdCount;
        int width = 20 + (this.SLOT_WIDTH + 20) * maxChannels;
        return width;
    }

    public void setPopupEnabled(boolean enabled) {
        this.popupEnabled = enabled;
    }

    public void finalize() {
        this.databaseManager.deviceDatabase.removeUpdateListener(this.deviceDatabaseChangeHandler);
    }

    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        ControllerDescriptor controllerDescriptor = this.databaseManager.getSelectedController();
        Point topLeft = new Point(20, 25);
        Font hexFont = new Font("Dialog", 0, 12);
        FontMetrics fontMetrics = g.getFontMetrics(hexFont);
        g.setFont(new Font("Dialog", 0, 11));
        for (int chan = 0; chan < controllerDescriptor.pathIdCount; ++chan) {
            topLeft.x = 20 + this.SLOT_WIDTH * chan + this.FIRST_COLUMN_OFFSET;
            topLeft.y = 25;
            g.setColor(Color.black);
            g.drawString("Channel" + chan, topLeft.x, topLeft.y - 5);
            for (int dev = 0; dev < controllerDescriptor.targetIdCount; ++dev) {
                SegmentDescriptor segment;
                boolean hasSelectedRaidSegment = false;
                int devId = chan * controllerDescriptor.targetIdCount + dev;
                DeviceDescriptor deviceDescriptor = this.databaseManager.deviceDatabase.getDevice(devId);
                if (deviceDescriptor == null) continue;
                if (deviceDescriptor.status.equals("Empty")) {
                    g.setColor(this.textColor);
                    g.drawString("Empty", topLeft.x + 6, topLeft.y + this.SLOT_HEIGHT + 12);
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.lightGray);
                }
                g.fillRect(topLeft.x, topLeft.y, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT);
                g.setColor(Color.black);
                g.drawRect(topLeft.x, topLeft.y, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT);
                if (chan == 0) {
                    g.drawString("ID " + dev, 20, topLeft.y + this.SLOT_HEIGHT / 2);
                }
                for (int segm = 0; segm < deviceDescriptor.segmentArray.size() && !hasSelectedRaidSegment; ++segm) {
                    RaidGroupDescriptor raidGroupDescriptor;
                    int segmentHeight = this.SLOT_HEIGHT / deviceDescriptor.segmentArray.size();
                    if (segm > 0) {
                        g.drawLine(topLeft.x, topLeft.y + segmentHeight * segm, topLeft.x + this.SLOT_WIDTH - 20, topLeft.y + segmentHeight * segm);
                    }
                    segment = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segm);
                    if (segment.status.equals("Member")) {
                        raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(Integer.parseInt(segment.raidGroup));
                        if (raidGroupDescriptor.status.equals("Reduced")) {
                            g.setColor(Color.yellow);
                        } else if (raidGroupDescriptor.status.equals("Online")) {
                            g.setColor(Color.green);
                        } else if (raidGroupDescriptor.status.equals("Offline")) {
                            if (raidGroupDescriptor.validateState.equals("Minimum")) {
                                g.setColor(Color.orange);
                            } else {
                                g.setColor(Color.pink);
                            }
                        }
                        if (raidGroupDescriptor.raidGroup == this.raidGroupInFocus) {
                            hasSelectedRaidSegment = true;
                            g.fillRect(topLeft.x, topLeft.y, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT);
                            g.setColor(this.textColor);
                            g.drawRect(topLeft.x, topLeft.y, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT);
                            g.drawRect(topLeft.x + 1, topLeft.y + 1, this.SLOT_WIDTH - 22, this.SLOT_HEIGHT - 2);
                            g.drawRect(topLeft.x + 2, topLeft.y + 2, this.SLOT_WIDTH - 24, this.SLOT_HEIGHT - 4);
                            if (raidGroupDescriptor.metadataFormat.equals("Old")) {
                                g.drawString("Legacy RG " + segment.raidGroup, topLeft.x + 6, topLeft.y + 26);
                            } else {
                                g.drawString(raidGroupDescriptor.label + " (RG" + raidGroupDescriptor.raidGroup + ")", topLeft.x + 6, topLeft.y + 26);
                            }
                            g.drawString(segment.capacity, topLeft.x + 6, topLeft.y + 38);
                            g.drawString(raidGroupDescriptor.configuration, topLeft.x + 6, topLeft.y + 50);
                            continue;
                        }
                        g.fillRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, segmentHeight);
                        g.setColor(this.textColor);
                        g.drawRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, segmentHeight);
                        if (this.raidGroupInFocus != -1) continue;
                        g.drawString(segment.capacity + " " + raidGroupDescriptor.configuration, topLeft.x + 6, topLeft.y + segmentHeight * segm + 12);
                        continue;
                    }
                    if (segment.status.endsWith("Spare")) {
                        g.setColor(Color.green.darker());
                        if (segment.status.startsWith("Dedicated")) {
                            raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(Integer.parseInt(segment.raidGroup));
                            if (raidGroupDescriptor.raidGroup == this.raidGroupInFocus) {
                                g.fillRect(topLeft.x, topLeft.y, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT);
                                g.setColor(this.textColor);
                                g.drawRect(topLeft.x, topLeft.y, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT);
                                g.drawRect(topLeft.x + 1, topLeft.y + 1, this.SLOT_WIDTH - 22, this.SLOT_HEIGHT - 2);
                                g.drawRect(topLeft.x + 2, topLeft.y + 2, this.SLOT_WIDTH - 24, this.SLOT_HEIGHT - 4);
                                g.drawString(segment.status + " (RG" + raidGroupDescriptor.raidGroup + ")", topLeft.x + 6, topLeft.y + 26);
                                g.drawString(segment.capacity, topLeft.x + 6, topLeft.y + 38);
                                hasSelectedRaidSegment = true;
                                continue;
                            }
                            g.fillRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, segmentHeight);
                            g.setColor(this.textColor);
                            g.drawRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, segmentHeight);
                            if (this.raidGroupInFocus != -1) continue;
                            g.drawString(segment.capacity + " " + segment.status, topLeft.x + 6, topLeft.y + segmentHeight * segm + 12);
                            continue;
                        }
                        g.fillRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, segmentHeight);
                        g.setColor(this.textColor);
                        g.drawRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, segmentHeight);
                        if (this.raidGroupInFocus != -1) continue;
                        g.drawString(segment.capacity + " " + segment.status, topLeft.x + 6, topLeft.y + segmentHeight * segm + 12);
                        continue;
                    }
                    if (segment.status.equals("Orphan")) {
                        g.setColor(Color.lightGray);
                        g.fillRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT - segmentHeight * segm);
                        g.setColor(this.textColor);
                        g.drawRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT - segmentHeight * segm);
                        if (this.raidGroupInFocus != -1) continue;
                        g.drawString(segment.capacity + " " + segment.status, topLeft.x + 6, topLeft.y + segmentHeight * segm + 12);
                        continue;
                    }
                    g.setColor(Color.lightGray);
                    if (deviceDescriptor.passThru) {
                        g.setColor(GlobalConstants.passThruColor);
                    }
                    g.fillRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT - segmentHeight * segm);
                    g.setColor(this.textColor);
                    g.drawRect(topLeft.x, topLeft.y + segmentHeight * segm, this.SLOT_WIDTH - 20, this.SLOT_HEIGHT - segmentHeight * segm);
                    if (this.raidGroupInFocus != -1) continue;
                    g.drawString(segment.capacity + " Available", topLeft.x + 6, topLeft.y + segmentHeight * segm + 12);
                    if (!deviceDescriptor.passThru) continue;
                    g.setFont(new Font("Dialog", 0, 17));
                    g.setColor(Color.blue);
                    g.drawString("P A S S - T H R U", topLeft.x + 9, topLeft.y + segmentHeight * segm + segmentHeight / 2 + 6);
                    g.setColor(this.textColor);
                    g.setFont(new Font("Dialog", 0, 11));
                }
                if (deviceDescriptor.segmentArray.size() > 0) {
                    float available = 0.0f;
                    boolean divider = false;
                    String unit = " MB";
                    for (int segm = 0; segm < deviceDescriptor.segmentArray.size(); ++segm) {
                        float delta = 0.0f;
                        segment = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segm);
                        if (!segment.status.equals("Available")) continue;
                        int endIndex = segment.capacity.indexOf(" MB");
                        if (endIndex != -1) {
                            delta = Float.parseFloat(segment.capacity.substring(0, endIndex));
                            if (!unit.equals(" MB")) {
                                delta /= 1024.0f;
                                if (unit.equals(" TB")) {
                                    delta /= 1024.0f;
                                }
                            }
                            available += delta;
                            continue;
                        }
                        endIndex = segment.capacity.indexOf(" GB");
                        if (endIndex != -1) {
                            delta = Float.parseFloat(segment.capacity.substring(0, endIndex));
                            if (unit.equals(" MB")) {
                                available /= 1024.0f;
                                unit = " GB";
                            } else if (unit.equals(" TB")) {
                                delta /= 1024.0f;
                            }
                            available += delta;
                            continue;
                        }
                        endIndex = segment.capacity.indexOf(" TB");
                        if (endIndex == -1) continue;
                        delta = Float.parseFloat(segment.capacity.substring(0, endIndex));
                        if (!unit.equals(" TB")) {
                            available /= 1024.0f;
                            if (unit.equals(" MB")) {
                                available /= 1024.0f;
                            }
                            unit = " TB";
                        }
                        available += delta;
                    }
                    g.setColor(this.textColor);
                    g.drawString(available + unit + " Available", topLeft.x + 6, topLeft.y + this.SLOT_HEIGHT + 12);
                }
                topLeft.y += this.SLOT_HEIGHT + this.ROW_OFFSET;
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void setSelected(int slot) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void highlightRaidGroupHandler(int raidGroup) {
        this.raidGroupInFocus = raidGroup;
        this.databaseChangeListener.run();
    }

    private class DatabaseNukeListener
    implements Runnable {
        private DatabaseNukeListener() {
        }

        public void run() {
            DeviceChannelPanel.this.removeListeners();
        }
    }

    private class DatabaseChangeListener
    implements Runnable {
        private DatabaseChangeListener() {
        }

        public void run() {
            DeviceChannelPanel.this.repaint();
        }
    }
}

