/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ResourcePage
extends KFrame {
    private ResourceTableModel tableModel;
    private KTable table;
    private Runnable updateHandler;
    private MessageQueue inbox;
    private Timer timer;
    private JLabel statusLabel;
    private JMenuItem suspendMenuItem;
    private JMenuItem resumeMenuItem;
    private AbstractMessageHandler infoMessageHandler;
    private int stateFlags;
    private int ACTIVE_STATE_MASK = 1;
    private int SUSPENDED_STATE_MASK = 2;
    private int DISCONNECTED_STATE_MASK = 4;
    final String[] rowNames = new String[]{"DSRB", "QSRB", "TDB", "DSD", "DBD"};

    public ResourcePage(DatabaseManager databaseManager, String title) {
        this.beginFrameInit(databaseManager, title);
        this.inbox = new MessageQueue();
        this.updateHandler = new UpdateHandler();
        this.buildMenus();
        this.buildTable();
        this.buildStatusBar();
        this.stateFlags = this.ACTIVE_STATE_MASK;
        this.updateStatusBar();
        this.infoMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                if (ResourcePage.this.stateFlags == ResourcePage.this.ACTIVE_STATE_MASK) {
                    ResourcePage.this.inbox.putMessage(message);
                    SwingUtilities.invokeLater(ResourcePage.this.updateHandler);
                }
            }
        };
        this.getResourceCounts();
        this.timer = new Timer(4000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ResourcePage.this.stateFlags == ResourcePage.this.ACTIVE_STATE_MASK) {
                    ResourcePage.this.getResourceCounts();
                }
            }
        });
        this.timer.start();
        this.completeFrameInit();
    }

    private void buildMenus() {
        JMenuItem openItem = new JMenuItem("Open...", 79);
        JMenuItem saveItem = new JMenuItem("Save...", 83);
        JMenuItem printItem = new JMenuItem("Print...", 80);
        JMenuItem exitItem = new JMenuItem("Exit", 88);
        openItem.setEnabled(false);
        saveItem.setEnabled(false);
        printItem.setEnabled(false);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourcePage.this.closeFrame();
            }
        });
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(exitItem);
        JMenuItem optionsMenuItem = new JMenuItem("Options...", 79);
        optionsMenuItem.setEnabled(false);
        this.suspendMenuItem = new JMenuItem("Suspend", 83);
        this.suspendMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.suspendMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourcePage.this.stateFlags |= ResourcePage.this.SUSPENDED_STATE_MASK;
                ResourcePage.this.suspendMenuItem.setEnabled(false);
                ResourcePage.this.resumeMenuItem.setEnabled(true);
                ResourcePage.this.updateStatusBar();
            }
        });
        this.resumeMenuItem = new JMenuItem("Resume", 82);
        this.resumeMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.resumeMenuItem.setEnabled(false);
        this.resumeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourcePage.this.stateFlags &= ~ResourcePage.this.SUSPENDED_STATE_MASK;
                ResourcePage.this.resumeMenuItem.setEnabled(false);
                ResourcePage.this.suspendMenuItem.setEnabled(true);
                ResourcePage.this.updateStatusBar();
            }
        });
        JMenu displayMenu = new JMenu("Display");
        displayMenu.setMnemonic(68);
        displayMenu.add(this.suspendMenuItem);
        displayMenu.add(this.resumeMenuItem);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(displayMenu);
        this.setJMenuBar(menubar);
    }

    private void updateStatusBar() {
        if (this.stateFlags == this.ACTIVE_STATE_MASK) {
            this.statusLabel.setText(" Active");
        } else if (this.stateFlags == (this.ACTIVE_STATE_MASK | this.SUSPENDED_STATE_MASK)) {
            this.statusLabel.setText(" Suspended");
        } else {
            this.statusLabel.setText(" Disconnected");
        }
    }

    public void closeFrame() {
        this.timer.stop();
        this.inbox.empty();
        this.completeFrameClosure();
    }

    private void buildTable() {
        this.tableModel = new ResourceTableModel();
        this.table = new KTable(this.tableModel, 5);
        this.table.setRowSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(this.table.getBackground());
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    private void buildStatusBar() {
        JPanel statusBar = new JPanel();
        GridBagLayout statusBarLayout = new GridBagLayout();
        statusBar.setLayout(statusBarLayout);
        this.getContentPane().add((Component)statusBar, "South");
        JLabel padLabel = new JLabel(" ");
        Utility.setLabelAtrributes(padLabel, 0, 0, 1, 10, 2, statusBarLayout);
        statusBar.add(padLabel);
        this.statusLabel = new JLabel(" Disconnected");
        Utility.setLabelAtrributes(this.statusLabel, 4, 1, 0, 13, 0, statusBarLayout);
        statusBar.add(this.statusLabel);
    }

    private void getResourceCounts() {
        String request = "<si:Request><si:Type>Resources</si:Type><si:Qualifier>Both</si:Qualifier></si:Request>";
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                ResourcePage.this.databaseManager.refresh();
                ResourcePage.this.storageManagementUtility.clearWait();
                XmlData xmlData = new XmlData(message.response);
                while (xmlData.getNextElement()) {
                    if (xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                        new ErrorMessageBox(ResourcePage.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Get Resources Error");
                        continue;
                    }
                    if (!xmlData.element.equals("Resources")) continue;
                    XmlData resourcesXmlData = new XmlData(xmlData.elementValue);
                    while (resourcesXmlData.getNextElement()) {
                        int type;
                        if (!resourcesXmlData.element.equals("ValueSet")) {
                            new ErrorMessageBox(ResourcePage.this, "The Requested Operation Failed: Syntax Error - Unexpected Element", "Get Resources Error");
                        }
                        int n = type = resourcesXmlData.elementValue.equals("Current") ? ((ResourcePage)ResourcePage.this).tableModel.TYPE_CURRENT : ((ResourcePage)ResourcePage.this).tableModel.TYPE_MAXIMUM;
                        block2: while (resourcesXmlData.getNextElement()) {
                            for (int row = 0; row < ResourcePage.this.rowNames.length; ++row) {
                                if (!resourcesXmlData.element.equalsIgnoreCase(ResourcePage.this.rowNames[row])) continue;
                                ResourcePage.this.tableModel.changeValue(type, row, resourcesXmlData.elementValue);
                                continue block2;
                            }
                        }
                        ResourcePage.this.tableModel.updateTable();
                    }
                }
            }
        };
        this.storageManagementUtility.setWait();
        this.databaseManager.commManager.sendMessage("Get", request, responseMessageHandler);
    }

    class ResourceTableModel
    extends KTableModel {
        final int TITLE_COLUMN = 0;
        final int TYPE_CURRENT = 1;
        final int TYPE_MAXIMUM = 2;
        final String dash = "-";
        final String[] columnNames = new String[]{"Resource", "Current", "Maximum"};
        final String[] maxWidths = new String[]{"X Maximum X", "X Maximum X", "X Maximum X"};
        String[][] tableData;

        public ResourceTableModel() {
            this.setColumns(this.columnNames, this.maxWidths);
            this.tableData = new String[this.columnNames.length][ResourcePage.this.rowNames.length];
            for (int column = 0; column < this.columnNames.length; ++column) {
                for (int row = 0; row < ResourcePage.this.rowNames.length; ++row) {
                    this.tableData[column][row] = column == 0 ? ResourcePage.this.rowNames[row] : "-";
                }
            }
        }

        public int getRowCount() {
            return ResourcePage.this.rowNames.length;
        }

        public Object getValueAt(int row, int column) {
            if (row >= ResourcePage.this.rowNames.length || column >= this.columnNames.length) {
                return " -";
            }
            return " " + this.tableData[column][row];
        }

        public void changeValue(int type, int row, String value) {
            int column = type;
            int x = this.tableData.length;
            int y = this.tableData[0].length;
            if (column > this.tableData.length) {
                --column;
            }
            this.tableData[type][row] = value;
        }

        public void clearTable() {
            for (int column = 1; column < 3; ++column) {
                for (int row = 0; row < ResourcePage.this.rowNames.length; ++row) {
                    this.tableData[column][row] = "-";
                }
            }
            this.updateTable();
        }

        public void updateTable() {
            this.fireTableRowsUpdated(0, ResourcePage.this.rowNames.length - 1);
        }
    }

    private class UpdateHandler
    implements Runnable {
        private UpdateHandler() {
        }

        public void run() {
            Message message;
            while ((message = (Message)ResourcePage.this.inbox.getMessage(false)) != null) {
                XmlData xmlData = new XmlData(message.response);
                while (xmlData.getNextElement()) {
                    int type;
                    if (!xmlData.element.equals("ValueSet")) {
                        return;
                    }
                    int n = type = xmlData.elementValue.equals("Current") ? ((ResourcePage)ResourcePage.this).tableModel.TYPE_CURRENT : ((ResourcePage)ResourcePage.this).tableModel.TYPE_MAXIMUM;
                    block2: while (xmlData.getNextElement()) {
                        for (int row = 0; row < ResourcePage.this.rowNames.length; ++row) {
                            if (!xmlData.element.equalsIgnoreCase(ResourcePage.this.rowNames[row])) continue;
                            ResourcePage.this.tableModel.changeValue(type, row, xmlData.elementValue);
                            continue block2;
                        }
                    }
                }
                ResourcePage.this.tableModel.updateTable();
            }
            return;
        }
    }
}

