/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class CommLink
implements GlobalConstants {
    private static final boolean abreviate = true;
    public static final int STATE_INACTIVE = 0;
    public static final int STATE_ATTEMPTING_OPEN = 1;
    public static final int STATE_ATTEMPTING_REOPEN = 2;
    public static final int STATE_ATTEMPTING_CONNECTION = 4;
    public static final int STATE_CONNECTED = 7;
    public static final int MAX_SENT = 4;
    public static final int LOCAL_CONNECTION = 0;
    public static final int REMOTE_CONNECTION = 1;
    public static final String[] connectionTypeStrings = new String[]{"Local", "Remote"};
    public static final int COM_LINK_STAT_GOOD = 0;
    public static final int COM_LINK_STAT_ERR_OPEN_FAILED = 1;
    public static final int COM_LINK_STAT_ERR_NO_CONTROLLER = 2;
    public String connectionType;
    public int connectionTypeIndex;
    public String upDownStatus;
    public int controller;
    public String controllerLabel;
    public long transferred;
    public Date timeStamp;
    public int transactions;
    public int initCount;
    public int commErrors;
    public String offlineStatus;
    public String offlineDetails;
    public int lastEvent;
    public long lastTransactions;
    public long messagesReceived;
    public long lastMessagesReceived;
    public boolean enabled;
    public boolean local;
    public String ipAddress;
    public int serverPort;
    public String newIpAddress;
    public int newController;
    public int newServerPort;
    public String lastError;
    private LinkThread linkThread;
    private CommManager commManager;
    private MessageQueue commManagerMailbox;
    private MessageQueue commQueue;
    private int tag;
    private boolean verbose;
    private int receivedByteCount;
    private int transmittedByteCount;
    private int linkState;
    private String logFileName;
    private int previousLinkState;
    private SoftRAID5DaemonConnection connectionDaemon;
    private int prevLinkState;
    private String prevUpDownStatus;
    private String prevIpAddress;
    private int prevController;
    private String prevControllerLabel;
    private String prevOfflineStatus;
    private String prevOfflineDetails;
    private int newControllerCount;
    private int controllerCount;
    private final String pingString = String.valueOf('\u0005');
    private final String blankString = " ";
    private final String controllerLabelString = "Controller";
    EventEmail eventEmail = new EventEmail();

    CommLink(CommManager commManager, MessageQueue commManagerMailbox, boolean verbose) {
        this.commManager = commManager;
        this.commManagerMailbox = commManagerMailbox;
        this.verbose = verbose;
        this.connectionDaemon = new SoftRAID5DaemonConnection();
        this.linkState = 0;
        this.upDownStatus = "Down";
        this.ipAddress = "0.0.0.0";
        this.controller = 0;
        this.controllerCount = 0;
        this.controllerLabel = " ";
        this.offlineStatus = "Link Disabled";
        this.offlineDetails = " ";
        File file = new File(GlobalConstants.userDirectory + GlobalConstants.separatorChar + "debug.txt");
        this.logFileName = file.exists() ? GlobalConstants.userDirectory + GlobalConstants.separatorChar + "CommLog.xml" : null;
        if (this.logFileName != null) {
            ApplicationLog.flush(this.logFileName);
        }
        this.commQueue = new MessageQueue();
        this.linkThread = new LinkThread();
        this.linkThread.start();
    }

    public synchronized boolean isConnected() {
        return this.linkState == 7;
    }

    public int openLocalLink(int controller) {
        Utility.println("received open link (local) request");
        MessageQueue callBackMailBox = new MessageQueue();
        Message message = new Message(3, "DirectConnect");
        message.controller = controller;
        message.callBackMailBox = callBackMailBox;
        message.callBackValid = true;
        this.commQueue.putMessage(message);
        message = (Message)callBackMailBox.getMessage(true);
        Utility.println("openLocalLink: received the callBack message with the status of: " + message.responseStatus);
        return message.responseStatus;
    }

    public int openEthernetLink(String newIpAddress, int controller, int serverPort) {
        Utility.println("received open link (ethernet) request for " + newIpAddress);
        MessageQueue callBackMailBox = new MessageQueue();
        Message message = new Message(3, "OpenLink");
        message.payload = newIpAddress;
        message.controller = controller;
        message.argument0 = serverPort;
        message.callBackMailBox = callBackMailBox;
        message.callBackValid = true;
        this.commQueue.putMessage(message);
        message = (Message)callBackMailBox.getMessage(true);
        Utility.println("openEthernetLink: received the callBack message with the status of: " + message.responseStatus);
        return message.responseStatus;
    }

    public int getControllerCount() {
        Utility.println("received get controller count request");
        return this.controllerCount;
    }

    public void closeLink() {
        Utility.println("received close link request");
        this.enabled = false;
        this.offlineStatus = "Closing link";
        this.offlineDetails = " ";
        this.commManager.linkStatusChange(null, null);
        this.commQueue.putMessage(new Message(3, "CloseLink"));
    }

    public void reconnect() {
        Utility.println("AAAAAA received reconnect request");
        this.offlineStatus = "Reconnecting";
        this.offlineDetails = " ";
        this.commManager.linkStatusChange(null, null);
        this.commQueue.putMessage(new Message(3, "Reconnect"));
    }

    public void resetLink() {
        this.offlineStatus = "Resetting link";
        this.offlineDetails = " ";
        this.commManager.linkStatusChange(null, null);
        this.commQueue.putMessage(new Message(3, "ResetLink"));
    }

    public void resetLinkState() {
        this.offlineStatus = "Resetting link";
        this.offlineDetails = " ";
        this.commManager.linkStatusChange(null, null);
        this.commQueue.putMessage(new Message(3, "ResetLink"));
    }

    public void goodbyeConnection() {
        Utility.println("received 'Goodbye' request");
        MessageQueue callBackMailBox = new MessageQueue();
        Message message = new Message(3, "Goodbye");
        message.controller = this.controller;
        message.callBackMailBox = callBackMailBox;
        message.callBackValid = true;
        this.commQueue.putMessage(message);
        message = (Message)callBackMailBox.getMessage(true);
        Utility.println("goodbyeConnection: received the callBack message with the status of: " + message.responseStatus);
    }

    public void remoteDebug(boolean state) {
        Utility.println("received 'RemoteDebug " + (state ? "On" : "Off") + "' request");
        Message message = new Message(3, "RemoteDebug");
        message.controller = this.controller;
        message.argument0 = state ? 1 : 0;
        this.commQueue.putMessage(message);
    }

    public void removeDrive(int controller, int pathId, int targetId) {
        Message message = new Message(3, "RemoveDrive");
        message.controller = controller;
        message.argument0 = pathId;
        message.argument1 = targetId;
        this.commQueue.putMessage(message);
    }

    public void scanDrive() {
        this.commQueue.putMessage(new Message(3, "ScanDrive"));
    }

    public void removeDriveDirect(int controller, int pathId, int targetId) {
        try {
            this.connectionDaemon.removeDrive(controller, pathId, targetId);
        }
        catch (Exception e) {
            String errMsg = "CommLink:: removeDriveDirect: removeDrive failed";
            ErrorLog.put(e, errMsg);
            Utility.println(errMsg);
        }
    }

    public boolean scanDriveDirect() {
        boolean result = true;
        try {
            result = this.connectionDaemon.scanDrive();
        }
        catch (Exception e) {
            result = false;
            String errMsg = "CommLink:: scanDriveDirect: scanDrive failed";
            ErrorLog.put(e, errMsg);
            Utility.println(errMsg);
        }
        return result;
    }

    public String getLinkTime() {
        if (this.upDownStatus.equals("Up")) {
            GregorianCalendar c = new GregorianCalendar();
            Date newDate = c.getTime();
            int time = (int)(newDate.getTime() - this.timeStamp.getTime()) / 1000;
            return Utility.covertSecondsToHourMinuteSecond(time);
        }
        return " ";
    }

    public String getTransferred() {
        return Utility.byteCountLongToString(this.transferred);
    }

    public int getLinkState() {
        return this.linkState;
    }

    public String getUpDownStatus() {
        return this.upDownStatus;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void sendMessage(Message message) {
        this.commQueue.putMessage(message);
    }

    private void changeIpAddress(String newIpAddress) {
        this.ipAddress = newIpAddress;
        this.commManager.linkStatusChange(null, null);
    }

    private CommLinkChangeEvent getEvent() {
        CommLinkChangeEvent event = new CommLinkChangeEvent();
        event.local = this.local;
        event.ipAddress = this.ipAddress;
        event.controller = this.controller;
        return event;
    }

    private synchronized void preserveCurrentState() {
        this.prevLinkState = this.linkState;
        this.prevUpDownStatus = this.upDownStatus;
        this.prevIpAddress = this.ipAddress;
        this.prevController = this.controller;
        this.prevControllerLabel = this.controllerLabel;
        this.prevOfflineStatus = this.offlineStatus;
        this.prevOfflineDetails = this.offlineDetails;
    }

    private synchronized void recoverPreviousState() {
        this.linkState = this.prevLinkState;
        this.upDownStatus = this.prevUpDownStatus;
        this.ipAddress = this.prevIpAddress;
        this.controller = this.prevController;
        this.controllerLabel = this.prevControllerLabel;
        this.offlineStatus = this.prevOfflineStatus;
        this.offlineDetails = this.prevOfflineDetails;
    }

    class LinkThread
    extends Thread {
        Timer timer;
        LinkedList sentList = new LinkedList();
        LinkedList waitingToSendList = new LinkedList();
        final int MAX_OUTSTANDING_MESSAGES = 8;
        final String StartOfEnvelope = "<?xml version='1.0' ?><env:Envelope xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\" env:encodingStyle=\"http://www.w3.org/2003/05/soap-encoding\" si=\"http://www.siliconimage.com\">";

        public LinkThread() {
            this.timer = new Timer(3000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CommLink.this.commQueue.putMessage(new Message(3, "ExpiredTimer"));
                }
            });
        }

        public void run() {
            while (true) {
                if (!DatabaseManager.RemoteAccessAllowed && DatabaseManager.RemoteAccessWanted) {
                    this.processRemoteInput();
                    continue;
                }
                Message message = (Message)CommLink.this.commQueue.getMessage(true);
                if (message.mailSort == 3) {
                    this.processInternalMessage(message);
                    continue;
                }
                if (message.mailSort == 1) {
                    this.processOutgoingMessage(message);
                    continue;
                }
                if (message.mailSort == 2) {
                    this.processIncomingMessage(message);
                    continue;
                }
                Utility.println("CommLink: Invalid Mail Sort Indicator: " + message.mailSort);
            }
        }

        private void processRemoteInput() {
            CommLink.this.eventEmail = EventEmail.getEventEmail();
            EventEmail cfr_ignored_0 = CommLink.this.eventEmail;
            String resp = EventEmail.Receive(" ", "");
            if (resp != null) {
                this.processMessageResponse(resp, new Message());
            }
        }

        private void processInternalMessage(Message message) {
            if (message.request.equals("ExpiredTimer")) {
                this.processExpiredTimer();
            } else if (message.request.equals("DirectConnect")) {
                message.responseStatus = this.processOpenDirectConnect(message.controller);
            } else if (message.request.equals("OpenLink")) {
                message.responseStatus = this.processOpenLink(1, message.payload, message.controller, message.argument0);
            } else if (message.request.equals("CloseLink")) {
                Utility.println("was told to close link");
                this.processCloseLink(true);
            } else if (message.request.equals("ControllerCount")) {
                message.responseStatus = this.processGetControllerCount();
            } else if (message.request.equals("ResetLink")) {
                this.processInternalResetLink();
            } else if (message.request.equals("Reconnect")) {
                Utility.println("was told to reconnect link");
                this.processCloseLink(false);
                this.goToSleep(1000);
                if (CommLink.this.local && CommLink.this.ipAddress.equals("0.0.0.0")) {
                    this.processOpenDirectConnect(CommLink.this.controller);
                } else {
                    this.processOpenLink(2, CommLink.this.ipAddress, CommLink.this.controller, CommLink.this.serverPort);
                }
            } else if (message.request.equals("Goodbye")) {
                Utility.println("saying 'Goodbye' to Daemon");
                this.processGoodbyeDaemon();
            } else if (message.request.equals("RemoteDebug")) {
                Utility.println("was told to set 'RemoteDebug' " + (message.argument0 == 1 ? "on" : "off"));
                this.processRemoteDebug(message.argument0);
            } else if (message.request.equals("ScanDrive")) {
                this.processInternalScanDrive();
            } else if (message.request.equals("RemoveDrive")) {
                this.processInternalRemoveDrive(message);
            }
            if (message.callBackValid) {
                Utility.println("CommLink: processInternalMessage(): callBack is being invoked for request: " + message.request);
                message.callBackMailBox.putMessage(message);
            }
        }

        private void processOutgoingMessage(Message message) {
            this.waitingToSendList.add(message);
            if (this.waitingToSendList.size() == 1 && this.sentList.size() < 4) {
                message = (Message)this.waitingToSendList.remove(0);
                message.tag = Integer.toString(CommLink.this.tag++);
                message.ticker = 0;
                this.sentList.add(message);
                this.transmitMessage(message);
            }
        }

        private void processIncomingMessage(Message message) {
            int offset = message.payload.indexOf("<env:Header>");
            if (offset == -1) {
                Utility.println("CommLink: Invalid Message Received " + message.payload);
            } else {
                String resp = message.payload.substring(offset, message.payload.length());
                message.response = this.getBodyContents(resp);
                if (CommLink.this.linkState == 7) {
                    ++CommLink.this.transactions;
                    ++CommLink.this.messagesReceived;
                }
                CommLink.this.commManagerMailbox.putMessage(message);
            }
            if (this.waitingToSendList.size() > 0) {
                Message newMessage = (Message)this.waitingToSendList.remove(0);
                newMessage.tag = Integer.toString(CommLink.this.tag++);
                newMessage.ticker = 0;
                this.sentList.add(newMessage);
                this.transmitMessage(newMessage);
            }
        }

        private void processExpiredTimer() {
            boolean newMessagesReceived = CommLink.this.messagesReceived != CommLink.this.lastMessagesReceived;
            CommLink.this.messagesReceived = CommLink.this.lastMessagesReceived;
            if (CommLink.this.linkState == 7) {
                CommLink.this.transferred = CommLink.this.receivedByteCount + CommLink.this.transmittedByteCount;
            }
            if (this.sentList.size() > 0) {
                Message sentMessage = (Message)this.sentList.get(0);
                if (newMessagesReceived) {
                    sentMessage.ticker = 0;
                } else {
                    ScheduleTime c = new ScheduleTime();
                    Utility.println(c.toString() + ": inactive " + CommLink.this.lastTransactions + " ticker " + sentMessage.ticker);
                    if (++sentMessage.ticker > 5) {
                        Utility.println("Timed out response ");
                        if (CommLink.this.linkState == 4) {
                            Utility.println("reset the Ethernet port");
                            this.processInternalResetLink();
                        }
                    }
                }
            }
        }

        private void processInternalResetLink() {
            Utility.println("Resetting the link");
            int closingLinkState = CommLink.this.linkState;
            this.processCloseLink(false);
            this.goToSleep(1000);
            if (closingLinkState == 4) {
                this.processOpenLink(1, CommLink.this.newIpAddress, CommLink.this.newController, CommLink.this.newServerPort);
            } else {
                this.processOpenLink(2, CommLink.this.newIpAddress, CommLink.this.newController, CommLink.this.newServerPort);
            }
        }

        private void processGoodbyeDaemon() {
            Utility.println("Bye, Bye, Daemon");
            try {
                CommLink.this.connectionDaemon.goodbye();
            }
            catch (Exception e) {
                String errMsg = "CommLink:: processGoodbyeDaemon: 'Goodbye' failed";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
            }
        }

        private void processRemoteDebug(int state) {
            String stateStr = state == 1 ? "on" : "off";
            Utility.println("RemoteDebug to " + stateStr);
            try {
                if (state == 1) {
                    CommLink.this.connectionDaemon.turnRemoteDebugOn();
                } else {
                    CommLink.this.connectionDaemon.turnRemoteDebugOff();
                }
            }
            catch (Exception e) {
                String errMsg = "CommLink:: processRemoteDebug: 'RemoteDebug' " + stateStr + " failed";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
            }
        }

        private void processInternalScanDrive() {
            Utility.println("Scanning drive");
            try {
                CommLink.this.connectionDaemon.scanDrive();
            }
            catch (Exception e) {
                String errMsg = "CommLink:: processInternalScanDrive: scanDrive failed";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
            }
        }

        private void processInternalRemoveDrive(Message message) {
            Utility.println("Removing drive");
            int pathId = message.argument0;
            int targetId = message.argument1;
            try {
                CommLink.this.connectionDaemon.removeDrive(message.controller, pathId, targetId);
            }
            catch (Exception e) {
                String errMsg = "CommLink:: processInternalRemoveDrive: removeDrive failed";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
            }
        }

        private int processOpenLink(int state, String ipAddress, int controller, int serverPort) {
            String type = "connection...";
            CommLink.this.preserveCurrentState();
            CommLink.this.offlineStatus = state == 2 ? "Attempting to reopen " + CommLink.this.connectionType + " " + type : "Attempting to open " + CommLink.this.connectionType + " " + type;
            CommLink.this.offlineDetails = " ";
            CommLink.this.linkState = state;
            CommLink.this.newIpAddress = ipAddress;
            CommLink.this.newController = controller;
            CommLink.this.newServerPort = serverPort;
            CommLink.this.commManager.linkStatusChange(null, null);
            this.timer.start();
            int retStatus = this.processOpenEthernetLink(CommLink.this.newIpAddress, CommLink.this.newController, CommLink.this.newServerPort);
            if (retStatus != 0) {
                this.timer.stop();
                CommLink.this.recoverPreviousState();
            }
            return retStatus;
        }

        private void processCloseLink(boolean userSelected) {
            Message message;
            boolean supressNotification = userSelected && CommLink.this.upDownStatus.equals("Down");
            int previousLinkState = CommLink.this.linkState;
            CommLink.this.linkState = 0;
            Utility.println("closed link");
            this.timer.stop();
            CommLink.this.receivedByteCount = 0;
            CommLink.this.transmittedByteCount = 0;
            CommLink.this.transactions = 0;
            CommLink.this.transferred = 0L;
            CommLink.this.controllerLabel = "None";
            CommLink.this.upDownStatus = "Down";
            CommLink.this.offlineStatus = userSelected ? "Closed by user" : (previousLinkState == 7 ? "Connection lost" : (previousLinkState == 4 ? "Connection attempt Failed" : "Resetting link"));
            CommLink.this.offlineDetails = " ";
            if (supressNotification) {
                CommLink.this.commManager.linkStatusChange(null, "LinkDown");
            } else {
                CommLink.this.commManager.linkStatusChange(CommLink.this.getEvent(), "LinkDown");
            }
            while (this.sentList.size() > 0) {
                message = (Message)this.sentList.remove(0);
                message.status = 1;
                Utility.println("Return with error from sent list: \n  Action: " + message.action + "\n  Request: " + message.request + "\n  Controller: " + message.controller);
                CommLink.this.commManagerMailbox.putMessage(message);
            }
            while (this.waitingToSendList.size() > 0) {
                message = (Message)this.waitingToSendList.remove(0);
                message.status = 1;
                Utility.println("Return with error from wait list: \n  Action: " + message.action + "\n  Request: " + message.request + "\n  Controller: " + message.controller);
                CommLink.this.commManagerMailbox.putMessage(message);
            }
        }

        private int processOpenDirectConnect(int controller) {
            int returnStatus = 0;
            String openedLocal = "CommLink: successfully opened local connection";
            String failedLocal = "CommLink: failed to open local connection";
            CommLink.this.preserveCurrentState();
            boolean connectionOk = true;
            try {
                CommLink.this.connectionDaemon.directConnect();
            }
            catch (Exception e) {
                connectionOk = false;
                String errMsg = "CommLink:: processOpenDirectConnect: directConnect failed";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
                Utility.println(failedLocal);
            }
            if (connectionOk && this.validateConnection()) {
                ApplicationLog.put(openedLocal);
                Utility.println(openedLocal);
                CommLink.this.commManager.linkStatusChange(null, null);
                this.establishConnection(0, controller);
            } else {
                ApplicationLog.put(failedLocal);
                Utility.println(failedLocal);
                CommLink.this.recoverPreviousState();
                returnStatus = 2;
            }
            return returnStatus;
        }

        private int processOpenEthernetLink(String ipAddress, int controller, int serverPort) {
            int returnStatus = 0;
            String openedSocket = "CommLink: successfully opened socket to '";
            String failedSocket = "CommLink: failed to open socket to '";
            boolean connectionOk = true;
            try {
                CommLink.this.connectionDaemon.netConnect(ipAddress, serverPort);
            }
            catch (Exception e) {
                connectionOk = false;
                String errMsg = "CommLink:: processOpenEthernetLink: netConnect to " + ipAddress + " failed";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
                ApplicationLog.put(failedSocket + ipAddress + "'. Returned error: " + CommLink.this.lastError);
                Utility.println(failedSocket + ipAddress + "'. Returned error: " + CommLink.this.lastError);
                returnStatus = 1;
            }
            if (connectionOk) {
                if (this.validateConnection()) {
                    ApplicationLog.put(openedSocket + ipAddress + "'");
                    Utility.println(openedSocket + ipAddress + "'");
                    CommLink.this.offlineStatus = CommLink.this.linkState == 2 ? "Attempting to reconnect to controller..." : "Attempting connection to controller...";
                    CommLink.this.linkState = 4;
                    CommLink.this.offlineDetails = " ";
                    CommLink.this.commManager.linkStatusChange(null, null);
                    this.establishConnection(1, controller);
                } else {
                    returnStatus = 2;
                }
            }
            return returnStatus;
        }

        private boolean validateConnection() {
            String noControllers = "CommLink: no controllers found on the opened link";
            try {
                CommLink.this.newControllerCount = CommLink.this.connectionDaemon.getHandleCount();
            }
            catch (Exception e) {
                String errMsg = "CommLink:: validateConnection: getHandleCount failed";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
            }
            if (CommLink.this.newControllerCount == 0) {
                ApplicationLog.put(noControllers);
                Utility.println(noControllers);
                return false;
            }
            return true;
        }

        private void establishConnection(int newConnectionTypeIndex, int newController) {
            CommLink.this.upDownStatus = "Up";
            CommLink.this.linkState = 7;
            CommLink.this.controller = newController;
            CommLink.this.ipAddress = CommLink.this.newIpAddress;
            CommLink.this.serverPort = CommLink.this.newServerPort;
            CommLink.this.controllerCount = CommLink.this.newControllerCount;
            CommLink.this.controllerLabel = "Controller";
            CommLink.this.connectionTypeIndex = newConnectionTypeIndex;
            ApplicationLog.put("Link logged in to " + CommLink.this.controllerLabel + Integer.toString(CommLink.this.controller));
            Utility.println("Link logged in to " + CommLink.this.controllerLabel + Integer.toString(CommLink.this.controller));
            CommLink.this.enabled = true;
            CommLink.this.local = CommLink.this.connectionTypeIndex == 0;
            CommLink.this.connectionType = connectionTypeStrings[CommLink.this.connectionTypeIndex];
            if (CommLink.this.local) {
                CommLink.this.ipAddress = "0.0.0.0";
            }
            GregorianCalendar c = new GregorianCalendar();
            CommLink.this.timeStamp = c.getTime();
            CommLink.this.offlineStatus = "Connection Established with " + CommLink.this.controllerLabel;
            CommLink.this.offlineDetails = " ";
            Utility.println("CommLink: establishConnection(): invoking LinkUp linkStatusChange");
            CommLink.this.commManager.linkStatusChange(CommLink.this.getEvent(), "LinkUp");
        }

        private int processGetControllerCount() {
            Utility.println("CommLink: processGetControllerCount() host is connected: " + (CommLink.this.isConnected() ? "true" : "false"));
            Utility.println("CommLink: processGetControllerCount() entered");
            int status = 0;
            try {
                status = CommLink.this.connectionDaemon.getHandleCount();
            }
            catch (Exception e) {
                String errMsg = "CommLink:: processGetControllerCount: getHandleCount failed";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
            }
            return status;
        }

        private void transmitMessage(Message message) {
            String header = "<env:Header><si:Reference>" + message.tag + "</si:Reference>" + "<si:Direction>Request</si:Direction>" + "<si:Action>" + message.action + "</si:Action>" + "</env:Header>";
            String xmlMessage = "<?xml version='1.0' ?><env:Envelope xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\" env:encodingStyle=\"http://www.w3.org/2003/05/soap-encoding\" si=\"http://www.siliconimage.com\">" + header + "<env:Body>" + message.request + "</env:Body></env:Envelope>";
            try {
                if (CommLink.this.logFileName != null) {
                    int offset = xmlMessage.indexOf("<env:Body>");
                    ApplicationLog.put(CommLink.this.logFileName, "Sent: " + xmlMessage.substring(offset, xmlMessage.length()));
                }
            }
            catch (Exception e) {
                String errMsg = "CommLink:: transmitMessage: Error writing the " + CommLink.this.logFileName + " file";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
            }
            String resp = "";
            boolean exchangeOk = true;
            try {
                resp = CommLink.this.connectionDaemon.exchange(message.controller, xmlMessage);
            }
            catch (Exception e) {
                exchangeOk = false;
                String errMsg = "CommLink:: transmitMessage: exchange failed";
                ErrorLog.put(e, errMsg);
                Utility.println(errMsg);
                JOptionPane.showMessageDialog(null, "Error was reported from the transport layer:\n\n" + e.getMessage(), "Exchange Error", 0);
            }
            if (!exchangeOk) {
                Message newMessage = (Message)this.sentList.remove(0);
                return;
            }
            Message newMessage = (Message)this.sentList.remove(0);
            this.processMessageResponse(resp, newMessage);
        }

        private void processMessageResponse(String resp, Message message) {
            message.mailSort = 2;
            message.payload = resp;
            if (CommLink.this.logFileName != null) {
                int offset = resp.indexOf("<env:Body>");
                if (offset == -1) {
                    ApplicationLog.put(CommLink.this.logFileName, "Rcvd: **** ERROR: <env:Body> not found");
                    ApplicationLog.put(CommLink.this.logFileName, "Rcvd: " + resp);
                } else {
                    ApplicationLog.put(CommLink.this.logFileName, "Rcvd: " + resp.substring(offset, resp.length()));
                }
            }
            CommLink.this.commQueue.putMessage(message);
        }

        private String getBodyContents(String payload) {
            XmlData xmlData = new XmlData(payload);
            while (xmlData.getNextElement()) {
                if (!xmlData.element.equals("Body")) continue;
                xmlData.nest();
                return xmlData.elementStream;
            }
            return "";
        }

        private void goToSleep(int sleepDuration) {
            try {
                Thread.sleep(sleepDuration);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

