/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DeleteRaidGroupMemberBox
extends KDialog {
    private ExtendedMemberTable extendedMemberTable;
    private ArrayList extendedMemberList;
    private ExtendedMemberDescriptor extendedMember;
    private String extendedMemberFields = "Device,RAID Group,Member,Capacity,Starting LBN";
    private String extendedMemberStatus = "Online";
    private boolean onlyRedundant = true;
    private String[] raidGroupStatuses = new String[]{"Online"};
    private String[] sortDefaultFields = new String[]{"Device", "RAID Group", "Member"};

    public DeleteRaidGroupMemberBox(DatabaseManager databaseManager, String title) {
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildDeleteMemberTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.completeDialogInit(true);
    }

    protected void closeDialog() {
        Utility.println("closeDialog");
        this.extendedMemberTable.dispose();
        this.dispose();
    }

    protected JPanel buildDeleteMemberTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.extendedMemberTable = new ExtendedMemberTable(this.databaseManager, this.preferences, this.extendedMemberFields, this.raidGroupStatuses, this.extendedMemberStatus, this.sortDefaultFields, this.onlyRedundant, 12, "New");
        this.extendedMemberTable.setSelectionMode(2);
        tablePanel.add(new JLabel("Select Member(s) to Delete:"));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.add(this.extendedMemberTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        return tablePanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton deleteButton = new JButton("Delete");
        JButton cancelButton = new JButton("Cancel");
        deleteButton.setMnemonic(68);
        cancelButton.setMnemonic(67);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteRaidGroupMemberBox.this.sendRequest();
                DeleteRaidGroupMemberBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteRaidGroupMemberBox.this.closeDialog();
            }
        });
        buttonPanel.add(deleteButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    private void sendRequest() {
        ArrayList extendedMemberList = this.extendedMemberTable.getSelectedExtendedMembers();
        for (int count = 0; count < extendedMemberList.size(); ++count) {
            ExtendedMemberDescriptor extendedMemberDescriptor = (ExtendedMemberDescriptor)extendedMemberList.get(count);
            String request = "<si:Request><si:Type>DeleteRaidGroupMember</si:Type><si:RaidGroupParams><si:RaidGroup>" + extendedMemberDescriptor.raidGroup + "</si:RaidGroup>" + "<si:Member>" + extendedMemberDescriptor.member + "</si:Member>" + "</si:RaidGroupParams>" + "</si:Request>";
            Utility.println(request);
            AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

                public void handleMessage(Message message) {
                    DeleteRaidGroupMemberBox.this.databaseManager.refresh();
                    DeleteRaidGroupMemberBox.this.storageManagementUtility.clearWait();
                    XmlData xmlData = new XmlData(message.response);
                    if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                        new ErrorMessageBox(DeleteRaidGroupMemberBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Delete RAID Group Member Error");
                    }
                }
            };
            this.storageManagementUtility.setWait();
            this.commManager.sendMessage("Execute", request, responseMessageHandler);
        }
    }
}

