/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class CreateRaidGroupBox
extends KDialog
implements GlobalConstants {
    private JTextField raidGroupLabelField;
    private JComboBox chunkSizeComboBox;
    private JComboBox capacityComboBox;
    private JComboBox configurationComboBox;
    private JComboBox rebuildPriorityComboBox;
    private JComboBox raidGroupNumberComboBox;
    private JPanel raidGroupPanel;
    private JPanel segmentPanel;
    private JPanel buttonPanel;
    private JPanel parameterPanel;
    private JPanel advancedFeatures;
    private JPanel advancedPanel;
    private JPanel restorePanel;
    private JPanel parityPanel;
    private JPanel compoundPanel;
    private JRadioButton[] restoreMethodButton;
    private JRadioButton[] parityMethodButton;
    private SegmentTable segmentTable;
    private JButton createButton;
    private JPanel borderPanel;
    private String raidGroup;
    private boolean responseOk;
    private boolean improperShutdownBoxVisible;
    private String[] configurationStrings = GlobalConstants.configFullStrings;
    private String[] chunkSizeStrings = new String[]{"8 KB", "16 KB", "32 KB", "64 KB", "128 KB"};
    private int[] chunkSizes = new int[]{16, 32, 64, 128, 256};
    private String[] memberCountStrings = new String[]{"1", "2", "3", "4"};
    private String[] priorityStrings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private String segmentFields = "Path ID,Target ID,Capacity,Starting LBN";
    private String[] segmentStatuses = new String[]{"Available"};
    private String[] raidGroupStatuses = new String[]{"Online", "Reduced", "Offline"};
    private String[] availableRaidGroupNumbers = new String[128];
    private String newMetadataFormat = "New";
    private CapacityComboBoxPollingThread capacityComboBoxPollingThread;
    private RaidGroupUpdateListener raidGroupUpdateListener;
    private ConfigComboBoxListener configComboBoxListener;
    private LabelFieldCaretListener labelFieldCaretListener;

    public CreateRaidGroupBox(DatabaseManager databaseManager, String title) {
        this.beginDialogInit(databaseManager, title, true);
        this.raidGroupPanel = this.buildRaidGroupPanel();
        this.segmentPanel = this.buildSegmentTablePanel();
        this.buttonPanel = this.buildButtonPanel();
        this.getContentPane().add((Component)this.raidGroupPanel, "North");
        this.getContentPane().add((Component)this.segmentPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.configComboBoxListener = new ConfigComboBoxListener();
        this.labelFieldCaretListener = new LabelFieldCaretListener();
        this.raidGroupLabelField.addCaretListener(this.labelFieldCaretListener);
        this.raidGroupUpdateListener = new RaidGroupUpdateListener();
        databaseManager.raidGroupDatabase.addUpdateListener(this.raidGroupUpdateListener);
        databaseManager.deviceDatabase.addUpdateListener(this.raidGroupUpdateListener);
        this.availableRaidGroupNumbers = databaseManager.raidGroupDatabase.getAvailableRaidGroupNumbers();
        this.initializeParameterPanel(Integer.toString(databaseManager.maximumRaidGroups));
        this.capacityComboBox.getEditor().getEditorComponent().addKeyListener(new CapacityComboKeyListener());
        this.capacityComboBox.setEditable(this.capacityComboBox.isEnabled());
        this.capacityComboBoxPollingThread = new CapacityComboBoxPollingThread();
        this.capacityComboBoxPollingThread.start();
        this.storageManagementUtility.createdRaidGroupCount = 0;
        this.generateConfigComboBoxItems();
        this.completeDialogInit(true);
    }

    protected JPanel buildRaidGroupPanel() {
        this.parameterPanel = this.buildParametersPanel();
        this.advancedFeatures = this.buildAdvancedFeaturesPanel();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.parameterPanel);
        this.improperShutdownBoxVisible = false;
        return panel;
    }

    protected JPanel buildParametersPanel() {
        this.compoundPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        this.compoundPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.raidGroupLabelField = new LengthTextField("", 10, 8);
        this.raidGroupNumberComboBox = new JComboBox<String>(this.databaseManager.raidGroupDatabase.getAvailableRaidGroupNumbers());
        this.configurationComboBox = new JComboBox<String>(this.configurationStrings);
        this.chunkSizeComboBox = new JComboBox<String>(this.chunkSizeStrings);
        this.chunkSizeComboBox.setEnabled(false);
        this.capacityComboBox = new JComboBox<String>(GlobalConstants.capacityStrings);
        this.rebuildPriorityComboBox = new JComboBox<String>(this.priorityStrings);
        this.rebuildPriorityComboBox.setSelectedIndex(this.priorityStrings.length - 1);
        int gap = 30;
        Utility.addComponent(new JLabel("RAID Group Label:"), this.compoundPanel, layout, constraints, 0, 0, 0, 0, 8, 8, 0.0);
        Utility.addComponent(this.raidGroupLabelField, this.compoundPanel, layout, constraints, 1, 0, 0, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("RAID Group:"), this.compoundPanel, layout, constraints, 0, 1, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.raidGroupNumberComboBox, this.compoundPanel, layout, constraints, 1, 1, 9, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("Configuration:"), this.compoundPanel, layout, constraints, 0, 2, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.configurationComboBox, this.compoundPanel, layout, constraints, 1, 2, 9, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("Capacity:"), this.compoundPanel, layout, constraints, 0, 3, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.capacityComboBox, this.compoundPanel, layout, constraints, 1, 3, 9, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("Chunk Size:"), this.compoundPanel, layout, constraints, 0, 4, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.chunkSizeComboBox, this.compoundPanel, layout, constraints, 1, 4, 9, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("Rebuild Priority:"), this.compoundPanel, layout, constraints, 0, 5, 9, 9, 8, 8, 0.0);
        Utility.addComponent(this.rebuildPriorityComboBox, this.compoundPanel, layout, constraints, 1, 5, 9, 9, gap, 8, 1.0);
        Dimension dimension = this.configurationComboBox.getPreferredSize();
        this.raidGroupLabelField.setPreferredSize(dimension);
        this.raidGroupNumberComboBox.setPreferredSize(dimension);
        this.capacityComboBox.setPreferredSize(dimension);
        this.chunkSizeComboBox.setPreferredSize(dimension);
        this.configurationComboBox.setPreferredSize(dimension);
        this.rebuildPriorityComboBox.setPreferredSize(dimension);
        this.compoundPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
        this.borderPanel = new JPanel();
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.borderPanel.add(this.compoundPanel);
        this.raidGroupLabelField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateRaidGroupBox.this.updateButtonState();
            }
        });
        return this.borderPanel;
    }

    protected JPanel buildAdvancedFeaturesPanel() {
        this.initializeAdvancedPanel();
        this.restorePanel = this.buildRestoreMethodPanel();
        this.parityPanel = this.buildParityMethodPanel();
        this.advancedPanel = new JPanel();
        this.advancedPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Improper Shutdown Policy"));
        this.advancedPanel.setLayout(new BoxLayout(this.advancedPanel, 0));
        this.advancedPanel.add(this.restorePanel);
        this.advancedPanel.add(this.parityPanel);
        JPanel returnPanel = new JPanel();
        returnPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        returnPanel.add(this.advancedPanel);
        Dimension dimA = this.advancedPanel.getPreferredSize();
        Dimension dimB = this.compoundPanel.getPreferredSize();
        dimB.width = dimA.width;
        this.compoundPanel.setPreferredSize(dimB);
        return returnPanel;
    }

    private JPanel buildRestoreMethodPanel() {
        String[] radioButtonTextArray = new String[]{"On (Quick Restore)", "Off (Best I/O Perf)"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        radioPanel.setLayout(layout);
        for (int count = 0; count < this.restoreMethodButton.length; ++count) {
            this.restoreMethodButton[count] = new JRadioButton(radioButtonTextArray[count]);
            buttonGroup.add(this.restoreMethodButton[count]);
        }
        Utility.addComponent(this.restoreMethodButton[0], radioPanel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 0, 0, 0, 0, 0, 1.0);
        Utility.addComponent(this.restoreMethodButton[1], radioPanel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 1, 0, 0, 0, 0, 1.0);
        this.restoreMethodButton[0].setSelected(true);
        radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Check Pointing"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(radioPanel);
        return panel;
    }

    private JPanel buildParityMethodPanel() {
        String[] radioButtonTextArray = new String[]{"Return Dirty Data", "Offline Raid Grp"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        radioPanel.setLayout(layout);
        for (int count = 0; count < this.parityMethodButton.length; ++count) {
            this.parityMethodButton[count] = new JRadioButton(radioButtonTextArray[count]);
            buttonGroup.add(this.parityMethodButton[count]);
        }
        Utility.addComponent(this.parityMethodButton[0], radioPanel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 0, 0, 0, 0, 0, 1.0);
        Utility.addComponent(this.parityMethodButton[1], radioPanel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 1, 0, 0, 0, 0, 1.0);
        this.parityMethodButton[0].setSelected(true);
        radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parity"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(radioPanel);
        return panel;
    }

    private JPanel buildSegmentTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.segmentTable = new SegmentTable(this.databaseManager, null, this.segmentFields, this.segmentStatuses, 6, "New");
        tablePanel.add(this.segmentTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(8, 14, 4, 14));
        return tablePanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.createButton = new JButton("Create");
        JButton closeButton = new JButton("Close");
        this.createButton.setMnemonic(69);
        closeButton.setMnemonic(88);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateRaidGroupBox.this.sendCreateRequest();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateRaidGroupBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.createButton);
        buttonPanel.add(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    private void initializeParameterPanel(String raidToSkip) {
        int dimension = this.availableRaidGroupNumbers.length - 1;
        if (raidToSkip.equals(Integer.toString(this.databaseManager.maximumRaidGroups))) {
            ++dimension;
        }
        String[] newAvailableRaidGroupNumbers = new String[dimension];
        this.raidGroupNumberComboBox.removeAllItems();
        this.raidGroupLabelField.setText("");
        int index = 0;
        for (int i = 0; i < this.availableRaidGroupNumbers.length; ++i) {
            if (raidToSkip.equals(this.availableRaidGroupNumbers[i])) continue;
            this.raidGroupNumberComboBox.addItem(this.availableRaidGroupNumbers[i]);
            newAvailableRaidGroupNumbers[index++] = this.availableRaidGroupNumbers[i];
        }
        this.availableRaidGroupNumbers = newAvailableRaidGroupNumbers;
        if (this.availableRaidGroupNumbers.length == 0 || !this.databaseManager.deviceDatabase.qualifiedSegmentExists()) {
            this.setControlCompoundPanel(false);
        } else {
            this.updateConfigComboBoxAndSegmentTable();
            this.raidGroupLabelField.setText(this.databaseManager.raidGroupDatabase.generateRaidGroupLabel(this.raidGroupStatuses, this.availableRaidGroupNumbers));
        }
    }

    private void updateConfigComboBoxAndSegmentTable() {
        this.configurationComboBox.removeActionListener(this.configComboBoxListener);
        int numMultiMemRaidGrps = this.databaseManager.raidGroupDatabase.getMultiMemRaidGroupCount();
        if (numMultiMemRaidGrps >= this.databaseManager.controllerDatabase.getMaxMultiMemRaidGrps()) {
            this.configurationComboBox.setEnabled(false);
            this.configurationComboBox.removeAllItems();
            this.configurationComboBox.addItem(this.configurationStrings[0]);
            this.configurationComboBox.setSelectedIndex(0);
            if (this.databaseManager.deviceDatabase.qualifiedSegmentExists(this.newMetadataFormat, this.configurationStrings[0])) {
                this.configurationComboBox.setEnabled(true);
            }
        }
        this.configurationComboBox.addActionListener(this.configComboBoxListener);
        boolean control = true;
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        if (configuration.equals("Contiguous") || configuration.equals("Mirrored") || configuration.equals("Concatenated")) {
            control = false;
        }
        if (this.chunkSizeComboBox.isEnabled() != control) {
            this.chunkSizeComboBox.setEnabled(control);
        }
        if (configuration.equals("Contiguous")) {
            this.updateAdvancedPanel();
        }
        this.segmentTable.segmentTableQualifiedUpdate("New", configuration);
        control = true;
        if (configuration.equals("Concatenated")) {
            control = false;
        }
        if (this.capacityComboBox.isEnabled() != control) {
            this.capacityComboBox.setEnabled(control);
            this.capacityComboBox.setEditable(control);
        }
        control = true;
        if (configuration.equals("Contiguous") || configuration.equals("Concatenated") || configuration.equals("Striped")) {
            control = false;
        }
        if (this.rebuildPriorityComboBox.isEnabled() != control) {
            this.rebuildPriorityComboBox.setEnabled(control);
        }
        if (this.segmentTable.getSegmentList().size() == 0 || configuration.equals("Concatenated") && this.segmentTable.getSegmentList().size() < 2) {
            this.setControlCompoundPanel(false);
        }
    }

    private void updateAdvancedPanel() {
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        if (this.storageManagementUtility.advancedRaidOption) {
            if (configuration.equals("Contiguous") || configuration.equals("Striped") || configuration.equals("Concatenated")) {
                if (this.improperShutdownBoxVisible) {
                    this.getContentPane().removeAll();
                    this.raidGroupPanel.removeAll();
                    this.raidGroupPanel.add(this.parameterPanel);
                    this.getContentPane().add((Component)this.raidGroupPanel, "North");
                    this.getContentPane().add((Component)this.segmentPanel, "Center");
                    this.getContentPane().add((Component)this.buttonPanel, "South");
                    this.pack();
                    this.setResizable(false);
                    ((Component)this).setVisible(true);
                    this.improperShutdownBoxVisible = false;
                }
            } else {
                if (!this.improperShutdownBoxVisible) {
                    this.getContentPane().removeAll();
                    this.raidGroupPanel.removeAll();
                    this.raidGroupPanel.add(this.parameterPanel);
                    this.raidGroupPanel.add(this.advancedFeatures);
                    this.getContentPane().add((Component)this.raidGroupPanel, "North");
                    this.getContentPane().add((Component)this.segmentPanel, "Center");
                    this.getContentPane().add((Component)this.buttonPanel, "South");
                    this.pack();
                    this.setResizable(false);
                    ((Component)this).setVisible(true);
                    this.improperShutdownBoxVisible = true;
                }
                boolean control = false;
                if (configuration.equals("Parity RAID")) {
                    control = true;
                }
                Utility.enableContainer(this.parityPanel, control);
            }
        }
        String buttonText = "Create";
        if (configuration.equals("Concatenated")) {
            buttonText = "Next";
        }
        if (!this.createButton.getText().equals(buttonText)) {
            this.createButton.setText(buttonText);
        }
    }

    private void initializeAdvancedPanel() {
        this.restoreMethodButton = new JRadioButton[2];
        this.parityMethodButton = new JRadioButton[2];
    }

    private void setControlCompoundPanel(boolean control) {
        this.raidGroupLabelField.setEnabled(control);
        this.raidGroupNumberComboBox.setEnabled(control);
        this.configurationComboBox.setEnabled(control);
        this.chunkSizeComboBox.setEnabled(control);
        this.capacityComboBox.setEnabled(control);
        this.capacityComboBox.setEditable(control);
        this.rebuildPriorityComboBox.setEnabled(control);
        this.borderPanel.setEnabled(control);
        this.updateCreateButtonState(control);
    }

    private void sendCreateRequest() {
        int answer;
        String raidGroupLabel = this.raidGroupLabelField.getText();
        if (this.databaseManager.raidGroupDatabase.raidGroupLabelExists(this.raidGroupStatuses, raidGroupLabel)) {
            JOptionPane.showMessageDialog(null, "Identical Label already exists. Please change the entry.", "Duplicate Label Alert", 0);
            return;
        }
        String capacityBlocksStr = "";
        this.raidGroup = (String)this.raidGroupNumberComboBox.getSelectedItem();
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        String capacityString = ((String)this.capacityComboBox.getSelectedItem()).toUpperCase();
        ArrayList segmentList = this.segmentTable.getSelectedSegments();
        boolean passThruFound = false;
        for (int member = 0; member < segmentList.size(); ++member) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(member);
            DeviceDescriptor deviceDescriptor = this.databaseManager.deviceDatabase.getDevice(Integer.parseInt(segmentDescriptor.device));
            if (!deviceDescriptor.passThru) continue;
            passThruFound = true;
            break;
        }
        if (passThruFound && (answer = JOptionPane.showConfirmDialog(this, "WARNING: You have selected one or more PASS-THRU disks to be used for this RAID Group.\nUsing these disks will result in any existing data on the disks being overwritten.\nWould you like to continue?", "Pass-Thru Disks Warning", 0)) == 1) {
            return;
        }
        int chunkSize = this.chunkSizes[this.chunkSizeComboBox.getSelectedIndex()];
        Utility.println("chunk size in blocks " + chunkSize);
        String rebuildPriority = (String)this.rebuildPriorityComboBox.getSelectedItem();
        long capacityBlocks = 0L;
        if (configuration.equals("Concatenated")) {
            this.returnStatus = false;
            this.returnList = new ArrayList();
            new ConcatCapacityBox(this, this.databaseManager, "Specify RAID Group Capacity", segmentList);
            if (!this.returnStatus) {
                return;
            }
            capacityBlocksStr = capacityBlocksStr + Long.toString(this.returnValue);
        } else {
            int capacityIndex;
            boolean found = false;
            for (capacityIndex = 0; capacityIndex < GlobalConstants.capacityStrings.length; ++capacityIndex) {
                if (!capacityString.equals(GlobalConstants.capacityStrings[capacityIndex])) continue;
                found = true;
                break;
            }
            if (found) {
                capacityBlocks = GlobalConstants.capacities[capacityIndex];
            } else {
                int endIndex = capacityString.indexOf(" MB");
                if (endIndex == -1) {
                    endIndex = capacityString.indexOf(" GB");
                    if (endIndex == -1) {
                        endIndex = capacityString.indexOf(" TB");
                        if (endIndex == -1) {
                            endIndex = capacityString.length();
                            capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 2048L;
                        } else {
                            capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 0x80000000L;
                        }
                    } else {
                        capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 0x200000L;
                    }
                } else {
                    capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 2048L;
                }
            }
            long capacityPerMember = 0L;
            if (!capacityString.equals("MAX") && !capacityString.equals("HALF")) {
                int memberCount = segmentList.size();
                int stripeWidth = 1;
                if (configuration.equals("Parity RAID")) {
                    stripeWidth = memberCount - 1;
                } else if (configuration.equals("Mirrored")) {
                    stripeWidth = 1;
                } else if (configuration.equals("Mirrored Striped")) {
                    stripeWidth = memberCount / 2;
                } else if (configuration.equals("Striped")) {
                    stripeWidth = memberCount;
                } else if (configuration.equals("Contiguous")) {
                    stripeWidth = 1;
                }
                if (stripeWidth == 0) {
                    ++stripeWidth;
                }
                if (((capacityPerMember = capacityBlocks / (long)stripeWidth) & (long)(chunkSize - 1)) != 0L) {
                    capacityPerMember = capacityPerMember + (long)chunkSize & (long)(~(chunkSize - 1));
                }
                capacityBlocks = capacityPerMember * (long)stripeWidth;
                Utility.println("capacity per member " + capacityPerMember);
            }
            capacityBlocksStr = capacityBlocksStr + Long.toString(capacityBlocks);
        }
        Utility.println("capacity " + capacityString + " " + capacityBlocksStr);
        String memberInfo = "";
        boolean foundMemberCount = false;
        for (int member = 0; member < segmentList.size(); ++member) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(member);
            memberInfo = memberInfo + "<si:RaidMemberInfo><si:Device>" + segmentDescriptor.device + "</si:Device>" + "<si:StartingPlbn>" + segmentDescriptor.startingPlbn + "</si:StartingPlbn>";
            if (configuration.equals("Concatenated")) {
                memberInfo = memberInfo + "<si:Capacity>" + (String)this.returnList.get(member) + "</si:Capacity>";
            }
            memberInfo = memberInfo + "</si:RaidMemberInfo>";
        }
        String checkPointing = this.restoreMethodButton[0].isSelected() ? "Yes" : "No";
        String dirtyData = this.parityMethodButton[0].isSelected() ? "Yes" : "No";
        String request = "<si:Request><si:Type>CreateRaidGroup</si:Type><si:RaidGroupParams><si:Label>" + raidGroupLabel + "</si:Label>" + "<si:RaidGroup>" + this.raidGroup + "</si:RaidGroup>" + "<si:Configuration>" + configuration + "</si:Configuration>" + "<si:ChunkSize>" + chunkSize + "</si:ChunkSize>" + "<si:Capacity>" + capacityBlocksStr + "</si:Capacity>" + "<si:RebuildPriority>" + rebuildPriority + "</si:RebuildPriority>" + "<si:MetadataFormat>New</si:MetadataFormat>" + "<si:WriteCheckPointing>" + checkPointing + "</si:WriteCheckPointing>" + "<si:ReturnDirtyData>" + dirtyData + "</si:ReturnDirtyData>" + memberInfo + "</si:RaidGroupParams>" + "</si:Request>";
        Utility.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                CreateRaidGroupBox.this.databaseManager.refresh();
                CreateRaidGroupBox.this.setCursor(new Cursor(0));
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    CreateRaidGroupBox.this.responseOk = false;
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(CreateRaidGroupBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Create RAID Group Error");
                }
                CreateRaidGroupBox.this.borderPanel.setEnabled(true);
            }
        };
        this.responseOk = true;
        this.borderPanel.setEnabled(false);
        this.setCursor(new Cursor(3));
        this.databaseManager.commManager.sendMessage("Execute", request, responseMessageHandler);
        while (!this.borderPanel.isEnabled()) {
        }
        if (this.responseOk) {
            ++this.storageManagementUtility.createdRaidGroupCount;
            this.initializeParameterPanel(this.raidGroup);
            this.updateButtonState();
        }
        this.raidGroupLabelField.requestFocus();
    }

    private void generateConfigComboBoxItems() {
        this.configurationComboBox.removeActionListener(this.configComboBoxListener);
        String selectedItem = (String)this.configurationComboBox.getSelectedItem();
        this.configurationComboBox.setEnabled(false);
        this.configurationComboBox.removeAllItems();
        for (int index = 0; index < this.configurationStrings.length; ++index) {
            if (!this.databaseManager.deviceDatabase.qualifiedSegmentExists(this.newMetadataFormat, this.configurationStrings[index])) continue;
            this.configurationComboBox.addItem(this.configurationStrings[index]);
        }
        if (this.configurationComboBox.getItemCount() > 0) {
            for (int itemIndex = 0; itemIndex < this.configurationComboBox.getItemCount(); ++itemIndex) {
                if (!selectedItem.equals((String)this.configurationComboBox.getItemAt(itemIndex))) continue;
                this.configurationComboBox.setSelectedIndex(itemIndex);
                break;
            }
            this.configurationComboBox.setEnabled(true);
        } else {
            this.configurationComboBox.addItem(this.configurationStrings[0]);
            this.configurationComboBox.setSelectedIndex(0);
        }
        this.configurationComboBox.addActionListener(this.configComboBoxListener);
    }

    protected void closeDialog() {
        this.capacityComboBoxPollingThread = null;
        this.configurationComboBox.removeActionListener(this.configComboBoxListener);
        this.databaseManager.deviceDatabase.removeUpdateListener(this.raidGroupUpdateListener);
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.raidGroupUpdateListener);
        this.raidGroupLabelField.removeCaretListener(this.labelFieldCaretListener);
        this.segmentTable.dispose();
        this.dispose();
    }

    private void updateButtonState() {
        boolean control = true;
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        if (configuration.equals("Concatenated")) {
            if (this.segmentTable.getSelectedSegments().size() < 2) {
                control = false;
            }
        } else {
            if (!this.capacityComboBox.isEnabled()) {
                return;
            }
            if (this.raidGroupLabelField.getText().trim().length() == 0 || !this.checkCapacityValidity() || this.segmentTable.getSelectedSegments().size() == 0) {
                control = false;
            }
        }
        this.updateCreateButtonState(control);
    }

    private void updateCreateButtonState(boolean newState) {
        if (this.createButton.isEnabled() != newState) {
            this.createButton.setEnabled(newState);
        }
    }

    private boolean checkCapacityValidity() {
        String capacityString = this.capacityComboBox.getEditor().getItem().toString().toUpperCase().trim();
        if (capacityString.equals("MAX") || capacityString.equals("HALF")) {
            return true;
        }
        int endIndex = capacityString.indexOf(" MB");
        if (endIndex == -1 && (endIndex = capacityString.indexOf(" GB")) == -1 && (endIndex = capacityString.indexOf(" TB")) == -1) {
            return false;
        }
        String suffix = capacityString.substring(endIndex, capacityString.length());
        if (suffix.length() > 3) {
            return false;
        }
        String digits = capacityString.substring(0, endIndex).trim();
        int digitsLen = digits.length();
        if (digitsLen == 0 || digitsLen > 3) {
            return false;
        }
        for (int index = 0; index < digits.length(); ++index) {
            char digit = digits.charAt(index);
            if (digit >= '0' && digit <= '9') continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ String[] access$1002(CreateRaidGroupBox x0, String[] x1) {
        x0.availableRaidGroupNumbers = x1;
        return x1;
    }

    private class ConfigComboBoxListener
    implements ActionListener {
        private ConfigComboBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String configuration = (String)CreateRaidGroupBox.this.configurationComboBox.getSelectedItem();
            boolean control = true;
            if (configuration.equals("Contiguous") || configuration.equals("Mirrored") || configuration.equals("Concatenated")) {
                control = false;
            }
            if (CreateRaidGroupBox.this.chunkSizeComboBox.isEnabled() != control) {
                CreateRaidGroupBox.this.chunkSizeComboBox.setEnabled(control);
            }
            if (!configuration.equals("Concatenated")) {
                control = true;
            }
            if (CreateRaidGroupBox.this.capacityComboBox.isEnabled() != control) {
                CreateRaidGroupBox.this.capacityComboBox.setEnabled(control);
                CreateRaidGroupBox.this.capacityComboBox.setEditable(control);
            }
            CreateRaidGroupBox.this.updateAdvancedPanel();
            CreateRaidGroupBox.this.updateConfigComboBoxAndSegmentTable();
        }
    }

    private class CapacityComboBoxPollingThread
    extends Thread {
        private CapacityComboBoxPollingThread() {
        }

        public void run() {
            while (CreateRaidGroupBox.this.capacityComboBoxPollingThread != null) {
                try {
                    Thread.sleep(500L);
                    CreateRaidGroupBox.this.updateButtonState();
                }
                catch (Exception exception) {}
            }
        }
    }

    private class LabelFieldCaretListener
    implements CaretListener {
        private LabelFieldCaretListener() {
        }

        public void caretUpdate(CaretEvent e) {
            CreateRaidGroupBox.this.updateButtonState();
        }
    }

    private class CapacityComboKeyListener
    implements KeyListener {
        private CapacityComboKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        /*
         * Unable to fully structure code
         */
        public void keyTyped(KeyEvent e) {
            digit = e.getKeyChar();
            if (digit >= 'a' && digit <= 'z') {
                digit = (char)(digit - 32);
                e.setKeyChar(digit);
            }
            capacityString = CreateRaidGroupBox.access$1600(CreateRaidGroupBox.this).getEditor().getItem().toString().trim();
            if (digit == '\b') ** GOTO lbl-1000
            if (digit == '\t') ** GOTO lbl-1000
            if (digit == ' ') ** GOTO lbl-1000
            if (digit == '%') ** GOTO lbl-1000
            if (digit == '\'') ** GOTO lbl-1000
            if (digit == '\u00e2') ** GOTO lbl-1000
            if (digit != '\u00e2' && digit != 'G' && digit != 'T' && digit != 'B') {
                if (digit < '0' || digit > '9') {
                    e.consume();
                    return;
                }
            } else lbl-1000:
            // 7 sources

            {
                if (digit == 'G' && capacityString.indexOf("G") != -1) {
                    e.consume();
                    return;
                }
                if (digit == 'T' && capacityString.indexOf("T") != -1) {
                    e.consume();
                    return;
                }
                if (digit == 'B' && capacityString.indexOf("B") != -1) {
                    e.consume();
                    return;
                }
            }
            if (digit != '\b' && capacityString.length() > 5) {
                e.consume();
                return;
            }
        }
    }

    private class RaidGroupUpdateListener
    implements Runnable {
        private RaidGroupUpdateListener() {
        }

        public void run() {
            CreateRaidGroupBox.this.generateConfigComboBoxItems();
            CreateRaidGroupBox.access$1002(CreateRaidGroupBox.this, CreateRaidGroupBox.this.databaseManager.raidGroupDatabase.getAvailableRaidGroupNumbers());
            if (CreateRaidGroupBox.this.availableRaidGroupNumbers.length == 0 || !CreateRaidGroupBox.this.databaseManager.deviceDatabase.qualifiedSegmentExists()) {
                CreateRaidGroupBox.this.setControlCompoundPanel(false);
                CreateRaidGroupBox.this.segmentTable.segmentTableClearUpdate();
            } else {
                CreateRaidGroupBox.this.setControlCompoundPanel(true);
                CreateRaidGroupBox.this.updateConfigComboBoxAndSegmentTable();
                CreateRaidGroupBox.this.raidGroupLabelField.setText(CreateRaidGroupBox.this.databaseManager.raidGroupDatabase.generateRaidGroupLabel(CreateRaidGroupBox.this.raidGroupStatuses, CreateRaidGroupBox.this.availableRaidGroupNumbers));
            }
        }
    }
}

