/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class RaidGroupTable
extends JPanel
implements SortInterface,
GlobalConstants {
    DatabaseManager databaseManager;
    KTable raidGroupTable;
    RaidGroupManagerTableModel raidGroupTableModel;
    RaidGroupDatabaseUpdateListener raidGroupDatabaseUpdateListener;
    RaidGroupDatabase raidGroupDatabase;
    ArrayList raidGroupList;
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;
    JLabel raidGroupCountLabel;
    Preferences preferences;
    JScrollPane scrollPane;
    String raidGroupStatus = "All";
    String metadataFormat = "All";
    String validateState = "All";
    int listSelection = 2;
    protected ArrayList notifyList;

    public RaidGroupTable(DatabaseManager databaseManager, Preferences preferences, int rowCount) {
        this.databaseManager = databaseManager;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.preferences = preferences;
        this.initRaidGroupTable(rowCount);
    }

    public RaidGroupTable(DatabaseManager databaseManager, Preferences preferences, int rowCount, String metadataFormat) {
        this.databaseManager = databaseManager;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.preferences = preferences;
        this.metadataFormat = metadataFormat;
        this.initRaidGroupTable(rowCount);
    }

    public RaidGroupTable(DatabaseManager databaseManager, Preferences preferences, int rowCount, int listSelection) {
        this.databaseManager = databaseManager;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.preferences = preferences;
        this.listSelection = listSelection;
        this.initRaidGroupTable(rowCount);
    }

    public RaidGroupTable(DatabaseManager databaseManager, Preferences preferences, int rowCount, String raidGroupStatus, int listSelection) {
        this.databaseManager = databaseManager;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.preferences = preferences;
        this.raidGroupStatus = raidGroupStatus;
        this.listSelection = listSelection;
        this.initRaidGroupTable(rowCount);
    }

    public RaidGroupTable(DatabaseManager databaseManager, Preferences preferences, int rowCount, String validateState, String metadataFormat) {
        this.databaseManager = databaseManager;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.preferences = preferences;
        this.validateState = validateState;
        this.metadataFormat = metadataFormat;
        this.initRaidGroupTable(rowCount);
    }

    private void initRaidGroupTable(int rowCount) {
        this.loadPreferences();
        this.buildTable(rowCount);
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        this.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.raidGroupDatabaseUpdateListener.run();
        this.notifyList = new ArrayList();
        this.savePreferences();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void dispose() {
        this.removeAllUpdateListeners();
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            if ((Runnable)this.notifyList.get(index) != updateListener) continue;
            this.notifyList.remove(index);
            break;
        }
    }

    private synchronized void removeAllUpdateListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            this.notifyList.remove(index);
        }
    }

    private void notifyListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
        }
    }

    public ArrayList getSelectedRaidGroups() {
        ArrayList<RaidGroupDescriptor> selectedList = new ArrayList<RaidGroupDescriptor>();
        int[] selectedRows = this.raidGroupTable.getSelectedRows();
        for (int count = 0; count < selectedRows.length; ++count) {
            RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)this.raidGroupList.get(selectedRows[count]);
            selectedList.add(raidGroupDescriptor);
        }
        return selectedList;
    }

    private void savePreferences() {
        int index;
        String columns = "";
        TableColumnModel tableColumnModel = this.raidGroupTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        for (index = 0; index < 3; ++index) {
        }
    }

    private void loadPreferences() {
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = this.preferences.get("Table Columns", "RAID Group,Configuration,Status,Capacity");
            int startIndex = 0;
            do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (int index = 0; index < RaidGroupDescriptor.fieldNames.length; ++index) {
                    if (!RaidGroupDescriptor.fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            this.preferences.put("Table Columns", "RAID Group,Configuration,Status,Capacity");
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index = 0; index < fieldList.size(); ++index) {
            this.defaultColumns[index] = fieldList.get(index);
        }
        this.defaultColumns = new Object[3];
        String[] defaultFields2 = new String[]{"RAID Group", "Configuration", "Status"};
        this.defaultColumns = defaultFields2;
        this.sortedList = new ArrayList();
        this.sortDescriptors = new SortDescriptor[3];
        String[] defaultFields = new String[]{"RAID Group", "Configuration", "Status"};
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending"};
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            String fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
            String direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            for (int index = 0; index < RaidGroupDescriptor.fieldNames.length; ++index) {
                if (!RaidGroupDescriptor.fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    private JScrollPane buildTable(int rowCount) {
        this.raidGroupList = this.getRaidGroupList();
        this.raidGroupTableModel = new RaidGroupManagerTableModel();
        this.raidGroupTable = new KTable(this.raidGroupTableModel, rowCount);
        this.raidGroupTable.setSelectionMode(this.listSelection);
        this.raidGroupTable.getColumnModel().addColumnModelListener(new RaidGroupTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = RaidGroupTable.this.raidGroupTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = RaidGroupTable.this.raidGroupTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = RaidGroupTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = RaidGroupTable.this.raidGroupTableModel.getColumnName(column);
                    for (count = 0; count < RaidGroupDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(RaidGroupDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < RaidGroupDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        RaidGroupTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.raidGroupTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.raidGroupTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.raidGroupTable);
        this.scrollPane.getViewport().setBackground(this.raidGroupTable.getBackground());
        return this.scrollPane;
    }

    private synchronized ArrayList getRaidGroupList() {
        ArrayList newRaidGroupList = this.raidGroupStatus.equals("All") ? this.raidGroupDatabase.getRaidGroupList(false) : (this.validateState.equals("Minimum") ? this.raidGroupDatabase.getMinimumRaidGroupList(this.metadataFormat) : this.raidGroupDatabase.getRaidGroupList(this.raidGroupStatus));
        ArrayList<RaidGroupDescriptor> sortedList = new ArrayList<RaidGroupDescriptor>();
        for (int sourceIndex = 0; sourceIndex < newRaidGroupList.size(); ++sourceIndex) {
            RaidGroupDescriptor destRaidGroup;
            int result;
            int destIndex;
            RaidGroupDescriptor sourceRaidGroup = (RaidGroupDescriptor)newRaidGroupList.get(sourceIndex);
            if (!sourceRaidGroup.metadataFormat.equals(this.metadataFormat) && !this.metadataFormat.equals("All")) continue;
            for (destIndex = 0; destIndex < sortedList.size() && (result = sourceRaidGroup.compare(destRaidGroup = (RaidGroupDescriptor)sortedList.get(destIndex), this.sortDescriptors[0])) < 1 && (result != 0 || (result = sourceRaidGroup.compare(destRaidGroup, this.sortDescriptors[1])) < 1 && (result != 0 || sourceRaidGroup.compare(destRaidGroup, this.sortDescriptors[2]) < 1)); ++destIndex) {
            }
            sortedList.add(destIndex, sourceRaidGroup);
        }
        return sortedList;
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
    }

    class RaidGroupManagerTableModel
    extends KTableModel {
        public RaidGroupManagerTableModel() {
            this.setColumns(RaidGroupDescriptor.reducedFieldNames, RaidGroupDescriptor.reducedMaxFieldText);
        }

        public Object[] getDefaultColumns() {
            return RaidGroupTable.this.defaultColumns;
        }

        public void updateDisplay() {
            if (RaidGroupTable.this.raidGroupList.size() > 0) {
                this.fireTableRowsInserted(0, RaidGroupTable.this.raidGroupList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return RaidGroupTable.this.raidGroupList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= RaidGroupTable.this.raidGroupList.size()) {
                value = "";
            } else {
                RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)RaidGroupTable.this.raidGroupList.get(row);
                value = raidGroup.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }
    }

    class RaidGroupTableColumnModelListener
    implements TableColumnModelListener {
        RaidGroupTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            RaidGroupTable.this.savePreferences();
        }

        public void columnMoved(TableColumnModelEvent e) {
            RaidGroupTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = RaidGroupTable.this.raidGroupTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < RaidGroupTable.this.raidGroupTable.getRowCount()) {
                RaidGroupTable.this.raidGroupTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)RaidGroupTable.this.raidGroupList.get(mouseSelectedRow);
            }
            RaidGroupTable.this.notifyListeners();
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    protected class RaidGroupDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void terminate() {
            this.active = false;
        }

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newRaidGroupList = RaidGroupTable.this.getRaidGroupList();
            if (RaidGroupTable.this.raidGroupTable.getSelectedRow() == -1) {
                RaidGroupTable.this.raidGroupList = newRaidGroupList;
                RaidGroupTable.this.raidGroupTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = RaidGroupTable.this.raidGroupList.size();
                int oldTableSize = RaidGroupTable.this.raidGroupTableModel.getRowCount();
                int[] selectedRows = RaidGroupTable.this.raidGroupTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)RaidGroupTable.this.raidGroupList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newRaidGroupList.size(); ++newRow) {
                        RaidGroupDescriptor newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newRow);
                        if (newRaidGroupDescriptor.raidGroup == raidGroupDescriptor.raidGroup) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                RaidGroupTable.this.raidGroupList = newRaidGroupList;
                RaidGroupTable.this.raidGroupTable.clearSelection();
                RaidGroupTable.this.raidGroupTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    RaidGroupTable.this.raidGroupTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        }
    }
}

