/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class DeviceDescriptor
extends AbstractDescriptor {
    public int device;
    public int pathId;
    public int targetId;
    public boolean passThru;
    public String logicalDeviceType;
    public String status;
    public String serialNumber;
    public String modelNumber;
    public String firmwareRevision;
    public String capacity;
    public String updateCount;
    public ArrayList segmentArray;
    private String[] fieldNameLookUp = new String[]{"Device", "device", "PathId", "pathId", "TargetId", "targetId", "Status", "status", "Capacity", "capacity", "ModelNumber", "modelNumber", "FirmwareRevision", "firmwareRevision", "SerialNumber", "serialNumber", "LogicalDeviceType", "logicalDeviceType", "UpdateCount", "updateCount"};
    public static final String[] fieldNames = new String[]{"Device", "Path ID", "Target ID", "Status", "Capacity", "Model", "Version", "Serial Number"};
    public static final String[] maxFieldText = new String[]{"XDeviceX", "XPath IDX", "XTarget IDX", "XFormattingX", "XX Capacity XX", "X XXXXXXXXXXXXXXXX X", "XXXXVersionXXXX", "X XXXXXXXXXXXXXXXX X", "Unsupported"};

    DeviceDescriptor() {
        this.nuke();
    }

    DeviceDescriptor(int pathId, int targetId, int device) {
        this.nuke();
        this.device = device;
        this.pathId = pathId;
        this.targetId = targetId;
    }

    DeviceDescriptor(int pathId, int targetId) {
        this.nuke();
        this.pathId = pathId;
        this.targetId = targetId;
    }

    DeviceDescriptor(String data) {
        this.nuke();
        this.parseXml(data);
    }

    public void nuke() {
        this.device = -1;
        this.pathId = -1;
        this.targetId = -1;
        this.status = "Empty";
        this.serialNumber = "Unknown";
        this.modelNumber = "Unknown";
        this.firmwareRevision = "Unknown";
        this.capacity = "Unknown";
        this.updateCount = "Unknown";
        this.logicalDeviceType = "Unknown";
        this.passThru = false;
        this.segmentArray = new ArrayList();
    }

    public synchronized Object clone() {
        DeviceDescriptor newDescriptor = new DeviceDescriptor();
        newDescriptor.device = this.device;
        newDescriptor.pathId = this.pathId;
        newDescriptor.targetId = this.targetId;
        newDescriptor.status = this.status;
        newDescriptor.logicalDeviceType = this.logicalDeviceType;
        newDescriptor.passThru = this.passThru;
        newDescriptor.serialNumber = this.serialNumber;
        newDescriptor.modelNumber = this.modelNumber;
        newDescriptor.firmwareRevision = this.firmwareRevision;
        newDescriptor.capacity = this.capacity;
        newDescriptor.updateCount = this.updateCount;
        for (int index = 0; index < this.segmentArray.size(); ++index) {
            newDescriptor.segmentArray.add(((SegmentDescriptor)this.segmentArray.get(index)).clone());
        }
        return newDescriptor;
    }

    public synchronized void parseXml(String data) {
        XmlData xmlData = new XmlData(data);
        while (xmlData.getNextElement()) {
            if (this.parseElement(this.fieldNameLookUp, xmlData.element, xmlData.elementValue) || !xmlData.element.equals("SegmentInfo")) continue;
            this.segmentArray.add(new SegmentDescriptor(this.device, this.pathId, this.targetId, xmlData.elementValue));
        }
        this.serialNumber = this.serialNumber.trim();
        this.modelNumber = this.modelNumber.trim();
        this.firmwareRevision = this.firmwareRevision.trim();
        if (this.logicalDeviceType.equals("PassThru")) {
            this.passThru = true;
        }
    }

    public String getFieldValue(int fieldIndicator) {
        String value = "";
        if (fieldIndicator < this.fieldNameLookUp.length / 2) {
            value = value + this.getValue(this.fieldNameLookUp[fieldIndicator * 2 + 1]);
        }
        return value;
    }

    public int compare(DeviceDescriptor compareDevice, SortDescriptor sortDescriptor) {
        long result = this.compareFields(this.fieldNameLookUp[sortDescriptor.field * 2 + 1], compareDevice);
        if (sortDescriptor.direction == 1) {
            if (result >= 1L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
        if (result >= 1L) {
            return 1;
        }
        if (result == 0L) {
            return 0;
        }
        return -1;
    }

    public String getFieldName(int fieldIndicator) {
        return fieldNames[fieldIndicator];
    }
}

