/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class RebuildRaidGroupBox
extends KDialog {
    private ExtendedMemberTable extendedMemberTable;
    private SegmentTable segmentTable;
    private String reducedRaidGroup;
    private String failedMember;
    private JButton rebuildButton;
    private int memberTableSelection;
    private int segmentTableSelection;
    private String extendedMemberFields = "RAID Group,Member,Status,Capacity";
    private String extendedMemberStatus = "Failed";
    private String[] sortDefaultFields = new String[]{"RAID Group", "Member", "Capacity"};
    private String[] raidGroupStatuses = new String[]{"Reduced"};
    private String segmentFields = "Path ID,Target ID,Status,Capacity,Starting LBN";
    private String[] segmentStatuses = new String[]{"Available"};
    private boolean raidGroupSpecified = false;
    private String metadataFormat = "New";
    private RaidGroupDatabaseUpdateListener raidGroupDatabaseUpdateListener;
    private ExtendedMemberTableSelectionListener extendedMemberTableSelectionListener;

    public RebuildRaidGroupBox(DatabaseManager databaseManager, String title, String metadataFormat) {
        this.metadataFormat = metadataFormat;
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildExtendedMemberTablePanel(), "West");
        this.getContentPane().add((Component)this.buildSegmentTablePanel(), "East");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        databaseManager.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.completeDialogInit(true);
    }

    public RebuildRaidGroupBox(DatabaseManager databaseManager, String title, String reducedRaidGroup, String failedMember, String metadataFormat) {
        this.reducedRaidGroup = reducedRaidGroup;
        this.failedMember = failedMember;
        this.metadataFormat = metadataFormat;
        this.raidGroupSpecified = true;
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildSegmentTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        databaseManager.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.segmentTable.segmentTableSpareUpdate("New", Integer.parseInt(reducedRaidGroup));
        this.completeDialogInit(true);
    }

    protected void completeDialogInit(boolean autoCenter) {
        this.pack();
        Rectangle rectangle = Utility.getCenteredBounds(this);
        if (!autoCenter && this.systemPreferences.getBoolean("RememberLocations", true)) {
            rectangle.width = this.preferences.getInt("Frame Width", rectangle.width);
            rectangle.height = this.preferences.getInt("Frame Height", rectangle.height);
            rectangle.x = this.preferences.getInt("Frame X", rectangle.x);
            rectangle.y = this.preferences.getInt("Frame Y", rectangle.y);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RebuildRaidGroupBox.this.closeDialog();
            }
        });
        ((Component)this).setBounds(rectangle);
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    protected void closeDialog() {
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.raidGroupDatabaseUpdateListener);
        if (!this.raidGroupSpecified) {
            this.extendedMemberTable.removeUpdateListener(this.extendedMemberTableSelectionListener);
            this.extendedMemberTable.dispose();
        }
        this.segmentTable.dispose();
        this.dispose();
    }

    protected JPanel buildExtendedMemberTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.extendedMemberTable = new ExtendedMemberTable(this.databaseManager, this.preferences, this.extendedMemberFields, this.raidGroupStatuses, this.extendedMemberStatus, this.sortDefaultFields, 12, this.metadataFormat);
        this.memberTableSelection = 0;
        tablePanel.add(new JLabel("Select a Member to Rebuild:"));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.add(this.extendedMemberTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        this.extendedMemberTableSelectionListener = new ExtendedMemberTableSelectionListener();
        this.extendedMemberTable.addUpdateListener(this.extendedMemberTableSelectionListener);
        return tablePanel;
    }

    protected JPanel buildSegmentTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.segmentTable = new SegmentTable(this.databaseManager, this.preferences, this.segmentFields, this.segmentStatuses, 12, this.metadataFormat);
        this.segmentTableSelection = 0;
        tablePanel.add(new JLabel("Select a Replacement Segment:"));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.add(this.segmentTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        return tablePanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.rebuildButton = new JButton("Rebuild");
        JButton cancelButton = new JButton("Cancel");
        this.rebuildButton.setMnemonic(82);
        cancelButton.setMnemonic(67);
        this.rebuildButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (RebuildRaidGroupBox.this.raidGroupSpecified) {
                    RebuildRaidGroupBox.this.sendRebuildRequest(RebuildRaidGroupBox.this.reducedRaidGroup, RebuildRaidGroupBox.this.failedMember);
                    RebuildRaidGroupBox.this.closeDialog();
                } else {
                    RebuildRaidGroupBox.this.sendRebuildRequest();
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RebuildRaidGroupBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.rebuildButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    public void sendRebuildRequest(String selectedRaidGroup, String failedMember) {
        ArrayList segmentSelectedList = this.segmentTable.getSelectedSegments();
        SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentSelectedList.get(0);
        this.segmentTableSelection = this.segmentTable.getSelectedRow();
        this.sendRebuildRequest(selectedRaidGroup, failedMember, segmentDescriptor.device, segmentDescriptor.startingPlbn);
    }

    private void sendRebuildRequest() {
        ArrayList extendedMemberSelectedList = this.extendedMemberTable.getSelectedExtendedMembers();
        ArrayList segmentSelectedList = this.segmentTable.getSelectedSegments();
        this.memberTableSelection = this.extendedMemberTable.getSelectedRow();
        this.segmentTableSelection = this.segmentTable.getSelectedRow();
        ExtendedMemberDescriptor extendedMemberDescriptor = (ExtendedMemberDescriptor)extendedMemberSelectedList.get(0);
        SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentSelectedList.get(0);
        this.sendRebuildRequest(extendedMemberDescriptor.raidGroup, extendedMemberDescriptor.member, segmentDescriptor.device, segmentDescriptor.startingPlbn);
    }

    private void sendRebuildRequest(String raidGroup, String member, String device, String startingPlbn) {
        int answer;
        DeviceDescriptor deviceDescriptor = this.databaseManager.deviceDatabase.getDevice(Integer.parseInt(device));
        if (deviceDescriptor.passThru && (answer = JOptionPane.showConfirmDialog(this, "WARNING: You have selected a PASS-THRU disk to be used for the rebuild operation.\nUsing this disk will result in any existing data on the disk being overwritten.\nWould you like to continue?", "Pass-Thru Disk Warning", 0)) == 1) {
            return;
        }
        String request = "<si:Request><si:Type>RebuildRaidGroup</si:Type><si:RaidGroup>" + raidGroup + "</si:RaidGroup>" + "<si:Member>" + member + "</si:Member>" + "<si:ReplacementMemberInfo>" + "<si:Device>" + device + "</si:Device>" + "<si:StartingPlbn>" + startingPlbn + "</si:StartingPlbn>" + "</si:ReplacementMemberInfo>" + "</si:Request>";
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                RebuildRaidGroupBox.this.storageManagementUtility.clearWait();
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(RebuildRaidGroupBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Rebuild RAID Group Error");
                }
                RebuildRaidGroupBox.this.databaseManager.refresh();
            }
        };
        this.storageManagementUtility.setWait();
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    protected class RaidGroupDatabaseUpdateListener
    implements Runnable {
        protected RaidGroupDatabaseUpdateListener() {
        }

        public void run() {
            int raidGroup = 0;
            if (!RebuildRaidGroupBox.this.raidGroupSpecified) {
                ArrayList newExtendedMemberList = RebuildRaidGroupBox.this.extendedMemberTable.getExtendedMemberList();
                int memberListSize = newExtendedMemberList.size();
                if (memberListSize == 0) {
                    RebuildRaidGroupBox.this.rebuildButton.setEnabled(false);
                } else {
                    if (RebuildRaidGroupBox.this.memberTableSelection >= memberListSize) {
                        RebuildRaidGroupBox.this.memberTableSelection = memberListSize - 1;
                    }
                    RebuildRaidGroupBox.this.extendedMemberTable.addRowSelectionInterval(RebuildRaidGroupBox.this.memberTableSelection, RebuildRaidGroupBox.this.memberTableSelection);
                    ExtendedMemberDescriptor memberDescriptor = RebuildRaidGroupBox.this.extendedMemberTable.getExtendedMemberDescriptor(RebuildRaidGroupBox.this.memberTableSelection);
                    raidGroup = Integer.parseInt(memberDescriptor.raidGroup);
                }
            } else {
                raidGroup = Integer.parseInt(RebuildRaidGroupBox.this.reducedRaidGroup);
            }
            ArrayList segmentList = RebuildRaidGroupBox.this.segmentTable.getSegmentList();
            int segmentListSize = segmentList.size();
            if (segmentListSize == 0) {
                RebuildRaidGroupBox.this.rebuildButton.setEnabled(false);
            }
            if (RebuildRaidGroupBox.this.rebuildButton.isEnabled()) {
                RebuildRaidGroupBox.this.segmentTable.segmentTableSpareUpdate("New", raidGroup);
                segmentList = RebuildRaidGroupBox.this.segmentTable.getSegmentList();
                segmentListSize = segmentList.size();
                if (RebuildRaidGroupBox.this.segmentTableSelection >= segmentListSize) {
                    RebuildRaidGroupBox.this.segmentTableSelection = segmentListSize - 1;
                }
                RebuildRaidGroupBox.this.segmentTable.addRowSelectionInterval(RebuildRaidGroupBox.this.segmentTableSelection, RebuildRaidGroupBox.this.segmentTableSelection);
            }
        }
    }

    protected class ExtendedMemberTableSelectionListener
    implements Runnable {
        protected ExtendedMemberTableSelectionListener() {
        }

        public void run() {
            RebuildRaidGroupBox.this.memberTableSelection = RebuildRaidGroupBox.this.extendedMemberTable.getSelectedRow();
            if (RebuildRaidGroupBox.this.memberTableSelection != -1) {
                ExtendedMemberDescriptor memberDescriptor = RebuildRaidGroupBox.this.extendedMemberTable.getExtendedMemberDescriptor(RebuildRaidGroupBox.this.memberTableSelection);
                int raidGroup = Integer.parseInt(memberDescriptor.raidGroup);
                RebuildRaidGroupBox.this.segmentTable.segmentTableSpareUpdate("New", raidGroup);
            }
        }
    }
}

