#!/bin/sh
#set -x

backup () {
  local file
  file="$1"
  if [ -f "$file" ] ;then
    #echo "Backup $file ..."
    if [ ! -f "$file.shipped" ] ;then
      mv -f "$file" "$file.shipped"
    fi
    cp -f "$file.shipped" "$file"
  fi
  if [ -f "$file.shipped" ] ;then
    cp -f "$file.shipped" "$file"
  fi
}

FLOPPY=`dirname $0`
FLOPPY=`( cd $FLOPPY; pwd )`

#CTLR="3114"
CTLR="3124"
#CTLR="3132"
#EXT=""
#EXT="r"
EXT="r5"

# it should be none only if you need X11 
# to install via Yast (Graphical Interface)
# DISK="--none--"
DISK=""
#####################################
# find where we are and where we go #
#####################################
if [ ! -d /media/floppy ] ;then
  if [ ! -d /mnt/sysimage ] ;then
    mkdir -p /mnt/sysimage
  fi
  if [ ! -d /boot/grub -a ! -f /etc/lilo.conf ] ;then
    mount /dev/sda2 /mnt/sysimage
    if [ $? == 0 ] ;then
      if [ -d /mnt/sysimage/boot ] ;then
        if [ ! -d /mnt/sysimage/boot/grub ] ;then
          mount /dev/sda1 /mnt/sysimage/boot
        fi
      fi
    fi
  fi
fi
if [ -d /mnt/sysimage/etc ] ;then
  DISK="/mnt/sysimage"
elif [ -d /etc/X11 ] ;then
  DISK=""
fi
if [ "$DISK" == "--none--" ] ;then
  echo "Unknown system layout"
  exit 9
fi
#echo -n ",,, - "; read a

#if [ -d /var/adm/mount/linux/suse ] ;then
  ############################################
  # we have been copied to somewhere in /tmp #
  # by YaST control center's Load Vendor CD  #
  ############################################
  #FLOPPY="/var/adm/mount"
#else
  #FLOPPY=`dirname $0`
#fi

##########################
# select the driver name #
##########################
uname -r > /tmp/b
b=`cat /tmp/b | grep "2.6"`
echo "/proc/pci may not exist in some configurations"

c=`cat /proc/pci | grep ":$CTLR "`
a=`ls /proc/scsi | grep "sii$CTLR"`
a=$a$c

# 3112 Section (Open Source Collision)
if [ "$a" == "" ] ;then
  sii="sii3112"
  echo "Moving Open Source Libata SATA modules to /tmp (not needed)"
#read nothing;
#SuSE
#Redhat may require even more steps
  #mv $DISK/lib/modules/2.6*/kernel/drivers/scsi/libata.ko /tmp/libata.ko
  #mv $DISK/lib/modules/2.6*smp/kernel/drivers/scsi/libata.ko /tmp/libata_smp.ko
  #mv $DISK/lib/modules/2.6*bigsmp/kernel/drivers/scsi/libata.ko /tmp/libata_smp.ko
  #echo "$DISK/lib/modules/2.6/kernel/drivers/scsi/libata.ko /tmp/libata.ko"
  mv $DISK/lib/modules/2.6*/kernel/drivers/scsi/sata_sil.ko /tmp/sata_sil.ko
  mv $DISK/lib/modules/2.6*smp/kernel/drivers/scsi/sata_sil.ko /tmp/sata_sil_smp.ko
  mv $DISK/lib/modules/2.6*bigsmp/kernel/drivers/scsi/sata_sil.ko /tmp/sata_sil_smp.ko
  echo "$DISK/lib/modules/2.6/kernel/drivers/scsi/sata_sil.ko /tmp/sata_sil.ko"

  echo "some modules may not be present.."

  if [ "$b" == "" ] ;then
     siio="$sii.o"
  else
     siio="$sii.ko"
  fi
else
  sii="si$CTLR$EXT"
  if [ "$b" == "" ] ;then
     siio="$sii.o"
  else
     siio="$sii.ko"
  fi
fi
echo "SiI driver file is $siio"

############################
# copy driver to boot disk #
#   update kernel files    #
############################

#handle new RH format
if [ -f "$FLOPPY/modules.cgz" ] ;then
  img=".img"
  if [ -d "/tmp/cpio" ] ;then
    echo "/tmp/cpio detected"
  else
    mkdir /tmp/cpio
  fi

  cd /tmp/cpio
  echo "Unzipping driver package."
  cat "$FLOPPY/modules.cgz" | gunzip | cpio -iH crc
fi

if [ -f "$FLOPPY/rhdd" ] ;then
  Arch="x86_64"
else
  Arch=""
fi

uname -a > /tmp/c
c=`cat /tmp/c | grep "x86_64"`

if [ -f $DISK/etc/SuSE-release ] ;then
    dist="SUSE"
elif [ -f $DISK/etc/redhat-release ] ;then
   dist="RHEL"
else
   dist=""
fi

echo "Copying driver files to module libraries"
dirs=`( cd $DISK/lib/modules; echo * )`
for dir in $dirs ;do
  if [ -d $DISK/lib/modules/$dir/kernel ] ;then
    if [ $dir == "2.6.5-7.191-bigsmp" ] ;then
      src="i386-sles9bigsmp"
    elif [ $dir == "2.6.5-7.191-smp" ] ;then
        src="i386-sles9smp"
    elif [ $dir == "2.6.5-7.191-default" ] ;then
        src="i386-sles9"
    elif [ $dir == "2.6.5-7.244-bigsmp" ] ;then
        src="i386-sles9bigsmp"
    elif [ $dir == "2.6.5-7.244-smp" ] ;then
        src="i386-sles9smp"
    elif [ $dir == "2.6.5-7.244-default" ] ;then
        src="i386-sles9"
	elif [ $dir == "2.4.21-99-smp4G" ] ;then
		src="i386-9.0SMP4G"
	elif [ $dir == "2.4.21-99-smp" ] ;then
		src="i386-9.0SMP"
	elif [ $dir == "2.4.21-99-athlon" ] ;then
		src="i386-9.0athlon"
	elif [ $dir == "2.4.21-102-default" ] ;then
		src="x86_64-9.0"
	elif [ $dir == "2.4.21-102-smp" ] ;then
		src="x86_64-9.0SMP"
	elif [ $dir == "2.4.19-SMP" ] ;then
		src="x86_64-ul1smp"
	elif [ $dir == "2.6.5-7.69-smp" ] ;then
		src="x86_64-sles9smp"
	elif [ $dir == "2.6.5-7.97-bigsmp" ] ;then
		src="i386-sles9bigsmp"
	elif [ $dir == "2.6.5-7.97-smp" ] ;then
		src="i386-sles9smp"
	elif [ $dir == "2.6.5-7.97-default" ] ;then
		src="i386-sles9"
	elif [ $dir == "2.6.5-7.139-bigsmp" ] ;then
		src="i386-sles9bigsmp"
	elif [ $dir == "2.6.5-7.139-smp" ] ;then
		src="i386-sles9smp"
	elif [ $dir == "2.6.5-7.139-default" ] ;then
		src="i386-sles9"
	elif [ $dir == "2.6.8-24-default" ] ;then
		src="i386-sles9"
	elif [ $dir == "2.6.8-24-bigsmp" ] ;then
		src="i386-sles9bigsmp"
	elif [ $dir == "2.6.8-24-smp" ] ;then
		src="i386-sles9smp"
	elif [ $dir == "2.6.11.4-20a-bigsmp" ] ;then
		src="i386-sles9bigsmp"
	elif [ $dir == "2.6.11.4-20a-default" ] ;then
		src="i386-sles9"
	elif [ $dir == "2.6.11.4-20a-smp" ] ;then
		src="i386-sles9smp"
	elif [ $dir == "2.6.11.4-20a-xen" ] ;then
		src="i386-sles9xen"
	elif [ $dir == "2.6.5-7.79-smp" ] ;then
		src="i386-sles9smp"
	elif [ $dir == "2.6.5-7.79-bigsmp" ] ;then
		src="i386-sles9bigsmp"
	elif [ $dir == "2.4.21-143-smp" ] ;then
		src="i386-ul1smp"
	elif [ $dir == "2.4.19-64GB-SMP" ] ;then
		src="i386-ul164GB-SMP"
    elif [ $dir == "2.6.9-22.EL" ] ;then
      src=$dir
    elif [ $dir == "2.6.9-22.ELhugemem" ] ;then
      src=$dir
    elif [ $dir == "2.6.9-22.ELsmp" ] ;then
      src=$dir
    elif [ $dir == "2.6.9-34.EL" ] ;then
      src=$dir
    elif [ $dir == "2.6.9-34.ELhugemem" ] ;then
      src=$dir
    elif [ $dir == "2.6.9-34.ELsmp" ] ;then
      src=$dir
    elif [ $dir == "2.6.11-1.1369_FC4" ] ;then
      src=$dir
    elif [ $dir == "2.6.11-1.1369_FC4smp" ] ;then
      src=$dir
    else
      src=""
      echo "  No support for modules in library $dir."
    fi

    ############################
    # copy driver to boot disk #
    ############################
    if [ "$src" != "" ] ;then
      if [ "$dist" == "SUSE" ] ;then
        objsrc="$FLOPPY/linux/suse/$src/modules/$siio"
      elif [ "$dist" == "RHEL" ] ;then
        objsrc="/tmp/cpio/$src/$siio"
      fi
      if [ "$objsrc" != "" ] ;then
        echo "  Copying file to $dir"
        cp -f $objsrc $DISK/lib/modules/$dir/kernel/drivers/scsi
      else
        echo "Distribution not defined"
      fi

      modules_dep="$DISK/lib/modules/$dir/modules.dep"

      ##########################################
      ## backup the origional modules.dep file #
      ##########################################
      backup $modules_dep
    
      #####################################################
      # add the Sii driver to the modules dependency file #
      #####################################################
      a=`grep $siio $modules_dep`
      if [ "$a" == "" ] ;then
        echo "  Updating $modules_dep ..."
        sii_dir="/lib/modules/$dir/kernel/drivers/scsi"
        if [ "$b" == "" ] ;then
           echo "$sii_dir/$siio: $sii_dir/scsi_mod.o " >>$modules_dep
        else
           echo "$sii_dir/$siio: $sii_dir/scsi_mod.ko" >>$modules_dep
        fi
      fi
    fi
  fi
done

if [ "$dist" == "SUSE" ] ;then
  #####################################
  # backup and modify the kernel file #
  #####################################
  backup $DISK/etc/sysconfig/kernel
  a=`grep $sii $DISK/etc/sysconfig/kernel`
  if [ "$a" == "" ] ;then
    sed -f $FLOPPY/addsii.sed $DISK/etc/sysconfig/kernel > /tmp/kertmp
    mv -f /tmp/kertmp $DISK/etc/sysconfig/kernel
  fi
  #echo -n ",,, - "; read a
fi
#echo -n ",,, - "; read a

#########################################
# backup and modify the bootloader file #
#########################################
# this will try to force LILO #
# which is not needed anymore #
###############################
#backup /etc/sysconfig/bootloader
#sed -f $FLOPPY/add2sii.sed /etc/sysconfig/bootloader > /tmp/kertmp2
#mv -f /tmp/kertmp2 /etc/sysconfig/bootloader

#######################################
# backup and generate the initrd file #
#######################################
uname -r > /tmp/v
v=`cat /tmp/v | grep "2.6"`
#special handling for 2.6 kernels

echo "Updating initrd boot images."
if [ "$dist" == "RHEL" ] ;then
  ##################
  # Redhat version #
  ##################
  dirs=`( cd $DISK/lib/modules; echo * )`
  for dir in $dirs ;do
    if [ -d $DISK/lib/modules/$dir/kernel ] ;then
      initrd="initrd-$dir$img"
      sysmap="System.map-$dir"
      backup $DISK/boot/$initrd
      backup $DISK/boot/$sysmap
      #echo -n ",,, - "; read a
      rm -f $DISK/boot/$initrd
      if [ "$DISK" == "" ] ;then
        disk="/"
      else
        disk="$DISK"
      fi
      if [ "$v" == "" ] ;then
        # 2.4 kernels
        $DISK/usr/sbin/chroot $disk /sbin/mkinitrd --with=scsi_mod --with=$sii /boot/$initrd $dir
      else
         # x86_64 echo "$DISK/usr/sbin/chroot $disk /sbin/mkinitrd --omit-scsi-modules --with=scsi_mod --with=sd_mod --with=$sii /boot/$initrd $dir"
         echo "  Making initrd for $dir"
         $DISK/usr/sbin/chroot $disk /sbin/mkinitrd --omit-scsi-modules --with=scsi_mod --with=sd_mod --with=sr_mod --with=$sii /boot/$initrd $dir
  	 #read nothing
      fi
    fi
  done
elif [ "$dist" == "SUSE" ] ;then
  ################
  # SuSE version #
  ################
  ( cd /boot; /sbin/mkinitrd )
else
  echo "Unknown Distribution:  Boot Images not updated"
fi

##########################
# update the boot loader #
##########################
#echo "The next section updates the bootloader"
#echo "This section is not normally required"
#echo "Modify the script if you need it"
#echo "DONE"

#cp -f $FLOPPY/special_update_bootloader.sh /tmp
#chmod 775 /tmp/special_update_bootloader.sh
#$FLOPPY/special_update_bootloader.sh
