/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ExtendedMemberTable
extends JPanel
implements SortInterface,
GlobalConstants {
    KTable extendedMemberTable;
    ExtendedMemberTableModel extendedMemberTableModel;
    RaidGroupDatabaseUpdateListener raidGroupDatabaseUpdateListener;
    RaidGroupDatabase raidGroupDatabase;
    DatabaseManager databaseManager;
    AbstractMessageHandler messageHandler;
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;
    ArrayList extendedMemberList;
    JScrollPane scrollPane;
    Preferences preferences;
    String memberFields;
    String memberStatus;
    String[] raidGroupStatuses;
    String[] sortDefaultFields;
    boolean onlyRedundant;
    String metadataFormat;
    protected ArrayList notifyList;

    public ExtendedMemberTable(DatabaseManager databaseManager, Preferences preferences, String memberFields, String[] raidGroupStatuses, String memberStatus, String[] sortDefaultFields, int rowCount, String metadataFormat) {
        this.preferences = preferences;
        this.databaseManager = databaseManager;
        this.memberFields = memberFields;
        this.raidGroupStatuses = raidGroupStatuses;
        this.sortDefaultFields = sortDefaultFields;
        this.memberStatus = memberStatus;
        this.onlyRedundant = false;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.metadataFormat = metadataFormat;
        this.loadPreferences();
        this.buildTable(rowCount);
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        this.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
    }

    public ExtendedMemberTable(DatabaseManager databaseManager, Preferences preferences, String memberFields, String[] raidGroupStatuses, String memberStatus, String[] sortDefaultFields, boolean onlyRedundant, int rowCount, String metadataFormat) {
        this.preferences = preferences;
        this.databaseManager = databaseManager;
        this.memberFields = memberFields;
        this.raidGroupStatuses = raidGroupStatuses;
        this.sortDefaultFields = sortDefaultFields;
        this.memberStatus = memberStatus;
        this.onlyRedundant = onlyRedundant;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.metadataFormat = metadataFormat;
        this.loadPreferences();
        this.buildTable(rowCount);
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        this.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
    }

    public void setSelectionMode(int selectionMode) {
        this.extendedMemberTable.setSelectionMode(selectionMode);
    }

    public ArrayList getSelectedExtendedMembers() {
        ArrayList<ExtendedMemberDescriptor> selectedList = new ArrayList<ExtendedMemberDescriptor>();
        int[] selectedRows = this.extendedMemberTable.getSelectedRows();
        for (int count = 0; count < selectedRows.length; ++count) {
            ExtendedMemberDescriptor extendedMemberDescriptor = (ExtendedMemberDescriptor)this.extendedMemberList.get(selectedRows[count]);
            selectedList.add(extendedMemberDescriptor);
        }
        return selectedList;
    }

    public void dispose() {
        this.raidGroupDatabase.removeUpdateListener(this.raidGroupDatabaseUpdateListener);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public int getSelectedRow() {
        return this.extendedMemberTable.getSelectedRow();
    }

    public KTable getTable() {
        return this.extendedMemberTable;
    }

    public ExtendedMemberTableModel getTableModel() {
        return this.extendedMemberTableModel;
    }

    public void addRowSelectionInterval(int selectionIndex0, int selectionIndex1) {
        this.extendedMemberTable.addRowSelectionInterval(selectionIndex0, selectionIndex1);
    }

    private void savePreferences() {
        int index;
        if (this.memberFields != null) {
            return;
        }
        String columns = "";
        TableColumnModel tableColumnModel = this.extendedMemberTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        for (index = 0; index < 3; ++index) {
            this.preferences.put("Table Sort Field" + index, ExtendedMemberDescriptor.fieldNames[this.sortDescriptors[index].field]);
            this.preferences.put("Table Sort Direction" + index, this.sortDescriptors[index].direction == 1 ? "Ascending" : "Descending");
        }
    }

    private void loadPreferences() {
        int index;
        String[] fieldNames = ExtendedMemberDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = this.memberFields != null ? this.memberFields : this.preferences.get("Table Columns", "RAID Group,Member,Status,Capacity");
            int startIndex = 0;
            do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (index = 0; index < fieldNames.length; ++index) {
                    if (!fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            if (this.memberFields.equals(null)) continue;
            this.preferences.put("Table Columns", "RAID Group,Member,Status,Capacity");
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index2 = 0; index2 < fieldList.size(); ++index2) {
            this.defaultColumns[index2] = fieldList.get(index2);
        }
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending"};
        this.sortDescriptors = new SortDescriptor[3];
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            String fields = this.sortDefaultFields[sorter];
            String direction = defaultDirection[sorter];
            if (this.memberFields == null) {
                fields = this.preferences.get("Table Sort Field" + sorter, this.sortDefaultFields[sorter]);
                direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            }
            for (index = 0; index < fieldNames.length; ++index) {
                if (!fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    protected void closeFrame() {
        this.raidGroupDatabase.removeUpdateListener(this.raidGroupDatabaseUpdateListener);
    }

    private void buildTable(int rowCount) {
        this.notifyList = new ArrayList();
        this.extendedMemberList = this.getExtendedMemberList();
        this.extendedMemberTableModel = new ExtendedMemberTableModel();
        this.extendedMemberTable = new KTable(this.extendedMemberTableModel, rowCount);
        this.extendedMemberTable.getColumnModel().addColumnModelListener(new ExtendedMemberTableColumnModelListener());
        this.extendedMemberTable.addListSelectionListener(new TableSelectionListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = ExtendedMemberTable.this.extendedMemberTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = ExtendedMemberTable.this.extendedMemberTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = ExtendedMemberTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = ExtendedMemberTable.this.extendedMemberTableModel.getColumnName(column);
                    for (count = 0; count < DeviceDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(DeviceDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < DeviceDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        ExtendedMemberTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        JTableHeader th = this.extendedMemberTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.extendedMemberTable);
        this.scrollPane.getViewport().setBackground(this.extendedMemberTable.getBackground());
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            if ((Runnable)this.notifyList.get(index) != updateListener) continue;
            this.notifyList.remove(index);
            break;
        }
    }

    private void notifyListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
        }
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.raidGroupDatabaseUpdateListener.run();
        this.extendedMemberList = this.getExtendedMemberList();
        this.extendedMemberTableModel.updateDisplay();
        this.savePreferences();
    }

    public synchronized ArrayList getExtendedMemberList() {
        ArrayList<ExtendedMemberDescriptor> newMemberList = new ArrayList<ExtendedMemberDescriptor>();
        ArrayList<ExtendedMemberDescriptor> sortedList = new ArrayList<ExtendedMemberDescriptor>();
        ArrayList raidGroupList = this.databaseManager.raidGroupDatabase.getRaidGroupList(this.raidGroupStatuses, this.onlyRedundant, this.metadataFormat);
        for (int raidGroup = 0; raidGroup < raidGroupList.size(); ++raidGroup) {
            MemberDescriptor memberDescriptor;
            int member;
            RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(raidGroup);
            String memberCapacity = "N/A";
            for (member = 0; member < raidGroupDescriptor.memberArray.size(); ++member) {
                memberDescriptor = (MemberDescriptor)raidGroupDescriptor.memberArray.get(member);
                if (!memberDescriptor.status.equals("Online")) continue;
                memberCapacity = memberDescriptor.getCapacity(this.databaseManager);
                break;
            }
            for (member = 0; member < raidGroupDescriptor.memberArray.size(); ++member) {
                memberDescriptor = (MemberDescriptor)raidGroupDescriptor.memberArray.get(member);
                if (!memberDescriptor.status.equals(this.memberStatus)) continue;
                ExtendedMemberDescriptor extendedMemberDescriptor = new ExtendedMemberDescriptor();
                extendedMemberDescriptor.member = memberDescriptor.member;
                extendedMemberDescriptor.status = memberDescriptor.status;
                extendedMemberDescriptor.pathId = memberDescriptor.pathId;
                extendedMemberDescriptor.targetId = memberDescriptor.targetId;
                extendedMemberDescriptor.startingPlbn = memberDescriptor.startingPlbn;
                extendedMemberDescriptor.capacity = memberCapacity;
                extendedMemberDescriptor.device = Integer.toString(memberDescriptor.getDevice(this.databaseManager));
                extendedMemberDescriptor.raidGroup = Integer.toString(raidGroupDescriptor.raidGroup);
                newMemberList.add(extendedMemberDescriptor);
            }
        }
        for (int sourceIndex = 0; sourceIndex < newMemberList.size(); ++sourceIndex) {
            ExtendedMemberDescriptor destMember;
            int result;
            int destIndex;
            ExtendedMemberDescriptor sourceMember = (ExtendedMemberDescriptor)newMemberList.get(sourceIndex);
            for (destIndex = 0; destIndex < sortedList.size() && (result = sourceMember.compare(destMember = (ExtendedMemberDescriptor)sortedList.get(destIndex), this.sortDescriptors[0])) < 1 && (result != 0 || (result = sourceMember.compare(destMember, this.sortDescriptors[1])) < 1 && (result != 0 || sourceMember.compare(destMember, this.sortDescriptors[2]) < 1)); ++destIndex) {
            }
            sortedList.add(destIndex, sourceMember);
        }
        return sortedList;
    }

    public ExtendedMemberDescriptor getExtendedMemberDescriptor(int row) {
        return (ExtendedMemberDescriptor)this.extendedMemberList.get(row);
    }

    class ExtendedMemberTableModel
    extends KTableModel {
        public ExtendedMemberTableModel() {
            this.setColumns(ExtendedMemberDescriptor.fieldNames, ExtendedMemberDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return ExtendedMemberTable.this.defaultColumns;
        }

        public void updateDisplay() {
            if (ExtendedMemberTable.this.extendedMemberList.size() > 0) {
                this.fireTableRowsInserted(0, ExtendedMemberTable.this.extendedMemberList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return ExtendedMemberTable.this.extendedMemberList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= ExtendedMemberTable.this.extendedMemberList.size()) {
                value = "";
            } else {
                ExtendedMemberDescriptor extendedMember = (ExtendedMemberDescriptor)ExtendedMemberTable.this.extendedMemberList.get(row);
                value = extendedMember.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }
    }

    class ExtendedMemberTableColumnModelListener
    implements TableColumnModelListener {
        ExtendedMemberTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            ExtendedMemberTable.this.savePreferences();
        }

        public void columnMoved(TableColumnModelEvent e) {
            ExtendedMemberTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    protected class RaidGroupDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void terminate() {
            this.active = false;
        }

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newExtendedMemberList = ExtendedMemberTable.this.getExtendedMemberList();
            if (ExtendedMemberTable.this.extendedMemberTable.getSelectedRow() == -1) {
                ExtendedMemberTable.this.extendedMemberList = newExtendedMemberList;
                ExtendedMemberTable.this.extendedMemberTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = ExtendedMemberTable.this.extendedMemberList.size();
                int oldTableSize = ExtendedMemberTable.this.extendedMemberTableModel.getRowCount();
                int[] selectedRows = ExtendedMemberTable.this.extendedMemberTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    ExtendedMemberDescriptor extendedMemberDescriptor = (ExtendedMemberDescriptor)ExtendedMemberTable.this.extendedMemberList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newExtendedMemberList.size(); ++newRow) {
                        ExtendedMemberDescriptor newExtendedMemberDescriptor = (ExtendedMemberDescriptor)newExtendedMemberList.get(newRow);
                        if (newExtendedMemberDescriptor.same(extendedMemberDescriptor)) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                ExtendedMemberTable.this.extendedMemberList = newExtendedMemberList;
                ExtendedMemberTable.this.extendedMemberTable.clearSelection();
                ExtendedMemberTable.this.extendedMemberTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    ExtendedMemberTable.this.extendedMemberTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        }
    }

    protected class TableSelectionListener
    implements ListSelectionListener {
        protected TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ExtendedMemberTable.this.notifyListeners();
        }
    }
}

