/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public abstract class KFrame
extends JFrame
implements GlobalConstants {
    protected StorageManagementUtility storageManagementUtility;
    protected DatabaseManager databaseManager;
    protected Preferences systemPreferences;
    protected Preferences preferences;
    protected final String FRAME_WIDTH = "Frame Width";
    protected final String FRAME_HEIGHT = "Frame Height";
    protected final String FRAME_X = "Frame X";
    protected final String FRAME_Y = "Frame Y";
    protected final String FRAME_OPEN = "Frame Open";

    protected void beginFrameInit(DatabaseManager databaseManager, String title) {
        this.beginFrameInit(databaseManager, databaseManager.storageManagementUtility, title);
    }

    protected void beginFrameInit(DatabaseManager databaseManager, StorageManagementUtility storageManagementUtility, String title) {
        this.databaseManager = databaseManager;
        this.storageManagementUtility = storageManagementUtility;
        this.setTitle(title);
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        this.setIconImage(imageIconLoader.loadImage("samIcon.gif"));
        this.systemPreferences = Preferences.userRoot().node("/Sam/System");
        this.preferences = Preferences.userRoot().node("/Sam/" + title.replace('/', '-'));
    }

    protected void changeFrameIcon(String title) {
        this.databaseManager = this.databaseManager;
        this.storageManagementUtility = this.storageManagementUtility;
        this.setTitle(title);
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        this.setIconImage(imageIconLoader.loadImage("samIcon.gif"));
    }

    protected void restoreFrameIcon(String title) {
        this.databaseManager = this.databaseManager;
        this.storageManagementUtility = this.storageManagementUtility;
        this.setTitle(title);
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        this.setIconImage(imageIconLoader.loadImage("samIcon.gif"));
    }

    protected void completeFrameInit() {
        this.pack();
        this.completeFrameInitUnpacked(null);
    }

    protected void completeFrameInitAutoCenter() {
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screen.width - this.getBounds().width) / 2, (screen.height - this.getBounds().height) / 2);
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    protected void completeFrameInitUnpacked(Rectangle rectangle) {
        this.preferences.putBoolean("Frame Open", true);
        if (rectangle == null) {
            rectangle = Utility.getCenteredBounds(this);
        }
        this.systemPreferences.putBoolean("RememberLocations", true);
        if (this.systemPreferences.getBoolean("RememberLocations", true)) {
            rectangle.width = this.preferences.getInt("Frame Width", rectangle.width);
            rectangle.height = this.preferences.getInt("Frame Height", rectangle.height);
            rectangle.x = this.preferences.getInt("Frame X", rectangle.x);
            rectangle.y = this.preferences.getInt("Frame Y", rectangle.y);
        }
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
                KFrame.this.saveFrameBounds();
            }

            public void componentResized(ComponentEvent e) {
                KFrame.this.saveFrameBounds();
            }

            public void componentShown(ComponentEvent e) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                KFrame.this.closeFrame();
            }
        });
        ((Component)this).setBounds(rectangle);
        this.setResizable(true);
        ((Component)this).setVisible(true);
    }

    protected void saveFrameBounds() {
        Rectangle rectangle = this.getBounds();
        this.preferences.putInt("Frame Width", rectangle.width);
        this.preferences.putInt("Frame Height", rectangle.height);
        this.preferences.putInt("Frame X", rectangle.x);
        this.preferences.putInt("Frame Y", rectangle.y);
    }

    protected void closeFrame() {
        this.completeFrameClosure();
    }

    protected void completeFrameClosure() {
        this.preferences.putBoolean("Frame Open", false);
        this.storageManagementUtility.closeNotification(this);
        this.dispose();
    }
}

