/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DeleteSpareBox
extends KDialog {
    String metadataFormat;
    private JButton deleteButton;
    private SpareTable spareTable;
    private ArrayList spareList;
    private SpareTableSelectionListener spareTableSelectionListener;

    public DeleteSpareBox(DatabaseManager databaseManager, String title, String metadataFormat) {
        this.metadataFormat = metadataFormat;
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildSpareTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.completeDialogInit(true);
    }

    protected void completeDialogInit(boolean autoCenter) {
        this.pack();
        Rectangle rectangle = Utility.getCenteredBounds(this);
        if (!autoCenter && this.systemPreferences.getBoolean("RememberLocations", true)) {
            rectangle.width = this.preferences.getInt("Frame Width", rectangle.width);
            rectangle.height = this.preferences.getInt("Frame Height", rectangle.height);
            rectangle.x = this.preferences.getInt("Frame X", rectangle.x);
            rectangle.y = this.preferences.getInt("Frame Y", rectangle.y);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DeleteSpareBox.this.closeDialog();
            }
        });
        ((Component)this).setBounds(rectangle);
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    protected void closeDialog() {
        this.spareTable.removeUpdateListener(this.spareTableSelectionListener);
        this.spareTable.dispose();
        this.dispose();
    }

    protected JPanel buildSpareTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.spareTable = new SpareTable(this.databaseManager, this.preferences, 12, this.metadataFormat);
        tablePanel.add(new JLabel("Select Spare(s):"));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.add(this.spareTable.getScrollPane());
        this.spareTableSelectionListener = new SpareTableSelectionListener();
        this.spareTable.addUpdateListener(this.spareTableSelectionListener);
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        return tablePanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.deleteButton = new JButton("Delete");
        JButton cancelButton = new JButton("Cancel");
        this.deleteButton.setMnemonic(68);
        cancelButton.setMnemonic(67);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer;
                String metadata = "";
                if (DeleteSpareBox.this.metadataFormat.equals("Old")) {
                    metadata = "Legacy ";
                }
                if ((answer = JOptionPane.showConfirmDialog(DeleteSpareBox.this, "Are you sure you want to delete specified " + metadata + "Spare(s)?", "Delete " + metadata + "Spare Verification", 0)) == 0) {
                    DeleteSpareBox.this.sendRequest();
                }
                DeleteSpareBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteSpareBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    private void sendRequest() {
        ArrayList selectedList = this.spareTable.getSelectedSpares();
        for (int selectedIndex = 0; selectedIndex < selectedList.size(); ++selectedIndex) {
            SpareDescriptor spare = (SpareDescriptor)selectedList.get(selectedIndex);
            String request = "<si:Request><si:Type>DeleteSpare</si:Type><si:SpareParams><si:Device>" + spare.device + "</si:Device>" + "<si:StartingPlbn>" + spare.startingPlbn + "</si:StartingPlbn>" + "</si:SpareParams>" + "</si:Request>";
            AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

                public void handleMessage(Message message) {
                    DeleteSpareBox.this.databaseManager.refresh();
                    DeleteSpareBox.this.storageManagementUtility.clearWait();
                    XmlData xmlData = new XmlData(message.response);
                    if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                        new ErrorMessageBox(DeleteSpareBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Delete Spare Error");
                    }
                }
            };
            this.storageManagementUtility.setWait();
            this.commManager.sendMessage("Execute", request, responseMessageHandler);
        }
    }

    private class SpareTableSelectionListener
    implements Runnable {
        private SpareTableSelectionListener() {
        }

        public void run() {
            Utility.println("SpareTableSelectionListener() entered");
            ArrayList spareList = DeleteSpareBox.this.spareTable.getSelectedSpares();
            if (spareList.size() > 0 && !DeleteSpareBox.this.deleteButton.isEnabled()) {
                DeleteSpareBox.this.deleteButton.setEnabled(true);
            }
        }
    }
}

