/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SegmentTable
extends JPanel
implements SortInterface,
GlobalConstants {
    KTable segmentTable;
    SegmentTableModel segmentTableModel;
    DeviceDatabaseUpdateListener deviceDatabaseUpdateListener;
    QualifyUpdateListener qualifyUpdateListener;
    SpareUpdateListener spareUpdateListener;
    DeviceDatabase deviceDatabase;
    DatabaseManager databaseManager;
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;
    JLabel deviceCountLabel;
    ArrayList segmentList;
    JScrollPane scrollPane;
    Preferences preferences;
    String segmentFields;
    String[] segmentStatuses;
    String metadataFormat;
    protected ArrayList notifyList;
    static /* synthetic */ Class class$java$lang$String;

    public SegmentTable(DatabaseManager databaseManager, Preferences preferences, String segmentFields, String[] segmentStatuses, int rowCount, String metadataFormat) {
        this.preferences = preferences;
        this.databaseManager = databaseManager;
        this.segmentFields = segmentFields;
        this.segmentStatuses = segmentStatuses;
        this.deviceDatabase = databaseManager.deviceDatabase;
        this.metadataFormat = metadataFormat;
        this.notifyList = new ArrayList();
        this.loadPreferences();
        this.buildTable(rowCount);
        this.deviceDatabaseUpdateListener = new DeviceDatabaseUpdateListener();
        this.deviceDatabase.addUpdateListener(this.deviceDatabaseUpdateListener);
        this.deviceDatabaseUpdateListener.run();
        this.qualifyUpdateListener = new QualifyUpdateListener();
        this.spareUpdateListener = new SpareUpdateListener();
    }

    public void setSelectionMode(int selectionMode) {
        this.segmentTable.setSelectionMode(selectionMode);
    }

    public ArrayList getSelectedSegments() {
        ArrayList<SegmentDescriptor> selectedList = new ArrayList<SegmentDescriptor>();
        int[] selectedRows = this.segmentTable.getSelectedRows();
        for (int count = 0; count < selectedRows.length; ++count) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)this.segmentList.get(selectedRows[count]);
            selectedList.add(segmentDescriptor);
        }
        return selectedList;
    }

    public void dispose() {
        this.deviceDatabase.removeUpdateListener(this.deviceDatabaseUpdateListener);
        this.removeAllUpdateListeners();
        this.savePreferences();
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            if ((Runnable)this.notifyList.get(index) != updateListener) continue;
            this.notifyList.remove(index);
            break;
        }
    }

    private synchronized void removeAllUpdateListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            this.notifyList.remove(index);
        }
    }

    private void notifyListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public KTable getTable() {
        return this.segmentTable;
    }

    public SegmentTableModel getTableModel() {
        return this.segmentTableModel;
    }

    public int getSelectedRow() {
        return this.segmentTable.getSelectedRow();
    }

    public void addRowSelectionInterval(int selectionIndex0, int selectionIndex1) {
        this.segmentTable.addRowSelectionInterval(selectionIndex0, selectionIndex1);
    }

    private void savePreferences() {
        int index;
        if (this.segmentFields == null || this.preferences == null) {
            return;
        }
        String columns = "";
        TableColumnModel tableColumnModel = this.segmentTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        for (index = 0; index < 3; ++index) {
            this.preferences.put("Table Sort Field" + index, SegmentDescriptor.fieldNames[this.sortDescriptors[index].field]);
            this.preferences.put("Table Sort Direction" + index, this.sortDescriptors[index].direction == 1 ? "Ascending" : "Descending");
        }
    }

    private void loadPreferences() {
        String[] fieldNames = SegmentDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = this.segmentFields != null ? this.segmentFields : (this.preferences != null ? this.preferences.get("Table Columns", "Device,Status,Capacity,Starting LBN") : "Device,Status,Capacity,Starting LBN");
            int startIndex = 0;
            block1: do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (int index = 0; index < fieldNames.length; ++index) {
                    if (!fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                    continue block1;
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            if (this.segmentFields == null || this.preferences == null) continue;
            this.preferences.put("Table Columns", "Device,Status,Capacity,Starting LBN");
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index = 0; index < fieldList.size(); ++index) {
            this.defaultColumns[index] = fieldList.get(index);
        }
        String[] defaultFields = new String[]{"Path ID", "Target ID", "Capacity"};
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending"};
        this.sortDescriptors = new SortDescriptor[3];
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            String fields = defaultFields[sorter];
            String direction = defaultDirection[sorter];
            if (this.segmentFields == null && this.preferences != null) {
                fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
                direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            }
            for (int index = 0; index < fieldNames.length; ++index) {
                if (!fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    private void buildTable(int rowCount) {
        this.segmentList = this.getSegmentList();
        this.segmentTableModel = new SegmentTableModel();
        this.segmentTable = new KTable(this.segmentTableModel, rowCount);
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.segmentTable.getTableHeader().getDefaultRenderer();
        renderer.setHorizontalAlignment(2);
        this.segmentTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = SegmentTable.class$("java.lang.String")) : class$java$lang$String, new NewCellRenderer());
        this.segmentTable.getColumnModel().addColumnModelListener(new DeviceTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = SegmentTable.this.segmentTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = SegmentTable.this.segmentTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = SegmentTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = SegmentTable.this.segmentTableModel.getColumnName(column);
                    for (count = 0; count < SegmentDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(SegmentDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < SegmentDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        SegmentTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.segmentTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.segmentTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.segmentTable);
        this.scrollPane.getViewport().setBackground(this.segmentTable.getBackground());
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.deviceDatabaseUpdateListener.run();
        this.segmentList = this.getSegmentList();
        this.segmentTableModel.updateDisplay();
        this.savePreferences();
    }

    public synchronized ArrayList getSegmentList() {
        ArrayList newSegmentList = this.metadataFormat.equals("New") ? this.deviceDatabase.getSegmentList(this.segmentStatuses) : this.deviceDatabase.getLegacySegmentList(this.segmentStatuses);
        ArrayList<SegmentDescriptor> sortedList = new ArrayList<SegmentDescriptor>();
        for (int sourceIndex = 0; sourceIndex < newSegmentList.size(); ++sourceIndex) {
            SegmentDescriptor destDevice;
            int result;
            int destIndex;
            SegmentDescriptor sourceDevice = (SegmentDescriptor)newSegmentList.get(sourceIndex);
            for (destIndex = 0; destIndex < sortedList.size() && (result = sourceDevice.compare(destDevice = (SegmentDescriptor)sortedList.get(destIndex), this.sortDescriptors[0])) < 1 && (result != 0 || (result = sourceDevice.compare(destDevice, this.sortDescriptors[1])) < 1 && (result != 0 || sourceDevice.compare(destDevice, this.sortDescriptors[2]) < 1)); ++destIndex) {
            }
            sortedList.add(destIndex, sourceDevice);
        }
        return sortedList;
    }

    public synchronized void segmentTableQualifiedUpdate(String metaformat, String configuration) {
        this.qualifyUpdateListener.setArguments(metaformat, configuration);
        this.qualifyUpdateListener.run();
    }

    public synchronized void segmentTableClearUpdate() {
        this.segmentTable.clearSelection();
        this.segmentList = new ArrayList();
        this.segmentTableModel.updateDisplay();
    }

    public synchronized void segmentTableSpareUpdate(String metaformat, int raidGroup) {
        this.spareUpdateListener.setArguments(metaformat, raidGroup);
        this.spareUpdateListener.run();
    }

    public synchronized void segmentTableUpdate() {
        this.deviceDatabaseUpdateListener.run();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NewCellRenderer
    extends DefaultTableCellRenderer {
        NewCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue;
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (SegmentTable.this.segmentTable.hexFont != null && ((String)value).length() > 3) {
                stringValue = (String)value;
                if (stringValue.charAt(0) == ' ') {
                    if (stringValue.substring(1, 3).equals("0x")) {
                        c.setFont(SegmentTable.this.segmentTable.hexFont);
                    }
                } else if (stringValue.substring(0, 2).equals("0x")) {
                    c.setFont(SegmentTable.this.segmentTable.hexFont);
                }
            }
            if (SegmentTable.this.segmentTable.alternateFont != null && (stringValue = (String)value).length() > 6 && stringValue.substring(0, 2).equals("0x") && stringValue.charAt(6) == ' ') {
                c.setFont(SegmentTable.this.segmentTable.alternateFont);
            }
            if (hasFocus) {
                if (table.getRowSelectionAllowed() && table.getSelectedRow() != -1) {
                    this.setBorder(BorderFactory.createLineBorder(table.getSelectionBackground()));
                } else {
                    this.setBorder(BorderFactory.createLineBorder(table.getBackground()));
                }
            }
            int pathId = 0;
            int targetId = 0;
            String pathIdStr = "";
            String targetIdStr = "";
            int columns = table.getColumnCount();
            TableColumnModel columnModel = table.getColumnModel();
            boolean pathIdFound = false;
            boolean targetIdFound = false;
            for (column = 0; column < columns; ++column) {
                String header = ((String)columnModel.getColumn(column).getHeaderValue()).trim();
                if (header.equals("Path ID")) {
                    pathIdStr = (String)table.getValueAt(row, column);
                    pathIdFound = true;
                } else if (header.equals("Target ID")) {
                    targetIdStr = (String)table.getValueAt(row, column);
                    targetIdFound = true;
                }
                if (pathIdFound && targetIdFound) break;
            }
            try {
                pathId = Integer.parseInt(pathIdStr.trim());
                targetId = Integer.parseInt(targetIdStr.trim());
            }
            catch (Exception e) {
                // empty catch block
            }
            ArrayList deviceList = SegmentTable.this.deviceDatabase.getDeviceList();
            boolean passThruFound = false;
            for (int device = 0; device < deviceList.size(); ++device) {
                DeviceDescriptor deviceDescriptor = (DeviceDescriptor)deviceList.get(device);
                if (deviceDescriptor.pathId != pathId || deviceDescriptor.targetId != targetId || !deviceDescriptor.passThru) continue;
                passThruFound = true;
                break;
            }
            if (passThruFound) {
                c.setBackground(GlobalConstants.passThruColor);
                c.setForeground(Color.black);
            } else {
                c.setBackground(table.getBackground());
                c.setForeground(table.getForeground());
            }
            if (isSelected) {
                c.setBackground(table.getSelectionBackground());
                c.setForeground(table.getSelectionForeground());
            }
            return c;
        }
    }

    class SegmentTableModel
    extends KTableModel {
        public SegmentTableModel() {
            this.setColumns(SegmentDescriptor.fieldNames, SegmentDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return SegmentTable.this.defaultColumns;
        }

        public void updateDisplay() {
            if (SegmentTable.this.segmentList.size() > 0) {
                this.fireTableRowsInserted(0, SegmentTable.this.segmentList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return SegmentTable.this.segmentList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= SegmentTable.this.segmentList.size()) {
                value = "";
            } else {
                SegmentDescriptor segment = (SegmentDescriptor)SegmentTable.this.segmentList.get(row);
                value = segment.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }
    }

    protected class SpareUpdateListener
    implements Runnable {
        String metaformat;
        int raidGroup;

        protected SpareUpdateListener() {
        }

        public void setArguments(String metaformat, int raidGroup) {
            this.metaformat = metaformat;
            this.raidGroup = raidGroup;
        }

        public void run() {
            ArrayList newSegmentList = SegmentTable.this.databaseManager.deviceDatabase.getQualifiedSegments(this.metaformat, "Spare");
            block0: for (int index = 0; index < newSegmentList.size(); ++index) {
                SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(index);
                DeviceDescriptor deviceDescriptor = SegmentTable.this.deviceDatabase.getDevice(Integer.parseInt(newSegmentDescriptor.device));
                if (!deviceDescriptor.status.equals("Healthy")) continue;
                for (int segment = 0; segment < deviceDescriptor.segmentArray.size(); ++segment) {
                    SegmentDescriptor devSegmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segment);
                    if (devSegmentDescriptor.raidGroup.equals("N/A")) continue;
                    RaidGroupDescriptor raidGroupDescriptor = SegmentTable.this.databaseManager.raidGroupDatabase.get(Integer.parseInt(devSegmentDescriptor.raidGroup));
                    if (raidGroupDescriptor.raidGroup != this.raidGroup || raidGroupDescriptor.status.equals("Unused")) continue;
                    newSegmentList.remove(index--);
                    continue block0;
                }
            }
            if (SegmentTable.this.segmentTable.getSelectedRow() == -1) {
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = SegmentTable.this.segmentList.size();
                int oldTableSize = SegmentTable.this.segmentTableModel.getRowCount();
                int[] selectedRows = SegmentTable.this.segmentTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    SegmentDescriptor segmentDescriptor = (SegmentDescriptor)SegmentTable.this.segmentList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newSegmentList.size(); ++newRow) {
                        SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(newRow);
                        if (!segmentDescriptor.same(newSegmentDescriptor)) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTable.clearSelection();
                SegmentTable.this.segmentTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    SegmentTable.this.segmentTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        }
    }

    protected class QualifyUpdateListener
    implements Runnable {
        String metaformat;
        String configuration;

        protected QualifyUpdateListener() {
        }

        public void setArguments(String metaformat, String configuration) {
            this.metaformat = metaformat;
            this.configuration = configuration;
        }

        public void run() {
            ArrayList newSegmentList = SegmentTable.this.databaseManager.deviceDatabase.getQualifiedSegments(this.metaformat, this.configuration);
            if (SegmentTable.this.segmentTable.getSelectedRow() == -1) {
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = SegmentTable.this.segmentList.size();
                int oldTableSize = SegmentTable.this.segmentTableModel.getRowCount();
                int[] selectedRows = SegmentTable.this.segmentTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    SegmentDescriptor segmentDescriptor = (SegmentDescriptor)SegmentTable.this.segmentList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newSegmentList.size(); ++newRow) {
                        SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(newRow);
                        if (!segmentDescriptor.same(newSegmentDescriptor)) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTable.clearSelection();
                SegmentTable.this.segmentTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    SegmentTable.this.segmentTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        }
    }

    protected class DeviceDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void terminate() {
            this.active = false;
        }

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newSegmentList = SegmentTable.this.getSegmentList();
            if (SegmentTable.this.segmentTable.getSelectedRow() == -1) {
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = SegmentTable.this.segmentList.size();
                int oldTableSize = SegmentTable.this.segmentTableModel.getRowCount();
                int[] selectedRows = SegmentTable.this.segmentTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    SegmentDescriptor segmentDescriptor = (SegmentDescriptor)SegmentTable.this.segmentList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newSegmentList.size(); ++newRow) {
                        SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(newRow);
                        if (!segmentDescriptor.same(newSegmentDescriptor)) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTable.clearSelection();
                SegmentTable.this.segmentTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    SegmentTable.this.segmentTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            SegmentTable.this.notifyListeners();
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    class DeviceTableColumnModelListener
    implements TableColumnModelListener {
        DeviceTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            SegmentTable.this.savePreferences();
        }

        public void columnMoved(TableColumnModelEvent e) {
            SegmentTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

