/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class SegmentSummaryPage
extends KFrame
implements SortInterface {
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;
    JLabel deviceCountLabel;
    ArrayList segmentList;
    SegmentTable segmentTable;

    public SegmentSummaryPage(DatabaseManager databaseManager, String title) {
        this.beginFrameInit(databaseManager, title);
        this.buildMenus();
        this.segmentTable = new SegmentTable(databaseManager, this.preferences, null, null, 10, "New");
        this.getContentPane().add((Component)this.segmentTable.getScrollPane(), "Center");
        this.buildStatusBar();
        this.completeFrameInit();
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.segmentTable.setSortDescriptors(newSorterDescriptors);
    }

    protected void closeFrame() {
        this.completeFrameClosure();
    }

    private void buildMenus() {
        JMenuItem openItem = new JMenuItem("Open...", 79);
        JMenuItem saveItem = new JMenuItem("Save...", 83);
        JMenuItem printItem = new JMenuItem("Print...", 80);
        JMenuItem exitItem = new JMenuItem("Exit", 88);
        openItem.setEnabled(false);
        saveItem.setEnabled(false);
        printItem.setEnabled(false);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SegmentSummaryPage.this.closeFrame();
            }
        });
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(exitItem);
        JMenuItem sortingItem = new JMenuItem("Sorting...", 83);
        JMenuItem fieldsItem = new JMenuItem("Fields...", 70);
        fieldsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new FieldsBox(SegmentSummaryPage.this, SegmentSummaryPage.this.segmentTable.getTable(), SegmentSummaryPage.this.segmentTable.getTableModel());
            }
        });
        sortingItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SortBox(SegmentSummaryPage.this, DeviceDescriptor.fieldNames, SegmentSummaryPage.this.segmentTable.sortDescriptors);
            }
        });
        JMenu optionsMenu = new JMenu("Options");
        optionsMenu.setMnemonic(79);
        optionsMenu.add(sortingItem);
        optionsMenu.add(fieldsItem);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(optionsMenu);
        this.setJMenuBar(menubar);
    }

    private void buildStatusBar() {
        this.deviceCountLabel = new JLabel(" Device Count: 0");
        this.deviceCountLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.deviceCountLabel, "South");
    }
}

