/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;

public class MessageQueue
extends LinkedList {
    DoorBell doorBell = new DoorBell();

    public synchronized void empty() {
        this.clear();
    }

    public void putMessage(Object message) {
        this.syncAddLast(message);
        this.doorBell.ring();
    }

    public Object getMessage(boolean waitForMessage) {
        while (true) {
            if (this.size() != 0) {
                return this.syncRemoveFirst();
            }
            if (!waitForMessage) break;
            this.doorBell.waitForRing();
        }
        return null;
    }

    private synchronized void syncAddLast(Object object) {
        this.addLast(object);
    }

    private synchronized Object syncRemoveFirst() {
        return this.removeFirst();
    }

    private class DoorBell {
        private DoorBell() {
        }

        public synchronized void waitForRing() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void ring() {
            this.notify();
        }
    }
}

