/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerTextField
extends JTextField
implements GlobalConstants {
    private boolean canBeNegative = false;
    private int cols;
    private int min;
    private int max;

    public IntegerTextField(int cols) {
        super(cols);
        this.cols = cols;
    }

    public IntegerTextField(int cols, int min, int max) {
        super(cols);
        this.cols = cols;
        this.min = min;
        this.max = max;
    }

    protected Document createDefaultModel() {
        return new IntegerDocument(this);
    }

    public Insets getInsets() {
        Insets ins = super.getInsets();
        return new Insets(ins.top, ins.left + 2, ins.bottom, ins.right);
    }

    public int getIntValue() {
        int n = 0;
        try {
            n = Integer.parseInt(this.getText());
        }
        catch (Exception ex) {
            return 0;
        }
        return n;
    }

    protected boolean withinRange(int value) {
        return value <= this.max && value >= this.min;
    }

    class IntegerDocument
    extends PlainDocument {
        IntegerTextField intTextField = null;

        public IntegerDocument(IntegerTextField intTextField) {
            this.intTextField = intTextField;
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            String oldString = this.getText(0, this.getLength());
            String newString = oldString.substring(0, offs) + str + oldString.substring(offs);
            try {
                int integer = Integer.parseInt(newString);
                if (this.intTextField.withinRange(integer)) {
                    super.insertString(offs, str, a);
                    if (oldString.equals("0")) {
                        super.remove(0, 1);
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (NumberFormatException e1) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

