/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class MakePassThruBox
extends KFrame
implements SortInterface {
    KTable deviceTable;
    DeviceManagerTableModel deviceTableModel;
    DeviceDatabaseUpdateListener deviceDatabaseUpdateListener;
    ArrayList deviceList;
    DeviceDatabase deviceDatabase;
    AbstractMessageHandler messageHandler;
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;

    public MakePassThruBox(DatabaseManager databaseManager, String title) {
        this.beginFrameInit(databaseManager, title);
        this.deviceDatabase = databaseManager.deviceDatabase;
        this.loadPreferences();
        this.buildTable();
        JPanel mainPanel = new JPanel();
        mainPanel.add(this.buildDeviceTablePanel());
        this.getContentPane().add((Component)mainPanel, "North");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.deviceDatabaseUpdateListener = new DeviceDatabaseUpdateListener();
        this.deviceDatabase.addUpdateListener(this.deviceDatabaseUpdateListener);
        this.deviceDatabaseUpdateListener.run();
        this.savePreferences();
        this.completeFrameInit();
    }

    protected void closeDialog() {
        this.deviceDatabase.removeUpdateListener(this.deviceDatabaseUpdateListener);
        this.savePreferences();
        this.dispose();
    }

    protected JPanel buildDeviceTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        tablePanel.add(new JLabel("Select Device(s): "));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        return tablePanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton convertButton = new JButton("Convert");
        JButton cancelButton = new JButton("Cancel");
        convertButton.setMnemonic(82);
        cancelButton.setMnemonic(67);
        convertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(MakePassThruBox.this, "Are you sure you want to convert specified device(s) to Pass-Thru device(s)?", "Convert to Pass-Thru Verification", 0);
                if (answer == 0) {
                    int[] selectedRows = MakePassThruBox.this.deviceTable.getSelectedRows();
                    for (int selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                        DeviceDescriptor deviceDescriptor = (DeviceDescriptor)MakePassThruBox.this.deviceList.get(selectedRows[selectedIndex]);
                        if (!MakePassThruBox.this.deviceDatabase.containsRaidGroupsAndSpares(deviceDescriptor)) continue;
                        JOptionPane.showMessageDialog(MakePassThruBox.this, "WARNING: One or more selected disks have active RAID Groups or Spares present on them.\nPlease delete any active RAID Groups and Spares on the selected disks before continuing.", "Active RAID Groups or Spares Warning", 2);
                        return;
                    }
                    MakePassThruBox.this.sendRequest(selectedRows);
                }
                MakePassThruBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MakePassThruBox.this.closeDialog();
            }
        });
        buttonPanel.add(convertButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    private void savePreferences() {
        int index;
        String columns = "";
        TableColumnModel tableColumnModel = this.deviceTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        for (index = 0; index < 1; ++index) {
            this.preferences.put("Table Sort Field" + index, DeviceDescriptor.fieldNames[this.sortDescriptors[index].field]);
            this.preferences.put("Table Sort Direction" + index, this.sortDescriptors[index].direction == 1 ? "Ascending" : "Descending");
        }
    }

    private void loadPreferences() {
        String defaultColumnHeaders = "Path ID,Target ID,Model,Serial Number,Capacity";
        String[] fieldNames = DeviceDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = this.preferences.get("Table Columns", defaultColumnHeaders);
            int startIndex = 0;
            do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (int index = 0; index < fieldNames.length; ++index) {
                    if (!fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            this.preferences.put("Table Columns", defaultColumnHeaders);
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index = 0; index < fieldList.size(); ++index) {
            this.defaultColumns[index] = fieldList.get(index);
        }
        String[] defaultFields = new String[]{"Device"};
        String[] defaultDirection = new String[]{"Ascending"};
        this.sortDescriptors = new SortDescriptor[1];
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            String fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
            String direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            for (int index = 0; index < fieldNames.length; ++index) {
                if (!fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    private void buildTable() {
        this.deviceList = this.getDeviceList();
        this.deviceTableModel = new DeviceManagerTableModel();
        this.deviceTable = new KTable(this.deviceTableModel, 24);
        this.deviceTable.setSelectionMode(2);
        this.deviceTable.setRowSelectionInterval(0, 0);
        this.deviceTable.getColumnModel().addColumnModelListener(new DeviceTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = MakePassThruBox.this.deviceTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = MakePassThruBox.this.deviceTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = MakePassThruBox.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = MakePassThruBox.this.deviceTableModel.getColumnName(column);
                    for (count = 0; count < DeviceDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(DeviceDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < DeviceDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        MakePassThruBox.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.deviceTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.deviceTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        JScrollPane scrollPane = new JScrollPane(this.deviceTable);
        scrollPane.getViewport().setBackground(this.deviceTable.getBackground());
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.deviceDatabaseUpdateListener.run();
        this.savePreferences();
    }

    private synchronized ArrayList getDeviceList() {
        ArrayList newDeviceList = this.deviceDatabase.getDeviceList();
        ArrayList<DeviceDescriptor> sortedList = new ArrayList<DeviceDescriptor>();
        for (int sourceIndex = 0; sourceIndex < newDeviceList.size(); ++sourceIndex) {
            DeviceDescriptor destDevice;
            int result;
            int destIndex;
            DeviceDescriptor sourceDevice = (DeviceDescriptor)newDeviceList.get(sourceIndex);
            if (sourceDevice.passThru || sourceDevice.status.equals("Empty")) continue;
            for (destIndex = 0; destIndex < sortedList.size() && (result = sourceDevice.compare(destDevice = (DeviceDescriptor)sortedList.get(destIndex), this.sortDescriptors[0])) < 1; ++destIndex) {
            }
            sortedList.add(destIndex, sourceDevice);
        }
        return sortedList;
    }

    private void sendRequest(int[] selectedRows) {
        selectedRows = this.deviceTable.getSelectedRows();
        for (int selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
            DeviceDescriptor deviceDescriptor = (DeviceDescriptor)this.deviceList.get(selectedRows[selectedIndex]);
            String request = "<si:Request><si:Type>MakePassThru</si:Type><si:DeviceParams><si:PathId>" + deviceDescriptor.pathId + "</si:PathId>" + "<si:TargetId>" + deviceDescriptor.targetId + "</si:TargetId>" + "<si:LogicalDeviceType>" + deviceDescriptor.logicalDeviceType + "</si:LogicalDeviceType>" + "</si:DeviceParams>" + "</si:Request>";
            AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

                public void handleMessage(Message message) {
                    MakePassThruBox.this.databaseManager.refresh();
                    MakePassThruBox.this.storageManagementUtility.clearWait();
                    XmlData xmlData = new XmlData(message.response);
                    if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                        new ErrorMessageBox(MakePassThruBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Make Pass-Thru Error");
                    }
                }
            };
            this.storageManagementUtility.setWait();
            this.databaseManager.commManager.sendMessage("Execute", request, responseMessageHandler);
        }
    }

    class DeviceManagerTableModel
    extends KTableModel {
        public DeviceManagerTableModel() {
            this.setColumns(DeviceDescriptor.fieldNames, DeviceDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return MakePassThruBox.this.defaultColumns;
        }

        public void updateDisplay() {
            if (MakePassThruBox.this.deviceList.size() > 0) {
                this.fireTableRowsInserted(0, MakePassThruBox.this.deviceList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return MakePassThruBox.this.deviceList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= MakePassThruBox.this.deviceList.size()) {
                value = "";
            } else {
                DeviceDescriptor device = (DeviceDescriptor)MakePassThruBox.this.deviceList.get(row);
                value = device.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = MakePassThruBox.this.deviceTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < MakePassThruBox.this.deviceTable.getRowCount()) {
                MakePassThruBox.this.deviceTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                DeviceDescriptor deviceDescriptor = (DeviceDescriptor)MakePassThruBox.this.deviceList.get(mouseSelectedRow);
            }
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    protected class DeviceDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void terminate() {
            this.active = false;
        }

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newDeviceList = MakePassThruBox.this.getDeviceList();
            if (MakePassThruBox.this.deviceTable.getSelectedRow() == -1) {
                MakePassThruBox.this.deviceList = newDeviceList;
                MakePassThruBox.this.deviceTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = MakePassThruBox.this.deviceList.size();
                int oldTableSize = MakePassThruBox.this.deviceTableModel.getRowCount();
                int[] selectedRows = MakePassThruBox.this.deviceTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    DeviceDescriptor deviceDescriptor = (DeviceDescriptor)MakePassThruBox.this.deviceList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newDeviceList.size(); ++newRow) {
                        DeviceDescriptor newDeviceDescriptor = (DeviceDescriptor)newDeviceList.get(newRow);
                        if (!newDeviceDescriptor.serialNumber.equals(deviceDescriptor.serialNumber)) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                MakePassThruBox.this.deviceList = newDeviceList;
                MakePassThruBox.this.deviceTable.clearSelection();
                MakePassThruBox.this.deviceTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    MakePassThruBox.this.deviceTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        }
    }

    class DeviceTableColumnModelListener
    implements TableColumnModelListener {
        DeviceTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            MakePassThruBox.this.savePreferences();
        }

        public void columnMoved(TableColumnModelEvent e) {
            MakePassThruBox.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

