/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.SwingUtilities;

public abstract class AbstractMessageHandler
implements GlobalConstants {
    boolean messageHandledByEventThread;
    boolean errorHandledByEventThread;

    public AbstractMessageHandler() {
        this.messageHandledByEventThread = false;
        this.errorHandledByEventThread = false;
    }

    public AbstractMessageHandler(boolean messageHandledByEventThread, boolean errorHandledByEventThread) {
        this.messageHandledByEventThread = messageHandledByEventThread;
        this.errorHandledByEventThread = errorHandledByEventThread;
    }

    public void dispatchMessageHandler(Message message) {
        if (this.messageHandledByEventThread) {
            SwingUtilities.invokeLater(new MessageHandler(message));
        } else {
            this.handleMessage(message);
        }
    }

    public void dispatchErrorHandler(Message message) {
        if (this.messageHandledByEventThread) {
            SwingUtilities.invokeLater(new ErrorHandler(message));
        } else {
            this.handleError(message);
        }
    }

    protected abstract void handleMessage(Message var1);

    protected void handleError(Message message) {
        Utility.println("Unable to send " + message.type);
    }

    private class ErrorHandler
    implements Runnable {
        Message message;

        public ErrorHandler(Message message) {
            this.message = message;
        }

        public void run() {
            AbstractMessageHandler.this.handleError(this.message);
        }
    }

    private class MessageHandler
    implements Runnable {
        Message message;

        public MessageHandler(Message message) {
            this.message = message;
        }

        public void run() {
            AbstractMessageHandler.this.handleMessage(this.message);
        }
    }
}

