/*
 * Decompiled with CFR 0.152.
 */
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;

class TaskDescriptor
extends AbstractDescriptor {
    private boolean DebugTask = false;
    public long task;
    public String status;
    public String priority;
    public String operation;
    public String parameters;
    public String startTime;
    public String endTime;
    public String updateCount;
    public String type;
    public String interval;
    public String errorCategory;
    public String errorDescription;
    public String progress;
    public String remaining;
    public long totalBlocks;
    public long blocksDone;
    public boolean active;
    public boolean done;
    public boolean valid;
    public int internalUpdateCount;
    public int intInterval;
    public int intPriority;
    public int intProgress;
    public int startTimeSeconds;
    public int endTimeSeconds;
    public int remainingSeconds;
    public int sampleCount;
    public long tickCount;
    ArrayList deltaTicksList;
    ArrayList deltaBlocksList;
    ArrayList data;
    ArrayList field;
    int blocksPerTick;
    long lastTickCount;
    long lastBlocksDone;
    int lastBlocksPerTick;
    final int MAX_SAMPLES = 5;
    final int MIN_SAMPLE_COUNT = 5;
    final int PENDING = 1;
    final int ACTIVE = 2;
    final int SUSPENDED = 4;
    final int CANCELED = 8;
    final int COMPLETED = 16;
    final int FAILED = 32;
    final int BLOCKED = 64;
    final int STATE_MASK = 127;
    static final int FIELD_TASK_ID = 0;
    static final int FIELD_OPERATION = 1;
    static final int FIELD_PARAMETERS = 2;
    static final int FIELD_STATE = 3;
    static final int FIELD_PRIORITY = 4;
    static final int FIELD_TYPE = 5;
    static final int FIELD_INTERVAL = 6;
    static final int FIELD_PROGRESS = 7;
    static final int FIELD_REMAINING = 8;
    static final int FIELD_START_TIME = 9;
    static final int FIELD_END_TIME = 10;
    private String[] fieldNameLookUp = new String[]{"Task", "task", "Operation", "operation", "Params", "parameters", "Status", "status", "Priority", "priority", "Progress", "progress", "StartTime", "startTime", "EndTime", "endTime", "Remaining", "remaining", "UpdateCount", "updateCount", "CompletedUnits", "blocksDone", "TotalUnits", "totalBlocks", "TickCount", "tickCount", "Ticker", "tickCount1", "Ticker", "tickCount1", "Ticker", "tickCount1", "Ticker", "tickCount1", "Ticker", "tickCount1", "Ticker", "tickCount1", "Ticker", "tickCount1"};
    static final String[] fieldNames = new String[]{"Task", "Operation", "Parameters", "Status", "Priority", "Progress", "Start Time", "End Time", "Remaining"};
    static final String[] fieldContentsMaxWidth = new String[]{"X Task X", "XX Reconfigure RAID Set XX", "X Raid Set 31, Member 15 X", "XX Status XX", "X Priority X", "X Progress X", "XX 00:00:00 00/00/00 XX", "XX 00:00:00 00/00/00 XX", "XX XXXXXXX XX", "XX XXXXXXX XX", "XX XXXXXXX XX"};

    TaskDescriptor() {
        this.nuke();
    }

    TaskDescriptor(String data) {
        this.nuke();
        this.parseXml(data);
    }

    public void nuke() {
        this.task = 0L;
        this.operation = "Unknown";
        this.parameters = "Unknown";
        this.type = "Unknown";
        this.interval = "N/A";
        this.startTime = "Unknown";
        this.endTime = "N/A";
        this.status = "Unknown";
        this.priority = "N/A";
        this.progress = "N/A";
        this.remaining = "N/A";
        this.updateCount = "Unknown";
        this.active = false;
        this.valid = true;
        this.blocksDone = 0L;
        this.totalBlocks = 0L;
        this.sampleCount = 0;
        this.deltaTicksList = new ArrayList();
        this.deltaBlocksList = new ArrayList();
        this.internalUpdateCount = 0;
        this.data = new ArrayList();
        this.field = new ArrayList();
    }

    private int convertToSeconds(String timeStamp) {
        int CLK_K_SECONDS_PER_MINUTE = 60;
        int CLK_K_MINUTES_PER_HOUR = 60;
        int CLK_K_HOURS_PER_DAY = 24;
        int CLK_K_MAX_DAYS_PER_MONTH = 31;
        int CLK_K_MONTHS_PER_YEAR = 12;
        int CLK_K_YEARS_PER_CENTURY = 100;
        int CLK_K_SECONDS_PER_HOUR = 3600;
        int CLK_K_SECONDS_PER_DAY = 86400;
        int CLK_K_SECONDS_PER_MONTH = 2678400;
        int CLK_K_SECONDS_PER_YEAR = 32140800;
        try {
            int startIndex = 0;
            int endIndex = timeStamp.indexOf("/", startIndex);
            int month = Integer.parseInt(timeStamp.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = timeStamp.indexOf("/", startIndex);
            int date = Integer.parseInt(timeStamp.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = timeStamp.indexOf(" ", startIndex);
            int year = Integer.parseInt(timeStamp.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = timeStamp.indexOf(":");
            int hours = Integer.parseInt(timeStamp.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = timeStamp.indexOf(":", startIndex);
            int minutes = Integer.parseInt(timeStamp.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = timeStamp.indexOf(" ", startIndex);
            int seconds = Integer.parseInt(timeStamp.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = timeStamp.length();
            if (timeStamp.substring(startIndex, endIndex).equals("PM")) {
                hours += 12;
            }
            return seconds + minutes * 60 + hours * 3600 + date * 86400 + month * 2678400 + year * 32140800;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public synchronized void parseXml(String data) {
        XmlData xmlData = new XmlData(data);
        Utility.println(data, this.DebugTask);
        while (xmlData.getNextElement()) {
            if (xmlData.element.equals("StartTime") || xmlData.element.equals("EndTime")) {
                Date taskStartDate = new Date((Long.valueOf(xmlData.elementValue) - 116444736000000000L) / 10000L);
                DateFormat dt = DateFormat.getDateTimeInstance(3, 3);
                xmlData.elementValue = dt.format(taskStartDate);
            }
            if (this.parseElement(this.fieldNameLookUp, xmlData.element, xmlData.elementValue)) continue;
            Utility.println("don't understand " + xmlData.element);
        }
        Utility.println("!!!tickCount " + this.tickCount, this.DebugTask);
        this.active = this.status.equals("Active");
        this.deriveProgress();
        this.done = this.status.equalsIgnoreCase("Completed") || this.status.equalsIgnoreCase("Failed") || this.status.equalsIgnoreCase("Canceled");
        ++this.internalUpdateCount;
        this.progress = this.active && this.totalBlocks != 0L ? "" + this.blocksDone * 100L / this.totalBlocks + " %" : "";
    }

    public void deriveProgress() {
        int CLK_K_SECONDS_PER_MINUTE = 60;
        int CLK_K_MINUTES_PER_HOUR = 60;
        int CLK_K_HOURS_PER_DAY = 24;
        int CLK_K_MAX_DAYS_PER_MONTH = 31;
        int CLK_K_MONTHS_PER_YEAR = 12;
        int CLK_K_YEARS_PER_CENTURY = 100;
        int CLK_K_SECONDS_PER_HOUR = 3600;
        int CLK_K_SECONDS_PER_DAY = 86400;
        int CLK_K_SECONDS_PER_MONTH = 2678400;
        int CLK_K_SECONDS_PER_YEAR = 32140800;
        String[] units = new String[]{"Second", "Minute", "Hour", "Day", "Month"};
        int[] unitValues = new int[]{1, 60, 3600, 86400, 2678400};
        TaskDescriptor task = this;
        task.startTimeSeconds = task.startTime.equals("Immediately") ? Integer.MAX_VALUE : this.convertToSeconds(task.startTime);
        task.endTimeSeconds = task.endTime.equalsIgnoreCase("N/A") ? Integer.MAX_VALUE : this.convertToSeconds(task.endTime);
        task.intInterval = Integer.MAX_VALUE;
        task.intPriority = task.priority.equalsIgnoreCase("N/A") ? Integer.MAX_VALUE : Integer.parseInt(task.priority);
        if (task.active && task.totalBlocks > 0L) {
            task.intProgress = (int)(task.blocksDone * 100L / task.totalBlocks);
            task.progress = new Integer(task.intProgress).toString() + "%";
        } else {
            task.intProgress = Integer.MAX_VALUE;
            task.progress = "N/A";
        }
        Utility.println("sampleCount " + task.sampleCount, this.DebugTask);
        Utility.println("task.tickCount " + task.tickCount, this.DebugTask);
        if (!task.status.equalsIgnoreCase("Active")) {
            Utility.println("not active! ", this.DebugTask);
            task.remaining = "N/A";
            task.sampleCount = 0;
            task.deltaTicksList.clear();
            task.deltaBlocksList.clear();
        } else if (task.sampleCount++ != 0) {
            int deltaTicks = (int)(task.tickCount - task.lastTickCount);
            int deltaBlocks = (int)(task.blocksDone - task.lastBlocksDone);
            Utility.println("deltaTicks " + deltaTicks, this.DebugTask);
            Utility.println("deltaBlocks " + deltaBlocks, this.DebugTask);
            if (deltaTicks > 0 && deltaBlocks > 0) {
                int index;
                task.deltaTicksList.add(new Integer(deltaTicks));
                task.deltaBlocksList.add(new Integer(deltaBlocks));
                int sampleTicks = 0;
                for (index = 0; index < task.deltaTicksList.size(); ++index) {
                    sampleTicks += ((Integer)task.deltaTicksList.get(index)).intValue();
                }
                int sampleBlocks = 0;
                for (index = 0; index < task.deltaBlocksList.size(); ++index) {
                    sampleBlocks += ((Integer)task.deltaBlocksList.get(index)).intValue();
                }
                long remainingBlocks = task.totalBlocks - task.blocksDone;
                float blocksPerSecond = (float)(sampleBlocks * 10) / (float)sampleTicks;
                task.remainingSeconds = remainingBlocks > 0L && (double)blocksPerSecond > 0.0 ? (int)((float)remainingBlocks / blocksPerSecond) : 0;
                int hour = task.remainingSeconds / 3600;
                int minute = task.remainingSeconds % 3600 / 60;
                int second = task.remainingSeconds % 60;
                Utility.println("got to remaining " + task.remaining, this.DebugTask);
                task.remaining = new String((hour > 9 ? "" : "0") + hour + (minute > 9 ? ":" : ":0") + minute + (second > 9 ? ":" : ":0") + second);
                int n = task.deltaTicksList.size();
                task.getClass();
                if (n > 5) {
                    task.deltaTicksList.remove(0);
                }
                int n2 = task.deltaBlocksList.size();
                task.getClass();
                if (n2 > 5) {
                    task.deltaBlocksList.remove(0);
                }
            }
        }
        task.lastTickCount = task.tickCount;
        task.lastBlocksDone = task.blocksDone;
    }

    public void clearRemainingTime() {
        this.remaining = "N/A";
        this.sampleCount = 0;
        this.deltaTicksList.clear();
        this.deltaBlocksList.clear();
        ++this.internalUpdateCount;
    }

    public Object clone() {
        TaskDescriptor taskDescriptor = new TaskDescriptor();
        taskDescriptor.task = this.task;
        taskDescriptor.status = this.status;
        taskDescriptor.priority = this.priority;
        taskDescriptor.operation = this.operation;
        taskDescriptor.parameters = this.parameters;
        taskDescriptor.type = this.type;
        taskDescriptor.interval = this.interval;
        taskDescriptor.startTime = this.startTime;
        taskDescriptor.endTime = this.endTime;
        taskDescriptor.updateCount = this.updateCount;
        taskDescriptor.errorCategory = this.errorCategory;
        taskDescriptor.errorDescription = this.errorDescription;
        taskDescriptor.progress = this.progress;
        taskDescriptor.remaining = this.remaining;
        taskDescriptor.totalBlocks = this.totalBlocks;
        taskDescriptor.active = this.active;
        taskDescriptor.done = this.done;
        taskDescriptor.valid = this.valid;
        taskDescriptor.intInterval = this.intInterval;
        taskDescriptor.intPriority = this.intPriority;
        taskDescriptor.intProgress = this.intProgress;
        taskDescriptor.startTimeSeconds = this.startTimeSeconds;
        taskDescriptor.endTimeSeconds = this.endTimeSeconds;
        taskDescriptor.remainingSeconds = this.remainingSeconds;
        taskDescriptor.sampleCount = this.sampleCount;
        taskDescriptor.deltaTicksList = this.deltaTicksList;
        taskDescriptor.deltaBlocksList = this.deltaBlocksList;
        taskDescriptor.tickCount = this.tickCount;
        taskDescriptor.blocksDone = this.blocksDone;
        taskDescriptor.blocksPerTick = this.blocksPerTick;
        taskDescriptor.lastTickCount = this.lastTickCount;
        taskDescriptor.lastBlocksDone = this.lastBlocksDone;
        taskDescriptor.lastBlocksPerTick = this.lastBlocksPerTick;
        taskDescriptor.internalUpdateCount = this.internalUpdateCount;
        taskDescriptor.data = (ArrayList)this.data.clone();
        taskDescriptor.field = (ArrayList)this.field.clone();
        return taskDescriptor;
    }

    public String getFieldValue(int fieldIndicator) {
        String value = "";
        if (fieldIndicator < this.fieldNameLookUp.length / 2) {
            value = value + this.getValue(this.fieldNameLookUp[fieldIndicator * 2 + 1]);
        }
        return value;
    }

    public int compare(DeviceDescriptor compareDevice, SortDescriptor sortDescriptor) {
        long result = this.compareFields(this.fieldNameLookUp[sortDescriptor.field * 2 + 1], compareDevice);
        if (sortDescriptor.direction == 1) {
            if (result >= 1L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
        if (result >= 1L) {
            return 1;
        }
        if (result == 0L) {
            return 0;
        }
        return -1;
    }

    public String getFieldName(int fieldIndicator) {
        return fieldNames[fieldIndicator];
    }

    public int compare(TaskDescriptor compareTask, SortDescriptor sortDescriptor) {
        if (compareTask == null) {
            return 0;
        }
        long result = this.compareFields(this.fieldNameLookUp[sortDescriptor.field * 2 + 1], compareTask);
        if (sortDescriptor.direction == 1) {
            if (result >= 1L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
        if (result >= 1L) {
            return 1;
        }
        if (result == 0L) {
            return 0;
        }
        return -1;
    }
}

