/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CreateLegacyRaidGroupBox
extends KDialog
implements GlobalConstants {
    private JComboBox chunkSizeComboBox;
    private JComboBox capacityComboBox;
    private JComboBox configurationComboBox;
    private JComboBox raidGroupNumberComboBox;
    private JComboBox rebuildPriorityComboBox;
    private SegmentTable segmentTable;
    private JButton createButton;
    private JButton closeButton;
    private JPanel borderPanel;
    private String raidGroup;
    private boolean responseOk;
    private int maxLegacyRaidGroups;
    private String[] configurationStrings;
    private String[] chunkSizeStrings = new String[]{"8 KB", "16 KB", "32 KB", "64 KB", "128 KB"};
    private int[] chunkSizes = new int[]{16, 32, 64, 128, 256};
    private String[] priorityStrings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private String segmentFields = "Path ID,Target ID,Capacity,Starting LBN";
    private String[] segmentStatuses = new String[]{"Available"};
    private String[] availableLegacyNumbers;
    private String oldMetadataFormat = "Old";
    private CapacityComboBoxPollingThread capacityComboBoxPollingThread;
    private LegacyRaidGroupUpdateListener legacyRaidGroupUpdateListener;
    private ConfigComboBoxListener configComboBoxListener;

    public CreateLegacyRaidGroupBox(DatabaseManager databaseManager, String title) {
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildParametersPanel(), "North");
        this.getContentPane().add((Component)this.buildSegmentTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.maxLegacyRaidGroups = databaseManager.raidGroupDatabase.getMaxLegacyRaidGroups();
        this.availableLegacyNumbers = new String[this.maxLegacyRaidGroups];
        this.availableLegacyNumbers = databaseManager.raidGroupDatabase.getAvailableLegacyRaidGroupNumbers();
        this.configComboBoxListener = new ConfigComboBoxListener();
        this.legacyRaidGroupUpdateListener = new LegacyRaidGroupUpdateListener();
        databaseManager.raidGroupDatabase.addUpdateListener(this.legacyRaidGroupUpdateListener);
        databaseManager.deviceDatabase.addUpdateListener(this.legacyRaidGroupUpdateListener);
        this.initializeParameterPanel(Integer.toString(databaseManager.maximumRaidGroups));
        this.capacityComboBox.getEditor().getEditorComponent().addKeyListener(new CapacityComboKeyListener());
        this.capacityComboBox.setEditable(true);
        this.createButton.setEnabled(false);
        this.capacityComboBoxPollingThread = new CapacityComboBoxPollingThread();
        this.capacityComboBoxPollingThread.start();
        this.storageManagementUtility.createdRaidGroupCount = 0;
        this.generateConfigComboBoxItems();
        this.completeDialogInit(true);
    }

    protected JPanel buildParametersPanel() {
        JPanel compoundPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        compoundPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.configurationStrings = GlobalConstants.configFullStrings;
        if (this.databaseManager.controllerDatabase.getControllerType().equals("Sil3132r5")) {
            this.configurationStrings = GlobalConstants.config3132Strings;
        }
        this.raidGroupNumberComboBox = new JComboBox<String>(this.databaseManager.raidGroupDatabase.getAvailableLegacyRaidGroupNumbers());
        this.configurationComboBox = new JComboBox<String>(this.configurationStrings);
        this.chunkSizeComboBox = new JComboBox<String>(this.chunkSizeStrings);
        this.chunkSizeComboBox.setEnabled(false);
        this.capacityComboBox = new JComboBox<String>(GlobalConstants.capacityStrings);
        this.rebuildPriorityComboBox = new JComboBox<String>(this.priorityStrings);
        this.rebuildPriorityComboBox.setSelectedIndex(this.priorityStrings.length - 1);
        Utility.addComponent(new JLabel("RAID Group:"), compoundPanel, layout, constraints, 0, 0, 0, 0, 8, 8, 0.0);
        Utility.addComponent(this.raidGroupNumberComboBox, compoundPanel, layout, constraints, 1, 0, 0, 0, 4, 8, 1.0);
        Utility.addComponent(new JLabel("Configuration:"), compoundPanel, layout, constraints, 0, 1, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.configurationComboBox, compoundPanel, layout, constraints, 1, 1, 9, 0, 4, 8, 1.0);
        Utility.addComponent(new JLabel("Capacity:"), compoundPanel, layout, constraints, 0, 2, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.capacityComboBox, compoundPanel, layout, constraints, 1, 2, 9, 0, 4, 8, 1.0);
        Utility.addComponent(new JLabel("Chunk Size:"), compoundPanel, layout, constraints, 0, 3, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.chunkSizeComboBox, compoundPanel, layout, constraints, 1, 3, 9, 0, 4, 8, 1.0);
        Utility.addComponent(new JLabel("Rebuild Priority:"), compoundPanel, layout, constraints, 0, 4, 9, 9, 8, 8, 0.0);
        Utility.addComponent(this.rebuildPriorityComboBox, compoundPanel, layout, constraints, 1, 4, 9, 9, 4, 8, 1.0);
        Dimension dimension = this.configurationComboBox.getPreferredSize();
        this.raidGroupNumberComboBox.setPreferredSize(dimension);
        this.capacityComboBox.setPreferredSize(dimension);
        this.chunkSizeComboBox.setPreferredSize(dimension);
        this.configurationComboBox.setPreferredSize(dimension);
        this.rebuildPriorityComboBox.setPreferredSize(dimension);
        compoundPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
        this.borderPanel = new JPanel();
        this.borderPanel.setLayout(new BoxLayout(this.borderPanel, 1));
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 13, 0, 13));
        this.borderPanel.add(compoundPanel);
        return this.borderPanel;
    }

    private JPanel buildSegmentTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.segmentTable = new SegmentTable(this.databaseManager, null, this.segmentFields, this.segmentStatuses, 6, "Old");
        tablePanel.add(this.segmentTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(8, 14, 4, 14));
        return tablePanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.createButton = new JButton("Create");
        this.closeButton = new JButton("Close");
        this.createButton.setMnemonic(69);
        this.closeButton.setMnemonic(88);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLegacyRaidGroupBox.this.sendCreateRequest();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLegacyRaidGroupBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.createButton);
        buttonPanel.add(this.closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    private synchronized void initializeParameterPanel(String raidToSkip) {
        int dimension = this.availableLegacyNumbers.length - 1;
        if (raidToSkip.equals(Integer.toString(this.databaseManager.maximumRaidGroups))) {
            ++dimension;
        }
        String[] newAvailableLegacyNumbers = new String[dimension];
        this.raidGroupNumberComboBox.removeAllItems();
        int index = 0;
        for (int i = 0; i < this.availableLegacyNumbers.length; ++i) {
            if (raidToSkip.equals(this.availableLegacyNumbers[i])) continue;
            this.raidGroupNumberComboBox.addItem(this.availableLegacyNumbers[i]);
            newAvailableLegacyNumbers[index++] = this.availableLegacyNumbers[i];
        }
        this.availableLegacyNumbers = newAvailableLegacyNumbers;
        if (this.availableLegacyNumbers.length == 0 || !this.databaseManager.deviceDatabase.legacyBootSupportable()) {
            this.setControlCompoundPanel(false);
        } else {
            this.updateConfigComboBoxAndSegmentTable();
        }
    }

    private void updateConfigComboBoxAndSegmentTable() {
        String[] configurations = new String[]{"Contiguous"};
        this.configurationComboBox.removeActionListener(this.configComboBoxListener);
        int legacyRaidGrps = this.databaseManager.raidGroupDatabase.getLegacyRaidGroupCount();
        if (legacyRaidGrps >= 2) {
            this.configurationComboBox.setEnabled(false);
            this.configurationComboBox.removeAllItems();
            this.configurationComboBox.addItem(this.configurationStrings[0]);
            this.configurationComboBox.setSelectedIndex(0);
            if (this.databaseManager.deviceDatabase.qualifiedSegmentExists(this.oldMetadataFormat, this.configurationStrings[0])) {
                this.configurationComboBox.setEnabled(true);
            }
        }
        this.configurationComboBox.addActionListener(this.configComboBoxListener);
        boolean control = true;
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        if (configuration.equals("Contiguous") || configuration.equals("Mirrored") || configuration.equals("Concatenated")) {
            control = false;
        }
        if (this.chunkSizeComboBox.isEnabled() != control) {
            this.chunkSizeComboBox.setEnabled(control);
        }
        this.segmentTable.segmentTableQualifiedUpdate("Old", configuration);
        control = true;
        if (configuration.equals("Concatenated")) {
            control = false;
        }
        if (this.capacityComboBox.isEnabled() != control) {
            this.capacityComboBox.setEnabled(control);
            this.capacityComboBox.setEditable(control);
        }
        if (this.segmentTable.getSegmentList().size() == 0 || configuration.equals("Concatenated") && this.segmentTable.getSegmentList().size() < 2) {
            this.setControlCompoundPanel(false);
        }
    }

    private void setControlCompoundPanel(boolean control) {
        this.raidGroupNumberComboBox.setEnabled(control);
        this.configurationComboBox.setEnabled(control);
        this.chunkSizeComboBox.setEnabled(control);
        this.capacityComboBox.setEnabled(control);
        this.capacityComboBox.setEditable(control);
        this.rebuildPriorityComboBox.setEnabled(control);
        this.borderPanel.setEnabled(control);
        this.updateCreateButtonState(control);
    }

    private void sendCreateRequest() {
        int answer;
        String capacityBlocksStr = "";
        this.raidGroup = (String)this.raidGroupNumberComboBox.getSelectedItem();
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        String capacityString = ((String)this.capacityComboBox.getSelectedItem()).toUpperCase();
        ArrayList segmentList = this.segmentTable.getSelectedSegments();
        boolean passThruFound = false;
        for (int member = 0; member < segmentList.size(); ++member) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(member);
            DeviceDescriptor deviceDescriptor = this.databaseManager.deviceDatabase.getDevice(Integer.parseInt(segmentDescriptor.device));
            if (!deviceDescriptor.passThru) continue;
            passThruFound = true;
            break;
        }
        if (passThruFound && (answer = JOptionPane.showConfirmDialog(this, "WARNING: You have selected one or more PASS-THRU disks to be used for this RAID Group.\nUsing these disks will result in any existing data on the disks being overwritten.\nWould you like to continue?", "Pass-Thru Disks Warning", 0)) == 1) {
            return;
        }
        int chunkSize = this.chunkSizes[this.chunkSizeComboBox.getSelectedIndex()];
        Utility.println("chunk size in blocks " + chunkSize);
        String rebuildPriority = (String)this.rebuildPriorityComboBox.getSelectedItem();
        long capacityBlocks = 0L;
        if (configuration.equals("Concatenated")) {
            this.returnStatus = false;
            this.returnList = new ArrayList();
            new ConcatCapacityBox(this, this.databaseManager, "Specify RAID Group Capacity", segmentList);
            if (!this.returnStatus) {
                return;
            }
            capacityBlocksStr = capacityBlocksStr + Long.toString(this.returnValue);
        } else {
            int capacityIndex;
            boolean found = false;
            for (capacityIndex = 0; capacityIndex < GlobalConstants.capacityStrings.length; ++capacityIndex) {
                if (!capacityString.equals(GlobalConstants.capacityStrings[capacityIndex])) continue;
                found = true;
                break;
            }
            if (found) {
                capacityBlocks = GlobalConstants.capacities[capacityIndex];
            } else {
                int endIndex = capacityString.indexOf(" MB");
                if (endIndex == -1) {
                    endIndex = capacityString.indexOf(" GB");
                    if (endIndex == -1) {
                        endIndex = capacityString.length();
                        capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 2048L;
                    } else {
                        capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 0x200000L;
                    }
                } else {
                    capacityBlocks = Long.parseLong(capacityString.substring(0, endIndex)) * 2048L;
                }
            }
            long capacityPerMember = 0L;
            if (!capacityString.equals("MAX") && !capacityString.equals("HALF")) {
                int memberCount = segmentList.size();
                int stripeWidth = 1;
                if (configuration.equals("Parity RAID")) {
                    stripeWidth = memberCount - 1;
                } else if (configuration.equals("Mirrored")) {
                    if (memberCount > 2) {
                        new ErrorMessageBox(this, "Create RAID Group Error", "Please retry by selecting 2 mirror members");
                        return;
                    }
                    stripeWidth = 1;
                } else if (configuration.equals("Mirrored Striped")) {
                    stripeWidth = memberCount / 2;
                } else if (configuration.equals("Striped")) {
                    stripeWidth = memberCount;
                } else if (configuration.equals("Contiguous")) {
                    stripeWidth = 1;
                } else if (configuration.equals("Concatenated")) {
                    stripeWidth = memberCount;
                }
                if (stripeWidth == 0) {
                    ++stripeWidth;
                }
                if (((capacityPerMember = capacityBlocks / (long)stripeWidth) & (long)(chunkSize - 1)) != 0L) {
                    capacityPerMember = capacityPerMember + (long)chunkSize & (long)(~(chunkSize - 1));
                }
                capacityBlocks = capacityPerMember * (long)stripeWidth;
                Utility.println("capacity per member " + capacityPerMember);
            }
            capacityBlocksStr = capacityBlocksStr + Long.toString(capacityBlocks);
        }
        Utility.println("capacity " + capacityString + " " + capacityBlocksStr);
        String memberInfo = "";
        boolean foundMemberCount = false;
        for (int member = 0; member < segmentList.size(); ++member) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(member);
            memberInfo = memberInfo + "<si:RaidMemberInfo><si:Device>" + segmentDescriptor.device + "</si:Device>" + "<si:StartingPlbn>" + segmentDescriptor.startingPlbn + "</si:StartingPlbn>";
            if (configuration.equals("Concatenated")) {
                memberInfo = memberInfo + "<si:Capacity>" + (String)this.returnList.get(member) + "</si:Capacity>";
            }
            memberInfo = memberInfo + "</si:RaidMemberInfo>";
        }
        String checkPointing = "Yes";
        String dirtyData = "Yes";
        String request = "<si:Request><si:Type>CreateRaidGroup</si:Type><si:RaidGroupParams><si:RaidGroup>" + this.raidGroup + "</si:RaidGroup>" + "<si:Label></si:Label>" + "<si:Configuration>" + configuration + "</si:Configuration>" + "<si:ChunkSize>" + chunkSize + "</si:ChunkSize>" + "<si:Capacity>" + capacityBlocksStr + "</si:Capacity>" + "<si:RebuildPriority>" + rebuildPriority + "</si:RebuildPriority>" + "<si:MetadataFormat>Old</si:MetadataFormat>" + "<si:WriteCheckPointing>" + checkPointing + "</si:WriteCheckPointing>" + "<si:ReturnDirtyData>" + dirtyData + "</si:ReturnDirtyData>" + memberInfo + "</si:RaidGroupParams>" + "</si:Request>";
        Utility.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                CreateLegacyRaidGroupBox.this.databaseManager.refresh();
                CreateLegacyRaidGroupBox.this.setCursor(new Cursor(0));
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    CreateLegacyRaidGroupBox.this.responseOk = false;
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(CreateLegacyRaidGroupBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Create Legacy RAID Group Error");
                }
                CreateLegacyRaidGroupBox.this.borderPanel.setEnabled(true);
            }
        };
        this.responseOk = true;
        this.borderPanel.setEnabled(false);
        this.setCursor(new Cursor(3));
        this.databaseManager.commManager.sendMessage("Execute", request, responseMessageHandler);
        while (!this.borderPanel.isEnabled()) {
        }
        if (this.responseOk) {
            ++this.storageManagementUtility.createdRaidGroupCount;
            this.initializeParameterPanel(this.raidGroup);
            this.updateButtonState();
        }
    }

    private void generateConfigComboBoxItems() {
        this.configurationComboBox.removeActionListener(this.configComboBoxListener);
        String selectedItem = (String)this.configurationComboBox.getSelectedItem();
        this.configurationComboBox.setEnabled(false);
        this.configurationComboBox.removeAllItems();
        for (int index = 0; index < this.configurationStrings.length; ++index) {
            if (!this.databaseManager.deviceDatabase.qualifiedSegmentExists(this.oldMetadataFormat, this.configurationStrings[index])) continue;
            this.configurationComboBox.addItem(this.configurationStrings[index]);
        }
        if (this.configurationComboBox.getItemCount() > 0) {
            for (int itemIndex = 0; itemIndex < this.configurationComboBox.getItemCount(); ++itemIndex) {
                if (!selectedItem.equals((String)this.configurationComboBox.getItemAt(itemIndex))) continue;
                this.configurationComboBox.setSelectedIndex(itemIndex);
                break;
            }
            this.configurationComboBox.setEnabled(true);
        } else {
            this.configurationComboBox.addItem(this.configurationStrings[0]);
            this.configurationComboBox.setSelectedIndex(0);
        }
        this.configurationComboBox.addActionListener(this.configComboBoxListener);
    }

    protected void closeDialog() {
        this.capacityComboBoxPollingThread = null;
        this.databaseManager.deviceDatabase.removeUpdateListener(this.legacyRaidGroupUpdateListener);
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.legacyRaidGroupUpdateListener);
        this.dispose();
    }

    private void updateButtonState() {
        boolean control = true;
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        if (configuration.equals("Concatenated")) {
            if (this.segmentTable.getSelectedSegments().size() < 2) {
                control = false;
            }
        } else {
            if (!this.capacityComboBox.isEnabled()) {
                return;
            }
            if (!this.checkCapacityValidity() || this.segmentTable.getSelectedSegments().size() == 0) {
                control = false;
            }
        }
        this.updateCreateButtonState(control);
    }

    private void updateCreateButtonState(boolean newState) {
        if (this.createButton.isEnabled() != newState) {
            this.createButton.setEnabled(newState);
        }
    }

    private boolean checkCapacityValidity() {
        String digits;
        int digitsLen;
        String suffix;
        String capacityString = this.capacityComboBox.getEditor().getItem().toString().toUpperCase().trim();
        if (capacityString.equals("MAX") || capacityString.equals("HALF")) {
            return true;
        }
        int endIndex = capacityString.indexOf(" MB");
        if (endIndex == -1) {
            endIndex = capacityString.indexOf(" GB");
            if (endIndex == -1) {
                return false;
            }
            suffix = capacityString.substring(endIndex);
            if (suffix.length() > 3) {
                return false;
            }
        } else {
            suffix = capacityString.substring(endIndex, capacityString.length());
            if (suffix.length() > 3) {
                return false;
            }
        }
        if ((digitsLen = (digits = capacityString.substring(0, endIndex).trim()).length()) == 0 || digitsLen > 3) {
            return false;
        }
        for (int index = 0; index < digits.length(); ++index) {
            char digit = digits.charAt(index);
            if (digit >= '0' && digit <= '9') continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ String[] access$802(CreateLegacyRaidGroupBox x0, String[] x1) {
        x0.availableLegacyNumbers = x1;
        return x1;
    }

    private class ConfigComboBoxListener
    implements ActionListener {
        private ConfigComboBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String configuration = (String)CreateLegacyRaidGroupBox.this.configurationComboBox.getSelectedItem();
            boolean control = true;
            if (configuration.equals("Contiguous") || configuration.equals("Mirrored") || configuration.equals("Concatenated")) {
                control = false;
            }
            if (CreateLegacyRaidGroupBox.this.chunkSizeComboBox.isEnabled() != control) {
                CreateLegacyRaidGroupBox.this.chunkSizeComboBox.setEnabled(control);
            }
            if (!configuration.equals("Concatenated")) {
                control = true;
            }
            if (CreateLegacyRaidGroupBox.this.capacityComboBox.isEnabled() != control) {
                CreateLegacyRaidGroupBox.this.capacityComboBox.setEnabled(control);
                CreateLegacyRaidGroupBox.this.capacityComboBox.setEditable(control);
            }
            String buttonText = "Create";
            if (configuration.equals("Concatenated")) {
                buttonText = "Next";
            }
            if (!CreateLegacyRaidGroupBox.this.createButton.getText().equals(buttonText)) {
                CreateLegacyRaidGroupBox.this.createButton.setText(buttonText);
            }
            CreateLegacyRaidGroupBox.this.updateConfigComboBoxAndSegmentTable();
        }
    }

    private class CapacityComboBoxPollingThread
    extends Thread {
        private CapacityComboBoxPollingThread() {
        }

        public void run() {
            while (CreateLegacyRaidGroupBox.this.capacityComboBoxPollingThread != null) {
                try {
                    Thread.sleep(500L);
                    CreateLegacyRaidGroupBox.this.updateButtonState();
                }
                catch (Exception exception) {}
            }
        }
    }

    private class CapacityComboKeyListener
    implements KeyListener {
        private CapacityComboKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        /*
         * Unable to fully structure code
         */
        public void keyTyped(KeyEvent e) {
            digit = e.getKeyChar();
            capacityString = CreateLegacyRaidGroupBox.access$1200(CreateLegacyRaidGroupBox.this).getEditor().getItem().toString().trim();
            if (digit == '\b') ** GOTO lbl-1000
            if (digit == '\t') ** GOTO lbl-1000
            if (digit == ' ') ** GOTO lbl-1000
            if (digit == '%') ** GOTO lbl-1000
            if (digit == '\'') ** GOTO lbl-1000
            if (digit == '\u00e2') ** GOTO lbl-1000
            if (digit != '\u00e2' && digit != 'G' && digit != 'B' && digit != 'g' && digit != 'b') {
                if (digit < '0' || digit > '9') {
                    e.consume();
                    return;
                }
            } else lbl-1000:
            // 7 sources

            {
                if (digit == 'G' && (capacityString.indexOf("G") != -1 || capacityString.indexOf("g") != -1) || digit == 'g' && (capacityString.indexOf("g") != -1 || capacityString.indexOf("G") != -1)) {
                    e.consume();
                    return;
                }
                if (digit == 'B' && (capacityString.indexOf("B") != -1 || capacityString.indexOf("b") != -1) || digit == 'b' && (capacityString.indexOf("b") != -1 || capacityString.indexOf("B") != -1)) {
                    e.consume();
                    return;
                }
            }
            if (digit != '\b' && capacityString.length() > 5) {
                e.consume();
                return;
            }
        }
    }

    private class LegacyRaidGroupUpdateListener
    implements Runnable {
        private LegacyRaidGroupUpdateListener() {
        }

        public void run() {
            CreateLegacyRaidGroupBox.this.generateConfigComboBoxItems();
            CreateLegacyRaidGroupBox.access$802(CreateLegacyRaidGroupBox.this, CreateLegacyRaidGroupBox.this.databaseManager.raidGroupDatabase.getAvailableLegacyRaidGroupNumbers());
            if (CreateLegacyRaidGroupBox.this.availableLegacyNumbers.length == 0 || !CreateLegacyRaidGroupBox.this.databaseManager.deviceDatabase.legacyBootSupportable()) {
                CreateLegacyRaidGroupBox.this.setControlCompoundPanel(false);
                CreateLegacyRaidGroupBox.this.segmentTable.segmentTableClearUpdate();
            } else {
                CreateLegacyRaidGroupBox.this.setControlCompoundPanel(true);
            }
            CreateLegacyRaidGroupBox.this.updateConfigComboBoxAndSegmentTable();
        }
    }
}

