/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutBox
extends JDialog
implements GlobalConstants {
    public AboutBox(DatabaseManager databaseManager) {
        super(databaseManager.storageManagementUtility, "About " + databaseManager.storageManagementUtility.applicationName, true);
        this.getContentPane().add((Component)this.buildIconPanel(), "West");
        this.getContentPane().add((Component)this.buildAboutPanel(databaseManager), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screen.width - this.getBounds().width) / 2, (screen.height - this.getBounds().height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AboutBox.this.dispose();
            }
        });
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private JPanel buildIconPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        ImageIcon iconImage = imageIconLoader.loadImageIcon("company.gif");
        Utility.addComponent(new JLabel(iconImage), panel, layout, constraints, 0, 0, 0, 4, 12, 0, 0.0);
        constraints.weighty = 1.0;
        Utility.addComponent(new JLabel(""), panel, layout, constraints, 0, 1, 0, 4, 12, 0, 1.0);
        panel.setBorder(BorderFactory.createEmptyBorder(12, 4, 0, 0));
        return panel;
    }

    private JPanel buildAboutPanel(DatabaseManager databaseManager) {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        Utility.addComponent(new JLabel(databaseManager.storageManagementUtility.applicationName + ", " + "Version 1.5.4.0"), panel, layout, constraints, 0, 0, 0, 4, 12, 0, 0.0);
        Utility.addComponent(new JLabel("Copyright 2006 " + databaseManager.storageManagementUtility.companyName), panel, layout, constraints, 0, 1, 0, 4, 12, 0, 0.0);
        Utility.addComponent(new JLabel("Running under " + System.getProperty("os.name") + ", Version " + System.getProperty("os.version")), panel, layout, constraints, 0, 2, 0, 4, 12, 0, 0.0);
        Utility.addComponent(new JLabel("Using Java, Version " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor")), panel, layout, constraints, 0, 3, 0, 4, 12, 0, 0.0);
        constraints.weighty = 1.0;
        Utility.addComponent(new JLabel(""), panel, layout, constraints, 0, 4, 0, 0, 0, 0, 1.0);
        panel.setBorder(BorderFactory.createEmptyBorder(12, 4, 0, 16));
        return panel;
    }

    private JPanel buildButtonPanel() {
        JButton okButton = new JButton("OK");
        okButton.setMnemonic(79);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutBox.this.dispose();
            }
        });
        JPanel panel = new JPanel();
        panel.add(okButton);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 8));
        return panel;
    }
}

