/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ConvertLegacyRaidGroupBox
extends KDialog {
    private RaidGroupTable raidGroupTable;
    private int selectedRaidGroup;
    private JButton convertButton;
    private PickDetectThread pickDetectThread;
    private final String warningText = "Converting Legacy (Bootable) RAID Group(s) now may prevent you from booting at a later time.\nLegacy (Bootable) RAID Group is where Operating System is stored and then is loaded from when the system reboots.\nAre you sure you want to convert the specified Legacy RAID Group(s)?";

    public ConvertLegacyRaidGroupBox(DatabaseManager databaseManager, String title) {
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildRaidGroupTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.updateButtonState();
        this.pickDetectThread = new PickDetectThread();
        this.pickDetectThread.start();
        this.completeDialogInit(true);
    }

    public ConvertLegacyRaidGroupBox(DatabaseManager databaseManager, int selectedRaidGroup) {
        this.databaseManager = databaseManager;
        this.storageManagementUtility = databaseManager.storageManagementUtility;
        this.commManager = databaseManager.commManager;
        int answer = JOptionPane.showConfirmDialog(this, "Converting Legacy (Bootable) RAID Group(s) now may prevent you from booting at a later time.\nLegacy (Bootable) RAID Group is where Operating System is stored and then is loaded from when the system reboots.\nAre you sure you want to convert the specified Legacy RAID Group(s)?", "Convert Legacy RAID Group Verification", 0);
        if (answer == 0) {
            this.sendRequest(selectedRaidGroup);
        }
    }

    protected void closeDialog() {
        this.pickDetectThread = null;
        Utility.println("closeDialog");
        this.raidGroupTable.dispose();
        this.dispose();
    }

    protected JPanel buildRaidGroupTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.raidGroupTable = new RaidGroupTable(this.databaseManager, this.preferences, 12, "Old");
        tablePanel.add(new JLabel("Select RAID Group(s):"));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.add(this.raidGroupTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        return tablePanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.convertButton = new JButton("Convert");
        JButton cancelButton = new JButton("Cancel");
        this.convertButton.setMnemonic(79);
        cancelButton.setMnemonic(67);
        this.convertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConvertLegacyRaidGroupBox.this.sendRequest();
                ConvertLegacyRaidGroupBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConvertLegacyRaidGroupBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.convertButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        if (GlobalConstants.MAC_OS) {
            Dimension dimPS = this.convertButton.getPreferredSize();
            Dimension dimCB = new Dimension();
            dimCB.height = dimPS.height;
            dimCB.width = dimPS.width + 20;
            this.convertButton.setMinimumSize(dimCB);
            this.convertButton.setMinimumSize(dimCB);
            this.convertButton.setPreferredSize(dimCB);
        }
        return buttonPanel;
    }

    private void updateButtonState() {
        ArrayList raidGroupList = this.raidGroupTable.getSelectedRaidGroups();
        boolean control = true;
        if (raidGroupList.size() == 0) {
            control = false;
        }
        if (this.convertButton.isEnabled() != control) {
            this.convertButton.setEnabled(control);
        }
    }

    private void sendRequest() {
        int answer = JOptionPane.showConfirmDialog(this, "Converting Legacy (Bootable) RAID Group(s) now may prevent you from booting at a later time.\nLegacy (Bootable) RAID Group is where Operating System is stored and then is loaded from when the system reboots.\nAre you sure you want to convert the specified Legacy RAID Group(s)?", "Convert Legacy RAID Group Verification", 0);
        if (answer == 0) {
            ArrayList raidGroupList = this.raidGroupTable.getSelectedRaidGroups();
            for (int count = 0; count < raidGroupList.size(); ++count) {
                RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(count);
                this.sendRequest(raidGroupDescriptor.raidGroup);
            }
        }
    }

    public void sendRequest(int raidGroup) {
        RaidGroupLabelBox labelInputBox = new RaidGroupLabelBox(this.databaseManager, "Enter RAID Group Label", raidGroup);
        if (!labelInputBox.raidGroupLabelIsValid()) {
            return;
        }
        String request = "<si:Request><si:Type>ConvertLegacyRaidGroup</si:Type><si:RaidGroupParams><si:RaidGroup>" + raidGroup + "</si:RaidGroup>" + "<si:Label>" + labelInputBox.getRaidGroupLabel() + "</si:Label>" + "<si:WriteCheckPointing>" + labelInputBox.getCheckPointing() + "</si:WriteCheckPointing>" + "<si:ReturnDirtyData>" + labelInputBox.getDirtyData() + "</si:ReturnDirtyData>" + "</si:RaidGroupParams>" + "</si:Request>";
        Utility.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                ConvertLegacyRaidGroupBox.this.storageManagementUtility.clearWait();
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(ConvertLegacyRaidGroupBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Convert RAID Group Metadata Error");
                }
                ConvertLegacyRaidGroupBox.this.databaseManager.refresh();
            }
        };
        this.storageManagementUtility.setWait();
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    private class PickDetectThread
    extends Thread {
        private PickDetectThread() {
        }

        public void run() {
            while (ConvertLegacyRaidGroupBox.this.pickDetectThread != null) {
                try {
                    Thread.sleep(500L);
                    ConvertLegacyRaidGroupBox.this.updateButtonState();
                }
                catch (Exception exception) {}
            }
        }
    }
}

