/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class KTable
extends JTable {
    KTableModel tableModel;
    TableColumn[] columns;
    int height;
    boolean showTableHeader;
    ArrayList sortCriteria;
    Font hexFont;
    Font alternateFont;
    boolean focusTraverable;
    static /* synthetic */ Class class$java$lang$String;

    public KTable(KTableModel tableModel, int rowCount) {
        super(tableModel);
        int column;
        this.tableModel = tableModel;
        this.height = this.height;
        this.showTableHeader = true;
        this.hexFont = null;
        this.sortCriteria = new ArrayList();
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer();
        renderer.setHorizontalAlignment(2);
        this.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = KTable.class$("java.lang.String")) : class$java$lang$String, new NewCellRenderer());
        if (UIManager.getSystemLookAndFeelClassName().equals("com.apple.mrj.swing.MacLookAndFeel")) {
            this.setGridColor(Color.gray);
        }
        this.columns = new TableColumn[tableModel.getColumnCount()];
        for (column = 0; column < tableModel.getColumnCount(); ++column) {
            this.columns[column] = this.getColumnModel().getColumn(column);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int totalWidth = 0;
        for (column = 0; column < this.getColumnCount(); ++column) {
            int columnWidth = tableModel.getColumnWidth(column, fontMetrics);
            this.getColumnModel().getColumn(column).setPreferredWidth(columnWidth);
            totalWidth += columnWidth;
        }
        this.setPreferredScrollableViewportSize(new Dimension(totalWidth, this.getRowHeight() * rowCount));
        Object[] defaultColumns = tableModel.getDefaultColumns();
        if (defaultColumns != null) {
            this.changeColumns(defaultColumns);
            this.setPreferredTableWidth();
        }
    }

    public void setPreferredTableWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int totalWidth = 0;
        for (int column = 0; column < this.getColumnCount(); ++column) {
            totalWidth += this.getColumnModel().getColumn(column).getPreferredWidth();
        }
        Dimension dimension = this.getPreferredScrollableViewportSize();
        dimension.width = totalWidth;
        this.setPreferredScrollableViewportSize(dimension);
    }

    public void setPreferredTableWidth(int width) {
        Dimension dimension = this.getPreferredScrollableViewportSize();
        dimension.width = width;
        this.setPreferredScrollableViewportSize(dimension);
    }

    public void setHexFont(Font hexFont) {
        this.hexFont = hexFont;
    }

    public void setAlternateFont(Font alternateFont) {
        this.alternateFont = alternateFont;
    }

    public void changeColumns(Object[] columnNames) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        while (this.getColumnCount() > 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        for (int column = 0; column < columnNames.length; ++column) {
            int index = this.tableModel.getColumnNameIndex(((String)columnNames[column]).trim());
            tableColumnModel.addColumn(this.columns[index]);
        }
    }

    public boolean moveSelectedRowDown() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1 && selectedRow < this.tableModel.getRowCount() - 1) {
            this.changeSelection(++selectedRow, 0, false, false);
            return true;
        }
        return false;
    }

    public void setShowTableHeader(boolean showHeader) {
        this.showTableHeader = showHeader;
    }

    public void setShowGrid(boolean showGrid) {
        super.setShowGrid(showGrid);
        if (showGrid) {
            this.setIntercellSpacing(new Dimension(1, 1));
        } else {
            this.setIntercellSpacing(new Dimension(0, 0));
        }
    }

    public boolean moveSelectedRowUp() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow > 0) {
            this.changeSelection(--selectedRow, 0, false, false);
            return true;
        }
        return false;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionModel.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionModel.removeListSelectionListener(listSelectionListener);
    }

    public void addSortCriteria(int field, int direction) {
        this.sortCriteria.add(new SortDescriptor(field, direction));
    }

    public SortDescriptor getSortCriteria(int index) {
        return (SortDescriptor)this.sortCriteria.get(index);
    }

    public ArrayList getSortCriteriaList() {
        return this.sortCriteria;
    }

    public void updateSortCriteria(int x, String[] fieldNames) {
        TableColumnModel columnModel = this.getColumnModel();
        int viewColumn = columnModel.getColumnIndexAtX(x);
        int column = this.convertColumnIndexToModel(viewColumn);
        if (column != -1) {
            int count;
            String name = this.tableModel.getColumnName(column);
            for (count = 0; count < fieldNames.length && !name.trim().equals(fieldNames[count]); ++count) {
            }
            if (count < fieldNames.length) {
                SortDescriptor sortDescriptor = (SortDescriptor)this.sortCriteria.get(0);
                if (sortDescriptor.field == count) {
                    sortDescriptor.toggleDirection();
                } else {
                    int index;
                    for (index = 0; index < this.sortCriteria.size(); ++index) {
                        sortDescriptor = (SortDescriptor)this.sortCriteria.get(index);
                        if (sortDescriptor.field != count) continue;
                        this.sortCriteria.remove(index);
                        this.sortCriteria.add(0, sortDescriptor);
                        break;
                    }
                    if (index >= this.sortCriteria.size()) {
                        this.sortCriteria.add(new SortDescriptor(count, 1));
                    }
                }
            }
        }
    }

    protected void configureEnclosingScrollPane() {
        if (this.showTableHeader) {
            super.configureEnclosingScrollPane();
        } else {
            Container grandParent;
            Container parent = this.getParent();
            if (parent instanceof JViewport && (grandParent = parent.getParent()) instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)grandParent;
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                scrollPane.getViewport().setScrollMode(2);
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NewCellRenderer
    extends DefaultTableCellRenderer {
        NewCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue;
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (KTable.this.hexFont != null && ((String)value).length() > 3) {
                stringValue = (String)value;
                if (stringValue.charAt(0) == ' ') {
                    if (stringValue.substring(1, 3).equals("0x")) {
                        c.setFont(KTable.this.hexFont);
                    }
                } else if (stringValue.substring(0, 2).equals("0x")) {
                    c.setFont(KTable.this.hexFont);
                }
            }
            if (KTable.this.alternateFont != null && (stringValue = (String)value).length() > 6 && stringValue.substring(0, 2).equals("0x") && stringValue.charAt(6) == ' ') {
                c.setFont(KTable.this.alternateFont);
            }
            if (hasFocus) {
                if (table.getRowSelectionAllowed() && table.getSelectedRow() != -1) {
                    this.setBorder(BorderFactory.createLineBorder(table.getSelectionBackground()));
                } else {
                    this.setBorder(BorderFactory.createLineBorder(table.getBackground()));
                }
            }
            return c;
        }
    }
}

