/*
 * Decompiled with CFR 0.152.
 */
public class ControllerDescriptor
extends AbstractDescriptor {
    public int controller;
    public String controllerId;
    public String chipType;
    public String chipRevision;
    public String driverType;
    public String pciStatus;
    public String irqNumber;
    public String pciBusNumber;
    public String pciDevNumber;
    public int pathIdCount;
    public int targetIdCount;
    public int maxRaidGroups;
    public int maxMemberCount;
    public int maxMembersPerDevice;
    public int maxMultiMemRaidGrps;
    public int maxContRaidGrpsPerDev;
    public int maxSpares;
    public String updateCount;
    private String[] fieldNameLookUp = new String[]{"ControllerId", "controllerId", "Type", "chipType", "Revision", "chipRevision", "BusNum", "pciBusNumber", "DevNum", "pciDevNumber", "IrqNum", "irqNumber", "Status", "pciStatus", "DriverType", "driverType", "PathIdCount", "pathIdCount", "TargetIdCount", "targetIdCount", "MaxRaidGroups", "maxRaidGroups", "MaxMemberCount", "maxMemberCount", "MaxMembersPerDevice", "maxMembersPerDevice", "MaxMultiMemRaidGrps", "maxMultiMemRaidGrps", "MaxContRaidGrpsPerDev", "maxContRaidGrpsPerDev", "MaxSpares", "maxSpares", "UpdateCount", "updateCount"};

    ControllerDescriptor() {
        this.nuke();
    }

    ControllerDescriptor(int controller) {
        this.nuke();
        this.controller = controller;
    }

    ControllerDescriptor(int controller, String data) {
        this.nuke();
        this.controller = controller;
        this.parseXml(data);
    }

    public void nuke() {
        this.controller = -1;
        this.controllerId = "Unknown";
        this.chipType = "Unknown";
        this.chipRevision = "Unknown";
        this.driverType = "Unknown";
        this.pciStatus = "Unknown";
        this.irqNumber = "Unknown";
        this.pciBusNumber = "Unknown";
        this.pciDevNumber = "Unknown";
        this.pathIdCount = -1;
        this.targetIdCount = -1;
        this.maxRaidGroups = -1;
        this.maxMemberCount = -1;
        this.maxMembersPerDevice = -1;
        this.maxMultiMemRaidGrps = -1;
        this.maxContRaidGrpsPerDev = -1;
        this.maxSpares = -1;
        this.updateCount = "Unknown";
    }

    public synchronized Object clone() {
        ControllerDescriptor newDescriptor = new ControllerDescriptor();
        newDescriptor.controller = this.controller;
        newDescriptor.controllerId = this.controllerId;
        newDescriptor.chipType = this.chipType;
        newDescriptor.chipRevision = this.chipRevision;
        newDescriptor.driverType = this.driverType;
        newDescriptor.irqNumber = this.irqNumber;
        newDescriptor.pciStatus = this.pciStatus;
        newDescriptor.pciBusNumber = this.pciBusNumber;
        newDescriptor.pciDevNumber = this.pciDevNumber;
        newDescriptor.pathIdCount = this.pathIdCount;
        newDescriptor.targetIdCount = this.targetIdCount;
        newDescriptor.maxRaidGroups = this.maxRaidGroups;
        newDescriptor.maxMemberCount = this.maxMemberCount;
        newDescriptor.maxMembersPerDevice = this.maxMembersPerDevice;
        newDescriptor.maxMultiMemRaidGrps = this.maxMultiMemRaidGrps;
        newDescriptor.maxContRaidGrpsPerDev = this.maxContRaidGrpsPerDev;
        newDescriptor.maxSpares = this.maxSpares;
        newDescriptor.updateCount = this.updateCount;
        return newDescriptor;
    }

    public synchronized void parseXml(String data) {
        XmlData xmlData = new XmlData(data);
        while (xmlData.getNextElement()) {
            if (this.parseElement(this.fieldNameLookUp, xmlData.element, xmlData.elementValue)) continue;
            if (xmlData.element.equals("ChipInfo")) {
                XmlData chipInfoXmlData = new XmlData(xmlData.elementValue);
                while (chipInfoXmlData.getNextElement()) {
                    this.parseElement(this.fieldNameLookUp, chipInfoXmlData.element, chipInfoXmlData.elementValue);
                }
                continue;
            }
            if (xmlData.element.equals("PciInfo")) {
                XmlData pciInfoXmlData = new XmlData(xmlData.elementValue);
                while (pciInfoXmlData.getNextElement()) {
                    this.parseElement(this.fieldNameLookUp, pciInfoXmlData.element, pciInfoXmlData.elementValue);
                }
                continue;
            }
            if (!xmlData.element.equals("Constraints")) continue;
            XmlData constraintsXmlData = new XmlData(xmlData.elementValue);
            while (constraintsXmlData.getNextElement()) {
                this.parseElement(this.fieldNameLookUp, constraintsXmlData.element, constraintsXmlData.elementValue);
            }
        }
        if (this.maxSpares == -1) {
            this.maxSpares = this.maxMultiMemRaidGrps * this.maxMemberCount >> 1;
        }
    }

    public String getFieldValue(int fieldIndicator) {
        String value = "";
        if (fieldIndicator < this.fieldNameLookUp.length >> 1) {
            value = value + this.getValue(this.fieldNameLookUp[fieldIndicator * 2 + 1]);
        }
        return value;
    }
}

