/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class RaidGroupLabelBox
extends KDialog
implements GlobalConstants {
    private int raidGroupNumber;
    private String raidGroupLabel;
    private boolean labelValid;
    private JTextField raidGroupLabelField;
    private JButton continueButton;
    private JPanel paramsPanel;
    private JPanel compoundPanel;
    private int gap = 4;
    private String[] raidGroupStatuses = new String[]{"Online", "Reduced", "Offline"};
    private boolean parityRaidGroup = false;
    private String[] availableRaidGroupNumbers = new String[128];
    private JRadioButton[] restoreMethodButton;
    private JRadioButton[] parityMethodButton;

    public RaidGroupLabelBox(DatabaseManager databaseManager, String title, int raidGroupNumber) {
        this.beginDialogInit(databaseManager, title, true);
        this.raidGroupNumber = raidGroupNumber;
        this.getContentPane().add((Component)this.buildParametersPanel(), "North");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.labelValid = false;
        this.raidGroupLabel = "";
        String raidGroupDefaultLabel = databaseManager.raidGroupDatabase.generateRaidGroupLabel(this.raidGroupStatuses, raidGroupNumber);
        if (raidGroupDefaultLabel.equals("")) {
            this.availableRaidGroupNumbers = databaseManager.raidGroupDatabase.getAvailableRaidGroupNumbers();
            raidGroupDefaultLabel = databaseManager.raidGroupDatabase.generateRaidGroupLabel(this.raidGroupStatuses, this.availableRaidGroupNumbers);
        }
        this.raidGroupLabelField.setText(raidGroupDefaultLabel);
        this.raidGroupLabelField.addCaretListener(new LabelFieldCaretListener());
        if (raidGroupDefaultLabel.equals("")) {
            this.continueButton.setEnabled(false);
        }
        this.completeDialogInit(true);
    }

    protected JPanel buildParametersPanel() {
        RaidGroupDescriptor raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(this.raidGroupNumber);
        if (this.storageManagementUtility.advancedRaidOption && raidGroupDescriptor.configuration.equals("Parity RAID")) {
            this.parityRaidGroup = true;
            this.gap = 30;
        }
        JPanel labelPanel = this.buildLabelPanel();
        JPanel advancedFeatures = this.buildAdvancedFeaturesPanel();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(labelPanel);
        if (this.parityRaidGroup) {
            panel.add(advancedFeatures);
        }
        return panel;
    }

    protected JPanel buildLabelPanel() {
        this.paramsPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        this.paramsPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.raidGroupLabelField = new LengthTextField("", 10, 8);
        Utility.addComponent(new JLabel("RAID Group Label:"), this.paramsPanel, layout, constraints, 0, 0, 0, 0, 8, 8, 0.0);
        Utility.addComponent(this.raidGroupLabelField, this.paramsPanel, layout, constraints, 1, 0, 0, 9, this.gap, 8, 1.0);
        Dimension dimension = this.raidGroupLabelField.getPreferredSize();
        this.raidGroupLabelField.setPreferredSize(dimension);
        this.paramsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "New Parameters"));
        this.compoundPanel = new JPanel();
        this.compoundPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.compoundPanel.add(this.paramsPanel);
        this.raidGroupLabelField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RaidGroupLabelBox.this.updateButtonState();
            }
        });
        return this.compoundPanel;
    }

    protected JPanel buildAdvancedFeaturesPanel() {
        this.restoreMethodButton = new JRadioButton[2];
        this.parityMethodButton = new JRadioButton[2];
        JPanel restorePanel = this.buildRestoreMethodPanel();
        JPanel parityPanel = this.buildParityMethodPanel();
        JPanel advancedPanel = new JPanel();
        advancedPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Improper Shutdown Policy"));
        advancedPanel.setLayout(new BoxLayout(advancedPanel, 0));
        advancedPanel.add(restorePanel);
        advancedPanel.add(parityPanel);
        JPanel returnPanel = new JPanel();
        returnPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        returnPanel.add(advancedPanel);
        if (this.parityRaidGroup) {
            Dimension dimA = advancedPanel.getPreferredSize();
            Dimension dimB = this.paramsPanel.getPreferredSize();
            dimB.width = dimA.width;
            this.paramsPanel.setPreferredSize(dimB);
        }
        return returnPanel;
    }

    private JPanel buildRestoreMethodPanel() {
        String[] radioButtonTextArray = new String[]{"On (Quick Restore)", "Off (Best I/O Perf)"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        radioPanel.setLayout(layout);
        for (int count = 0; count < this.restoreMethodButton.length; ++count) {
            this.restoreMethodButton[count] = new JRadioButton(radioButtonTextArray[count]);
            buttonGroup.add(this.restoreMethodButton[count]);
        }
        Utility.addComponent(this.restoreMethodButton[0], radioPanel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 0, 0, 0, 0, 0, 1.0);
        Utility.addComponent(this.restoreMethodButton[1], radioPanel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 1, 0, 0, 0, 0, 1.0);
        this.restoreMethodButton[0].setSelected(true);
        radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Check Pointing"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(radioPanel);
        return panel;
    }

    private JPanel buildParityMethodPanel() {
        String[] radioButtonTextArray = new String[]{"Return Dirty Data", "Offline Raid Grp"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        radioPanel.setLayout(layout);
        for (int count = 0; count < this.parityMethodButton.length; ++count) {
            this.parityMethodButton[count] = new JRadioButton(radioButtonTextArray[count]);
            buttonGroup.add(this.parityMethodButton[count]);
        }
        Utility.addComponent(this.parityMethodButton[0], radioPanel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 0, 0, 0, 0, 0, 1.0);
        Utility.addComponent(this.parityMethodButton[1], radioPanel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 1, 0, 0, 0, 0, 1.0);
        this.parityMethodButton[0].setSelected(true);
        radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parity"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(radioPanel);
        return panel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.continueButton = new JButton("Continue");
        JButton cancelButton = new JButton("Cancel");
        this.continueButton.setMnemonic(79);
        cancelButton.setMnemonic(67);
        this.continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RaidGroupLabelBox.this.raidGroupLabel = RaidGroupLabelBox.this.raidGroupLabelField.getText();
                if (RaidGroupLabelBox.this.databaseManager.raidGroupDatabase.raidGroupLabelExists(RaidGroupLabelBox.this.raidGroupStatuses, RaidGroupLabelBox.this.raidGroupLabel)) {
                    JOptionPane.showMessageDialog(null, "Identical Label already exists. Please change the entry.", "Duplicate Label Alert", 0);
                    return;
                }
                RaidGroupLabelBox.this.labelValid = true;
                RaidGroupLabelBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RaidGroupLabelBox.this.labelValid = false;
                RaidGroupLabelBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.continueButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        if (GlobalConstants.MAC_OS) {
            Dimension dimPS = this.continueButton.getPreferredSize();
            Dimension dimCB = new Dimension();
            dimCB.height = dimPS.height;
            dimCB.width = dimPS.width + 20;
            this.continueButton.setMinimumSize(dimCB);
            this.continueButton.setMinimumSize(dimCB);
            this.continueButton.setPreferredSize(dimCB);
        }
        return buttonPanel;
    }

    protected void closeDialog() {
        Utility.println("closeDialog");
        this.dispose();
    }

    private void updateButtonState() {
        if (this.raidGroupLabelField.getText().trim().length() == 0) {
            if (this.continueButton.isEnabled()) {
                this.continueButton.setEnabled(false);
            }
        } else if (!this.continueButton.isEnabled()) {
            this.continueButton.setEnabled(true);
        }
    }

    public boolean raidGroupLabelIsValid() {
        return this.labelValid;
    }

    public String getRaidGroupLabel() {
        return this.raidGroupLabel;
    }

    public String getCheckPointing() {
        return this.restoreMethodButton[0].isSelected() ? "Yes" : "No";
    }

    public String getDirtyData() {
        return this.parityMethodButton[0].isSelected() ? "Yes" : "No";
    }

    private class LabelFieldCaretListener
    implements CaretListener {
        private LabelFieldCaretListener() {
        }

        public void caretUpdate(CaretEvent e) {
            RaidGroupLabelBox.this.updateButtonState();
        }
    }
}

