/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RaidGroupTreePane
extends JScrollPane
implements GlobalConstants,
TreeSelectionListener {
    private StorageManagementUtility storageManagementUtility;
    private DatabaseManager databaseManager;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private ImageIcon controllerGreenIcon;
    private ImageIcon raidGroupGreenIcon;
    private ImageIcon raidGroupYellowIcon;
    private JPopupMenu controllerPopupMenu;
    private JMenuItem createRaidGroupMenuItem;
    private JMenuItem createLegacyRaidGroupMenuItem;
    private JPopupMenu raidGroupPopupMenu;
    private JMenuItem rebuildRaidGroupMenuItem;
    private JMenuItem deleteRaidGroupMenuItem;
    private JPopupMenu legacyRaidGroupPopupMenu;
    private JMenuItem rebuildLegacyRaidGroupMenuItem;
    private JMenuItem deleteLegacyRaidGroupMenuItem;
    private JMenuItem convertLegacyRaidGroupMenuItem;
    private ArrayList raidGroupList;
    private RaidGroupDescriptor[] raidGroupTable;
    private RaidGroupDescriptor selectedRaidGroupDescriptor;
    private int popUpAnswer;

    public RaidGroupTreePane(StorageManagementUtility storageManagementUtility, DatabaseManager databaseManager) {
        this.storageManagementUtility = storageManagementUtility;
        this.databaseManager = databaseManager;
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        this.controllerGreenIcon = imageIconLoader.loadImageIcon("controllerGreen.gif");
        this.raidGroupGreenIcon = imageIconLoader.loadImageIcon("raidGroupGreen.gif");
        this.raidGroupYellowIcon = imageIconLoader.loadImageIcon("raidGroupYellow.gif");
        this.buildTree();
        this.buildPopupMenus();
        AbstractListener databaseChangeHandler = new AbstractListener(){

            public void processChange() {
                RaidGroupTreePane.this.updateRaidGroupNodes();
            }
        };
        databaseManager.deviceDatabase.addUpdateListener(databaseChangeHandler);
        databaseManager.raidGroupDatabase.addUpdateListener(databaseChangeHandler);
        databaseManager.controllerDatabase.addUpdateListener(databaseChangeHandler);
        databaseChangeHandler.processChange();
    }

    private void buildTree() {
        this.raidGroupList = new ArrayList();
        this.raidGroupList.clear();
        this.raidGroupTable = new RaidGroupDescriptor[this.databaseManager.getSelectedController().maxRaidGroups];
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.title = "Controller " + Integer.toString(this.databaseManager.getNexusController());
        nodeInfo.type = nodeInfo.CONTROLLER_TYPE;
        nodeInfo.raidGroup = -1;
        nodeInfo.icon = this.controllerGreenIcon;
        this.rootNode = new DefaultMutableTreeNode(nodeInfo);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        for (int raidGroup = 0; raidGroup < this.databaseManager.getSelectedController().maxRaidGroups; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(raidGroup);
            if (!raidGroupDescriptor.status.equals("Online") && !raidGroupDescriptor.status.equals("Reduced")) continue;
            nodeInfo = new NodeInfo();
            nodeInfo.title = raidGroupDescriptor.label + " (RG" + raidGroupDescriptor.raidGroup + ")";
            if (raidGroupDescriptor.label.equals("") && raidGroupDescriptor.metadataFormat.equals("Old")) {
                nodeInfo.title = "Legacy RG " + raidGroupDescriptor.raidGroup;
            }
            nodeInfo.type = nodeInfo.RAID_GROUP_TYPE;
            nodeInfo.raidGroup = raidGroupDescriptor.raidGroup;
            if (raidGroupDescriptor.status.equals("Online")) {
                nodeInfo.icon = this.raidGroupGreenIcon;
            } else if (raidGroupDescriptor.status.equals("Reduced")) {
                nodeInfo.icon = this.raidGroupYellowIcon;
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeInfo);
            this.treeModel.insertNodeInto(node, this.rootNode, this.rootNode.getChildCount());
            TreePath treePath = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(treePath);
        }
        this.raidGroupList = this.databaseManager.raidGroupDatabase.getRaidGroupList(false);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(new MouseTreeListener());
        this.tree.setCellRenderer(new TreeCellRenderer());
        this.tree.setRowHeight(18);
        Dimension d = this.tree.getPreferredSize();
        d.width = (int)((double)d.width * 1.25);
        this.tree.setPreferredSize(d);
        this.setViewportView(this.tree);
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            this.storageManagementUtility.deviceChannelPanel.highlightRaidGroupHandler(-1);
            return;
        }
        Object nodeInfo = node.getUserObject();
        NodeInfo treeNode = (NodeInfo)nodeInfo;
        this.storageManagementUtility.deviceChannelPanel.highlightRaidGroupHandler(treeNode.raidGroup);
    }

    private synchronized void updateRaidGroupNodes() {
        int count;
        RaidGroupDescriptor newRaidGroupDescriptor;
        int newIndex;
        int index;
        RaidGroupDescriptor raidGroupDescriptor;
        Object topNode = this.rootNode.getUserObject();
        NodeInfo topNodeInfo = (NodeInfo)topNode;
        String currentControllerTitle = "Controller " + Integer.toString(this.databaseManager.getNexusController());
        if (!topNodeInfo.title.equals(currentControllerTitle)) {
            topNodeInfo.title = currentControllerTitle;
        }
        ArrayList newRaidGroupList = this.databaseManager.raidGroupDatabase.getRaidGroupList(false);
        for (int newIndex2 = 0; newIndex2 < newRaidGroupList.size(); ++newIndex2) {
            this.raidGroupTable[raidGroupDescriptor.raidGroup] = raidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newIndex2);
        }
        ArrayList<RaidGroupDescriptor> removeList = new ArrayList<RaidGroupDescriptor>();
        for (index = 0; index < this.raidGroupList.size(); ++index) {
            raidGroupDescriptor = (RaidGroupDescriptor)this.raidGroupList.get(index);
            boolean found = false;
            for (newIndex = 0; newIndex < newRaidGroupList.size(); ++newIndex) {
                newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newIndex);
                if (raidGroupDescriptor.raidGroup != newRaidGroupDescriptor.raidGroup || !raidGroupDescriptor.label.equals(newRaidGroupDescriptor.label)) continue;
                found = true;
                break;
            }
            if (found) continue;
            removeList.add(raidGroupDescriptor);
        }
        ArrayList<RaidGroupDescriptor> addList = new ArrayList<RaidGroupDescriptor>();
        for (newIndex = 0; newIndex < newRaidGroupList.size(); ++newIndex) {
            newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newIndex);
            boolean found = false;
            for (index = 0; index < this.raidGroupList.size(); ++index) {
                raidGroupDescriptor = (RaidGroupDescriptor)this.raidGroupList.get(index);
                if (raidGroupDescriptor.raidGroup != newRaidGroupDescriptor.raidGroup || !raidGroupDescriptor.label.equals(newRaidGroupDescriptor.label)) continue;
                found = true;
                break;
            }
            if (found) continue;
            addList.add(newRaidGroupDescriptor);
        }
        block5: for (count = 0; count < removeList.size(); ++count) {
            raidGroupDescriptor = (RaidGroupDescriptor)removeList.get(count);
            for (DefaultMutableTreeNode leaf = this.rootNode.getFirstLeaf(); leaf != null && leaf != this.rootNode; leaf = leaf.getNextLeaf()) {
                NodeInfo nodeInfo = (NodeInfo)leaf.getUserObject();
                if (nodeInfo.raidGroup != raidGroupDescriptor.raidGroup) continue;
                this.treeModel.removeNodeFromParent(leaf);
                continue block5;
            }
        }
        for (count = 0; count < addList.size(); ++count) {
            DefaultMutableTreeNode leaf;
            NodeInfo nodeInfo = new NodeInfo();
            raidGroupDescriptor = (RaidGroupDescriptor)addList.get(count);
            nodeInfo.title = raidGroupDescriptor.label + " (RG" + raidGroupDescriptor.raidGroup + ")";
            if (raidGroupDescriptor.label.equals("") && raidGroupDescriptor.metadataFormat.equals("Old")) {
                nodeInfo.title = "Legacy RG " + raidGroupDescriptor.raidGroup;
            }
            nodeInfo.type = nodeInfo.RAID_GROUP_TYPE;
            nodeInfo.raidGroup = raidGroupDescriptor.raidGroup;
            if (raidGroupDescriptor.status.equals("Online")) {
                nodeInfo.icon = this.raidGroupGreenIcon;
            } else if (raidGroupDescriptor.status.equals("Reduced")) {
                nodeInfo.icon = this.raidGroupYellowIcon;
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(nodeInfo);
            if (leaf == this.rootNode) {
                this.treeModel.insertNodeInto(newNode, this.rootNode, 0);
                this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                continue;
            }
            NodeInfo newNodeInfo = null;
            index = 0;
            for (leaf = this.rootNode.getFirstLeaf(); leaf != null; leaf = leaf.getNextLeaf()) {
                newNodeInfo = (NodeInfo)leaf.getUserObject();
                if (newNodeInfo.raidGroup >= raidGroupDescriptor.raidGroup) {
                    this.treeModel.insertNodeInto(newNode, this.rootNode, index);
                    this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                    newNode = null;
                    break;
                }
                if (++index >= this.rootNode.getChildCount()) break;
            }
            if (newNode == null) continue;
            this.treeModel.insertNodeInto(newNode, this.rootNode, this.rootNode.getChildCount());
            this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
        }
        for (DefaultMutableTreeNode leaf = this.rootNode.getFirstLeaf(); leaf != null && leaf != this.rootNode; leaf = leaf.getNextLeaf()) {
            boolean changed = false;
            NodeInfo nodeInfo = (NodeInfo)leaf.getUserObject();
            raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(nodeInfo.raidGroup);
            if (raidGroupDescriptor.status.equals("Online")) {
                if (!nodeInfo.icon.equals(this.raidGroupGreenIcon)) {
                    nodeInfo.icon = this.raidGroupGreenIcon;
                    changed = true;
                }
            } else if (raidGroupDescriptor.status.equals("Reduced") && !nodeInfo.icon.equals(this.raidGroupYellowIcon)) {
                nodeInfo.icon = this.raidGroupYellowIcon;
                changed = true;
            }
            if (!changed) continue;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeInfo);
            TreeNode parent = leaf.getParent();
            int position = this.treeModel.getIndexOfChild(parent, leaf);
            this.treeModel.removeNodeFromParent(leaf);
            this.treeModel.insertNodeInto(node, this.rootNode, position);
        }
        this.raidGroupList = newRaidGroupList;
        this.tree.setRowHeight(18);
        this.tree.setPreferredSize(this.tree.getPreferredSize());
        this.tree.repaint();
    }

    public void buildPopupMenus() {
        this.controllerPopupMenu = new JPopupMenu();
        this.createRaidGroupMenuItem = new JMenuItem("Create RAID Group", 67);
        this.createLegacyRaidGroupMenuItem = new JMenuItem("Create Legacy RAID Group", 76);
        this.createRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean answer = false;
                if (((RaidGroupTreePane)RaidGroupTreePane.this).databaseManager.deviceDatabase.legacyBootSupportable()) {
                    String header = "RAID Group Creation Verification";
                    String message = "Creation of RAID Group(s) now may prevent you from creating Bootable RAID Group(s) at a later time.\nOperating System can only be stored on and started from a Bootable RAID Group.\nTo create Bootable RAID Group(s), use the Create Legacy RAID Group option under the Legacy Support.\nAre you sure you want to continue?";
                    new MessagePopUpBox(header, message);
                }
                if (RaidGroupTreePane.this.popUpAnswer == 0) {
                    new CreateRaidGroupBox(RaidGroupTreePane.this.databaseManager, "Create RAID Group");
                }
            }
        });
        this.createLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new CreateLegacyRaidGroupBox(RaidGroupTreePane.this.databaseManager, "Create Legacy RAID Group");
            }
        });
        this.controllerPopupMenu.add(this.createRaidGroupMenuItem);
        if (this.storageManagementUtility.legacySupportOption) {
            this.controllerPopupMenu.add(this.createLegacyRaidGroupMenuItem);
        }
        this.raidGroupPopupMenu = new JPopupMenu();
        this.rebuildRaidGroupMenuItem = new JMenuItem("Rebuild RAID Group", 82);
        this.deleteRaidGroupMenuItem = new JMenuItem("Delete RAID Group", 68);
        this.rebuildRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String failedMember = "";
                String title = "Rebuild RAID Group";
                ArrayList selectedList = new ArrayList();
                RaidGroupDescriptor rebuildRaidGroupDescriptor = (RaidGroupDescriptor)RaidGroupTreePane.this.selectedRaidGroupDescriptor.clone();
                rebuildRaidGroupDescriptor.memberArray.clear();
                String reducedRaidGroup = Integer.toString(rebuildRaidGroupDescriptor.raidGroup);
                int failedMemberCount = 0;
                for (int member = 0; member < ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.memberArray.size(); ++member) {
                    MemberDescriptor memberDescriptor = (MemberDescriptor)((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.memberArray.get(member);
                    if (!memberDescriptor.status.equals("Failed")) continue;
                    ++failedMemberCount;
                    failedMember = Integer.toString(member);
                }
                new RebuildRaidGroupBox(RaidGroupTreePane.this.databaseManager, title, reducedRaidGroup, failedMember, "New");
            }
        });
        this.deleteRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String header = "Delete RAID Group Verification";
                String message = "Are you sure you want to delete specified RAID Group?";
                new MessagePopUpBox(header, message);
                if (RaidGroupTreePane.this.popUpAnswer == 0) {
                    new DeleteRaidGroupBox(RaidGroupTreePane.this.databaseManager, ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.raidGroup, "New");
                }
            }
        });
        this.raidGroupPopupMenu.add(this.rebuildRaidGroupMenuItem);
        this.raidGroupPopupMenu.add(this.deleteRaidGroupMenuItem);
        this.legacyRaidGroupPopupMenu = new JPopupMenu();
        this.rebuildLegacyRaidGroupMenuItem = new JMenuItem("Rebuild Legacy RAID Group", 82);
        this.deleteLegacyRaidGroupMenuItem = new JMenuItem("Delete Legacy RAID Group", 68);
        this.convertLegacyRaidGroupMenuItem = new JMenuItem("Convert Legacy RAID Group", 67);
        this.rebuildLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String failedMember = "";
                String title = "Rebuild Legacy RAID Group";
                ArrayList selectedList = new ArrayList();
                RaidGroupDescriptor rebuildRaidGroupDescriptor = (RaidGroupDescriptor)RaidGroupTreePane.this.selectedRaidGroupDescriptor.clone();
                rebuildRaidGroupDescriptor.memberArray.clear();
                String reducedRaidGroup = Integer.toString(rebuildRaidGroupDescriptor.raidGroup);
                int failedMemberCount = 0;
                for (int member = 0; member < ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.memberArray.size(); ++member) {
                    MemberDescriptor memberDescriptor = (MemberDescriptor)((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.memberArray.get(member);
                    if (!memberDescriptor.status.equals("Failed")) continue;
                    ++failedMemberCount;
                    failedMember = Integer.toString(member);
                }
                new RebuildRaidGroupBox(RaidGroupTreePane.this.databaseManager, title, reducedRaidGroup, failedMember, "Old");
            }
        });
        this.deleteLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String header = "Delete Legacy RAID Group Verification";
                String message = "Are you sure you want to delete specified Legacy RAID Group?";
                new MessagePopUpBox(header, message);
                if (RaidGroupTreePane.this.popUpAnswer == 0) {
                    new DeleteRaidGroupBox(RaidGroupTreePane.this.databaseManager, ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.raidGroup, "Old");
                }
            }
        });
        this.convertLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ConvertLegacyRaidGroupBox(RaidGroupTreePane.this.databaseManager, ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.raidGroup);
            }
        });
        this.legacyRaidGroupPopupMenu.add(this.rebuildLegacyRaidGroupMenuItem);
        this.legacyRaidGroupPopupMenu.add(this.deleteLegacyRaidGroupMenuItem);
        this.legacyRaidGroupPopupMenu.add(this.convertLegacyRaidGroupMenuItem);
    }

    private void updateControllerPopupMenu() {
        if (this.databaseManager.raidGroupDatabase.getNextAvailableRaidGroup() == -1) {
            this.createRaidGroupMenuItem.setEnabled(false);
            this.createLegacyRaidGroupMenuItem.setEnabled(false);
        } else {
            this.createRaidGroupMenuItem.setEnabled(true);
            this.createLegacyRaidGroupMenuItem.setEnabled(false);
            if (this.databaseManager.deviceDatabase.legacyBootSupportable()) {
                this.createLegacyRaidGroupMenuItem.setEnabled(true);
            }
        }
    }

    private void updatePopupMenu(RaidGroupDescriptor raidGroupDescriptor) {
        if (raidGroupDescriptor.status.equals("Reduced") && this.databaseManager.deviceDatabase.rebuildSegmentExists(raidGroupDescriptor.raidGroup)) {
            this.rebuildRaidGroupMenuItem.setEnabled(true);
        } else {
            this.rebuildRaidGroupMenuItem.setEnabled(false);
        }
        this.deleteRaidGroupMenuItem.setEnabled(true);
    }

    private void updateLegacyPopupMenu(RaidGroupDescriptor raidGroupDescriptor) {
        this.rebuildLegacyRaidGroupMenuItem.setEnabled(false);
        if (raidGroupDescriptor.status.equals("Reduced") && this.databaseManager.deviceDatabase.availableLbn0SegmentExists()) {
            this.rebuildLegacyRaidGroupMenuItem.setEnabled(true);
        }
        this.deleteLegacyRaidGroupMenuItem.setEnabled(true);
        this.convertLegacyRaidGroupMenuItem.setEnabled(true);
    }

    private class MessagePopUpBox
    extends JDialog {
        public MessagePopUpBox(String header, String message) {
            RaidGroupTreePane.this.popUpAnswer = 1;
            RaidGroupTreePane.this.popUpAnswer = JOptionPane.showConfirmDialog(this, message, header, 0);
        }
    }

    class NodeInfo {
        int type;
        int raidGroup;
        String title = "?";
        ImageIcon icon;
        final int RAID_GROUP_TYPE = 0;
        final int CONTROLLER_TYPE = 1;

        public String toString() {
            return this.title;
        }
    }

    private class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)value;
            Object userObject = newNode.getUserObject();
            NodeInfo nodeInfo = (NodeInfo)userObject;
            if (nodeInfo.icon != null) {
                this.setIcon(nodeInfo.icon);
            }
            return this;
        }
    }

    private class MouseTreeListener
    extends MouseAdapter {
        private MouseTreeListener() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = RaidGroupTreePane.this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1 || (e.getModifiers() & 4) == 0) {
                return;
            }
            RaidGroupTreePane.this.tree.setSelectionRow(selRow);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)RaidGroupTreePane.this.tree.getLastSelectedPathComponent();
            NodeInfo nodeInfo = (NodeInfo)node.getUserObject();
            if (nodeInfo.type == nodeInfo.CONTROLLER_TYPE) {
                RaidGroupTreePane.this.updateControllerPopupMenu();
                Utility.displayPopupMenu(RaidGroupTreePane.this, RaidGroupTreePane.this.controllerPopupMenu, e);
            } else if (nodeInfo.type == nodeInfo.RAID_GROUP_TYPE) {
                RaidGroupTreePane.this.selectedRaidGroupDescriptor = RaidGroupTreePane.this.raidGroupTable[nodeInfo.raidGroup];
                if (RaidGroupTreePane.this.selectedRaidGroupDescriptor.isLegacy()) {
                    RaidGroupTreePane.this.updateLegacyPopupMenu(RaidGroupTreePane.this.raidGroupTable[nodeInfo.raidGroup]);
                    Utility.displayPopupMenu(RaidGroupTreePane.this, RaidGroupTreePane.this.legacyRaidGroupPopupMenu, e);
                } else {
                    RaidGroupTreePane.this.updatePopupMenu(RaidGroupTreePane.this.raidGroupTable[nodeInfo.raidGroup]);
                    Utility.displayPopupMenu(RaidGroupTreePane.this, RaidGroupTreePane.this.raidGroupPopupMenu, e);
                }
            }
        }
    }
}

