/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumericTextField
extends JTextField
implements GlobalConstants {
    private boolean isFloat = false;
    private boolean canBeNegative = false;
    private boolean debug = false;
    private int cols;
    private boolean beingSet;

    public NumericTextField(int cols) {
        super(cols);
        this.cols = cols;
        this.beingSet = false;
    }

    public NumericTextField(String s, int n) {
        super(s, n);
        this.cols = n;
        this.beingSet = false;
    }

    public NumericTextField(int cols, boolean isFloat, boolean neg) {
        super(cols);
        this.cols = cols;
        this.isFloat = isFloat;
        this.canBeNegative = neg;
        this.beingSet = false;
    }

    public NumericTextField(String s, int n, boolean isFloat, boolean neg) {
        super(s, n);
        this.cols = n;
        this.isFloat = isFloat;
        this.canBeNegative = neg;
        this.beingSet = false;
    }

    public void setText(String text) {
        this.beingSet = true;
        super.setText(text);
        this.beingSet = false;
    }

    public void setCaretPosition(int position) {
        this.beingSet = true;
        super.setCaretPosition(position);
        this.beingSet = false;
    }

    public boolean isBeingSet() {
        return this.beingSet;
    }

    protected Document createDefaultModel() {
        return new NumericDocument();
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    public Insets getInsets() {
        Insets ins = super.getInsets();
        return new Insets(ins.top, ins.left + 2, ins.bottom, ins.right);
    }

    public double getFloatValue() {
        return this.getDoubleValue();
    }

    public double getDoubleValue() {
        return Double.valueOf(this.getText());
    }

    public int getIntValue() {
        int n = 0;
        try {
            n = Integer.parseInt(this.getText());
        }
        catch (Exception ex) {
            return 0;
        }
        return n;
    }

    class NumericDocument
    extends PlainDocument {
        NumericDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] text = str.toCharArray();
            for (int i = 0; i < text.length; ++i) {
                char ti = text[i];
                boolean flag = false;
                if (ti == '-' && NumericTextField.this.canBeNegative) {
                    super.insertString(offs, new String(text), a);
                    break;
                }
                if ((ti == '.' || Character.isDigit(ti)) && NumericTextField.this.isFloat) {
                    super.insertString(offs, new String(text), a);
                    break;
                }
                if (Character.isDigit(ti)) {
                    if (NumericTextField.this.cols > 0 && this.getLength() > NumericTextField.this.cols - 1) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    super.insertString(offs, new String(text), a);
                    break;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

