/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class FieldsBox
extends JDialog {
    private JList availableFieldList;
    private JList displayedFieldList;
    private DefaultListModel availableFieldListModel;
    private DefaultListModel displayedFieldListModel;
    private JButton removeButton;
    private JButton addButton;
    private JButton applyButton;
    private int startDragRow;
    private Object[] originalValue;
    private KTable table;

    public FieldsBox(JFrame parent, KTable table, KTableModel tableModel) {
        super(parent, "Fields", true);
        this.table = table;
        JPanel listPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 17;
        listPanel.setLayout(layout);
        JLabel label = new JLabel("Available Fields:");
        this.setConstraints(constraints, 0, 0, 8, 14, 4, 8, 1, 0, 0);
        layout.setConstraints(label, constraints);
        listPanel.add(label);
        this.availableFieldListModel = new DefaultListModel();
        this.getAvailableFields(this.availableFieldListModel, table, tableModel);
        this.availableFieldList = new JList(this.availableFieldListModel);
        this.availableFieldList.setSelectionMode(0);
        this.availableFieldList.setSelectedIndex(0);
        this.availableFieldList.setVisibleRowCount(9);
        this.availableFieldList.addMouseListener(new AvailableFieldListMouseListener());
        JScrollPane availableFieldPane = new JScrollPane(this.availableFieldList);
        this.setConstraints(constraints, 0, 1, 0, 12, 4, 8, 10, 50, 0);
        layout.setConstraints(availableFieldPane, constraints);
        Dimension dimension = new Dimension();
        dimension = this.availableFieldList.getPreferredSize();
        dimension.width = 80;
        this.availableFieldList.setPreferredSize(dimension);
        listPanel.add(availableFieldPane);
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(new AddButtonListener());
        this.setConstraints(constraints, 1, 1, 0, 4, 0, 0, 1, 0, 0);
        layout.setConstraints(this.addButton, constraints);
        listPanel.add(this.addButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(new RemoveButtonListener());
        Insets insets = this.removeButton.getMargin();
        insets.left = 8;
        insets.right = 8;
        this.removeButton.setMargin(insets);
        this.setConstraints(constraints, 1, 2, 12, 4, 8, 0, 1, 0, 0);
        layout.setConstraints(this.removeButton, constraints);
        listPanel.add(this.removeButton);
        this.addButton.setPreferredSize(this.removeButton.getPreferredSize());
        label = new JLabel("Displayed Fields:");
        this.setConstraints(constraints, 2, 0, 8, 12, 4, 8, 1, 0, 0);
        layout.setConstraints(label, constraints);
        listPanel.add(label);
        this.displayedFieldListModel = new DefaultListModel();
        this.getDisplayedFields(this.displayedFieldListModel, table, tableModel);
        this.originalValue = this.displayedFieldListModel.toArray();
        this.displayedFieldList = new JList(this.displayedFieldListModel);
        this.displayedFieldList.setSelectionMode(0);
        this.displayedFieldList.setSelectedIndex(0);
        this.displayedFieldList.setVisibleRowCount(9);
        this.displayedFieldList.addMouseListener(new DisplayedFieldListMouseListener());
        this.displayedFieldList.addMouseMotionListener(new DisplayedFieldMouseMotionListener());
        dimension = new Dimension();
        dimension = this.displayedFieldList.getPreferredSize();
        dimension.width = 80;
        this.displayedFieldList.setPreferredSize(dimension);
        JScrollPane displayedFieldPane = new JScrollPane(this.displayedFieldList);
        this.setConstraints(constraints, 2, 1, 0, 12, 2, 12, 10, 50, 0);
        layout.setConstraints(displayedFieldPane, constraints);
        listPanel.add(displayedFieldPane);
        JPanel buttonPanel = this.buildButtonPanel();
        this.getContentPane().add((Component)listPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FieldsBox.this.dispose();
            }
        });
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setBounds(x, y, w, h);
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton okButton = new JButton("OK");
        this.applyButton = new JButton("Apply");
        JButton cancelButton = new JButton("Cancel");
        okButton.setMnemonic(79);
        this.applyButton.setMnemonic(65);
        cancelButton.setMnemonic(67);
        okButton.addActionListener(new OkButtonListener());
        this.applyButton.addActionListener(new ApplyButtonListener());
        cancelButton.addActionListener(new CanelButtonListener());
        buttonPanel.add(okButton);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(cancelButton);
        this.applyButton.setEnabled(false);
        return buttonPanel;
    }

    private void setConstraints(GridBagConstraints constraints, int gridx, int gridy, int top, int left, int bottom, int right, int gridheight, int ipadx, int weightx) {
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.insets.top = top;
        constraints.insets.left = left;
        constraints.insets.bottom = bottom;
        constraints.insets.right = right;
        constraints.gridheight = gridheight;
        constraints.ipadx = ipadx;
        constraints.weightx = weightx;
    }

    private boolean parametersChanged() {
        boolean changed;
        Object[] newValue = this.displayedFieldListModel.toArray();
        if (this.originalValue.length != newValue.length) {
            changed = true;
        } else {
            changed = false;
            for (int index = 0; index < this.originalValue.length; ++index) {
                if (((String)this.originalValue[index]).trim().equalsIgnoreCase((String)newValue[index])) continue;
                changed = true;
                break;
            }
        }
        return changed;
    }

    private void updateApplyButton() {
        if (this.parametersChanged() && this.displayedFieldListModel.getSize() > 0) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
    }

    void addItem() {
        if (this.availableFieldListModel.getSize() == 0) {
            return;
        }
        int removeIndex = this.availableFieldList.getSelectedIndex();
        String item = (String)this.availableFieldListModel.elementAt(removeIndex);
        this.availableFieldListModel.remove(removeIndex);
        if (this.availableFieldListModel.getSize() > 0) {
            if (removeIndex == this.availableFieldListModel.getSize()) {
                this.availableFieldList.setSelectedIndex(removeIndex - 1);
            } else {
                this.availableFieldList.setSelectedIndex(removeIndex);
            }
        }
        int addIndex = this.displayedFieldList.getSelectedIndex() + 1;
        this.displayedFieldListModel.insertElementAt(item, addIndex);
        this.displayedFieldList.setSelectedIndex(addIndex);
        if (this.displayedFieldListModel.getSize() >= 1) {
            this.removeButton.setEnabled(true);
        }
        if (this.availableFieldListModel.getSize() == 0) {
            this.addButton.setEnabled(false);
        }
        this.updateApplyButton();
    }

    void removeItem() {
        int addIndex;
        if (this.displayedFieldListModel.getSize() == 0) {
            return;
        }
        int removeIndex = this.displayedFieldList.getSelectedIndex();
        String item = (String)this.displayedFieldListModel.elementAt(removeIndex);
        this.displayedFieldListModel.remove(removeIndex);
        if (this.displayedFieldListModel.getSize() == 1) {
            this.removeButton.setEnabled(false);
        } else if (removeIndex == this.displayedFieldListModel.getSize()) {
            this.displayedFieldList.setSelectedIndex(removeIndex - 1);
        } else {
            this.displayedFieldList.setSelectedIndex(removeIndex);
        }
        for (addIndex = 0; addIndex < this.availableFieldListModel.getSize() && item.compareTo((String)this.availableFieldListModel.elementAt(addIndex)) >= 0; ++addIndex) {
        }
        this.availableFieldListModel.insertElementAt(item, addIndex);
        if (this.availableFieldListModel.getSize() == 1) {
            this.addButton.setEnabled(true);
            this.availableFieldList.setSelectedIndex(0);
        }
        this.updateApplyButton();
    }

    private void getDisplayedFields(DefaultListModel displayedFieldListModel, JTable table, AbstractTableModel tableModel) {
        for (int index = 0; index < table.getColumnCount(); ++index) {
            displayedFieldListModel.addElement(table.getColumnName(index));
        }
    }

    private void getAvailableFields(DefaultListModel availableFieldListModel, JTable table, AbstractTableModel tableModel) {
        for (int index = 0; index < tableModel.getColumnCount(); ++index) {
            int addIndex;
            String name = tableModel.getColumnName(index);
            boolean used = false;
            for (int used_index = 0; used_index < table.getColumnCount(); ++used_index) {
                if (!name.equalsIgnoreCase(table.getColumnName(used_index))) continue;
                used = true;
                break;
            }
            if (used) continue;
            for (addIndex = 0; addIndex < availableFieldListModel.getSize() && name.compareTo((String)availableFieldListModel.elementAt(addIndex)) >= 0; ++addIndex) {
            }
            availableFieldListModel.insertElementAt(name, addIndex);
        }
    }

    static /* synthetic */ Object[] access$602(FieldsBox x0, Object[] x1) {
        x0.originalValue = x1;
        return x1;
    }

    class CanelButtonListener
    implements ActionListener {
        CanelButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FieldsBox.this.dispose();
        }
    }

    class OkButtonListener
    implements ActionListener {
        OkButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (FieldsBox.this.parametersChanged()) {
                FieldsBox.access$602(FieldsBox.this, FieldsBox.this.displayedFieldListModel.toArray());
                FieldsBox.this.table.changeColumns(FieldsBox.this.originalValue);
                FieldsBox.this.updateApplyButton();
            }
            FieldsBox.this.dispose();
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        ApplyButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FieldsBox.access$602(FieldsBox.this, FieldsBox.this.displayedFieldListModel.toArray());
            FieldsBox.this.table.changeColumns(FieldsBox.this.originalValue);
            FieldsBox.this.updateApplyButton();
        }
    }

    class AddButtonListener
    implements ActionListener {
        AddButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FieldsBox.this.addItem();
        }
    }

    class RemoveButtonListener
    implements ActionListener {
        RemoveButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FieldsBox.this.removeItem();
        }
    }

    public class DisplayedFieldMouseMotionListener
    implements MouseMotionListener {
        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int row = FieldsBox.this.displayedFieldList.getSelectedIndex();
            if (row != FieldsBox.this.startDragRow) {
                String item = (String)FieldsBox.this.displayedFieldListModel.remove(FieldsBox.this.startDragRow);
                FieldsBox.this.displayedFieldListModel.insertElementAt(item, row);
                FieldsBox.this.startDragRow = row;
                FieldsBox.this.updateApplyButton();
            }
        }
    }

    class DisplayedFieldListMouseListener
    extends MouseAdapter {
        DisplayedFieldListMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            FieldsBox.this.startDragRow = FieldsBox.this.displayedFieldList.getSelectedIndex();
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point p = FieldsBox.this.displayedFieldList.indexToLocation(FieldsBox.this.displayedFieldListModel.getSize() - 1);
                FontMetrics fm = FieldsBox.this.displayedFieldList.getFontMetrics(FieldsBox.this.displayedFieldList.getFont());
                if (e.getY() < p.y + fm.getHeight()) {
                    FieldsBox.this.removeItem();
                }
            }
        }
    }

    class AvailableFieldListMouseListener
    extends MouseAdapter {
        AvailableFieldListMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point p = FieldsBox.this.availableFieldList.indexToLocation(FieldsBox.this.availableFieldListModel.getSize() - 1);
                FontMetrics fm = FieldsBox.this.availableFieldList.getFontMetrics(FieldsBox.this.availableFieldList.getFont());
                if (e.getY() < p.y + fm.getHeight()) {
                    FieldsBox.this.addItem();
                }
            }
        }
    }
}

