/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;

public class ControllerDatabase
extends AbstractDatabase {
    private ControllerDescriptor[] controllerArray;
    private boolean firstController = true;

    ControllerDatabase(DatabaseManager databaseManager) {
        super(databaseManager, "Controller");
        this.controllerArray = new ControllerDescriptor[databaseManager.getControllerCount()];
        for (int controller = 0; controller < this.controllerArray.length; ++controller) {
            this.controllerArray[controller] = new ControllerDescriptor(controller);
        }
    }

    public void initialize() {
        super.initialize();
        this.getControllerInfo(0);
    }

    public synchronized void nuke() {
        super.nuke();
    }

    public void snapshot(FileOutputStream outputStream) {
    }

    protected synchronized void processNewData(Message message) {
        try {
            XmlData xmlData = new XmlData(message.response);
            if (xmlData.getNextElement()) {
                if (xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                } else if (xmlData.element.equals("ControllerInfo")) {
                    ControllerDescriptor controllerDescriptor;
                    this.controllerArray[controllerDescriptor.controller] = controllerDescriptor = new ControllerDescriptor(message.controller, xmlData.elementValue);
                    if (this.initializing) {
                        if (this.firstController) {
                            this.databaseManager.maximumRaidGroups = controllerDescriptor.maxRaidGroups;
                            this.firstController = false;
                        }
                        if (controllerDescriptor.controller < this.controllerArray.length - 1) {
                            this.getControllerInfo(controllerDescriptor.controller + 1);
                        } else {
                            this.initializationComplete();
                        }
                    } else {
                        this.notifyListeners();
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "Controller Database Exception\nMessage " + message.response);
        }
    }

    private void getControllerInfo(int controller) {
        String request = "<si:Request><si:Type>ControllerInfo</si:Type></si:Request>";
        this.databaseManager.commManager.sendMessage(controller, "Get", request, this.infoMessageHandler);
    }

    public ControllerDescriptor getConnectedController() {
        return (ControllerDescriptor)this.controllerArray[this.databaseManager.getNexusController()].clone();
    }

    public ControllerDescriptor getController(int controller) {
        return (ControllerDescriptor)this.controllerArray[controller].clone();
    }

    public int getMaxNumberRaidGroups() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.maxRaidGroups;
    }

    public int getMaxNumberPhysDevs() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.pathIdCount * controller.targetIdCount;
    }

    public int getMaxPhysicalPathCount() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.pathIdCount;
    }

    public int getMaxTargetsPerPathCount() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.targetIdCount;
    }

    public synchronized int getMaxNumberContRaidGrps() {
        ControllerDescriptor controller = this.getConnectedController();
        int maxContRaidGroups = controller.pathIdCount * controller.targetIdCount * controller.maxContRaidGrpsPerDev;
        return Utility.minInt(maxContRaidGroups, controller.maxRaidGroups);
    }

    public synchronized int getMaxMultiMemRaidGrps() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.maxMultiMemRaidGrps;
    }

    public synchronized int getMaxContRaidGrpsPerDev() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.maxContRaidGrpsPerDev;
    }

    public synchronized String getControllerType() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.chipType;
    }

    public synchronized int getMaxMemberCount() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.maxMemberCount;
    }

    public synchronized int getMaxMembersPerDevice() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.maxMembersPerDevice;
    }
}

