/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PopUpBox
extends KDialog
implements GlobalConstants {
    private PopBoxPollingThread popBoxPollingThread;

    public PopUpBox(DatabaseManager databaseManager, String title) {
        this.beginDialogInit(databaseManager, title, false);
        if (this.storageManagementUtility.anyModalWindows()) {
            ((JDialog)this.storageManagementUtility.getTopModalWindow()).setModal(false);
        }
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.getContentPane().add((Component)this.buildPopUpMainPanel(), "Center");
        this.popBoxPollingThread = new PopBoxPollingThread();
        this.popBoxPollingThread.start();
        this.completeDialogInit(true);
    }

    protected JPanel buildPopUpMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.buildPopUpLabelPanel());
        mainPanel.add(this.buildButtonPanel());
        mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 8, 12, 8), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "")));
        return mainPanel;
    }

    protected JPanel buildPopUpLabelPanel() {
        JPanel paramsPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        paramsPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        Utility.addComponent(new JLabel(this.storageManagementUtility.applicationName + " detected a new event."), paramsPanel, layout, constraints, 0, 0, 0, 0, 8, 8, 0.0);
        Dimension dim = paramsPanel.getPreferredSize();
        dim.height *= 2;
        paramsPanel.setPreferredSize(dim);
        paramsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel compoundPanel = new JPanel();
        compoundPanel.add(paramsPanel);
        return compoundPanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton okButton = new JButton("OK");
        okButton.setMnemonic(79);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopUpBox.this.closeDialog();
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected void closeDialog() {
        this.popBoxPollingThread = null;
        if (this.storageManagementUtility.anyModalWindows()) {
            ((JDialog)this.storageManagementUtility.getTopModalWindow()).setModal(true);
        }
        this.dispose();
    }

    private class PopBoxPollingThread
    extends Thread {
        private PopBoxPollingThread() {
        }

        public void run() {
            while (PopUpBox.this.popBoxPollingThread != null) {
                try {
                    Thread.sleep(100L);
                    PopUpBox.this.toFront();
                }
                catch (Exception exception) {}
            }
        }
    }
}

