/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;

public class EventDatabase
extends AbstractDatabase {
    private ListTable eventTable;
    private DatabaseManager databaseManager;
    private static EventDatabase eventDatabase;
    private PopUpBoxThread popUpBoxThread = null;
    public static int Event;
    public static int EventsExpected;
    public static int CurrentEvent;
    public static int EventTableIndex;
    Runnable eventDatabaseChangeHandler;
    final char unitSeparator = (char)31;
    final char unitSeparatr2 = (char)30;
    private boolean initEvents = false;

    EventDatabase(DatabaseManager databaseManager) {
        super(databaseManager, "Event");
        this.databaseManager = databaseManager;
    }

    public void initialize() {
        super.initialize();
        this.eventTable = new ListTable();
        try {
            if (this.databaseManager.storageManagementUtility.logFileGen) {
                this.readLogFile();
            }
            if (this.updateCount > 0L) {
                this.getNew();
            } else {
                this.initializationComplete();
            }
        }
        catch (Exception e) {
            ErrorLog.put(e, this.getClass().getName() + ": initialize()");
        }
    }

    public synchronized void nuke() {
        if (this.eventTable != null) {
            this.eventTable.clear();
        }
        EventTableIndex = 0;
        this.updateCount = 0L;
    }

    public synchronized void reloadLogFile() {
        try {
            this.nuke();
            this.readLogFile();
            this.notifyListeners();
        }
        catch (Exception e) {
            ErrorLog.put(e, this.getClass().getName() + ": reloadLogFile()");
        }
    }

    private void appendLogFile(String logMessage) {
        if (!this.databaseManager.storageManagementUtility.logFileGen) {
            return;
        }
        File logFile = new File(this.databaseManager.storageManagementUtility.logFilePath);
        try {
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            FileOutputStream eventLogFileOutputStream = new FileOutputStream(logFile, true);
            eventLogFileOutputStream.write(logMessage.getBytes());
            eventLogFileOutputStream.close();
        }
        catch (Exception e) {
            ErrorLog.put(e, this.getClass().getName() + ": appendLogFile()");
        }
    }

    public void purgeWithoutSave(String logFilePath) {
        File logFile = new File(logFilePath);
        try {
            logFile.delete();
            logFile.createNewFile();
            this.nuke();
        }
        catch (Exception e) {
            ErrorLog.put(e, this.getClass().getName() + ": purgeWithoutSave()");
        }
    }

    public void purgeWithSave(String logFilePath, String saveFilePath) {
        File saveFile = new File(saveFilePath);
        File logFile = new File(logFilePath);
        try {
            logFile.renameTo(saveFile);
            logFile.createNewFile();
            this.nuke();
        }
        catch (Exception e) {
            ErrorLog.put(e, this.getClass().getName() + ": purgeWithSave()");
        }
    }

    public void purgeWithDeleteAndSave(String logFilePath, String backupFilePath) {
        File backupFile = new File(backupFilePath);
        File logFile = new File(logFilePath);
        try {
            backupFile.delete();
            logFile.renameTo(backupFile);
            logFile.createNewFile();
            this.nuke();
        }
        catch (Exception e) {
            ErrorLog.put(e, this.getClass().getName() + ": purgeWithDeleteAndSave()");
        }
    }

    public void purgeWithAppendSave(String logFilePath, String backupFilePath) {
        boolean beginIndex = false;
        boolean endIndex = false;
        boolean append = true;
        try {
            File logFile = new File(logFilePath);
            File backupFile = new File(backupFilePath);
            int bytesRead = 0;
            int fileSize = (int)logFile.length();
            char[] logData = new char[fileSize];
            FileReader logFileReader = new FileReader(logFile);
            FileWriter backupFileWriter = new FileWriter(backupFile, append);
            while (logFileReader.ready()) {
                bytesRead += logFileReader.read(logData, bytesRead, fileSize - bytesRead);
            }
            logFileReader.close();
            backupFileWriter.write(logData);
            backupFileWriter.close();
            logFile.delete();
            logFile.createNewFile();
            this.nuke();
        }
        catch (IOException e) {
            ErrorLog.put(e, this.getClass().getName() + ": purgeWithAppendSave()");
        }
    }

    private void readLogFile() {
        int beginIndex = 0;
        int endIndex = 0;
        try {
            File logFile = new File(this.databaseManager.storageManagementUtility.logFilePath);
            int fileSize = (int)logFile.length();
            char[] logData = new char[fileSize];
            FileReader logFileReader = new FileReader(logFile);
            int bytesRead = 0;
            while (logFileReader.ready()) {
                bytesRead += logFileReader.read(logData, bytesRead, fileSize - bytesRead);
            }
            logFileReader.close();
            String logDataString = new String(logData, 0, fileSize);
            while (endIndex <= fileSize) {
                EventDescriptor logFileEventDescriptor = new EventDescriptor();
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0) {
                    return;
                }
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    this.databaseManager.storageManagementUtility.systemExitApplication();
                }
                logFileEventDescriptor.EventDate = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    this.databaseManager.storageManagementUtility.systemExitApplication();
                }
                logFileEventDescriptor.EventTime = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                if ((beginIndex = logDataString.indexOf(30, beginIndex)) >= 0) {
                    endIndex = logDataString.indexOf(30, beginIndex + 1);
                    if (beginIndex < 0 || endIndex < 0) {
                        if (this.popUpDamagedFileWarning() == 0) {
                            return;
                        }
                        this.databaseManager.storageManagementUtility.systemExitApplication();
                    }
                    logFileEventDescriptor.EventSource = logDataString.substring(beginIndex + 1, endIndex);
                }
                beginIndex = endIndex + 1;
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    this.databaseManager.storageManagementUtility.systemExitApplication();
                }
                logFileEventDescriptor.EventType = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    this.databaseManager.storageManagementUtility.systemExitApplication();
                }
                logFileEventDescriptor.EventLevel = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    this.databaseManager.storageManagementUtility.systemExitApplication();
                }
                logFileEventDescriptor.EventMessage = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                this.eventTable.put(this.eventTable.size(), Integer.toString(EventTableIndex++), logFileEventDescriptor);
            }
        }
        catch (IOException e) {
            ErrorLog.put(e, this.getClass().getName() + ": readLogFile()");
        }
    }

    protected int popUpDamagedFileWarning() {
        int answer = JOptionPane.showConfirmDialog(null, "File holding the saved events appears to be damaged.\nIf you choose to continue, the rest of the event log file will be skipped.\nIf you choose not to continue, the application will exit back to the system.\nAre you sure you want to continue?", "Event File Damage Warning", 0);
        return answer;
    }

    public synchronized void processUpdateCount(long latestUpdateCount) {
        if (latestUpdateCount > 0L) {
            String request = "<si:Request><si:Type>" + this.updateCountType + "UpdateCounts</si:Type>" + "</si:Request>";
            this.databaseManager.commManager.sendMessage("Get", request, this.countsMessageHandler);
        }
    }

    protected synchronized void processUpdateCountsMessage(Message message) {
        long xmlUpdateCount = 0L;
        String data = message.response;
        try {
            XmlData xmlData = new XmlData(data);
            Utility.println("event counts " + data);
            while (xmlData.getNextElement()) {
                if (!xmlData.element.equals("EventUpdateCount")) continue;
                String event = null;
                XmlData updateXmlData = new XmlData(xmlData.elementValue);
                while (updateXmlData.getNextElement()) {
                    if (updateXmlData.element.equals("Event")) {
                        event = updateXmlData.elementValue;
                        continue;
                    }
                    if (!updateXmlData.element.equals("Count")) continue;
                    xmlUpdateCount = Long.parseLong(updateXmlData.elementValue);
                }
            }
            if (xmlUpdateCount > 0L && this.updateCount == 0L) {
                this.updateCount = xmlUpdateCount;
                this.getNew();
            }
        }
        catch (Exception exception) {
            this.UpdateApplicationEvents("Error", "Event Database Process Update Counts Exception " + data);
            ErrorLog.put(exception, "Event Database Process Update Counts Exception\nController " + data);
        }
    }

    protected synchronized void processNewData(Message message) {
        int appEventLevel = this.getEventLevelValue(this.databaseManager.storageManagementUtility.popUpLevel);
        if (this.databaseManager.state != 3 && !this.initializing) {
            return;
        }
        try {
            XmlData xmlData = new XmlData(message.response);
            if (xmlData.getNextElement()) {
                if (xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    if (this.initializing) {
                        this.initializationComplete();
                        this.notifyListeners();
                    }
                } else if (xmlData.element.equals("EventInfo")) {
                    EventDescriptor eventDescriptor = new EventDescriptor(xmlData.elementValue);
                    ControllerDescriptor controllerDescriptor = this.databaseManager.getSelectedController();
                    eventDescriptor.EventSource = "Controller " + Integer.toString(controllerDescriptor.controller) + " - " + controllerDescriptor.chipType;
                    String logEvent = "\u001f" + eventDescriptor.EventDate + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventTime + '\u001f' + "\t" + '\u001e' + eventDescriptor.EventSource + '\u001e' + "\t" + '\u001f' + eventDescriptor.EventType + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventLevel + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventMessage + '\u001f' + "\n";
                    this.appendLogFile(logEvent);
                    this.eventTable.put(this.eventTable.size(), Integer.toString(EventTableIndex++), eventDescriptor);
                    int eventLevel = this.getEventLevelValue(eventDescriptor.EventLevel);
                    if (eventLevel <= appEventLevel) {
                        if (this.initializing) {
                            this.initEvents = true;
                        } else {
                            this.newEventNotification();
                        }
                    }
                    if (--this.updateCount > 0L) {
                        this.getNew();
                    } else {
                        if (this.initializing) {
                            this.initializationComplete();
                        }
                        this.notifyListeners();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.UpdateApplicationEvents("Error", "EventDatabase Process New Event Exception");
            ErrorLog.put(exception, "EventDatabase Process New Event Exception\nMessage " + message.response);
        }
    }

    public synchronized ArrayList getEventList() {
        ArrayList<Object> requestedEventList = new ArrayList<Object>();
        for (int event = 0; event < this.eventTable.size(); ++event) {
            requestedEventList.add(((EventDescriptor)this.eventTable.get(event)).clone());
        }
        return requestedEventList;
    }

    public synchronized EventDescriptor getEvent(int event) {
        return (EventDescriptor)((EventDescriptor)this.eventTable.get(event)).clone();
    }

    public void UpdateApplicationEvents(String EventLevel, String EventMessage) {
        String dateSeparator = "/";
        Date trialTime = new Date();
        DateFormat dt = DateFormat.getDateInstance(3);
        String date = dt.format(trialTime);
        dt = DateFormat.getTimeInstance(1);
        String time = dt.format(trialTime);
        EventDescriptor eventDescriptor = new EventDescriptor();
        ControllerDescriptor controllerDescriptor = this.databaseManager.getSelectedController();
        eventDescriptor.EventSource = "Controller " + Integer.toString(controllerDescriptor.controller) + " - " + controllerDescriptor.chipType;
        eventDescriptor.EventDate = date;
        eventDescriptor.EventTime = time;
        eventDescriptor.EventType = "Application";
        eventDescriptor.EventLevel = EventLevel;
        eventDescriptor.EventMessage = EventMessage;
        this.eventTable.put(this.eventTable.size(), Integer.toString(EventTableIndex++), eventDescriptor);
        String logEvent = "\u001f" + eventDescriptor.EventDate + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventTime + '\u001f' + "\t" + '\u001e' + eventDescriptor.EventSource + '\u001e' + "\t" + '\u001f' + eventDescriptor.EventType + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventLevel + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventMessage + '\u001f' + "\n";
        this.appendLogFile(logEvent);
        this.notifyListeners();
    }

    protected int getEventLevelValue(String eventLevel) {
        int eventLevelValue = 0;
        if (!eventLevel.equals("Disabled")) {
            ++eventLevelValue;
            if (!eventLevel.equals("Error")) {
                ++eventLevelValue;
                if (!eventLevel.equals("Warning")) {
                    ++eventLevelValue;
                }
            }
        }
        return eventLevelValue;
    }

    public boolean initializationEvents() {
        return this.initEvents;
    }

    public void newEventNotification() {
        if (this.popUpBoxThread == null) {
            this.popUpBoxThread = new PopUpBoxThread();
            this.popUpBoxThread.start();
        }
    }

    static {
        Event = 0;
        EventsExpected = 0;
        CurrentEvent = 0;
        EventTableIndex = 0;
    }

    private class PopUpBoxThread
    extends Thread {
        private PopUpBoxThread() {
        }

        public void run() {
            new PopUpBox(EventDatabase.this.databaseManager, "New event notification");
            EventDatabase.this.popUpBoxThread = null;
        }
    }
}

