/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.util.ArrayList;

public class DeviceDatabase
extends AbstractDatabase {
    private DeviceDescriptor[] deviceArray;
    private final String[] legacySegmentStatuses = new String[]{"Legacy Spare"};
    private final String[] newSegmentStatuses = new String[]{"Global Spare", "Dedicated Spare"};
    private final String[] segmentStatuses = new String[]{"Available"};

    DeviceDatabase(DatabaseManager databaseManager) {
        super(databaseManager, "Device");
    }

    public synchronized void initialize() {
        super.initialize();
        if (this.deviceArray != null) {
            for (int device = 0; device < this.deviceArray.length; ++device) {
                this.deviceArray[device] = null;
            }
        }
        ControllerDescriptor controllerDescriptor = this.databaseManager.getSelectedController();
        this.deviceArray = new DeviceDescriptor[controllerDescriptor.pathIdCount * controllerDescriptor.targetIdCount];
        int device = 0;
        for (int pathId = 0; pathId < controllerDescriptor.pathIdCount; ++pathId) {
            for (int TargetId = 0; TargetId < controllerDescriptor.targetIdCount; ++TargetId) {
                this.deviceArray[device] = new DeviceDescriptor(pathId, TargetId, device++);
            }
        }
        this.getFirst();
    }

    public synchronized void nuke() {
        super.nuke();
    }

    public void snapshot(FileOutputStream outputStream) {
    }

    protected synchronized void processNewData(Message message) {
        try {
            XmlData xmlData = new XmlData(message.response);
            if (xmlData.getNextElement()) {
                if (xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    if (this.initializing && faultDescriptor.reason.equals("None Found")) {
                        this.initializationComplete();
                    }
                } else if (xmlData.element.equals("DeviceInfo")) {
                    DeviceDescriptor deviceDescriptor;
                    this.deviceArray[deviceDescriptor.device] = deviceDescriptor = new DeviceDescriptor(xmlData.elementValue);
                    if (this.initializing) {
                        this.getNext(deviceDescriptor.device);
                    } else {
                        this.notifyListeners();
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "DeviceDatabase Exception\nMessage " + message.response);
        }
    }

    protected void processUpdateCountsMessage(Message message) {
        String data = message.response;
        try {
            for (int device = 0; device < this.deviceArray.length; ++device) {
                this.deviceArray[device].receivedUpdateCount = false;
            }
            XmlData xmlData = new XmlData(data);
            while (xmlData.getNextElement()) {
                if (!xmlData.element.equals("DeviceUpdateCount")) continue;
                String device = null;
                String updateCount = null;
                XmlData updateXmlData = new XmlData(xmlData.elementValue);
                while (updateXmlData.getNextElement()) {
                    if (updateXmlData.element.equals("Device")) {
                        device = updateXmlData.elementValue;
                        continue;
                    }
                    if (!updateXmlData.element.equals("Count")) continue;
                    updateCount = updateXmlData.elementValue;
                }
                if (device == null || updateCount == null) continue;
                DeviceDescriptor deviceDescriptor = this.deviceArray[Integer.parseInt(device)];
                deviceDescriptor.receivedUpdateCount = true;
                if (deviceDescriptor.updateCount.equals(updateCount)) continue;
                this.getThis(Integer.parseInt(device));
            }
            for (int device = 0; device < this.deviceArray.length; ++device) {
                if (this.deviceArray[device].receivedUpdateCount || this.deviceArray[device].status.equals("Failed") || this.deviceArray[device].status.equals("Unused")) continue;
                this.getThis(device);
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "Device Database Process Update Counts Exception\nController " + data);
        }
    }

    public synchronized ArrayList getDeviceList() {
        ArrayList<Object> requestedDeviceList = new ArrayList<Object>();
        for (int device = 0; device < this.deviceArray.length; ++device) {
            if (this.deviceArray[device].status.equals("Unknown")) continue;
            requestedDeviceList.add(this.deviceArray[device].clone());
        }
        return requestedDeviceList;
    }

    public synchronized DeviceDescriptor getDevice(int device) {
        DeviceDescriptor deviceDescriptor = null;
        try {
            deviceDescriptor = (DeviceDescriptor)this.deviceArray[device].clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deviceDescriptor;
    }

    public synchronized ArrayList getSegmentList(String[] statuses) {
        ArrayList<Object> requestedSegmentList = new ArrayList<Object>();
        for (int device = 0; device < this.deviceArray.length; ++device) {
            if (this.deviceArray[device].status.equals("Unknown")) continue;
            for (int index = 0; index < this.deviceArray[device].segmentArray.size(); ++index) {
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)this.deviceArray[device].segmentArray.get(index);
                if (statuses == null) {
                    requestedSegmentList.add(segmentDescriptor.clone());
                    continue;
                }
                for (int count = 0; count < statuses.length; ++count) {
                    if (!statuses[count].equals(segmentDescriptor.status)) continue;
                    requestedSegmentList.add(segmentDescriptor.clone());
                }
            }
        }
        return requestedSegmentList;
    }

    public synchronized ArrayList getLegacySegmentList(String[] statuses) {
        ControllerDescriptor controller = this.databaseManager.getSelectedController();
        ArrayList<Object> requestedSegmentList = new ArrayList<Object>();
        ArrayList deviceList = this.getDeviceList();
        int lastIndex = deviceList.size();
        int bootableSegments = 0;
        boolean done = false;
        block2: for (int deviceIndex = 0; deviceIndex < lastIndex && !done; ++deviceIndex) {
            DeviceDescriptor device = (DeviceDescriptor)deviceList.get(deviceIndex);
            if (device.status.equals("Empty") || device.targetId != 0) continue;
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)device.segmentArray.get(0);
            try {
                if (segmentDescriptor == null || Long.parseLong(segmentDescriptor.startingPlbn, 16) != 0L) continue;
                for (int count = 0; count < statuses.length; ++count) {
                    if (!statuses[count].equals(segmentDescriptor.status)) continue;
                    requestedSegmentList.add(segmentDescriptor.clone());
                    if (++bootableSegments < controller.pathIdCount && bootableSegments < 4) continue;
                    done = true;
                    continue block2;
                }
                continue;
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "");
            }
        }
        return requestedSegmentList;
    }

    public synchronized boolean legacyBootSupportable() {
        return this.getBootableSegmentCount() > 0;
    }

    public synchronized int getBootableSegmentCount() {
        ControllerDescriptor controller = this.databaseManager.getSelectedController();
        ArrayList deviceList = this.getDeviceList();
        int lastIndex = deviceList.size();
        int bootableSegments = 0;
        for (int deviceIndex = 0; deviceIndex < lastIndex; ++deviceIndex) {
            DeviceDescriptor device = (DeviceDescriptor)deviceList.get(deviceIndex);
            if (device.status.equals("Empty") || device.targetId != 0) continue;
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)device.segmentArray.get(0);
            try {
                if (segmentDescriptor == null || Long.parseLong(segmentDescriptor.startingPlbn, 16) != 0L || !segmentDescriptor.status.equals("Available") || ++bootableSegments < controller.pathIdCount && bootableSegments < 4) continue;
                break;
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "");
            }
        }
        return bootableSegments;
    }

    public synchronized boolean orphanedSegmentExists() {
        String[] segmentStatuses = new String[]{"Orphan"};
        ArrayList segmentList = this.getSegmentList(segmentStatuses);
        return segmentList.size() > 0;
    }

    public synchronized boolean legacySpareExists() {
        ArrayList segmentList = this.getSegmentList(this.legacySegmentStatuses);
        return segmentList.size() > 0;
    }

    public synchronized boolean newSpareExists() {
        ArrayList segmentList = this.getSegmentList(this.newSegmentStatuses);
        return segmentList.size() > 0;
    }

    public synchronized int getNumberOfLegacySpares() {
        ArrayList segmentList = this.getSegmentList(this.legacySegmentStatuses);
        return segmentList.size();
    }

    public synchronized int getNumberOfNewSpares() {
        ArrayList segmentList = this.getSegmentList(this.newSegmentStatuses);
        return segmentList.size();
    }

    public synchronized int getNumberOfAllSpares() {
        ArrayList segmentList = this.getSegmentList(this.newSegmentStatuses);
        ArrayList legacySegmentList = this.getSegmentList(this.legacySegmentStatuses);
        return segmentList.size() + legacySegmentList.size();
    }

    public synchronized boolean availableSegmentExists() {
        String[] segmentStatuses = new String[]{"Available"};
        ArrayList segmentList = this.getSegmentList(segmentStatuses);
        return segmentList.size() > 0;
    }

    public synchronized boolean availableLbn0SegmentExists() {
        String[] segmentStatuses = new String[]{"Available"};
        ArrayList segmentList = this.getSegmentList(segmentStatuses);
        for (int index = 0; index < segmentList.size(); ++index) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(index);
            try {
                if (!segmentDescriptor.status.equals("Available") || Long.parseLong(segmentDescriptor.startingPlbn, 16) != 0L) continue;
                return true;
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "");
            }
        }
        return false;
    }

    public synchronized boolean rebuildSegmentExists(int raidGroup) {
        ArrayList segmentList = this.getRebuildSegmentList(raidGroup);
        return segmentList.size() > 0;
    }

    public int getCapacityInBlocks(String inCapacityStr) {
        String capacityString = inCapacityStr.toUpperCase();
        int capacityBlocks = 0;
        int decIndex = capacityString.indexOf(".");
        try {
            int endIndex;
            if (decIndex != -1) {
                String newCapacityString = capacityString.substring(0, decIndex);
                long capacityInt = Long.parseLong(newCapacityString) + 1L;
                newCapacityString = Long.toString(capacityInt);
                int suffixMBStartIndex = capacityString.indexOf(" MB");
                int suffixGBStartIndex = capacityString.indexOf(" GB");
                int suffixEndIndex = capacityString.length();
                if (suffixMBStartIndex != -1 || suffixGBStartIndex != -1) {
                    String suffixString = suffixMBStartIndex != -1 ? capacityString.substring(suffixMBStartIndex, suffixEndIndex) : capacityString.substring(suffixGBStartIndex, suffixEndIndex);
                    capacityString = newCapacityString + suffixString;
                }
            }
            if ((endIndex = capacityString.indexOf(" MB")) == -1) {
                endIndex = capacityString.indexOf(" GB");
                if (endIndex == -1) {
                    endIndex = capacityString.length();
                    capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 2048;
                } else {
                    capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 0x200000;
                }
            } else {
                capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 2048;
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "");
        }
        return capacityBlocks;
    }

    public synchronized ArrayList getRebuildSegmentList(int raidGroup) {
        ArrayList segmentList = this.getSegmentList(this.segmentStatuses);
        block0: for (int index = 0; index < segmentList.size(); ++index) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(index);
            DeviceDescriptor deviceDescriptor = this.getDevice(Integer.parseInt(segmentDescriptor.device));
            if (!deviceDescriptor.status.equals("Healthy")) continue;
            for (int segment = 0; segment < deviceDescriptor.segmentArray.size(); ++segment) {
                SegmentDescriptor devSegmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segment);
                if (devSegmentDescriptor.raidGroup.equals("N/A")) continue;
                RaidGroupDescriptor raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(Integer.parseInt(devSegmentDescriptor.raidGroup));
                if (raidGroupDescriptor.raidGroup != raidGroup || !raidGroupDescriptor.status.equals("Online") && !raidGroupDescriptor.status.equals("Reduced")) continue;
                segmentList.remove(index--);
                continue block0;
            }
        }
        return segmentList;
    }

    public synchronized ArrayList getQualifiedSegments() {
        String[] segmentStatuses = new String[]{"Available"};
        int maxContRaidGrpsPerDev = this.databaseManager.controllerDatabase.getMaxContRaidGrpsPerDev();
        int maxMultiMemRaidGrps = this.databaseManager.controllerDatabase.getMaxMultiMemRaidGrps();
        int maxMembersPerDevice = this.databaseManager.controllerDatabase.getMaxMembersPerDevice();
        int curMultiMemRaidGrps = this.databaseManager.raidGroupDatabase.getMultiMemRaidGroupCount();
        boolean multiMemLimitReached = curMultiMemRaidGrps >= maxMultiMemRaidGrps;
        ArrayList newSegmentList = new ArrayList();
        ArrayList deviceList = this.getDeviceList();
        int lastIndex = deviceList.size();
        for (int deviceIndex = 0; deviceIndex < lastIndex; ++deviceIndex) {
            DeviceDescriptor deviceDescriptor = (DeviceDescriptor)deviceList.get(deviceIndex);
            if (!deviceDescriptor.status.equals("Healthy")) continue;
            ArrayList<SegmentDescriptor> devSegmentList = new ArrayList<SegmentDescriptor>();
            int contigCount = 0;
            int memberCount = 0;
            for (int segment = 0; segment < deviceDescriptor.segmentArray.size(); ++segment) {
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segment);
                if (!segmentDescriptor.status.equals("Available")) {
                    if (++memberCount >= maxMembersPerDevice) {
                        devSegmentList.clear();
                        break;
                    }
                } else {
                    devSegmentList.add(segmentDescriptor);
                }
                if (!segmentDescriptor.status.equals("Member") || segmentDescriptor.raidGroup.equals("N/A")) continue;
                RaidGroupDescriptor raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(Integer.parseInt(segmentDescriptor.raidGroup));
                if (raidGroupDescriptor.status.equals("Unused") || !raidGroupDescriptor.configuration.equals("Contiguous") || ++contigCount < maxContRaidGrpsPerDev || !multiMemLimitReached) continue;
                devSegmentList.clear();
                break;
            }
            while (devSegmentList.size() > 0) {
                newSegmentList.add(devSegmentList.remove(0));
            }
        }
        return newSegmentList;
    }

    public synchronized ArrayList getQualifiedSegments(String metaformat, String configuration) {
        String[] segmentStatuses = new String[]{"Available"};
        int maxContRaidGrpsPerDev = this.databaseManager.controllerDatabase.getMaxContRaidGrpsPerDev();
        int maxMultiMemRaidGrps = this.databaseManager.controllerDatabase.getMaxMultiMemRaidGrps();
        int maxMembersPerDevice = this.databaseManager.controllerDatabase.getMaxMembersPerDevice();
        int curMultiMemRaidGrps = this.databaseManager.raidGroupDatabase.getMultiMemRaidGroupCount();
        boolean multiMemLimitReached = curMultiMemRaidGrps >= maxMultiMemRaidGrps;
        ArrayList newSegmentList = new ArrayList();
        ArrayList deviceList = this.getDeviceList();
        int lastIndex = deviceList.size();
        for (int deviceIndex = 0; deviceIndex < lastIndex; ++deviceIndex) {
            DeviceDescriptor deviceDescriptor = (DeviceDescriptor)deviceList.get(deviceIndex);
            if (!deviceDescriptor.status.equals("Healthy")) continue;
            ArrayList<SegmentDescriptor> devSegmentList = new ArrayList<SegmentDescriptor>();
            int contigCount = 0;
            int memberCount = 0;
            for (int segment = 0; segment < deviceDescriptor.segmentArray.size(); ++segment) {
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segment);
                if (!segmentDescriptor.status.equals("Available")) {
                    if (++memberCount >= maxMembersPerDevice) {
                        devSegmentList.clear();
                        break;
                    }
                    if (configuration.contains("Spare") || !segmentDescriptor.status.equals("Member") || segmentDescriptor.raidGroup.equals("N/A")) continue;
                    RaidGroupDescriptor raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(Integer.parseInt(segmentDescriptor.raidGroup));
                    if (raidGroupDescriptor.status.equals("Unused") || !raidGroupDescriptor.configuration.equals("Contiguous") || ++contigCount < maxContRaidGrpsPerDev) continue;
                    if (configuration.equals("Contiguous")) {
                        devSegmentList.clear();
                        break;
                    }
                    if (!multiMemLimitReached) continue;
                    devSegmentList.clear();
                    break;
                }
                Long startingPlbn = new Long(1L);
                try {
                    startingPlbn = new Long(Long.parseLong(segmentDescriptor.startingPlbn, 16));
                }
                catch (Exception exception) {
                    ErrorLog.put(exception, "");
                }
                if (metaformat.equals("Old") && (!segmentDescriptor.targetId.equals("0") || startingPlbn != 0L)) continue;
                devSegmentList.add(segmentDescriptor);
            }
            while (devSegmentList.size() > 0) {
                newSegmentList.add(devSegmentList.remove(0));
            }
        }
        return newSegmentList;
    }

    public synchronized boolean qualifiedSegmentExists() {
        ArrayList segmentList = this.getQualifiedSegments();
        return segmentList.size() > 0;
    }

    public synchronized boolean qualifiedSegmentExists(String metadataFormat) {
        ArrayList qualSegmentList = this.getQualifiedSegments();
        if (metadataFormat.equals("New")) {
            return qualSegmentList.size() > 0;
        }
        ArrayList legSegmentList = this.getQualifiedSegments();
        ArrayList<Object> qualLegSegmentList = new ArrayList<Object>();
        for (int qualIndex = 0; qualIndex < qualSegmentList.size(); ++qualIndex) {
            SegmentDescriptor qualSegmentDescriptor = (SegmentDescriptor)qualSegmentList.get(qualIndex);
            for (int legIndex = 0; legIndex < legSegmentList.size(); ++legIndex) {
                SegmentDescriptor legSegmentDescriptor = (SegmentDescriptor)legSegmentList.get(legIndex);
                if (!qualSegmentDescriptor.same(legSegmentDescriptor)) continue;
                qualLegSegmentList.add(qualSegmentDescriptor.clone());
            }
        }
        return qualLegSegmentList.size() > 0;
    }

    public synchronized boolean qualifiedLegacySegmentExists() {
        String[] configurationStrings = GlobalConstants.configFullStrings;
        if (this.databaseManager.controllerDatabase.getControllerType().equals("Sil3132r5")) {
            configurationStrings = GlobalConstants.config3132Strings;
        }
        for (int configIndex = 0; configIndex < configurationStrings.length; ++configIndex) {
            if (!this.qualifiedSegmentExists("Old", configurationStrings[configIndex])) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean qualifiedLegacySpareSegmentExists() {
        ArrayList qualifiedSegments = this.getQualifiedSegments("Old", "Legacy Spare");
        return qualifiedSegments.size() > 0;
    }

    public synchronized boolean qualifiedSegmentExists(String metadataFormat, String configuration) {
        String[] segmentStatuses = new String[]{"Available"};
        int maxContRaidGrpsPerDev = this.databaseManager.controllerDatabase.getMaxContRaidGrpsPerDev();
        int maxMultiMemRaidGrps = this.databaseManager.controllerDatabase.getMaxMultiMemRaidGrps();
        int maxMembersPerDevice = this.databaseManager.controllerDatabase.getMaxMembersPerDevice();
        int curMultiMemRaidGrps = this.databaseManager.raidGroupDatabase.getMultiMemRaidGroupCount();
        boolean multiMemLimitReached = curMultiMemRaidGrps >= maxMultiMemRaidGrps;
        ArrayList newSegmentList = metadataFormat.equals("New") ? this.getSegmentList(segmentStatuses) : this.getLegacySegmentList(segmentStatuses);
        block0: for (int index = 0; index < newSegmentList.size(); ++index) {
            SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(index);
            DeviceDescriptor deviceDescriptor = this.getDevice(Integer.parseInt(newSegmentDescriptor.device));
            if (!deviceDescriptor.status.equals("Healthy")) continue;
            int contigCount = 0;
            int memberCount = 0;
            for (int segment = 0; segment < deviceDescriptor.segmentArray.size(); ++segment) {
                SegmentDescriptor devSegmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segment);
                if (!devSegmentDescriptor.status.equals("Available") && ++memberCount >= maxMembersPerDevice) {
                    newSegmentList.remove(index--);
                    continue block0;
                }
                if (devSegmentDescriptor.raidGroup.equals("N/A")) continue;
                RaidGroupDescriptor raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(Integer.parseInt(devSegmentDescriptor.raidGroup));
                if (raidGroupDescriptor.status.equals("Unused") || !raidGroupDescriptor.configuration.equals("Contiguous") || ++contigCount < maxContRaidGrpsPerDev || !configuration.equals("Contiguous")) continue;
                newSegmentList.remove(index--);
                continue block0;
            }
        }
        if (configuration.equals("Contiguous")) {
            return newSegmentList.size() != 0;
        }
        if (multiMemLimitReached) {
            return false;
        }
        if (configuration.equals("Concatenated")) {
            return newSegmentList.size() >= 2;
        }
        if (configuration.equals("Mirrored") || configuration.equals("Striped")) {
            return newSegmentList.size() >= 2;
        }
        if (configuration.equals("Mirrored Striped")) {
            return newSegmentList.size() >= 4;
        }
        if (configuration.equals("Parity RAID")) {
            return newSegmentList.size() >= 3;
        }
        return false;
    }

    public synchronized boolean containsRaidGroupsAndSpares(DeviceDescriptor deviceDescriptor) {
        String[] segmentStatuses = new String[]{"Member", "Global Spare", "Dedicated Spare", "Legacy Spare"};
        ArrayList segmentList = this.getSegmentList(segmentStatuses);
        for (int segmentIndex = 0; segmentIndex < segmentList.size(); ++segmentIndex) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(segmentIndex);
            int segPathId = Integer.parseInt(segmentDescriptor.pathId);
            int segTargetId = Integer.parseInt(segmentDescriptor.targetId);
            if (deviceDescriptor.pathId != segPathId || deviceDescriptor.targetId != segTargetId) continue;
            return true;
        }
        return false;
    }
}

