/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class HostConnectionManager
implements GlobalConstants {
    public StorageManagementUtility storageManagementUtility;
    public CommManager commManager;
    protected ArrayList notifyList;
    private int currentConnectionIndex;
    private Nexus nexus;
    private ArrayList hostConnections;
    private int numberOfConnections;
    private boolean defaultHostConnection = false;
    private boolean localHostConnection = false;
    private SleepThread sleepThread;
    private final String hostConnectionManager = "HostConnectionManager Exception\n";
    private final String retrieval = " retrieval from preferences";

    public HostConnectionManager(StorageManagementUtility storageManagementUtility) {
        boolean verbose = false;
        this.storageManagementUtility = storageManagementUtility;
        this.nexus = new Nexus();
        this.notifyList = new ArrayList();
        this.commManager = new CommManager(storageManagementUtility, this, verbose);
        Utility.println("HostConnectionManager: commManager initialized");
        this.hostConnections = new ArrayList();
        this.currentConnectionIndex = -1;
        int status = 2;
        try {
            status = this.commManager.openRemoteConnection("127.0.0.1", 0, 4242);
        }
        catch (Exception e) {
            String errMsg = "HostConnectionManager:: constructor: openRemoteConnection() to '127.0.0.1' failed";
            ErrorLog.put(e, errMsg);
            Utility.println(errMsg);
        }
        if (status == 0) {
            this.defaultHostConnection = true;
            Utility.println("Local connection exists");
            HostConnectionDescriptor hostConnection = new HostConnectionDescriptor();
            hostConnection.setNumberOfControllers(this.commManager.getControllerCount());
            hostConnection.alias = "Local Host";
            hostConnection.type = "Remote";
            hostConnection.ipAddress = "127.0.0.1";
            hostConnection.serverPort = Integer.toString(4242);
            hostConnection.controller = 0;
            this.hostConnections.add(hostConnection);
            this.commManager.closeConnection();
        } else {
            int attempt;
            status = 2;
            this.sleepThread = new SleepThread();
            boolean connected = false;
            int loopLimit = 10;
            for (attempt = 0; attempt < loopLimit && !connected; ++attempt) {
                try {
                    status = this.commManager.openLocalConnection(0);
                    if (status == 0) {
                        connected = true;
                    }
                }
                catch (Exception e) {
                    String errMsg = "HostConnectionManager:: constructor: openLocalConnection() failed";
                    ErrorLog.put(e, errMsg);
                    Utility.println(errMsg);
                }
                if (status == 0 || attempt >= loopLimit - 1) continue;
                this.sleepThread.run();
            }
            this.sleepThread = null;
            ApplicationLog.put("Number of connection attempts: " + attempt);
            if (status == 0) {
                this.localHostConnection = true;
                Utility.println("Local connection exists");
                HostConnectionDescriptor hostConnection = new HostConnectionDescriptor();
                hostConnection.setNumberOfControllers(this.commManager.getControllerCount());
                hostConnection.alias = "Local Host";
                hostConnection.type = "Local";
                hostConnection.controller = 0;
                this.hostConnections.add(hostConnection);
                this.commManager.closeConnection();
            } else {
                Utility.println("HostConnectionManager: No controllers found in the Local host");
                NoControllerBox noControllerBox = new NoControllerBox(storageManagementUtility);
                noControllerBox = null;
                storageManagementUtility.systemExitApplication();
            }
        }
        ArrayList retrievedConnections = null;
        int numberOfRetrievedConnections = 0;
        boolean preferredFound = false;
        int preferredIndex = 0;
        for (int index = 0; index < numberOfRetrievedConnections; ++index) {
            HostConnectionDescriptor retrievedConnection = (HostConnectionDescriptor)retrievedConnections.get(index);
            if (retrievedConnection.type.equals("Local")) {
                if (!this.localHostConnection) continue;
                HostConnectionDescriptor localConnection = (HostConnectionDescriptor)this.hostConnections.get(0);
                localConnection.preferred = retrievedConnection.preferred;
                if (!retrievedConnection.preferred) continue;
                preferredFound = true;
                preferredIndex = index;
                continue;
            }
            if (retrievedConnection.preferred) {
                preferredFound = true;
                preferredIndex = this.hostConnections.size();
            }
            this.hostConnections.add(retrievedConnection);
        }
        if (this.hostConnections.size() > 0) {
            Utility.println("Preference connections retrieved");
            if (preferredFound) {
                Utility.println("Preferred connections found");
                status = this.openNewHostConnection((HostConnectionDescriptor)this.hostConnections.get(preferredIndex), 0);
                if (status != 0) {
                    Utility.println("Failed to open preferred connection");
                    if (this.defaultHostConnection) {
                        Utility.println("Default connection exits, opening default connection");
                        this.tryDefaultConnection();
                    } else if (this.localHostConnection) {
                        Utility.println("Opening local connection");
                        this.tryLocalConnection();
                    }
                }
            } else {
                Utility.println("NO Preferred connection found");
                if (this.defaultHostConnection) {
                    Utility.println("Default connection exits, opening default connection");
                    this.tryDefaultConnection();
                } else if (this.localHostConnection) {
                    Utility.println("Local connection exits, opening local connection");
                    this.tryLocalConnection();
                }
            }
        } else {
            Utility.println("NO Preference connections retrieved");
            if (this.defaultHostConnection) {
                Utility.println("Default connection exits, opening default connection");
                this.tryDefaultConnection();
            } else if (this.localHostConnection) {
                Utility.println("Local connection exits, opening local connection");
                this.tryLocalConnection();
            } else {
                Utility.println("NO Preference connections retrieved & NO local connection exists");
                new ImmediateConnectionTableBox(storageManagementUtility, this);
            }
        }
        this.numberOfConnections = this.hostConnections.size();
        if (this.numberOfConnections > 0) {
            if (this.currentConnectionIndex == -1) {
                Utility.println("number of connections: " + this.numberOfConnections);
                if (!(preferredFound && preferredIndex == 0 || (status = this.openNewHostConnection((HostConnectionDescriptor)this.hostConnections.get(0), 0)) == 0)) {
                    Utility.println("We failed to open the first preferences connection. Solicit new connection info");
                    new ImmediateConnectionTableBox(storageManagementUtility, this);
                    if (this.hostConnections.size() > 0 && this.currentConnectionIndex == -1) {
                        int tablePreferredIndex = this.getPreferredConnectionIndex();
                        if (tablePreferredIndex == -1) {
                            ++tablePreferredIndex;
                        }
                        if (!(preferredFound && preferredIndex == tablePreferredIndex || (status = this.openNewHostConnection((HostConnectionDescriptor)this.hostConnections.get(tablePreferredIndex), 0)) == 0)) {
                            storageManagementUtility.systemExitApplication();
                        }
                    }
                }
            }
            HostConnectionDescriptor currentConnection = (HostConnectionDescriptor)this.hostConnections.get(this.currentConnectionIndex);
            this.setNexusToConnection(currentConnection.type.equals("Local"), currentConnection.ipAddress, currentConnection.controller);
        } else {
            storageManagementUtility.systemExitApplication();
        }
    }

    private void tryDefaultConnection() {
        Utility.println("tryDefaultConnection: Opening default connection 127.0.0.1");
        int status = 2;
        try {
            status = this.commManager.openRemoteConnection("127.0.0.1", 0, 4242);
        }
        catch (Exception e) {
            String errMsg = "HostConnectionManager:: tryDefaultConnection: openRemoteConnection() to '127.0.0.1' failed";
            ErrorLog.put(e, errMsg);
            Utility.println(errMsg);
        }
        if (status != 0) {
            new ImmediateConnectionTableBox(this.storageManagementUtility, this);
        } else {
            this.currentConnectionIndex = 0;
        }
    }

    private void tryLocalConnection() {
        Utility.println("tryLocalConnection: Opening local connection");
        int status = this.commManager.openLocalConnection(0);
        if (status != 0) {
            new ImmediateConnectionTableBox(this.storageManagementUtility, this);
        } else {
            this.currentConnectionIndex = 0;
        }
    }

    private synchronized ArrayList retrieveHostConnectionPreferences() {
        Preferences connectionPreferences;
        ArrayList<HostConnectionDescriptor> retrievedConnections = new ArrayList<HostConnectionDescriptor>();
        try {
            connectionPreferences = Preferences.userRoot().node("/Sam/System/Connections");
            connectionPreferences.sync();
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences retrieval");
            Utility.println("HostConnectionManager: connection preferences retrieval exception");
            return retrievedConnections;
        }
        int numberOfConnections = connectionPreferences.getInt("NumberOfConnections", 0);
        Utility.println("retrieveHostConnectionPreferences: numberOfConnections = " + numberOfConnections);
        for (int index = 0; index < numberOfConnections; ++index) {
            Preferences connectionNode;
            String connection = "Connection";
            HostConnectionDescriptor connectionDescriptor = new HostConnectionDescriptor();
            try {
                connectionNode = connectionPreferences.node(connection + Integer.toString(index));
                connectionNode.sync();
                Utility.println("retrieveHostConnectionPreferences: connection node retrieved");
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "HostConnectionManager Exception\n" + connection + " Node" + " retrieval from preferences");
                Utility.println("HostConnectionManager: connection node preferences retrieval exception");
                retrievedConnections.clear();
                return retrievedConnections;
            }
            connectionDescriptor.alias = connectionNode.get("Alias", "");
            connectionDescriptor.type = connectionNode.get("Type", "");
            connectionDescriptor.controller = 0;
            if (connectionDescriptor.type.equals("Remote")) {
                String ipAddress;
                connectionDescriptor.ipAddress = ipAddress = connectionNode.get("IpAddress", "0.0.0.0");
                if (!connectionDescriptor.disassembleAndSetEtherPortAddress(ipAddress)) continue;
                connectionDescriptor.serverPort = connectionNode.get("ServerPort", Integer.toString(4242));
            }
            connectionDescriptor.preferred = connectionNode.get("Preferred", "").equals("Y");
            Utility.println("retrieveHostConnectionPreferences: connection retrieved: ");
            retrievedConnections.add(connectionDescriptor);
        }
        return retrievedConnections;
    }

    public void saveHostConnectionPreferences() {
        Preferences connectionPreferences;
        Utility.println("saveHostConnectionPreferences() entered");
        try {
            connectionPreferences = Preferences.userRoot().node("/Sam/System/Connections");
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences retrieval");
            Utility.println("HostConnectionManager: connection preferences retrieval exception");
            return;
        }
        try {
            connectionPreferences.removeNode();
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences clearing");
            Utility.println("HostConnectionManager: connection preferences clearing exception");
            return;
        }
        try {
            connectionPreferences.flush();
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences flush after remove");
            Utility.println("HostConnectionManager: connection preferences flush after remove exception");
        }
        try {
            connectionPreferences = Preferences.userRoot().node("/Sam/System/Connections");
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences retrieval");
            Utility.println("HostConnectionManager: connection preferences retrieval exception");
            return;
        }
        int numberOfConnections = this.hostConnections.size();
        connectionPreferences.putInt("NumberOfConnections", numberOfConnections);
        Utility.println("saveHostConnectionPreferences: numberOfConnections = " + numberOfConnections);
        numberOfConnections = this.hostConnections.size();
        for (int index = 0; index < numberOfConnections; ++index) {
            Preferences connectionNode;
            String connection = "Connection";
            try {
                connectionNode = connectionPreferences.node(connection + Integer.toString(index));
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "HostConnectionManager Exception\n" + connection + " Node creation");
                Utility.println("HostConnectionManager: connection preferences node creation exception");
                return;
            }
            HostConnectionDescriptor connectionDescriptor = (HostConnectionDescriptor)this.hostConnections.get(index);
            Utility.println("saveHostConnectionPreferences: saving connection:");
            connectionNode.put("Alias", connectionDescriptor.alias);
            connectionNode.put("Type", connectionDescriptor.type);
            connectionNode.put("IpAddress", connectionDescriptor.ipAddress);
            connectionNode.put("Preferred", connectionDescriptor.preferred ? "Y" : "N");
            connectionNode.put("ServerPort", connectionDescriptor.serverPort);
            try {
                connectionNode.flush();
                continue;
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "HostConnectionManager Exception\nconnection node flush");
                Utility.println("HostConnectionManager: connection node flush exception");
            }
        }
        try {
            connectionPreferences.flush();
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences flush");
            Utility.println("HostConnectionManager: connection preferences flush exception");
        }
    }

    public void mergeHostConnections(ArrayList newHostConnections) {
        boolean found;
        Utility.println("mergeHostConnections() entered");
        Utility.println("mergeHostConnections(): newHostConnections.size = " + newHostConnections.size());
        Utility.println("mergeHostConnections(): hostConnections.size    = " + this.hostConnections.size());
        if (newHostConnections.size() == 0) {
            return;
        }
        if (this.hostConnections.size() == 0) {
            while (newHostConnections.size() > 0) {
                HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)newHostConnections.remove(0);
                this.hostConnections.add(hostConnection);
            }
            this.notifyListeners();
            return;
        }
        for (int srcIndex = 0; srcIndex < newHostConnections.size(); ++srcIndex) {
            HostConnectionDescriptor hostSrcConnection = (HostConnectionDescriptor)newHostConnections.get(srcIndex);
            found = false;
            Utility.println("mergeHostConnections(): step1: src node dump");
            int hostConnectionsSize = this.hostConnections.size();
            for (int mstIndex = 0; mstIndex < hostConnectionsSize; ++mstIndex) {
                HostConnectionDescriptor hostMstConnection = (HostConnectionDescriptor)this.hostConnections.get(mstIndex);
                Utility.println("mergeHostConnections(): step1: master node dump");
                if (!hostSrcConnection.same(hostMstConnection)) continue;
                Utility.println("mergeHostConnections(): step1: match found");
                found = true;
                break;
            }
            if (found) continue;
            Utility.println("mergeHostConnections(): step1: match NOT found - adding to the master list");
            this.addHostConnection((HostConnectionDescriptor)hostSrcConnection.clone(), false);
        }
        for (int mstIndex = 0; mstIndex < this.hostConnections.size(); ++mstIndex) {
            HostConnectionDescriptor hostMstConnection = (HostConnectionDescriptor)this.hostConnections.get(mstIndex);
            found = false;
            Utility.println("mergeHostConnections(): step2: master node dump");
            for (int srcIndex = 0; srcIndex < newHostConnections.size(); ++srcIndex) {
                HostConnectionDescriptor hostSrcConnection = (HostConnectionDescriptor)newHostConnections.get(srcIndex);
                Utility.println("mergeHostConnections(): step2: src node dump");
                if (!hostMstConnection.same(hostSrcConnection)) continue;
                Utility.println("mergeHostConnections(): step2: match found");
                found = true;
                break;
            }
            if (found) continue;
            Utility.println("mergeHostConnections(): step2: match NOT found - removing from master list");
            this.removeHostConnection(hostMstConnection, false);
            --mstIndex;
        }
        this.notifyListeners();
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            if ((Runnable)this.notifyList.get(index) != updateListener) continue;
            this.notifyList.remove(index);
            break;
        }
    }

    public void notifyListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
        }
    }

    public synchronized int openNewHostConnection(HostConnectionDescriptor connection, int controller) {
        Utility.println("openNewHostConnection entered: connection.ipAddress = " + connection.ipAddress + " controller = " + controller);
        Utility.println("openNewHostConnection: currentConnectionIndex on entry: " + this.currentConnectionIndex);
        this.commManager.closeConnection();
        int retStatus = 0;
        int answer = 0;
        if (connection.type.equals("Local")) {
            this.storageManagementUtility.setCursor(new Cursor(3));
            retStatus = this.commManager.openLocalConnection(controller);
            this.storageManagementUtility.setCursor(new Cursor(0));
            if (retStatus == 2) {
                Utility.println("HostConnectionManager: No controllers found on the Local link");
                JOptionPane.showMessageDialog(null, "Invalid Local Connection. No controllers were found in the system", "Invalid Local Connection Error", 0);
            }
        } else {
            while (answer == 0) {
                answer = 1;
                this.storageManagementUtility.setCursor(new Cursor(3));
                retStatus = this.commManager.openRemoteConnection(connection.ipAddress, controller, Integer.parseInt(connection.serverPort));
                this.storageManagementUtility.setCursor(new Cursor(0));
                if (retStatus == 1) {
                    answer = JOptionPane.showConfirmDialog(null, "Attempt to open the " + connection.ipAddress + " connection failed.\nDo you wish to retry the operation?", "Failed Open operation", 0);
                    continue;
                }
                if (retStatus != 2) continue;
                Utility.println("HostConnectionManager: No controllers found on the opened link");
                JOptionPane.showMessageDialog(null, "No controllers found on the " + connection.ipAddress + " connection", "Invalid Connection Error", 0);
            }
        }
        if (retStatus == 0) {
            connection.setNumberOfControllers(this.commManager.getControllerCount());
            Utility.println("openNewHostConnection: number of controllers set: " + connection.controllers);
            int index = this.findHostConnectionIndex(connection);
            if (index != -1) {
                this.currentConnectionIndex = index;
            }
            Utility.println("openNewHostConnection: currentConnectionIndex on exit: " + this.currentConnectionIndex);
            this.notifyListeners();
        }
        return retStatus;
    }

    public synchronized void reconnectPreviousConnection() {
        Utility.println("reconnectPreviousConnection entered");
        this.commManager.reconnectConnection();
    }

    public int getControllerCount(String ipAddress, int serverPort) {
        int status = this.commManager.openRemoteConnection(ipAddress, 0, serverPort);
        int controllerCount = -1;
        if (status == 0) {
            controllerCount = this.commManager.getControllerCount();
            this.commManager.closeConnection();
        }
        return controllerCount;
    }

    public int getControllerCount() {
        return this.commManager.getControllerCount();
    }

    public int getHostConnectionCount() {
        return this.hostConnections.size();
    }

    public ArrayList getHostConnectionList() {
        ArrayList<Object> returnHostConnectionList = new ArrayList<Object>();
        for (int connectionIndex = 0; connectionIndex < this.hostConnections.size(); ++connectionIndex) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(connectionIndex);
            returnHostConnectionList.add(hostConnection.clone());
        }
        return returnHostConnectionList;
    }

    public int getCurrentConnectionIndex() {
        return this.currentConnectionIndex;
    }

    public HostConnectionDescriptor getCurrentHostConnection() {
        return this.getHostConnection(this.currentConnectionIndex);
    }

    public HostConnectionDescriptor getHostConnection(int connectionIndex) {
        return (HostConnectionDescriptor)this.hostConnections.get(connectionIndex);
    }

    public void addHostConnection(HostConnectionDescriptor connection, boolean notify) {
        this.hostConnections.add(connection);
        if (notify) {
            this.notifyListeners();
        }
    }

    public void removeHostConnection(HostConnectionDescriptor connection, boolean notify) {
        int connectionIndex = this.findHostConnectionIndex(connection);
        this.removeHostConnection(connectionIndex, notify);
    }

    public void removeHostConnection(int connectionIndex, boolean notify) {
        if (connectionIndex == this.currentConnectionIndex) {
            this.commManager.closeConnection();
        }
        this.hostConnections.remove(connectionIndex);
        if (notify) {
            this.notifyListeners();
        }
    }

    public CommManager getCommManager() {
        return this.commManager;
    }

    public Nexus getNexus() {
        return (Nexus)this.nexus.clone();
    }

    public int getNexusController() {
        return this.nexus.getController();
    }

    public String getNexusIpAddress() {
        return this.nexus.getIpAddress();
    }

    public boolean getNexusLocal() {
        return this.nexus.getLocal();
    }

    public void setNexusToConnection(boolean local, String ipAddress, int controller) {
        this.nexus.setLocal(local);
        this.nexus.setIpAddress(ipAddress);
        this.nexus.setController(controller);
        System.out.println(":::: Established connection: type = " + (local ? "Local" : "Remote") + " ipAddress = " + ipAddress + " controller = " + controller);
    }

    public int findHostConnectionIndex(HostConnectionDescriptor connection) {
        for (int index = 0; index < this.hostConnections.size(); ++index) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(index);
            if (!hostConnection.same(connection)) continue;
            return index;
        }
        return -1;
    }

    private boolean localConnectionExists() {
        for (int index = 0; index < this.hostConnections.size(); ++index) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(index);
            if (!hostConnection.type.equals("Local")) continue;
            return true;
        }
        return false;
    }

    private boolean preferredConnectionExists() {
        for (int index = 0; index < this.hostConnections.size(); ++index) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(index);
            if (!hostConnection.preferred) continue;
            return true;
        }
        return false;
    }

    private int getPreferredConnectionIndex() {
        if (this.hostConnections.size() == 0) {
            return -1;
        }
        for (int index = 0; index < this.hostConnections.size(); ++index) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(index);
            if (!hostConnection.preferred) continue;
            return index;
        }
        return 0;
    }

    private class SleepThread
    extends Thread {
        private SleepThread() {
        }

        public void run() {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

