/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CreateSpareBox
extends KDialog
implements GlobalConstants {
    private SegmentTable segmentTable;
    private JComboBox spareTypeComboBox;
    private JComboBox dedicTypeComboBox;
    private JComboBox capacityComboBox;
    private JComboBox raidGroupComboBox;
    private JButton createButton;
    private JPanel borderPanel;
    private JPanel paramPanel;
    private JPanel dedicPanel;
    private JPanel segmentPanel;
    private JPanel buttonPanel;
    private String[] raidGroupStrings;
    private String[] spareTypeStrings = new String[]{"Global", "Dedicated"};
    private String segmentFields = "Path ID,Target ID,Capacity,Starting LBN";
    private String[] segmentStatuses = new String[]{"Available"};
    private String[] metadataFormats = new String[]{"New"};
    private String[] usedRaidGroupNumbers = new String[128];
    private RaidGroupComboBoxListener raidGroupComboBoxListener;
    private SpareUpdateListener spareUpdateListener;
    private SegmentTableSelectionListener segmentTableSelectionListener;

    public CreateSpareBox(DatabaseManager databaseManager, String title) {
        this.beginDialogInit(databaseManager, title, true);
        this.paramPanel = this.buildParametersPanel();
        this.dedicPanel = this.buildDedicatedPanel();
        this.segmentPanel = this.buildSpareTablePanel();
        this.buttonPanel = this.buildButtonPanel();
        this.getContentPane().add((Component)this.paramPanel, "North");
        this.getContentPane().add((Component)this.segmentPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.raidGroupComboBoxListener = new RaidGroupComboBoxListener();
        this.raidGroupComboBox.addActionListener(this.raidGroupComboBoxListener);
        this.spareUpdateListener = new SpareUpdateListener();
        databaseManager.raidGroupDatabase.addUpdateListener(this.spareUpdateListener);
        databaseManager.deviceDatabase.addUpdateListener(this.spareUpdateListener);
        this.usedRaidGroupNumbers = this.getRaidGroupNumbers();
        this.initializeParameterPanel(Integer.toString(databaseManager.maximumRaidGroups));
        this.completeDialogInit(true);
    }

    protected void closeDialog() {
        Utility.println("closeDialog");
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.spareUpdateListener);
        this.databaseManager.deviceDatabase.removeUpdateListener(this.spareUpdateListener);
        this.raidGroupComboBox.removeActionListener(this.raidGroupComboBoxListener);
        this.segmentTable.removeUpdateListener(this.segmentTableSelectionListener);
        this.segmentTable.dispose();
        this.dispose();
    }

    protected JPanel buildSpareTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.segmentTable = new SegmentTable(this.databaseManager, null, this.segmentFields, this.segmentStatuses, 6, "New");
        this.segmentTable.setSelectionMode(0);
        tablePanel.add(this.segmentTable.getScrollPane());
        this.segmentTableSelectionListener = new SegmentTableSelectionListener();
        this.segmentTable.addUpdateListener(this.segmentTableSelectionListener);
        tablePanel.setBorder(BorderFactory.createEmptyBorder(8, 14, 4, 14));
        return tablePanel;
    }

    protected JPanel buildParametersPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.capacityComboBox = new JComboBox<String>(GlobalConstants.spareCapacityStrings);
        this.capacityComboBox.setEditable(true);
        this.capacityComboBox.setSelectedIndex(1);
        this.spareTypeComboBox = new JComboBox<String>(this.spareTypeStrings);
        Utility.addComponent(new JLabel("Spare Type:"), panel, layout, constraints, 0, 0, 0, 0, 8, 10, 0.0);
        Utility.addComponent(this.spareTypeComboBox, panel, layout, constraints, 1, 0, 0, 0, 4, 10, 1.0);
        this.spareTypeComboBox.setSelectedIndex(0);
        this.capacityComboBox = new JComboBox<String>(GlobalConstants.spareCapacityStrings);
        Utility.addComponent(new JLabel("Capacity:"), panel, layout, constraints, 0, 1, 9, 9, 8, 10, 0.0);
        Utility.addComponent(this.capacityComboBox, panel, layout, constraints, 1, 1, 9, 9, 4, 10, 1.0);
        Dimension dimension = this.spareTypeComboBox.getPreferredSize();
        dimension.width = (int)((double)dimension.width * 1.5);
        this.spareTypeComboBox.setPreferredSize(dimension);
        this.capacityComboBox.setPreferredSize(dimension);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
        this.borderPanel = new JPanel();
        this.borderPanel.setLayout(new BoxLayout(this.borderPanel, 1));
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 13, 0, 13));
        this.borderPanel.add(panel);
        this.spareTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CreateSpareBox.this.spareTypeComboBox.isEnabled()) {
                    if (CreateSpareBox.this.spareTypeComboBox.getSelectedItem().equals("Global")) {
                        CreateSpareBox.this.raidGroupComboBox.setEnabled(false);
                        CreateSpareBox.this.spareTypeComboBox.setEnabled(false);
                        CreateSpareBox.this.spareTypeComboBox.setSelectedIndex(0);
                        CreateSpareBox.this.spareTypeComboBox.setEnabled(true);
                        CreateSpareBox.this.switchToParamPanel();
                    } else if (CreateSpareBox.this.spareTypeComboBox.getSelectedItem().equals("Dedicated")) {
                        CreateSpareBox.this.raidGroupComboBox.setEnabled(true);
                        CreateSpareBox.this.dedicTypeComboBox.setEnabled(false);
                        CreateSpareBox.this.dedicTypeComboBox.setSelectedIndex(1);
                        CreateSpareBox.this.dedicTypeComboBox.setEnabled(true);
                        CreateSpareBox.this.switchToDedicPanel();
                    }
                    CreateSpareBox.this.updateSegmentTable();
                }
            }
        });
        return this.borderPanel;
    }

    protected JPanel buildDedicatedPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.dedicTypeComboBox = new JComboBox<String>(this.spareTypeStrings);
        Utility.addComponent(new JLabel("Spare Type:"), panel, layout, constraints, 0, 0, 0, 0, 8, 10, 0.0);
        Utility.addComponent(this.dedicTypeComboBox, panel, layout, constraints, 1, 0, 0, 0, 4, 10, 1.0);
        this.dedicTypeComboBox.setSelectedIndex(1);
        this.raidGroupStrings = new String[this.databaseManager.maximumRaidGroups];
        this.raidGroupComboBox = new JComboBox<String>(this.getRaidGroupNumbers());
        Utility.addComponent(new JLabel("RAID Group:"), panel, layout, constraints, 0, 1, 9, 9, 8, 10, 0.0);
        Utility.addComponent(this.raidGroupComboBox, panel, layout, constraints, 1, 1, 9, 9, 4, 10, 1.0);
        this.raidGroupComboBox.setEnabled(false);
        Dimension dimension = this.dedicTypeComboBox.getPreferredSize();
        dimension.width = (int)((double)dimension.width * 1.5);
        this.dedicTypeComboBox.setPreferredSize(dimension);
        this.raidGroupComboBox.setPreferredSize(dimension);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
        this.borderPanel = new JPanel();
        this.borderPanel.setLayout(new BoxLayout(this.borderPanel, 1));
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 13, 0, 13));
        this.borderPanel.add(panel);
        this.dedicTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CreateSpareBox.this.dedicTypeComboBox.isEnabled()) {
                    if (CreateSpareBox.this.dedicTypeComboBox.getSelectedItem().equals("Global")) {
                        CreateSpareBox.this.raidGroupComboBox.setEnabled(false);
                        CreateSpareBox.this.spareTypeComboBox.setEnabled(false);
                        CreateSpareBox.this.spareTypeComboBox.setSelectedIndex(0);
                        CreateSpareBox.this.spareTypeComboBox.setEnabled(true);
                        CreateSpareBox.this.switchToParamPanel();
                    } else if (CreateSpareBox.this.dedicTypeComboBox.getSelectedItem().equals("Dedicated")) {
                        CreateSpareBox.this.raidGroupComboBox.setEnabled(true);
                        CreateSpareBox.this.dedicTypeComboBox.setEnabled(false);
                        CreateSpareBox.this.dedicTypeComboBox.setSelectedIndex(1);
                        CreateSpareBox.this.dedicTypeComboBox.setEnabled(true);
                        CreateSpareBox.this.switchToDedicPanel();
                    }
                    CreateSpareBox.this.updateSegmentTable();
                }
            }
        });
        return this.borderPanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.createButton = new JButton("Create");
        JButton closeButton = new JButton("Close");
        this.createButton.setMnemonic(69);
        closeButton.setMnemonic(88);
        this.createButton.setEnabled(false);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateSpareBox.this.sendRequest();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateSpareBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.createButton);
        buttonPanel.add(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    private void initializeParameterPanel(String raidToSkip) {
        int dimension = this.usedRaidGroupNumbers.length - 1;
        if (raidToSkip.equals(Integer.toString(this.databaseManager.maximumRaidGroups))) {
            ++dimension;
        }
        String[] newUsedRaidGroupNumbers = new String[dimension];
        this.raidGroupComboBox.removeActionListener(this.raidGroupComboBoxListener);
        this.raidGroupComboBox.removeAllItems();
        int index = 0;
        for (int i = 0; i < this.usedRaidGroupNumbers.length; ++i) {
            if (raidToSkip.equals(this.usedRaidGroupNumbers[i])) continue;
            this.raidGroupComboBox.addItem(this.usedRaidGroupNumbers[i]);
            newUsedRaidGroupNumbers[index++] = this.usedRaidGroupNumbers[i];
        }
        this.usedRaidGroupNumbers = newUsedRaidGroupNumbers;
        this.raidGroupComboBox.addActionListener(this.raidGroupComboBoxListener);
        if (this.usedRaidGroupNumbers.length == 0) {
            this.disableDedicatedOption();
        }
        this.updateSegmentTable();
    }

    private String[] getRaidGroupNumbers() {
        int count = 0;
        String[] statuses = new String[]{"Dedicated Spare"};
        String[] usedRaidGroups = new String[this.databaseManager.getSelectedController().maxRaidGroups];
        usedRaidGroups = this.databaseManager.raidGroupDatabase.getUsedRaidGroupNumbers(this.metadataFormats, true);
        ArrayList dedicatedSpares = this.databaseManager.deviceDatabase.getSegmentList(statuses);
        for (int index = 0; index < usedRaidGroups.length; ++index) {
            boolean found = false;
            for (int spare = 0; spare < dedicatedSpares.size(); ++spare) {
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)dedicatedSpares.get(spare);
                if (!segmentDescriptor.raidGroup.equals(usedRaidGroups[index])) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++count;
        }
        if (count == 0) {
            return new String[0];
        }
        String[] usedRaidGroupsNoSpare = new String[count];
        count = 0;
        for (int index = 0; index < usedRaidGroups.length; ++index) {
            boolean found = false;
            for (int spare = 0; spare < dedicatedSpares.size(); ++spare) {
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)dedicatedSpares.get(spare);
                if (!segmentDescriptor.raidGroup.equals(usedRaidGroups[index])) continue;
                found = true;
                break;
            }
            if (found) continue;
            usedRaidGroupsNoSpare[count++] = usedRaidGroups[index];
        }
        return usedRaidGroupsNoSpare;
    }

    private void disableDedicatedOption() {
        if (!this.borderPanel.isEnabled()) {
            return;
        }
        this.spareTypeComboBox.setEnabled(false);
        this.spareTypeComboBox.removeAllItems();
        this.spareTypeComboBox.addItem("Global");
        this.spareTypeComboBox.setSelectedIndex(0);
        this.spareTypeComboBox.setEnabled(true);
        this.raidGroupComboBox.setEnabled(false);
    }

    private void setControlCompoundPanel(boolean control) {
        this.spareTypeComboBox.setEnabled(control);
        this.raidGroupComboBox.setEnabled(control);
        this.capacityComboBox.setEnabled(control);
        this.borderPanel.setEnabled(control);
    }

    private void updateSegmentTable() {
        if (this.spareTypeComboBox.getSelectedItem().equals("Dedicated")) {
            int raidGroup = Integer.parseInt((String)this.raidGroupComboBox.getSelectedItem());
            this.segmentTable.segmentTableSpareUpdate("New", raidGroup);
        } else {
            this.segmentTable.segmentTableQualifiedUpdate("New", "Spare");
        }
    }

    private void switchToParamPanel() {
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.paramPanel, "North");
        this.getContentPane().add((Component)this.segmentPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private void switchToDedicPanel() {
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.dedicPanel, "North");
        this.getContentPane().add((Component)this.segmentPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private void sendRequest() {
        int answer;
        SegmentDescriptor segmentDescriptor;
        long capacityBlocks = -1L;
        int raidGroup = -1;
        ArrayList segmentList = this.segmentTable.getSelectedSegments();
        boolean passThruFound = false;
        for (int segment = 0; segment < segmentList.size(); ++segment) {
            segmentDescriptor = (SegmentDescriptor)segmentList.get(segment);
            DeviceDescriptor deviceDescriptor = this.databaseManager.deviceDatabase.getDevice(Integer.parseInt(segmentDescriptor.device));
            if (!deviceDescriptor.passThru) continue;
            passThruFound = true;
            break;
        }
        if (passThruFound && (answer = JOptionPane.showConfirmDialog(this, "WARNING: You have selected one or more PASS-THRU disks to be used for the Spare(s).\nUsing these disks will result in any existing data on the disks being overwritten.\nWould you like to continue?", "Pass-Thru Disks Warning", 0)) == 1) {
            return;
        }
        String spareType = (String)this.spareTypeComboBox.getSelectedItem();
        if (spareType.equals("Dedicated")) {
            raidGroup = Integer.parseInt((String)this.raidGroupComboBox.getSelectedItem());
            capacityBlocks = this.databaseManager.raidGroupDatabase.getRaidGroupMemberCapacity(raidGroup);
        } else {
            String capacityString = (String)this.capacityComboBox.getSelectedItem();
            for (int capacityIndex = 0; capacityIndex < GlobalConstants.spareCapacityStrings.length; ++capacityIndex) {
                if (!capacityString.equals(GlobalConstants.spareCapacityStrings[capacityIndex])) continue;
                capacityBlocks = GlobalConstants.spareCapacities[capacityIndex];
                break;
            }
        }
        segmentDescriptor = (SegmentDescriptor)segmentList.get(0);
        String request = "<si:Request><si:Type>CreateSpare</si:Type><si:SpareParams><si:Type>" + spareType + "</si:Type>" + "<si:Device>" + segmentDescriptor.device + "</si:Device>" + "<si:StartingPlbn>" + segmentDescriptor.startingPlbn + "</si:StartingPlbn>" + "<si:Capacity>" + capacityBlocks + "</si:Capacity>";
        if (spareType.equals("Dedicated")) {
            request = request + "<si:RaidGroup>" + raidGroup + "</si:RaidGroup>";
        }
        request = request + "</si:SpareParams>";
        request = request + "</si:Request>";
        Utility.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                CreateSpareBox.this.databaseManager.refresh();
                CreateSpareBox.this.setCursor(new Cursor(0));
                CreateSpareBox.this.borderPanel.setEnabled(true);
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement()) {
                    if (xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                        new ErrorMessageBox(CreateSpareBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Create Spare Error");
                    } else if (CreateSpareBox.this.databaseManager.deviceDatabase.getNumberOfAllSpares() >= CreateSpareBox.this.databaseManager.maximumSpares - 1) {
                        CreateSpareBox.this.setControlCompoundPanel(false);
                        CreateSpareBox.this.createButton.setEnabled(false);
                    } else if (((String)CreateSpareBox.this.spareTypeComboBox.getSelectedItem()).equals("Dedicated")) {
                        CreateSpareBox.this.initializeParameterPanel((String)CreateSpareBox.this.raidGroupComboBox.getSelectedItem());
                    }
                    CreateSpareBox.this.segmentTableSelectionListener.run();
                }
            }
        };
        this.borderPanel.setEnabled(false);
        this.setCursor(new Cursor(3));
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    static /* synthetic */ String[] access$1102(CreateSpareBox x0, String[] x1) {
        x0.usedRaidGroupNumbers = x1;
        return x1;
    }

    private class SegmentTableSelectionListener
    implements Runnable {
        private SegmentTableSelectionListener() {
        }

        public void run() {
            Utility.println("SegmentTableSelectionListener() entered");
            if (CreateSpareBox.this.databaseManager.deviceDatabase.getNumberOfAllSpares() < CreateSpareBox.this.databaseManager.maximumSpares) {
                ArrayList segmentList = CreateSpareBox.this.segmentTable.getSelectedSegments();
                boolean control = false;
                if (segmentList.size() > 0 && !CreateSpareBox.this.createButton.isEnabled()) {
                    control = true;
                }
                CreateSpareBox.this.createButton.setEnabled(control);
            }
        }
    }

    private class SpareUpdateListener
    implements Runnable {
        private SpareUpdateListener() {
        }

        public void run() {
            String[] newUsedRaidGroupNumbers = CreateSpareBox.this.getRaidGroupNumbers();
            String[] segmentStatuses = new String[]{"Dedicated Spare"};
            ArrayList segmentList = CreateSpareBox.this.databaseManager.deviceDatabase.getSegmentList(segmentStatuses);
            int spareTypeIndex = CreateSpareBox.this.spareTypeComboBox.getSelectedIndex();
            if (newUsedRaidGroupNumbers.length == 0) {
                CreateSpareBox.this.switchToParamPanel();
            } else {
                if (CreateSpareBox.this.spareTypeComboBox.getItemCount() == 1) {
                    CreateSpareBox.this.spareTypeComboBox.setEnabled(false);
                    CreateSpareBox.this.spareTypeComboBox.removeAllItems();
                    CreateSpareBox.this.spareTypeComboBox.addItem("Global");
                    CreateSpareBox.this.spareTypeComboBox.addItem("Dedicated");
                    CreateSpareBox.this.spareTypeComboBox.setSelectedIndex(0);
                    CreateSpareBox.this.spareTypeComboBox.setEnabled(true);
                }
                CreateSpareBox.access$1102(CreateSpareBox.this, newUsedRaidGroupNumbers);
            }
            CreateSpareBox.this.updateSegmentTable();
            if (CreateSpareBox.this.databaseManager.deviceDatabase.getNumberOfAllSpares() >= CreateSpareBox.this.databaseManager.maximumSpares) {
                CreateSpareBox.this.setControlCompoundPanel(false);
                CreateSpareBox.this.createButton.setEnabled(false);
            } else {
                CreateSpareBox.this.setControlCompoundPanel(true);
            }
        }
    }

    private class RaidGroupComboBoxListener
    implements ActionListener {
        private RaidGroupComboBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CreateSpareBox.this.updateSegmentTable();
        }
    }
}

